/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.llm;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.llm.BaiduLlmParam;
import kd.ai.gai.core.domain.llm.PromptBuildParam;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.MessageItem4AzureBaiduTencentXf;
import kd.ai.gai.core.domain.llm.base.ModelResult;
import kd.ai.gai.core.domain.llm.base.ModelResultParam;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmRole;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.service.llm.LlmService;
import kd.ai.gai.core.util.GaiUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BaiduErnieService
extends LlmService<BaiduLlmParam> {
    private static final Log logger = LogFactory.getLog(BaiduErnieService.class);

    public BaiduErnieService(int inputLimit, LLM llm) {
        super(inputLimit, llm);
    }

    @Override
    public LlmParam buildPrompt(PromptBuildParam promptBuildParam) {
        String user = promptBuildParam.getUser();
        boolean stream = promptBuildParam.isStream();
        Boolean reference = promptBuildParam.getReference();
        String systemPromptTemplate = promptBuildParam.getSystemPromptTemplate();
        Map<String, String> variableMap = promptBuildParam.getVariableMap();
        List<UserHistoryMessage> history = promptBuildParam.getHistory();
        List<Chunk> chunkList = promptBuildParam.getChunkList();
        String userInput = promptBuildParam.getUserInput();
        String customParamJson = promptBuildParam.getCustomParamJson();
        logger.info("\u6784\u5efa\u63d0\u793a\uff0c\u5176\u4e2d\u5386\u53f2\u8bb0\u5f55{}\u6761\uff0c\u4e0a\u4e0b\u6587{}\u6761", (Object)(history == null ? 0 : history.size()), (Object)(chunkList == null ? 0 : chunkList.size()));
        BaiduLlmParam baiduLlmParam = new BaiduLlmParam(promptBuildParam.getLlmStyle(), customParamJson);
        baiduLlmParam.setStream(stream);
        baiduLlmParam.setUser_id(user);
        ArrayList<MessageItem4AzureBaiduTencentXf> list = new ArrayList<MessageItem4AzureBaiduTencentXf>(16);
        if (variableMap == null) {
            variableMap = new HashMap<String, String>();
        }
        String systemContent = BaiduErnieService.fillVariable(systemPromptTemplate, chunkList, variableMap);
        String context = this.getContext(reference, systemContent, chunkList, this.getTokenCount(userInput) + this.getTokenCount(systemContent));
        systemContent = reference == null ? systemContent + context : context;
        systemContent = systemContent + ResManager.loadKDString((String)"\\n#\u7528\u6237\u95ee\u9898\uff1a", (String)"BaiduErnieService_15096224", (String)"ai-gai-core", (Object[])new Object[0]) + "";
        int total = userInput.length() + systemContent.length();
        if (total > this.getInputLimit()) {
            logger.info("\u8f93\u5165\u53ef\u80fd\u8d85\u957f,\u8bf7\u5173\u6ce8\uff1a{}", (Object)total);
        }
        MessageItem4AzureBaiduTencentXf messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
        if (userInput.startsWith("functioncall")) {
            String name = userInput.split("&")[1];
            userInput = userInput.split("&")[2];
            messageItem4AzureBaiduTencentXf.setRole(LlmRole.user);
            messageItem4AzureBaiduTencentXf.setName(name);
        } else {
            messageItem4AzureBaiduTencentXf.setRole(LlmRole.user);
        }
        messageItem4AzureBaiduTencentXf.setContent(userInput);
        list.add(messageItem4AzureBaiduTencentXf);
        if (history != null && !history.isEmpty()) {
            Collections.reverse(history);
            for (UserHistoryMessage item : history) {
                MessageItem4AzureBaiduTencentXf lastItem = (MessageItem4AzureBaiduTencentXf)list.get(list.size() - 1);
                LlmRole lastRole = lastItem.getRole();
                if (kd.bos.util.StringUtils.isNotEmpty((String)item.getAssistant())) {
                    if (LlmRole.assistant == lastRole) break;
                    if (list.isEmpty() || ((MessageItem4AzureBaiduTencentXf)list.get(list.size() - 1)).getRole() == LlmRole.user) {
                        if ((total += item.getAssistant().length()) > this.getInputLimit()) break;
                        messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
                        messageItem4AzureBaiduTencentXf.setRole(LlmRole.assistant);
                        messageItem4AzureBaiduTencentXf.setContent(item.getAssistant());
                        list.add(messageItem4AzureBaiduTencentXf);
                    }
                }
                if (!kd.bos.util.StringUtils.isNotEmpty((String)item.getUser())) continue;
                if (LlmRole.user == lastRole) break;
                if (list.isEmpty() || ((MessageItem4AzureBaiduTencentXf)list.get(list.size() - 1)).getRole() != LlmRole.assistant) continue;
                if ((total += item.getUser().length()) > this.getInputLimit()) break;
                messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
                messageItem4AzureBaiduTencentXf.setRole(LlmRole.user);
                if (item.getUser().startsWith("functioncall")) {
                    String input = item.getUser().split("&")[2];
                    String name = item.getUser().split("&")[1];
                    messageItem4AzureBaiduTencentXf.setName(name);
                    messageItem4AzureBaiduTencentXf.setContent(input);
                } else {
                    messageItem4AzureBaiduTencentXf.setContent(item.getUser());
                }
                list.add(messageItem4AzureBaiduTencentXf);
            }
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)systemContent)) {
            MessageItem4AzureBaiduTencentXf messageItem4AzureBaiduTencentXfFirst = (MessageItem4AzureBaiduTencentXf)list.get(0);
            messageItem4AzureBaiduTencentXfFirst.setContent(systemContent + " " + messageItem4AzureBaiduTencentXfFirst.getContent());
        }
        Collections.reverse(list);
        baiduLlmParam.setMessages(list);
        String tools = variableMap.get("function");
        JSONArray function = new JSONArray();
        if (tools != null && tools.length() > 0) {
            JSONArray jsonArray = JSONArray.parseArray((String)tools);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject tool = jsonArray.getJSONObject(i);
                function.add((Object)tool);
            }
            baiduLlmParam.setFunctions(function);
        }
        return baiduLlmParam;
    }

    @Override
    public ModelResult getResult(ModelResultParam modelResultParam) {
        boolean stream = modelResultParam.isStream();
        String result = modelResultParam.getResult();
        boolean searchInfo = false;
        ModelResult modelResult = new ModelResult();
        if (stream) {
            if (kd.bos.util.StringUtils.isEmpty((String)result)) {
                modelResult.setContent("");
                return modelResult;
            }
            String string = result.startsWith("data:") ? (result.indexOf("{") != -1 ? result.substring(result.indexOf("{")) : result) : (result = result);
            if (JSONPath.contains((Object)result, (String)"$.function_call")) {
                String msg = (String)JSONPath.read((String)result, (String)"$.function_call", String.class);
                modelResult.setContent(msg == null ? "" : "function_call&" + msg);
                return modelResult;
            }
            if (JSONPath.contains((Object)result, (String)"$.result")) {
                String msg = (String)JSONPath.read((String)result, (String)"$.result", String.class);
                modelResult.setContent(msg == null ? "" : msg);
                return modelResult;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)result, (CharSequence)"[DONE]")) {
                return modelResult;
            }
            throw new KDBizException(this.getLlm().getNumber() + ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:", (String)"BaiduErnieService_15096225", (String)"ai-gai-core", (Object[])new Object[0]) + result);
        }
        if (JSONPath.contains((Object)result, (String)"$.function_call")) {
            String msg = (String)JSONPath.read((String)result, (String)"$.function_call", String.class);
            modelResult.setContent(msg == null ? "" : msg);
            return modelResult;
        }
        if (!JSONPath.contains((Object)result, (String)"$.result")) {
            throw new KDBizException(this.getLlm().getNumber() + ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:", (String)"BaiduErnieService_15096226", (String)"ai-gai-core", (Object[])new Object[0]) + result);
        }
        modelResult.setContent((String)JSONPath.read((String)result, (String)"$.result", String.class));
        return modelResult;
    }

    @Override
    public int getTokenCount(String text) {
        return (int)Math.ceil((double)GaiUtils.countEnglishWords(text) * 1.3) + GaiUtils.countChineseCharacters(text);
    }

    @Override
    public JSONObject getTypeParam(LlmStyle llmStyle) {
        BaiduLlmParam baiduLlmParam = new BaiduLlmParam();
        JSONObject reultJson = baiduLlmParam.getDefaultTypeParam(llmStyle);
        return reultJson;
    }
}

