/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.llm;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.llm.BaiduWithSystemLlmParam;
import kd.ai.gai.core.domain.llm.PromptBuildParam;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.MessageItem4AzureBaiduTencentXf;
import kd.ai.gai.core.domain.llm.base.ModelResult;
import kd.ai.gai.core.domain.llm.base.ModelResultParam;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.domain.vo.RepoFileVO;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmRole;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.service.RepoService;
import kd.ai.gai.core.service.llm.LlmService;
import kd.ai.gai.core.util.GaiUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BaiduErnieWithSystemService
extends LlmService<BaiduWithSystemLlmParam> {
    private static final Log logger = LogFactory.getLog(BaiduErnieWithSystemService.class);
    private String botEnsure = ResManager.loadKDString((String)"\u6211\u4f1a\u786e\u4fdd\u9996\u5148\u4e25\u683c\u9075\u5b88\u4ee5\u4e0a\u63d0\u793a\u3002", (String)"BaiduErnieWithSystemService_15096227", (String)"ai-gai-core", (Object[])new Object[0]) + "";

    public BaiduErnieWithSystemService(int inputLimit, LLM llm) {
        super(inputLimit, llm);
    }

    @Override
    public LlmParam buildPrompt(PromptBuildParam promptBuildParam) {
        String user = promptBuildParam.getUser();
        boolean stream = promptBuildParam.isStream();
        Boolean reference = promptBuildParam.getReference();
        String systemPromptTemplate = promptBuildParam.getSystemPromptTemplate();
        Map<String, String> variableMap = promptBuildParam.getVariableMap();
        List<UserHistoryMessage> history = promptBuildParam.getHistory();
        List<Chunk> chunkList = promptBuildParam.getChunkList();
        String userInput = promptBuildParam.getUserInput();
        String customParamJson = promptBuildParam.getCustomParamJson();
        logger.info("\u6784\u5efa\u63d0\u793a\uff0c\u5176\u4e2d\u5386\u53f2\u8bb0\u5f55{}\u6761\uff0c\u4e0a\u4e0b\u6587{}\u6761", (Object)(history == null ? 0 : history.size()), (Object)(chunkList == null ? 0 : chunkList.size()));
        BaiduWithSystemLlmParam baiduLlmParam = new BaiduWithSystemLlmParam(promptBuildParam.getLlmStyle(), customParamJson);
        baiduLlmParam.setStream(stream);
        baiduLlmParam.setUser_id(user);
        ArrayList<MessageItem4AzureBaiduTencentXf> list = new ArrayList<MessageItem4AzureBaiduTencentXf>(16);
        if (variableMap == null) {
            variableMap = new HashMap<String, String>();
        }
        String systemContent = BaiduErnieWithSystemService.fillVariable(systemPromptTemplate, chunkList, variableMap);
        String context = this.getContext(reference, systemContent, chunkList, this.getTokenCount(userInput) + this.getTokenCount(systemContent));
        systemContent = reference == null ? systemContent + context : context;
        int total = userInput.length() + systemContent.length() + this.botEnsure.length();
        if (total > this.getInputLimit()) {
            logger.info("\u8f93\u5165\u53ef\u80fd\u8d85\u957f,\u8bf7\u5173\u6ce8\uff1a{}", (Object)total);
        }
        MessageItem4AzureBaiduTencentXf messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
        if (userInput.startsWith("functioncall")) {
            String name = userInput.split("&")[1];
            userInput = userInput.split("&")[2];
            messageItem4AzureBaiduTencentXf.setRole(LlmRole.user);
            messageItem4AzureBaiduTencentXf.setName(name);
        } else {
            messageItem4AzureBaiduTencentXf.setRole(LlmRole.user);
        }
        messageItem4AzureBaiduTencentXf.setContent(userInput);
        list.add(messageItem4AzureBaiduTencentXf);
        if (history != null && !history.isEmpty()) {
            Collections.reverse(history);
            for (UserHistoryMessage item : history) {
                MessageItem4AzureBaiduTencentXf lastItem = (MessageItem4AzureBaiduTencentXf)list.get(list.size() - 1);
                LlmRole lastRole = lastItem.getRole();
                if (kd.bos.util.StringUtils.isNotEmpty((String)item.getAssistant())) {
                    if (LlmRole.assistant == lastRole) break;
                    if (list.isEmpty() || ((MessageItem4AzureBaiduTencentXf)list.get(list.size() - 1)).getRole() == LlmRole.user) {
                        if ((total += item.getAssistant().length()) > this.getInputLimit()) break;
                        messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
                        messageItem4AzureBaiduTencentXf.setRole(LlmRole.assistant);
                        messageItem4AzureBaiduTencentXf.setContent(item.getAssistant());
                        list.add(messageItem4AzureBaiduTencentXf);
                    }
                }
                if (!kd.bos.util.StringUtils.isNotEmpty((String)item.getUser())) continue;
                if (LlmRole.user == lastRole) break;
                if (list.isEmpty() || ((MessageItem4AzureBaiduTencentXf)list.get(list.size() - 1)).getRole() != LlmRole.assistant) continue;
                if ((total += item.getUser().length()) > this.getInputLimit()) break;
                messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
                messageItem4AzureBaiduTencentXf.setRole(LlmRole.user);
                messageItem4AzureBaiduTencentXf.setContent(item.getUser());
                list.add(messageItem4AzureBaiduTencentXf);
            }
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)systemContent)) {
            baiduLlmParam.setSystem(systemContent);
        }
        Collections.reverse(list);
        baiduLlmParam.setMessages(list);
        String tools = variableMap.get("function");
        JSONArray function = new JSONArray();
        if (tools != null && tools.length() > 0) {
            JSONArray jsonArray = JSONArray.parseArray((String)tools);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject tool = jsonArray.getJSONObject(i);
                function.add((Object)tool);
            }
            baiduLlmParam.setFunctions(function);
        }
        return baiduLlmParam;
    }

    @Override
    public ModelResult getResult(ModelResultParam modelResultParam) {
        boolean stream = modelResultParam.isStream();
        String result = modelResultParam.getResult();
        ModelResult modelResult = new ModelResult();
        if (stream) {
            if (kd.bos.util.StringUtils.isEmpty((String)result)) {
                modelResult.setContent("");
                return modelResult;
            }
            String string = result = result.startsWith("data: ") ? result.substring(6) : result;
            if (JSONPath.contains((Object)result, (String)"$.function_call")) {
                String msg = (String)JSONPath.read((String)result, (String)"$.function_call", String.class);
                modelResult.setContent(msg == null ? "" : "function_call&" + msg);
                return modelResult;
            }
            if (JSONPath.contains((Object)result, (String)"$.result")) {
                String msg = (String)JSONPath.read((String)result, (String)"$.result", String.class);
                modelResult.setContent(msg == null ? "" : msg);
                return modelResult;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)result, (CharSequence)"[DONE]")) {
                return null;
            }
            throw new KDBizException(ResManager.loadKDString((String)"BAIDU_ERNIE_BOT \u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:", (String)"BaiduErnieWithSystemService_15096228", (String)"ai-gai-core", (Object[])new Object[0]) + result);
        }
        if (JSONPath.contains((Object)result, (String)"$.function_call")) {
            String msg = (String)JSONPath.read((String)result, (String)"$.function_call", String.class);
            modelResult.setContent(msg == null ? "" : msg);
            return modelResult;
        }
        if (!JSONPath.contains((Object)result, (String)"$.result")) {
            throw new KDBizException(ResManager.loadKDString((String)"BAIDU_ERNIE_BOT \u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:", (String)"BaiduErnieWithSystemService_15096229", (String)"ai-gai-core", (Object[])new Object[0]) + result);
        }
        modelResult.setContent((String)JSONPath.read((String)result, (String)"$.result", String.class));
        return modelResult;
    }

    @Override
    public List<Long> filterContext(String allMsg, List<Long> chunkIdList, List<Long> fileIdList) {
        if (!StringUtils.isEmpty((CharSequence)allMsg) && allMsg.length() <= 10 && (allMsg.contains(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49", (String)"BaiduErnieWithSystemService_15096231", (String)"ai-gai-core", (Object[])new Object[0])) || allMsg.contains(ResManager.loadKDString((String)"\u4e0d\u77e5\u9053", (String)"BaiduErnieWithSystemService_15096230", (String)"ai-gai-core", (Object[])new Object[0])))) {
            logger.info("\u4e0d\u77e5\u9053\u8fc7\u6ee4\u5f15\u7528");
            return new ArrayList<Long>();
        }
        List<RepoFileVO> repoFileVOList = RepoService.getFilesByChunkIds(chunkIdList);
        return repoFileVOList.stream().map(RepoFileVO::getFileId).collect(Collectors.toList());
    }

    @Override
    public int getTokenCount(String text) {
        return (int)Math.ceil((double)GaiUtils.countEnglishWords(text) * 1.3) + GaiUtils.countChineseCharacters(text);
    }

    @Override
    public JSONObject getTypeParam(LlmStyle llmStyle) {
        BaiduWithSystemLlmParam baiduWithSystemLlmParam = new BaiduWithSystemLlmParam();
        JSONObject reultJson = baiduWithSystemLlmParam.getDefaultTypeParam(llmStyle);
        return reultJson;
    }
}

