/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.llm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.llm.AzureLlmParam;
import kd.ai.gai.core.domain.llm.PromptBuildParam;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.MessageItem4AzureBaiduTencentXf;
import kd.ai.gai.core.domain.llm.base.ModelResult;
import kd.ai.gai.core.domain.llm.base.ModelResultParam;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.service.llm.Azure35Service;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DeepSeekService
extends Azure35Service {
    private static final Log logger = LogFactory.getLog(DeepSeekService.class);

    public DeepSeekService(int inputLimit, LLM llm) {
        super(inputLimit, llm);
    }

    @Override
    public LlmParam buildPrompt(PromptBuildParam promptBuildParam) {
        String user = promptBuildParam.getUser();
        boolean stream = promptBuildParam.isStream();
        Boolean reference = promptBuildParam.getReference();
        String systemPromptTemplate = promptBuildParam.getSystemPromptTemplate();
        Map<String, String> variableMap = promptBuildParam.getVariableMap();
        List<UserHistoryMessage> history = promptBuildParam.getHistory();
        List<Chunk> chunkList = promptBuildParam.getChunkList();
        String userInput = promptBuildParam.getUserInput();
        String customParamJson = promptBuildParam.getCustomParamJson();
        logger.info("\u6784\u5efa\u63d0\u793a\uff0c\u5176\u4e2d\u5386\u53f2\u8bb0\u5f55{}\u6761\uff0c\u4e0a\u4e0b\u6587{}\u6761", (Object)(history == null ? 0 : history.size()), (Object)(chunkList == null ? 0 : chunkList.size()));
        AzureLlmParam azureGptParam = this.buildParam(promptBuildParam.getLlmStyle(), customParamJson);
        azureGptParam.setStream(stream);
        azureGptParam.setUser(user);
        ArrayList<MessageItem4AzureBaiduTencentXf> list = new ArrayList<MessageItem4AzureBaiduTencentXf>(16);
        int tokenCount = this.addHistoryMessage(reference, systemPromptTemplate, variableMap, history, chunkList, userInput, list, true);
        azureGptParam.setInPutToken(tokenCount);
        azureGptParam.setMessages(list);
        return azureGptParam;
    }

    @Override
    public AzureLlmParam buildParam(LlmStyle llmStyle, String paramJson) {
        AzureLlmParam azureLlmParam = new AzureLlmParam();
        if (StringUtils.isNotEmpty((CharSequence)paramJson)) {
            JSONObject paramObj = JSON.parseObject((String)paramJson);
            azureLlmParam.setTemperature(paramObj.getFloat("temperature").floatValue());
            azureLlmParam.setTop_p(paramObj.getFloat("top_p").floatValue());
            azureLlmParam.setPresence_penalty(paramObj.getFloat("presence_penalty").floatValue());
            azureLlmParam.setFrequency_penalty(paramObj.getFloat("frequency_penalty").floatValue());
            azureLlmParam.setMax_tokens(paramObj.getInteger("max_tokens"));
        } else {
            switch (llmStyle) {
                case CREATIVITY: {
                    azureLlmParam.setTemperature(0.8f);
                    azureLlmParam.setTop_p(0.9f);
                    azureLlmParam.setPresence_penalty(0.1f);
                    azureLlmParam.setFrequency_penalty(0.1f);
                    break;
                }
                case PRECISION: {
                    azureLlmParam.setTemperature(0.0f);
                    azureLlmParam.setTop_p(0.95f);
                    azureLlmParam.setPresence_penalty(0.0f);
                    azureLlmParam.setFrequency_penalty(0.0f);
                    break;
                }
                default: {
                    azureLlmParam.setTemperature(0.5f);
                    azureLlmParam.setTop_p(0.95f);
                    azureLlmParam.setPresence_penalty(0.0f);
                    azureLlmParam.setFrequency_penalty(0.0f);
                }
            }
        }
        return azureLlmParam;
    }

    @Override
    public ModelResult getResult(ModelResultParam modelResultParam) {
        boolean stream = modelResultParam.isStream();
        String result = modelResultParam.getResult();
        ModelResult modelResult = new ModelResult();
        if (StringUtils.isEmpty((CharSequence)result)) {
            modelResult.setContent("");
            modelResult.setThink("");
            return modelResult;
        }
        if (stream) {
            String string = result.startsWith("data:") ? (result.indexOf("{") != -1 ? result.substring(result.indexOf("{")) : result) : (result = result);
            if (JSONPath.contains((Object)result, (String)"$.prompt_filter_results")) {
                modelResult.setContent("");
                modelResult.setThink("");
                return modelResult;
            }
            if (JSONPath.contains((Object)result, (String)"$.choices") && (Integer)JSONPath.read((String)result, (String)"$.choices.size()", Integer.TYPE) == 0) {
                modelResult.setContent("");
                return modelResult;
            }
            if (JSONPath.contains((Object)result, (String)"$.id")) {
                String finishReason;
                String id = (String)JSONPath.read((String)result, (String)"$.id", String.class);
                LocalMemoryCache localCache = EngineCache.getLocalCache(id);
                boolean thinkInResoning = false;
                Object judgeFlagObj = localCache.get(this.getJudgeFlagKey(id));
                if (judgeFlagObj != null) {
                    thinkInResoning = (Boolean)judgeFlagObj;
                }
                if (JSONPath.contains((Object)result, (String)"$.choices[0].finish_reason") && "stop".equals(finishReason = (String)JSONPath.read((String)result, (String)"$.choices[0].finish_reason", String.class))) {
                    this.removeJudgeFlagCache(id);
                }
                if (JSONPath.contains((Object)result, (String)"$.choices[0].delta")) {
                    if (JSONPath.contains((Object)result, (String)"$.choices[0].delta.reasoning_content")) {
                        String think = (String)JSONPath.read((String)result, (String)"$.choices[0].delta.reasoning_content", String.class);
                        modelResult.setThink(think == null ? "" : think);
                        if (!thinkInResoning) {
                            this.updateJudgeFlag(id);
                            thinkInResoning = true;
                        }
                        return modelResult;
                    }
                    if (JSONPath.contains((Object)result, (String)"$.choices[0].delta.content")) {
                        String msg = (String)JSONPath.read((String)result, (String)"$.choices[0].delta.content", String.class);
                        this.updateModelResult(msg, id, modelResult, thinkInResoning);
                        return modelResult;
                    }
                    modelResult.setContent("");
                    modelResult.setThink("");
                    return modelResult;
                }
            }
            if (StringUtils.containsIgnoreCase((CharSequence)result, (CharSequence)"[DONE]")) {
                return modelResult;
            }
            throw new KDBizException(this.getLlm().getNumber() + "\u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:" + result);
        }
        if (JSONPath.contains((Object)result, (String)"$.choices[0].message.reasoning_content")) {
            String think = (String)JSONPath.read((String)result, (String)"$.choices[0].message.reasoning_content", String.class);
            modelResult.setThink(think == null ? "" : think);
        }
        if (JSONPath.contains((Object)result, (String)"$.choices[0].message.content")) {
            String msg = (String)JSONPath.read((String)result, (String)"$.choices[0].message.content", String.class);
            String string = msg = msg == null ? "" : msg;
            if (msg.contains("<think>") && msg.contains("</think>")) {
                this.setThinkAndContent(msg, modelResult);
            } else {
                modelResult.setContent(msg);
            }
        }
        return modelResult;
    }

    private String getJudgeFlagKey(String id) {
        return String.format("gai_need_judge_think_%s", id);
    }

    private void removeJudgeFlagCache(String id) {
        LocalMemoryCache localCache = EngineCache.getLocalCache(id);
        localCache.remove(new String[]{this.getJudgeFlagKey(id)});
        localCache.remove(new String[]{"streamThinkTag_" + id});
    }

    private void updateJudgeFlag(String id) {
        LocalMemoryCache localCache = EngineCache.getLocalCache(id);
        Object o = localCache.get(this.getJudgeFlagKey(id));
        if (o == null) {
            localCache.put(this.getJudgeFlagKey(id), (Object)true);
        }
    }

    private void updateModelResult(String msg, String id, ModelResult modelResult, boolean thinkInResoning) {
        boolean thinkFlag;
        LocalMemoryCache localCache = EngineCache.getLocalCache(id);
        String taskThinkFlag = (String)localCache.get("streamThinkTag_" + id);
        boolean bl = thinkFlag = StringUtils.isNotEmpty((CharSequence)taskThinkFlag) && "1,2".contains(taskThinkFlag);
        if (StringUtils.isEmpty((CharSequence)msg)) {
            if (thinkFlag) {
                modelResult.setThink("");
            } else {
                modelResult.setContent("");
            }
            return;
        }
        if (msg.contains("<think>") || !thinkInResoning && taskThinkFlag == null) {
            if (taskThinkFlag == null) {
                localCache.put("streamThinkTag_" + id, (Object)"1");
                msg = msg.replace("<think>", "");
            } else {
                localCache.put("streamThinkTag_" + id, (Object)"2");
            }
            thinkFlag = true;
        } else if (msg.contains("</think>")) {
            if ("1,2".contains(taskThinkFlag)) {
                msg = msg.replace("</think>", "");
            }
            localCache.put("streamThinkTag_" + id, (Object)"0");
        }
        if (thinkFlag) {
            modelResult.setThink(msg);
        } else {
            modelResult.setContent(msg);
        }
    }

    private void setThinkAndContent(String msg, ModelResult modelResult) {
        String think = msg.substring(msg.indexOf("<think>") + 7, msg.lastIndexOf("</think>"));
        String content = msg.substring(msg.lastIndexOf("</think>") + 8);
        modelResult.setThink(think);
        modelResult.setContent(content);
    }
}

