/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.llm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.llm.AzureLlmParam;
import kd.ai.gai.core.domain.llm.PromptBuildParam;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.MessageItem4AzureBaiduTencentXf;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.service.llm.Azure35Service;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DeepSeekV3Service
extends Azure35Service {
    private static final Log logger = LogFactory.getLog(DeepSeekV3Service.class);

    public DeepSeekV3Service(int inputLimit, LLM llm) {
        super(inputLimit, llm);
    }

    @Override
    public LlmParam buildPrompt(PromptBuildParam promptBuildParam) {
        String user = promptBuildParam.getUser();
        boolean stream = promptBuildParam.isStream();
        Boolean reference = promptBuildParam.getReference();
        String systemPromptTemplate = promptBuildParam.getSystemPromptTemplate();
        Map<String, String> variableMap = promptBuildParam.getVariableMap();
        List<UserHistoryMessage> history = promptBuildParam.getHistory();
        List<Chunk> chunkList = promptBuildParam.getChunkList();
        String userInput = promptBuildParam.getUserInput();
        String customParamJson = promptBuildParam.getCustomParamJson();
        logger.info("\u6784\u5efa\u63d0\u793a\uff0c\u5176\u4e2d\u5386\u53f2\u8bb0\u5f55{}\u6761\uff0c\u4e0a\u4e0b\u6587{}\u6761", (Object)(history == null ? 0 : history.size()), (Object)(chunkList == null ? 0 : chunkList.size()));
        AzureLlmParam azureGptParam = this.buildParam(promptBuildParam.getLlmStyle(), customParamJson);
        azureGptParam.setStream(stream);
        azureGptParam.setUser(user);
        ArrayList<MessageItem4AzureBaiduTencentXf> list = new ArrayList<MessageItem4AzureBaiduTencentXf>(16);
        int tokenCount = this.addHistoryMessage(reference, systemPromptTemplate, variableMap, history, chunkList, userInput, list, true);
        azureGptParam.setInPutToken(tokenCount);
        azureGptParam.setMessages(list);
        return azureGptParam;
    }

    @Override
    public AzureLlmParam buildParam(LlmStyle llmStyle, String paramJson) {
        AzureLlmParam azureLlmParam = new AzureLlmParam();
        if (StringUtils.isNotEmpty((CharSequence)paramJson)) {
            JSONObject paramObj = JSON.parseObject((String)paramJson);
            azureLlmParam.setTemperature(paramObj.getFloat("temperature").floatValue());
            azureLlmParam.setTop_p(paramObj.getFloat("top_p").floatValue());
            azureLlmParam.setPresence_penalty(paramObj.getFloat("presence_penalty").floatValue());
            azureLlmParam.setFrequency_penalty(paramObj.getFloat("frequency_penalty").floatValue());
        } else {
            switch (llmStyle) {
                case CREATIVITY: {
                    azureLlmParam.setTemperature(0.8f);
                    azureLlmParam.setTop_p(0.9f);
                    azureLlmParam.setPresence_penalty(0.1f);
                    azureLlmParam.setFrequency_penalty(0.1f);
                    break;
                }
                case PRECISION: {
                    azureLlmParam.setTemperature(0.0f);
                    azureLlmParam.setTop_p(0.95f);
                    azureLlmParam.setPresence_penalty(0.0f);
                    azureLlmParam.setFrequency_penalty(0.0f);
                    break;
                }
                default: {
                    azureLlmParam.setTemperature(0.5f);
                    azureLlmParam.setTop_p(0.95f);
                    azureLlmParam.setPresence_penalty(0.0f);
                    azureLlmParam.setFrequency_penalty(0.0f);
                }
            }
        }
        return azureLlmParam;
    }
}

