/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.llm;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.llm.KingdeeLlmParam;
import kd.ai.gai.core.domain.llm.PromptBuildParam;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.ModelResult;
import kd.ai.gai.core.domain.llm.base.ModelResultParam;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.domain.vo.RepoFileVO;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.service.RepoService;
import kd.ai.gai.core.service.llm.LlmService;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class KingdeeModelService
extends LlmService<KingdeeLlmParam> {
    private static final Log logger = LogFactory.getLog(KingdeeModelService.class);

    public KingdeeModelService(int inputLimit, LLM llm) {
        super(inputLimit, llm);
    }

    @Override
    public LlmParam buildPrompt(PromptBuildParam promptBuildParam) {
        String user = promptBuildParam.getUser();
        boolean stream = promptBuildParam.isStream();
        Boolean reference = promptBuildParam.getReference();
        String systemPromptTemplate = promptBuildParam.getSystemPromptTemplate();
        Map<String, String> variableMap = promptBuildParam.getVariableMap();
        List<UserHistoryMessage> history = promptBuildParam.getHistory();
        List<Chunk> chunkList = promptBuildParam.getChunkList();
        String userInput = promptBuildParam.getUserInput();
        String customParamJson = promptBuildParam.getCustomParamJson();
        logger.info("\u6784\u5efa\u63d0\u793a\uff0c\u5176\u4e2d\u5386\u53f2\u8bb0\u5f55{}\u6761\uff0c\u4e0a\u4e0b\u6587{}\u6761", (Object)(history == null ? 0 : history.size()), (Object)(chunkList == null ? 0 : chunkList.size()));
        if (variableMap == null) {
            variableMap = new HashMap<String, String>();
        }
        String systemContent = KingdeeModelService.fillVariable(systemPromptTemplate, chunkList, variableMap);
        String context = this.getContext(reference, systemContent, chunkList, this.getTokenCount(userInput) + this.getTokenCount(systemContent));
        systemContent = reference == null ? systemContent + context : context;
        KingdeeLlmParam kingdeeLlmParam = new KingdeeLlmParam();
        kingdeeLlmParam.setSystem(systemContent);
        kingdeeLlmParam.setUserInput(userInput);
        kingdeeLlmParam.setStream(stream);
        return kingdeeLlmParam;
    }

    @Override
    public ModelResult getResult(ModelResultParam modelResultParam) {
        boolean stream = modelResultParam.isStream();
        String result = modelResultParam.getResult();
        ModelResult modelResult = new ModelResult();
        if (stream) {
            if (StringUtils.isEmpty((CharSequence)result)) {
                modelResult.setContent("");
                return modelResult;
            }
            String string = result = result.startsWith("data: ") ? result.substring(6) : result;
            if (JSONPath.contains((Object)result, (String)"$.choices") && (Integer)JSONPath.read((String)result, (String)"$.choices.size()", Integer.TYPE) == 0) {
                modelResult.setContent("");
                return modelResult;
            }
            if (JSONPath.contains((Object)result, (String)"$.choices[0].delta")) {
                String msg = (String)JSONPath.read((String)result, (String)"$.choices[0].delta.content", String.class);
                modelResult.setContent(msg == null ? "" : msg);
                return modelResult;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)result, (CharSequence)"[DONE]")) {
                return modelResult;
            }
        } else {
            if (JSONPath.contains((Object)result, (String)"$.results[0]")) {
                String msg = (String)JSONPath.read((String)result, (String)"$.results[0]", String.class);
                modelResult.setContent(msg == null ? "" : msg);
                return modelResult;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)result, (CharSequence)"[DONE]")) {
                return modelResult;
            }
        }
        throw new KDBizException("Kingdee Model \u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:" + result);
    }

    @Override
    public List<Long> filterContext(String allMsg, List<Long> chunkIdList, List<Long> fileIdList) {
        if (!StringUtils.isEmpty((CharSequence)allMsg) && allMsg.length() <= 10 && (allMsg.contains("\u5f88\u62b1\u6b49") || allMsg.contains("\u4e0d\u77e5\u9053"))) {
            logger.info("\u4e0d\u77e5\u9053\u8fc7\u6ee4\u5f15\u7528");
            return new ArrayList<Long>();
        }
        List<RepoFileVO> repoFileVOList = RepoService.getFilesByChunkIds(chunkIdList);
        return repoFileVOList.stream().map(RepoFileVO::getFileId).collect(Collectors.toList());
    }

    @Override
    public JSONObject getTypeParam(LlmStyle llmStyle) {
        KingdeeLlmParam kingdeeLlmParam = new KingdeeLlmParam();
        JSONObject reultJson = kingdeeLlmParam.getDefaultTypeParam(llmStyle);
        return reultJson;
    }
}

