/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.llm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.dto.Chunks4LLMItem;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.domain.dto.TrustLayerContext;
import kd.ai.gai.core.domain.dto.TrustLayerResult;
import kd.ai.gai.core.domain.llm.LLMSearchInfo;
import kd.ai.gai.core.domain.llm.PromptBuildParam;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.ModelResult;
import kd.ai.gai.core.domain.llm.base.ModelResultParam;
import kd.ai.gai.core.domain.llm.base.Result2User;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.domain.vo.RepoFileVO;
import kd.ai.gai.core.domain.vo.RepoVO;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.message.llmcallback.LLMParsedMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.enuz.VectorMetricType;
import kd.ai.gai.core.service.LlmServiceFactory;
import kd.ai.gai.core.service.RepoService;
import kd.ai.gai.core.service.embedding.EmbeddingServiceFactory;
import kd.ai.gai.core.service.trusty.TrustLayerService;
import kd.ai.gai.core.trace.entity.PromptLog;
import kd.ai.gai.core.trace.entity.TrustLayerLog;
import kd.ai.gai.core.trace.entity.VectorRetrieverLog;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.ai.gai.core.util.GaiUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public abstract class LlmService<T extends LlmParam> {
    private static final Log logger = LogFactory.getLog(LlmService.class);
    public static final String splitUserContent = "########";
    private LLM llm;
    private int inputLimit;

    public LlmService(int inputLimit, LLM llm) {
        this.inputLimit = inputLimit;
        this.llm = llm;
    }

    public abstract LlmParam buildPrompt(PromptBuildParam var1);

    public abstract ModelResult getResult(ModelResultParam var1);

    protected String getContext(Boolean reference, String promptTemplate, List<Chunk> chunkList, int systemAndInputLen) {
        if (reference == null) {
            if (chunkList == null || chunkList.isEmpty() || StringUtils.isNotEmpty((CharSequence)chunkList.get(0).getKdCode())) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            switch (this.getLlm()) {
                case AZURE_GPT_40: 
                case AZURE_GPT_40_32: 
                case XMINDAI_GPT_40: 
                case AWS_ANTHROPIC_CLAUDE_MESSAGES: {
                    String docStart = ResManager.loadKDString((String)"#\u4f60\u662f\u4e00\u4e2a\u77e5\u8bc6\u95ee\u7b54\u52a9\u624b\uff0c\u8bf7\u4e25\u683c\u4f9d\u636e\u63d0\u4f9b\u7684\u77e5\u8bc6\uff0c\u51c6\u786e\u3001\u7b80\u6d01\u5730\u56de\u7b54\u7528\u6237\u95ee\u9898\uff0c\u8bf7\u4e0d\u8981\u7f16\u9020\u5e7b\u60f3\u3002\u5982\u679c\u4f60\u65e0\u6cd5\u4ece\u63d0\u4f9b\u7684\u77e5\u8bc6\u4e2d\u5f97\u51fa\u7b54\u6848\uff0c\u8bf7\u56de\u590d\u201c\u4e0d\u77e5\u9053\u201d\u3002\n#\u77e5\u8bc6\u5c06\u4f1a\u4ee5json\u7684\u5f62\u5f0f\u51fa\u73b0\uff0c\u4e3b\u8981\u5305\u542b\u77e5\u8bc6\u7684ID\uff08doc_id\uff09\u3001\u77e5\u8bc6\u7684\u5185\u5bb9\uff08content\uff09\u3002\u77e5\u8bc6\u7684\u683c\u5f0f\u793a\u4f8b\u5982\u4e0b\uff1a\n[{\"doc_id\":111,\"content\":\"\u7532\u65b9\u8054\u7cfb\u4eba\u5f20\u4e09\"},{\"doc_id\":222,\"content\":\"\u4e59\u65b9\u8054\u7cfb\u4eba\u674e\u56db\"}]\n#\u4f60\u7684\u56de\u590d\u4e3b\u8981\u5305\u542b\u56de\u590d\u6587\u672c\u548c\u53c2\u8003\u7684\u77e5\u8bc6ID\u3002\u8bf7\u4f60\u4e00\u53e5\u4e00\u53e5\u7684\u56de\u590d\uff0c\u5982\u679c\u4f60\u56de\u590d\u4e2d\u7684\u67d0\u53e5\u8bdd\u662f\u53c2\u8003\u67d0\u4e2a\u77e5\u8bc6\u800c\u5f97\u51fa\u7684\uff0c\u8bf7\u4f60\u5728\u8fd9\u53e5\u8bdd\u6700\u540e\u52a0\u4e0a\u77e5\u8bc6\u7684doc_id\uff0c\u5e76\u5728doc_id\u524d\u540e\u62fc\u63a5\u201c########\u201d\u3002\n#\u5b8c\u6574\u793a\u4f8b\u5982\u4e0b\uff1a\n\u63d0\u4f9b\u7684\u77e5\u8bc6\u662f[{\"doc_id\":111,\"content\":\"\u7532\u65b9\u8054\u7cfb\u4eba\u5f20\u4e09\"},{\"doc_id\":222,\"content\":\"\u4e59\u65b9\u8054\u7cfb\u4eba\u674e\u56db\"}]\n\u7528\u6237\u95ee\u9898\u662f\u201c\u7532\u65b9\u548c\u4e59\u65b9\u8054\u7cfb\u4eba\u5206\u522b\u662f\u8c01\uff1f\u201d\n\u7ed9\u51fa\u56de\u590d\uff1a\u7532\u65b9\u8054\u7cfb\u4eba\u662f\u5f20\u4e09 ########111######## \uff0c\u4e59\u65b9\u8054\u7cfb\u4eba\u662f\u674e\u56db########222######## \u3002\n#\u77e5\u8bc6\n", (String)"gai.core.doc.gpt4.start", (String)"ai-gai-core", (Object[])new Object[0]);
                    builder.append(docStart);
                    List<Chunks4LLMItem> chunk4Llm = this.chunkList2LLMList(chunkList, systemAndInputLen);
                    builder.append(JSON.toJSON(chunk4Llm));
                    break;
                }
                case AZURE_GPT_35: 
                case DEEPSEEK_R1: 
                case DEEPSEEK_V3: 
                case AZURE_GPT_35_16: {
                    String docStart = ResManager.loadKDString((String)"#\u4f60\u662f\u4e00\u4e2a\u77e5\u8bc6\u95ee\u7b54\u52a9\u624b\uff0c\u6839\u636e\u63d0\u4f9b\u7684\u77e5\u8bc6\u51c6\u786e\u3001\u7b80\u6d01\u5730\u56de\u7b54\u95ee\u9898\u3002\u5728\u7b54\u590d\u7684\u6bcf\u4e00\u53e5\u540e\u8fb9\u7ed9\u51fa\u5185\u5bb9\u7684\u51fa\u5904\uff0c\u524d\u540e\u4f7f\u201c########\u201d\u5305\u88f9\u5f15\u7528\u5230\u7684doc_id\u3002\n\n#\u4f8b\u5b50\n\u77e5\u8bc6\uff1a\n[{\"doc_id\":111,\"content\":\"\n\u7532\u65b9\u8054\u7cfb\u4eba\u5f20\u4e09\n\"},{\"doc_id\":222,\"content\":\"\n\u4e59\u65b9\u8054\u7cfb\u4eba\u674e\u56db\n\"}]\n\u95ee\u9898\uff1a\u7532\u4e59\u65b9\u8054\u7cfb\u4eba\u5206\u522b\u662f\u8c01\uff1f\n\u56de\u590d\uff1a\u7532\u65b9\u8054\u7cfb\u4eba\u662f\u5f20\u4e09########111########\uff0c\u4e59\u65b9\u8054\u7cfb\u4eba\u662f\u674e\u56db########222########\u3002\n", (String)"gai.core.doc.gpt35.start", (String)"ai-gai-core", (Object[])new Object[0]);
                    builder.append(docStart);
                    List<Chunks4LLMItem> chunk4Llm = this.chunkList2LLMList(chunkList, systemAndInputLen);
                    builder.append(JSON.toJSON(chunk4Llm));
                    break;
                }
                case BAIDU_ERNIE_BOT_PRO: {
                    String docStart = ResManager.loadKDString((String)"#\u4f60\u662f\u4e00\u4e2a\u77e5\u8bc6\u95ee\u7b54\u52a9\u624b\uff0c\u8bf7\u4e25\u683c\u4f9d\u636e\u63d0\u4f9b\u7684\u77e5\u8bc6\uff0c\u51c6\u786e\u3001\u7b80\u6d01\u5730\u56de\u7b54\u7528\u6237\u95ee\u9898\uff0c\u8bf7\u4e0d\u8981\u7f16\u9020\u5e7b\u60f3\u3002\u5982\u679c\u4f60\u65e0\u6cd5\u4ece\u63d0\u4f9b\u7684\u77e5\u8bc6\u4e2d\u5f97\u51fa\u7b54\u6848\uff0c\u8bf7\u56de\u590d\u201c\u4e0d\u77e5\u9053\u201d\u3002\n#\u77e5\u8bc6\u5c06\u4f1a\u4ee5json\u7684\u5f62\u5f0f\u51fa\u73b0\uff0c\u4e3b\u8981\u5305\u542b\u77e5\u8bc6\u7684ID\uff08doc_id\uff09\u3001\u77e5\u8bc6\u7684\u5185\u5bb9\uff08content\uff09\u3002\n#\u4f60\u7684\u56de\u590d\u9700\u8981\u9075\u5faa\u4ee5\u4e0b\u8981\u6c42\uff1a1\u3001\u5728\u56de\u590d\u7684\u672b\u5c3e\u6dfb\u52a0\u201c########\u201d\u3002 2\u3001\u4f9d\u6b21\u6dfb\u52a0\u56de\u590d\u6240\u53c2\u8003\u77e5\u8bc6\u7684doc_id\n#\u5b8c\u6574\u793a\u4f8b\u5982\u4e0b\uff1a\n\u63d0\u4f9b\u7684\u77e5\u8bc6\u662f\uff1a[{\"doc_id\":111,\"content\":\"\u7532\u65b9\u8054\u7cfb\u4eba\u5f20\u4e09\"},{\"doc_id\":222,\"content\":\"\u4e59\u65b9\u8054\u7cfb\u4eba\u674e\u56db\"}]\n\u7528\u6237\u95ee\u9898\u662f\uff1a\u201c\u7532\u65b9\u548c\u4e59\u65b9\u8054\u7cfb\u4eba\u5206\u522b\u662f\u8c01\uff1f\u201d\n\u7ed9\u51fa\u56de\u590d\uff1a\u7532\u65b9\u8054\u7cfb\u4eba\u662f\u5f20\u4e09\uff0c\u4e59\u65b9\u8054\u7cfb\u4eba\u662f\u674e\u56db\u3002########111,222\n\u77e5\u8bc6\n", (String)"gai.core.doc.ernie.pro.start", (String)"ai-gai-core", (Object[])new Object[0]);
                    builder.append(docStart);
                    List<Chunks4LLMItem> chunk4Llm = this.chunkList2LLMList(chunkList, systemAndInputLen);
                    builder.append(JSON.toJSON(chunk4Llm));
                    break;
                }
                default: {
                    builder.append("#\u4f60\u662f\u4e00\u4e2a\u6587\u6863\u95ee\u7b54\u52a9\u624b\uff0c\u6839\u636e\u76f8\u5173\u6587\u6863\u5185\u5bb9\u51c6\u786e\u3001\u7b80\u6d01\u5730\u56de\u7b54\u95ee\u9898\u3002\u53ea\u56de\u590d\u5185\u5bb9\uff0c\u4e0d\u8981\u56de\u590d <>\u5305\u88f9\u7684\u6570\u5b57\u5e8f\u53f7");
                    builder.append("#\u5982\u679c\u76f8\u5173\u6587\u6863\u5185\u5bb9\u6ca1\u6709\u7b54\u6848\uff0c\u5c31\u56de\u7b54\"\u4e0d\u77e5\u9053\"\uff0c\u4e0d\u8981\u7f16\u9020\u3002\r\n");
                    builder.append("#\u5982\u679c\u76f8\u5173\u6587\u6863\u5185\u5bb9\u6ca1\u6709\u7b54\u6848\uff0c\u5c31\u56de\u7b54\"\u4e0d\u77e5\u9053\"\uff0c\u4e0d\u8981\u7f16\u9020\u3002\r\n");
                    builder.append("#\u76f8\u5173\u6587\u6863\uff1a\r\n");
                    for (Chunk chunk : chunkList) {
                        builder.append('<').append(chunk.getId()).append('>').append(' ').append(chunk.getChunk()).append("\r\n");
                    }
                }
            }
            return builder.toString();
        }
        if (reference.booleanValue()) {
            switch (this.getLlm()) {
                case AZURE_GPT_40: 
                case AZURE_GPT_40_32: 
                case XMINDAI_GPT_40: 
                case AWS_ANTHROPIC_CLAUDE_MESSAGES: 
                case DEEPSEEK_R1: 
                case DEEPSEEK_V3: {
                    return promptTemplate + ResManager.loadKDString((String)"#\u77e5\u8bc6\u5c06\u4f1a\u4ee5json\u7684\u5f62\u5f0f\u51fa\u73b0\uff0c\u4e3b\u8981\u5305\u542b\u77e5\u8bc6\u7684ID\uff08doc_id\uff09\u3001\u77e5\u8bc6\u7684\u5185\u5bb9\uff08content\uff09\u3002\u77e5\u8bc6\u7684\u683c\u5f0f\u793a\u4f8b\u5982\u4e0b\uff1a\n[{\"doc_id\":111,\"content\":\"\u7532\u65b9\u8054\u7cfb\u4eba\u5f20\u4e09\"},{\"doc_id\":222,\"content\":\"\u4e59\u65b9\u8054\u7cfb\u4eba\u674e\u56db\"}]\n#\u4f60\u7684\u56de\u590d\u4e3b\u8981\u5305\u542b\u56de\u590d\u6587\u672c\u548c\u53c2\u8003\u7684\u77e5\u8bc6ID\u3002\u8bf7\u4f60\u4e00\u53e5\u4e00\u53e5\u7684\u56de\u590d\uff0c\u5982\u679c\u4f60\u56de\u590d\u4e2d\u7684\u67d0\u53e5\u8bdd\u662f\u53c2\u8003\u67d0\u4e2a\u77e5\u8bc6\u800c\u5f97\u51fa\u7684\uff0c\u8bf7\u4f60\u5728\u8fd9\u53e5\u8bdd\u6700\u540e\u52a0\u4e0a\u77e5\u8bc6\u7684doc_id\uff0c\u5e76\u5728doc_id\u524d\u540e\u62fc\u63a5\u201c########\u201d\u3002\n#\u5b8c\u6574\u793a\u4f8b\u5982\u4e0b\uff1a\n\u63d0\u4f9b\u7684\u77e5\u8bc6\u662f[{\"doc_id\":111,\"content\":\"\u7532\u65b9\u8054\u7cfb\u4eba\u5f20\u4e09\"},{\"doc_id\":222,\"content\":\"\u4e59\u65b9\u8054\u7cfb\u4eba\u674e\u56db\"}]\n\u7528\u6237\u95ee\u9898\u662f\u201c\u7532\u65b9\u548c\u4e59\u65b9\u8054\u7cfb\u4eba\u5206\u522b\u662f\u8c01\uff1f\u201d\n\u7ed9\u51fa\u56de\u590d\uff1a\u7532\u65b9\u8054\u7cfb\u4eba\u662f\u5f20\u4e09 ########111######## \uff0c\u4e59\u65b9\u8054\u7cfb\u4eba\u662f\u674e\u56db########222######## \u3002", (String)"gai.core.doc.azure40.repo.start", (String)"ai-gai-core", (Object[])new Object[0]);
                }
                case BAIDU_ERNIE_TURBO: {
                    return promptTemplate + ResManager.loadKDString((String)"#\u77e5\u8bc6\u5c06\u4f1a\u4ee5JSON\u7684\u5f62\u5f0f\u5448\u73b0\uff0c\u4e3b\u8981\u5305\u542b\u77e5\u8bc6\u7684\u552f\u4e00\u6807\u8bc6\u7b26\uff08chunkId\uff09\u53ca\u5bf9\u5e94\u7684\u5185\u5bb9\uff08chunk\uff09\u3002\n\u77e5\u8bc6\u7684\u5177\u4f53\u683c\u5f0f\u793a\u4f8b\u5982\u4e0b\uff1a\n[{\"chunkId\":111,\"chunk\":\"\u7532\u65b9\u8054\u7cfb\u4eba\u5f20\u4e09\"},{\"chunkId\":222,\"chunk\":\"\u4e59\u65b9\u8054\u7cfb\u4eba\u674e\u56db\"}]\n#\u4f60\u7684\u56de\u590d\u5e94\u4ee5\u6587\u672c\u5f62\u5f0f\u7ed9\u51fa\uff0c\u5e76\u5305\u542b\u5bf9\u5e94\u7684\u53c2\u8003\u77e5\u8bc6ID\u3002\u8bf7\u5728\u5f15\u7528\u67d0\u4e2a\u77e5\u8bc6\u65f6\uff0c\u5728\u8be5\u53e5\u8bdd\u672b\u5c3e\u6dfb\u52a0\u8be5\u77e5\u8bc6\u7684chunkId\uff0c\u683c\u5f0f\u4e3a\u201c########chunkId########\u201d\u3002\n#\u5b8c\u6574\u793a\u4f8b\u8bf4\u660e\uff1a\n\u5047\u8bbe\u63d0\u4f9b\u7684\u77e5\u8bc6\u4e3a[{\"chunkId\":111,\"chunk\":\"\u7532\u65b9\u8054\u7cfb\u4eba\u5f20\u4e09\"},{\"chunkId\":222,\"chunk\":\"\u4e59\u65b9\u8054\u7cfb\u4eba\u674e\u56db\"}]\n\u9762\u5bf9\u7528\u6237\u63d0\u95ee\u201c\u7532\u65b9\u548c\u4e59\u65b9\u8054\u7cfb\u4eba\u5206\u522b\u662f\u8c01\uff1f\u201d\n\u4f60\u7684\u56de\u590d\u5e94\u4e3a\uff1a\u7532\u65b9\u8054\u7cfb\u4eba\u662f\u5f20\u4e09########111########\uff0c\u4e59\u65b9\u8054\u7cfb\u4eba\u662f\u674e\u56db########222########\u3002", (String)"gai.core.doc.ernie.turbo.start", (String)"ai-gai-core", (Object[])new Object[0]);
                }
            }
            return promptTemplate + ResManager.loadKDString((String)"#\u77e5\u8bc6\u5c06\u4f1a\u4ee5json\u7684\u5f62\u5f0f\u51fa\u73b0\uff0c\u4e3b\u8981\u5305\u542b\u77e5\u8bc6\u7684ID\uff08doc_id\uff09\u3001\u77e5\u8bc6\u7684\u5185\u5bb9\uff08content\uff09\u3002\n#\u4f60\u7684\u56de\u590d\u9700\u8981\u9075\u5faa\u4ee5\u4e0b\u8981\u6c42\uff1a1\u3001\u5728\u56de\u590d\u7684\u672b\u5c3e\u6dfb\u52a0\u201c########\u201d\u3002 2\u3001\u4f9d\u6b21\u6dfb\u52a0\u56de\u590d\u6240\u53c2\u8003\u77e5\u8bc6\u7684doc_id\n#\u5b8c\u6574\u793a\u4f8b\u5982\u4e0b\uff1a\n\u63d0\u4f9b\u7684\u77e5\u8bc6\u662f\uff1a[{\"doc_id\":111,\"content\":\"\u7532\u65b9\u8054\u7cfb\u4eba\u5f20\u4e09\"},{\"doc_id\":222,\"content\":\"\u4e59\u65b9\u8054\u7cfb\u4eba\u674e\u56db\"}]\n\u7528\u6237\u95ee\u9898\u662f\uff1a\u201c\u7532\u65b9\u548c\u4e59\u65b9\u8054\u7cfb\u4eba\u5206\u522b\u662f\u8c01\uff1f\u201d\n\u7ed9\u51fa\u56de\u590d\uff1a\u7532\u65b9\u8054\u7cfb\u4eba\u662f\u5f20\u4e09\uff0c\u4e59\u65b9\u8054\u7cfb\u4eba\u662f\u674e\u56db\u3002########111,222", (String)"gai.core.doc.azure40.repo.start", (String)"ai-gai-core", (Object[])new Object[0]);
        }
        return promptTemplate;
    }

    public List<Chunks4LLMItem> chunkList2LLMList(List<Chunk> chunkList, int systemInputLen) {
        ArrayList<Chunks4LLMItem> resultList = new ArrayList<Chunks4LLMItem>(chunkList.size());
        for (Chunk chunk : chunkList) {
            if (this.getInputLimit() <= (systemInputLen += this.getTokenCount(chunk.getChunk()))) break;
            Chunks4LLMItem chunks4LLMItem = new Chunks4LLMItem(chunk.getId(), chunk.getChunk());
            resultList.add(chunks4LLMItem);
        }
        return resultList;
    }

    public static String fillVariable(String template, List<Chunk> chunkList, Map<String, String> variableMap) {
        if (StringUtils.isEmpty((CharSequence)template)) {
            return "";
        }
        if (null == variableMap) {
            variableMap = new HashMap<String, String>();
        }
        if (chunkList != null && !chunkList.isEmpty() && StringUtils.isNotEmpty((CharSequence)chunkList.get(0).getKdCode())) {
            ArrayList codeList = new ArrayList(16);
            for (Chunk chunk : chunkList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("Q", chunk.getChunk());
                map.put("A", chunk.getKdCode());
                codeList.add(map);
            }
            variableMap.put("_sys_code_chunk", JSON.toJSONString(codeList));
        }
        Iterator<Map.Entry<String, String>> iterator = variableMap.entrySet().iterator();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        while (iterator.hasNext()) {
            Map.Entry<String, String> item = iterator.next();
            dataMap.put("{{" + item.getKey() + "}}", item.getValue());
        }
        for (Map.Entry item : dataMap.entrySet()) {
            template = StringUtils.replace((String)template, (String)((String)item.getKey()), (String)((String)item.getValue()));
        }
        if (template != null && template.contains("{{")) {
            template = LlmService.replaceTemplateVariables(template);
        }
        return template;
    }

    public static String replaceTemplateVariables(String template) {
        if (template == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int length = template.length();
        int start = 0;
        while (start < length) {
            int openIndex = template.indexOf("{{", start);
            if (openIndex == -1) {
                result.append(template.substring(start));
                break;
            }
            result.append(template, start, openIndex);
            int closeIndex = template.indexOf("}}", openIndex);
            if (closeIndex == -1) {
                result.append(template.substring(openIndex));
                break;
            }
            start = closeIndex + 2;
        }
        return result.toString();
    }

    public static Result2User syncGpt(Prompt prompt, Map<String, String> variableMap, List<UserHistoryMessage> history, String userInput, int useKnowledgeTopK) {
        LLM llm = prompt.getLlm();
        List<Chunk> chunkList = LlmService.addChunkId(prompt, userInput, useKnowledgeTopK);
        logger.info("\u654f\u611f\u8bcd\u8f93\u5165\u5ba1\u67e5\u5f00\u59cb");
        TrustLayerResult trustLayerResult = TrustLayerService.check(prompt, variableMap, history, userInput, chunkList);
        logger.info("\u654f\u611f\u8bcd\u8f93\u5165\u5ba1\u67e5\u7ed3\u675f");
        if (null != trustLayerResult.getErrorCode()) {
            return new Result2User(Errors.FAKE_OK.getCode(), trustLayerResult.getErrorMsg(), "100", trustLayerResult.getErrorMsg());
        }
        String userId = RequestContext.get().getCurrUserId() + "";
        LlmService helper = LlmServiceFactory.getExecutor(llm, false);
        String promptTemplate = StringUtils.isEmpty((CharSequence)prompt.getPrompt()) ? " " : prompt.getPrompt();
        PromptBuildParam promptBuildParam = new PromptBuildParam();
        promptBuildParam.setUser(userId);
        promptBuildParam.setStream(false);
        promptBuildParam.setReference(prompt.getReference());
        promptBuildParam.setLlmStyle(prompt.getLlmStyle());
        promptBuildParam.setSystemPromptTemplate(promptTemplate);
        promptBuildParam.setVariableMap(variableMap);
        promptBuildParam.setHistory(history);
        promptBuildParam.setChunkList(chunkList);
        promptBuildParam.setUserInput(userInput);
        promptBuildParam.setCustomParamJson(null);
        LlmParam llmParam = helper.buildPrompt(promptBuildParam);
        TrustLayerService.startMasking();
        TrustLayerService.maskingLLMParam(llmParam);
        TrustLayerContext trustLayerContext = TrustLayerService.endMasking();
        String llmParamString = JSON.toJSONString((Object)llmParam);
        String userName = RequestContext.get().getUserName();
        long start = System.currentTimeMillis();
        HashMap<String, String> contextMap = new HashMap<String, String>();
        contextMap.put("stream", "false");
        contextMap.put("isEncrypt", String.valueOf(prompt.isEncrypt()));
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"aicc", (String)"AiccService", (String)"syncService", (Object[])new Object[]{contextMap, prompt.getServiceNumber(), llmParamString});
        logger.info("\u7528\u6237({})\u8c03\u7528AICC {} \u540c\u6b65\u670d\u52a1\u6267\u884c\u7ed3\u679c {} \uff0c\u8017\u65f6 {}", new Object[]{userName, "syncService", JSON.toJSON((Object)result), System.currentTimeMillis() - start});
        String content = "";
        String think = "";
        String taskId = (String)result.get("id");
        String errMessage = (String)result.get("message");
        String errorCode = (String)result.get("errorCode");
        ModelResultParam resultParam = new ModelResultParam(false, (String)result.get("result"));
        List<LLMSearchInfo> searchInfoList = null;
        if (Errors.OK.getCode().equals(errorCode)) {
            ModelResult modelResult = helper.getResult(resultParam);
            think = modelResult.getThink();
            TrustLayerResult trustLayerThoughtResult = TrustLayerService.checkOutput(think = TrustLayerService.deMasking(think, trustLayerContext));
            if (null != trustLayerThoughtResult.getErrorCode()) {
                return new Result2User(Errors.FAKE_OK.getCode(), trustLayerThoughtResult.getErrorMsg(), "100", trustLayerThoughtResult.getErrorMsg());
            }
            content = modelResult.getContent();
            searchInfoList = modelResult.getSearchInfoList();
            TrustLayerResult outCheckResult = TrustLayerService.checkOutput(content = TrustLayerService.deMasking(content, trustLayerContext));
            if (null != outCheckResult.getErrorCode()) {
                return new Result2User(Errors.FAKE_OK.getCode(), outCheckResult.getErrorMsg(), "100", outCheckResult.getErrorMsg());
            }
        }
        Result2User result2User = new Result2User(errorCode, errMessage, taskId, think, content);
        result2User.setSearchInfoList(searchInfoList);
        return result2User;
    }

    public static Result2User syncGpt(Prompt prompt, Map<String, String> variableMap, List<UserHistoryMessage> history, String userInput, String chatSessionId, long traceId, int useKnowledgeTopK, long flowId, int nodeId) {
        LLM llm = prompt.getLlm();
        long beforeChunk = System.currentTimeMillis();
        List<Chunk> chunkList = LlmService.addChunkId(prompt, userInput, useKnowledgeTopK);
        long endChunk = System.currentTimeMillis();
        long startTrust = System.currentTimeMillis();
        TrustLayerLog trustLayerLog = new TrustLayerLog(chatSessionId, traceId, userInput, prompt, flowId, nodeId);
        logger.info("\u654f\u611f\u8bcd\u8f93\u5165\u5ba1\u67e5\u5f00\u59cb");
        TrustLayerResult trustLayerResult = TrustLayerService.check(prompt, variableMap, history, userInput, chunkList);
        logger.info("\u654f\u611f\u8bcd\u8f93\u5165\u5ba1\u67e5\u7ed3\u675f");
        long endTrust = System.currentTimeMillis();
        if (null != trustLayerResult.getErrorCode()) {
            trustLayerLog.setStart(startTrust);
            trustLayerLog.setEnd(endTrust);
            trustLayerLog.setErrorCode(Errors.FAKE_OK.getCode());
            trustLayerLog.setErrorMsg(trustLayerResult.getErrorMsg());
            TraceUtil.saveTraceTrustLog(chatSessionId, traceId, trustLayerLog);
            return new Result2User(Errors.FAKE_OK.getCode(), trustLayerResult.getErrorMsg(), "100", trustLayerResult.getErrorMsg());
        }
        String userId = RequestContext.get().getCurrUserId() + "";
        LlmService helper = LlmServiceFactory.getExecutor(llm, false);
        String promptTemplate = StringUtils.isEmpty((CharSequence)prompt.getPrompt()) ? " " : prompt.getPrompt();
        long beforePrompt = System.currentTimeMillis();
        PromptBuildParam promptBuildParam = new PromptBuildParam();
        promptBuildParam.setUser(userId);
        promptBuildParam.setStream(false);
        promptBuildParam.setReference(prompt.getReference());
        promptBuildParam.setLlmStyle(prompt.getLlmStyle());
        promptBuildParam.setSystemPromptTemplate(promptTemplate);
        promptBuildParam.setVariableMap(variableMap);
        promptBuildParam.setHistory(history);
        promptBuildParam.setChunkList(chunkList);
        promptBuildParam.setUserInput(userInput);
        promptBuildParam.setCustomParamJson(null);
        LlmParam llmParam = helper.buildPrompt(promptBuildParam);
        long endPrompt = System.currentTimeMillis();
        TrustLayerService.startMasking();
        TrustLayerService.maskingLLMParam(llmParam);
        TrustLayerContext trustLayerContext = TrustLayerService.endMasking();
        String llmParamString = JSON.toJSONString((Object)llmParam);
        String userName = RequestContext.get().getUserName();
        long start = System.currentTimeMillis();
        HashMap<String, String> contextMap = new HashMap<String, String>();
        contextMap.put("stream", "false");
        contextMap.put("isEncrypt", String.valueOf(prompt.isEncrypt()));
        String llmNumber = llm.getNumber();
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"aicc", (String)"AiccService", (String)"syncService", (Object[])new Object[]{contextMap, prompt.getServiceNumber(), llmParamString});
        logger.info("\u7528\u6237({})\u8c03\u7528AICC {} \u540c\u6b65\u670d\u52a1\u6267\u884c\u7ed3\u679c {} \uff0c\u8017\u65f6 {}", new Object[]{userName, "syncService", JSON.toJSON((Object)result), System.currentTimeMillis() - start});
        String content = "";
        String think = "";
        String taskId = (String)result.get("id");
        String errMessage = (String)result.get("message");
        String errorCode = (String)result.get("errorCode");
        String retrievalContent = variableMap.get("cachedItems-" + chatSessionId);
        logger.info("syncGpt.variableMap() : {}", variableMap);
        if (StringUtils.isNotEmpty((CharSequence)retrievalContent)) {
            EngineCache.getAppCache(chatSessionId).put("needcachedKnowledge" + taskId, (Object)retrievalContent);
            logger.info("syncGpt\u7f13\u5b58\u77e5\u8bc6\u6570\u636e\uff1a{}", (Object)retrievalContent);
        }
        VectorRetrieverLog vectorRetrieverLog = new VectorRetrieverLog(chatSessionId, traceId, userInput, JSONObject.toJSONString(chunkList), flowId, nodeId, prompt, beforeChunk, endChunk);
        vectorRetrieverLog.setTaskId(taskId);
        PromptLog promptLog = new PromptLog(taskId, chatSessionId, traceId, prompt.getServiceNumber(), JSONObject.toJSONString(chunkList), llmParamString, flowId, nodeId, prompt, beforePrompt, endPrompt);
        trustLayerLog.setTaskId(taskId);
        trustLayerLog.setStart(startTrust);
        trustLayerLog.setEnd(endTrust);
        if (trustLayerResult.getErrorCode() != null) {
            trustLayerLog.setErrorCode(Errors.FAKE_OK.getCode());
            trustLayerLog.setErrorMsg(trustLayerResult.getErrorMsg());
        } else {
            trustLayerLog.setErrorCode(Errors.OK.getCode());
            trustLayerLog.setErrorMsg(Errors.OK.getMessage());
        }
        TraceUtil.saveTraceStepsLog(chatSessionId, traceId, vectorRetrieverLog, promptLog, trustLayerLog);
        List<LLMSearchInfo> searchInfoList = null;
        if (Errors.OK.getCode().equals(errorCode)) {
            ModelResultParam resultParam = new ModelResultParam(false, (String)result.get("result"));
            ModelResult modelResult = helper.getResult(resultParam);
            searchInfoList = modelResult.getSearchInfoList();
            think = modelResult.getThink();
            TrustLayerResult outThoughtCheckResult = TrustLayerService.checkOutput(think = TrustLayerService.deMasking(think, trustLayerContext));
            if (null != outThoughtCheckResult.getErrorCode()) {
                Result2User result2User = new Result2User(Errors.FAKE_OK.getCode(), outThoughtCheckResult.getErrorMsg(), "100", outThoughtCheckResult.getErrorMsg());
                result2User.setStartLlm(start);
                return result2User;
            }
            content = modelResult.getContent();
            TrustLayerResult outCheckResult = TrustLayerService.checkOutput(content = TrustLayerService.deMasking(content, trustLayerContext));
            if (null != outCheckResult.getErrorCode()) {
                Result2User result2User = new Result2User(Errors.FAKE_OK.getCode(), outCheckResult.getErrorMsg(), "100", outCheckResult.getErrorMsg());
                result2User.setStartLlm(start);
                return result2User;
            }
        }
        Result2User result2User = new Result2User(errorCode, errMessage, taskId, think, content);
        result2User.setSearchInfoList(searchInfoList);
        result2User.setStartLlm(start);
        return result2User;
    }

    public static Result2User doAsyncGpt(boolean stream, Prompt prompt, Map<String, String> variableMap, List<UserHistoryMessage> history, String userInput, String chatSessionId, LLMParsedMessage callbackMessage, long traceId, int useKnowledgeTopK) {
        GaiExceptionUtil.checkCondition(prompt != null, GaiErrorCode.NO_PROMPT);
        if (userInput == null) {
            userInput = "";
        }
        LLM llm = prompt.getLlm();
        String promptTemplate = StringUtils.isEmpty((CharSequence)prompt.getPrompt()) ? " " : prompt.getPrompt();
        LlmStyle llmStyle = prompt.getLlmStyle();
        String userId = RequestContext.get().getCurrUserId() + "";
        LlmService helper = LlmServiceFactory.getExecutor(llm, stream);
        long beforeChunk = System.currentTimeMillis();
        List<Chunk> chunkList = LlmService.addChunkId(prompt, userInput, useKnowledgeTopK);
        long endChunk = System.currentTimeMillis();
        long startTrust = System.currentTimeMillis();
        logger.info("\u654f\u611f\u8bcd\u8f93\u5165\u5ba1\u67e5\u5f00\u59cb");
        TrustLayerResult trustLayerResult = TrustLayerService.check(prompt, variableMap, history, userInput, chunkList);
        logger.info("\u654f\u611f\u8bcd\u8f93\u5165\u5ba1\u67e5\u7ed3\u675f");
        long endTrust = System.currentTimeMillis();
        if (null != trustLayerResult.getErrorCode()) {
            Result2User result2User = new Result2User(Errors.FAKE_OK.getCode(), trustLayerResult.getErrorMsg(), "100", trustLayerResult.getErrorMsg());
            result2User.setStartTrust(startTrust);
            result2User.setEndTrust(endTrust);
            return result2User;
        }
        long startPrompt = System.currentTimeMillis();
        PromptBuildParam promptBuildParam = new PromptBuildParam();
        promptBuildParam.setUser(userId);
        promptBuildParam.setStream(stream);
        promptBuildParam.setReference(prompt.getReference());
        promptBuildParam.setLlmStyle(llmStyle);
        promptBuildParam.setSystemPromptTemplate(promptTemplate);
        promptBuildParam.setVariableMap(variableMap);
        promptBuildParam.setHistory(history);
        promptBuildParam.setChunkList(chunkList);
        promptBuildParam.setUserInput(userInput);
        promptBuildParam.setCustomParamJson(prompt.getCustomStyle());
        LlmParam llmParam = helper.buildPrompt(promptBuildParam);
        long endPrompt = System.currentTimeMillis();
        TrustLayerService.startMasking();
        TrustLayerService.maskingLLMParam(llmParam);
        TrustLayerContext trustLayerContext = TrustLayerService.endMasking();
        String llmParamString = JSON.toJSONString((Object)llmParam);
        String userName = RequestContext.get().getUserName();
        long startLlm = System.currentTimeMillis();
        HashMap<String, String> contextMap = new HashMap<String, String>();
        String stringStream = LLM.ALI_GPT_QWEN == llm ? "false" : String.valueOf(stream);
        contextMap.put("stream", stringStream);
        contextMap.put("notify_ms_cloudid", "ai");
        contextMap.put("notify_ms_appid", "gai");
        contextMap.put("notify_ms_service_name", "GaiCallBackService");
        contextMap.put("notify_ms_method_name", "llmNotify");
        contextMap.put("isEncrypt", String.valueOf(prompt.isEncrypt()));
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"aicc", (String)"AiccService", (String)"asyncService", (Object[])new Object[]{contextMap, prompt.getServiceNumber(), llmParamString});
        logger.info("\u7528\u6237({})\u8c03\u7528AICC {} \u5f02\u6b65\u670d\u52a1\u6267\u884c\u7ed3\u679c {} \uff0c\u8017\u65f6 {}\uff0cprompt\u53c2\u6570{}", new Object[]{userName, "syncService", JSON.toJSON((Object)result), System.currentTimeMillis() - startLlm, llmParamString});
        String errCode = (String)result.get("errorCode");
        String errMsg = (String)result.get("message");
        if (!Errors.OK.getCode().equals(errCode)) {
            throw new KDBizException(new ErrorCode(errCode, "AICC\u670d\u52a1\u8c03\u7528\u5931\u8d25\u3002" + errMsg), new Object[0]);
        }
        String taskId = (String)result.get("id");
        String content = (String)result.get("result");
        String retrievalContent = variableMap.get("cachedItems-" + chatSessionId);
        if (StringUtils.isNotEmpty((CharSequence)retrievalContent)) {
            EngineCache.getAppCache(chatSessionId).put("needcachedKnowledge" + taskId, (Object)retrievalContent);
            logger.info("doAsyncGpt\u7f13\u5b58\u77e5\u8bc6\u6570\u636e\uff1a{}", (Object)retrievalContent);
        }
        Result2User result2User = new Result2User(errCode, errMsg, taskId, content);
        result2User.setTrustLayerContext(trustLayerContext);
        result2User.setLlmParamString(llmParamString);
        result2User.setChunkList(chunkList);
        result2User.setBeforeChunk(beforeChunk);
        result2User.setEndChunk(endChunk);
        result2User.setStartTrust(startTrust);
        result2User.setEndTrust(endTrust);
        result2User.setStartLlm(startLlm);
        result2User.setStartPrompt(startPrompt);
        result2User.setEndPrompt(endPrompt);
        return result2User;
    }

    public static void stopGpt(Long taskId) {
        if (null == taskId || taskId == 0L) {
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"ai", (String)"aicc", (String)"AiccService", (String)"stopStream", (Object[])new Object[]{taskId});
    }

    public List<Long> filterContext(String allMsg, List<Long> chunkIdList, List<Long> fileIdList) {
        if (null == chunkIdList || chunkIdList.isEmpty()) {
            return new ArrayList<Long>();
        }
        if (!StringUtils.isEmpty((CharSequence)allMsg) && allMsg.length() <= 15 && (allMsg.contains("\u5f88\u62b1\u6b49") || allMsg.contains("\u4e0d\u77e5\u9053"))) {
            logger.info("\u4e0d\u77e5\u9053\u8fc7\u6ee4\u5f15\u7528");
            return new ArrayList<Long>();
        }
        switch (this.getLlm()) {
            case AZURE_GPT_40: 
            case AZURE_GPT_40_32: 
            case XMINDAI_GPT_40: 
            case AZURE_GPT_35_16: 
            case BAIDU_ERNIE_BOT_PRO: {
                return fileIdList;
            }
        }
        List<RepoFileVO> repoFileVOList = RepoService.getFilesByChunkIds(chunkIdList);
        return repoFileVOList.stream().map(RepoFileVO::getFileId).collect(Collectors.toList());
    }

    public List<Long> filterContext(String allMsg, List<Long> chunkIdList) {
        if (null == chunkIdList || chunkIdList.isEmpty()) {
            return new ArrayList<Long>();
        }
        if (!StringUtils.isEmpty((CharSequence)allMsg) && allMsg.length() <= 15 && (allMsg.contains("\u5f88\u62b1\u6b49") || allMsg.contains("\u4e0d\u77e5\u9053"))) {
            logger.info("\u4e0d\u77e5\u9053\u8fc7\u6ee4\u5f15\u7528");
            return new ArrayList<Long>();
        }
        return chunkIdList;
    }

    public int getTokenCount(String text) {
        return GaiUtils.countChineseCharacters(text) + GaiUtils.countEnglishWords(text);
    }

    private static List<Chunk> addChunkId(Prompt prompt, String userInput, int useKnowledgeTopK) {
        List<Chunk> chunkList = new ArrayList<Chunk>();
        List<Long> repoIdList = prompt.getRepoIds();
        logger.info("\u4e0a\u4e0b\u6587repoIdList:{}", JSON.toJSON(repoIdList));
        if (repoIdList != null && !repoIdList.isEmpty() && !StringUtils.isEmpty((CharSequence)userInput)) {
            RepoVO repoInfo = RepoService.queryRepoMainInfo(repoIdList.get(0));
            LLM embeddingModel = repoInfo.getLlm();
            VectorMetricType vectorMetricType = repoInfo.getVectorMetricType();
            chunkList = useKnowledgeTopK <= 0 ? EmbeddingServiceFactory.getExecutor(embeddingModel, vectorMetricType).search(repoIdList, userInput) : (useKnowledgeTopK > 20 ? EmbeddingServiceFactory.getExecutor(embeddingModel, vectorMetricType).search(repoIdList, userInput, 20) : EmbeddingServiceFactory.getExecutor(embeddingModel, vectorMetricType).search(repoIdList, userInput, useKnowledgeTopK));
            logger.info("\u4e0a\u4e0b\u6587chunkIdList:{}", JSON.toJSON(chunkList));
            if (chunkList != null && !chunkList.isEmpty()) {
                List<Long> chunkIdList = chunkList.stream().map(Chunk::getId).collect(Collectors.toList());
                prompt.setChunkIdList(chunkIdList);
            }
        }
        return chunkList;
    }

    public int getInputLimit() {
        return this.inputLimit;
    }

    public void setInputLimit(int inputLimit) {
        this.inputLimit = inputLimit;
    }

    public LLM getLlm() {
        return this.llm;
    }

    public void setLlm(LLM llm) {
        this.llm = llm;
    }

    public T parseLLMParam(JSONObject jsonLLMParam) {
        Type[] actualTypeArguments;
        Type genericSuperClass = this.getClass().getGenericSuperclass();
        if (genericSuperClass instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)genericSuperClass).getActualTypeArguments()).length > 0) {
            for (Type actualType : actualTypeArguments) {
                if (!LlmParam.class.isAssignableFrom((Class)actualType)) continue;
                return (T)((LlmParam)jsonLLMParam.toJavaObject(actualType));
            }
        }
        return null;
    }

    public abstract JSONObject getTypeParam(LlmStyle var1);
}

