/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.llm;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.llm.PromptBuildParam;
import kd.ai.gai.core.domain.llm.TencentLlmV3Param;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.MessageItem4Tencent;
import kd.ai.gai.core.domain.llm.base.ModelResult;
import kd.ai.gai.core.domain.llm.base.ModelResultParam;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.domain.vo.RepoFileVO;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmRole;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.service.RepoService;
import kd.ai.gai.core.service.llm.BaiduErnieService;
import kd.ai.gai.core.service.llm.LlmService;
import kd.ai.gai.core.util.GaiUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class TencentService
extends LlmService<TencentLlmV3Param> {
    private static final Log logger = LogFactory.getLog(BaiduErnieService.class);

    public TencentService(int inputLimit, LLM llm) {
        super(inputLimit, llm);
    }

    @Override
    public LlmParam buildPrompt(PromptBuildParam promptBuildParam) {
        int lastIndex;
        MessageItem4Tencent tencent;
        String user = promptBuildParam.getUser();
        boolean stream = promptBuildParam.isStream();
        Boolean reference = promptBuildParam.getReference();
        String systemPromptTemplate = promptBuildParam.getSystemPromptTemplate();
        Map<String, String> variableMap = promptBuildParam.getVariableMap();
        List<UserHistoryMessage> history = promptBuildParam.getHistory();
        List<Chunk> chunkList = promptBuildParam.getChunkList();
        String userInput = promptBuildParam.getUserInput();
        String customParamJson = promptBuildParam.getCustomParamJson();
        logger.info("\u6784\u5efa\u63d0\u793a\uff0c\u5176\u4e2d\u5386\u53f2\u8bb0\u5f55{}\u6761\uff0c\u4e0a\u4e0b\u6587{}\u6761", (Object)(history == null ? 0 : history.size()), (Object)(chunkList == null ? 0 : chunkList.size()));
        TencentLlmV3Param tencentLlmV3Param = new TencentLlmV3Param(promptBuildParam.getLlmStyle(), customParamJson);
        tencentLlmV3Param.setStream(stream);
        ArrayList<MessageItem4Tencent> list = new ArrayList<MessageItem4Tencent>(16);
        if (variableMap == null) {
            variableMap = new HashMap<String, String>();
        }
        String systemContent = TencentService.fillVariable(systemPromptTemplate, chunkList, variableMap);
        String context = this.getContext(reference, systemContent, chunkList, this.getTokenCount(userInput) + this.getTokenCount(systemContent));
        systemContent = reference == null ? systemContent + context : context;
        int total = userInput.length() + systemContent.length();
        if (total > this.getInputLimit()) {
            logger.info("\u8f93\u5165\u53ef\u80fd\u8d85\u957f,\u8bf7\u5173\u6ce8\uff1a{}", (Object)total);
        }
        MessageItem4Tencent messageItem4Tencent = new MessageItem4Tencent();
        messageItem4Tencent.setRole(LlmRole.user);
        messageItem4Tencent.setContent(userInput);
        list.add(messageItem4Tencent);
        if (history != null && !history.isEmpty()) {
            Collections.reverse(history);
            if (history.size() % 2 != 0) {
                history.remove(history.size() - 1);
            }
            for (UserHistoryMessage item : history) {
                MessageItem4Tencent lastItem = (MessageItem4Tencent)list.get(list.size() - 1);
                LlmRole lastRole = lastItem.getRole();
                if (kd.bos.util.StringUtils.isNotEmpty((String)item.getAssistant())) {
                    if (lastRole == LlmRole.assistant) break;
                    if (list.isEmpty() || ((MessageItem4Tencent)list.get(list.size() - 1)).getRole() == LlmRole.user) {
                        if ((total += item.getAssistant().length()) > this.getInputLimit()) break;
                        messageItem4Tencent = new MessageItem4Tencent();
                        messageItem4Tencent.setRole(LlmRole.assistant);
                        messageItem4Tencent.setContent(item.getAssistant());
                        list.add(messageItem4Tencent);
                    }
                }
                if (!kd.bos.util.StringUtils.isNotEmpty((String)item.getUser())) continue;
                if (lastRole == LlmRole.user) break;
                if (list.isEmpty() || ((MessageItem4Tencent)list.get(list.size() - 1)).getRole() != LlmRole.assistant) continue;
                if ((total += item.getUser().length()) > this.getInputLimit()) break;
                messageItem4Tencent = new MessageItem4Tencent();
                messageItem4Tencent.setRole(LlmRole.user);
                messageItem4Tencent.setContent(item.getUser());
                list.add(messageItem4Tencent);
            }
        }
        if (!list.isEmpty() && (tencent = (MessageItem4Tencent)list.get(lastIndex = list.size() - 1)).getRole() == LlmRole.assistant) {
            list.remove(lastIndex);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)systemContent.trim())) {
            MessageItem4Tencent messageItem4TencentLast = new MessageItem4Tencent();
            messageItem4TencentLast.setRole(LlmRole.system);
            messageItem4TencentLast.setContent(systemContent);
            list.add(messageItem4TencentLast);
        }
        tencentLlmV3Param.setModel("hunyuan-pro");
        Collections.reverse(list);
        tencentLlmV3Param.setMessages(list);
        return tencentLlmV3Param;
    }

    @Override
    public ModelResult getResult(ModelResultParam modelResultParam) {
        boolean stream = modelResultParam.isStream();
        String result = modelResultParam.getResult();
        ModelResult modelResult = new ModelResult();
        if (stream) {
            if (kd.bos.util.StringUtils.isEmpty((String)result)) {
                modelResult.setContent("");
                return modelResult;
            }
            String string = result = result.startsWith("data: ") ? result.substring(6) : result;
            if (JSONPath.contains((Object)result, (String)"$.Choices") && (Integer)JSONPath.read((String)result, (String)"$.Choices.size()", Integer.TYPE) == 0) {
                modelResult.setContent("");
                return modelResult;
            }
            if (JSONPath.contains((Object)result, (String)"$.Choices[0].Delta.Content")) {
                String msg = (String)JSONPath.read((String)result, (String)"$.Choices[0].Delta.Content", String.class);
                modelResult.setContent(msg == null ? "" : msg);
                return modelResult;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)result, (CharSequence)"[DONE]")) {
                return modelResult;
            }
            throw new KDBizException("Tencent(stream)\u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:" + result);
        }
        if (!JSONPath.contains((Object)result, (String)"$.Response.Choices[0].Message.Content")) {
            throw new KDBizException("Tencent(no-stream) \u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:" + result);
        }
        modelResult.setContent((String)JSONPath.read((String)result, (String)"$.Response.Choices[0].Message.Content", String.class));
        return modelResult;
    }

    @Override
    public List<Long> filterContext(String allMsg, List<Long> chunkIdList, List<Long> fileIdList) {
        if (!StringUtils.isEmpty((CharSequence)allMsg) && allMsg.length() <= 10 && (allMsg.contains("\u5f88\u62b1\u6b49") || allMsg.contains("\u4e0d\u77e5\u9053"))) {
            logger.info("\u4e0d\u77e5\u9053\u8fc7\u6ee4\u5f15\u7528");
            return new ArrayList<Long>();
        }
        List<RepoFileVO> repoFileVOList = RepoService.getFilesByChunkIds(chunkIdList);
        return repoFileVOList.stream().map(RepoFileVO::getFileId).collect(Collectors.toList());
    }

    @Override
    public int getTokenCount(String text) {
        double chineseWeight = 1.8;
        double englishWeight = 3.0;
        int chineseCount = GaiUtils.countChineseCharacters(text);
        int englishCount = GaiUtils.countEnglishLetters(text);
        return (int)Math.ceil((double)chineseCount / chineseWeight + (double)englishCount / englishWeight);
    }

    @Override
    public JSONObject getTypeParam(LlmStyle llmStyle) {
        TencentLlmV3Param tencentLlmV3Param = new TencentLlmV3Param();
        JSONObject reultJson = tencentLlmV3Param.getDefaultTypeParam(llmStyle);
        return reultJson;
    }
}

