/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.llm;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import kd.ai.gai.core.domain.llm.AzureLlmParam;
import kd.ai.gai.core.domain.llm.LLMSearchInfo;
import kd.ai.gai.core.domain.llm.base.ModelResult;
import kd.ai.gai.core.domain.llm.base.ModelResultParam;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.service.llm.Azure35Service;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class VolcanoAgentService
extends Azure35Service {
    private static final Log log = LogFactory.getLog(VolcanoAgentService.class);

    public VolcanoAgentService(int inputLimit, LLM llm) {
        super(inputLimit, llm);
    }

    public AzureLlmParam buildParam(LlmStyle llmStyle) {
        AzureLlmParam azureLlmParam = new AzureLlmParam();
        switch (llmStyle) {
            case CREATIVITY: {
                azureLlmParam.setTemperature(0.8f);
                azureLlmParam.setTop_p(0.9f);
                azureLlmParam.setPresence_penalty(0.1f);
                azureLlmParam.setFrequency_penalty(0.1f);
                break;
            }
            case PRECISION: {
                azureLlmParam.setTemperature(0.0f);
                azureLlmParam.setTop_p(0.95f);
                azureLlmParam.setPresence_penalty(0.0f);
                azureLlmParam.setFrequency_penalty(0.0f);
                break;
            }
            default: {
                azureLlmParam.setTemperature(0.5f);
                azureLlmParam.setTop_p(0.95f);
                azureLlmParam.setPresence_penalty(0.0f);
                azureLlmParam.setFrequency_penalty(0.0f);
            }
        }
        return azureLlmParam;
    }

    @Override
    public ModelResult getResult(ModelResultParam modelResultParam) {
        boolean stream = modelResultParam.isStream();
        boolean searchInfo = true;
        String result = modelResultParam.getResult();
        log.warn("[psfBug\u6392\u67e5\u65e5\u5fd7],getResult:[{}]", (Object)result);
        ModelResult modelResult = new ModelResult();
        if (stream) {
            if (StringUtils.isEmpty((CharSequence)result)) {
                modelResult.setContent("");
                return modelResult;
            }
            String string = result.startsWith("data:") ? (result.indexOf("{") != -1 ? result.substring(result.indexOf("{")) : result) : (result = result);
            if (JSONPath.contains((Object)result, (String)"$.choices") && (Integer)JSONPath.read((String)result, (String)"$.choices.size()", Integer.TYPE) == 0) {
                modelResult.setContent("");
                return modelResult;
            }
            if (JSONPath.contains((Object)result, (String)"$.choices[0].delta")) {
                String msg = (String)JSONPath.read((String)result, (String)"$.choices[0].delta.content", String.class);
                modelResult.setContent(msg == null ? "" : msg);
                if (searchInfo) {
                    ArrayList<LLMSearchInfo> searchInfoList = new ArrayList<LLMSearchInfo>(1);
                    if (JSONPath.contains((Object)result, (String)"$.references")) {
                        JSONArray searchJson = (JSONArray)JSONPath.read((String)result, (String)"$.references", JSONArray.class);
                        for (JSONObject search : searchJson) {
                            LLMSearchInfo llmSearchInfo = new LLMSearchInfo();
                            llmSearchInfo.setUrl(search.getString("url"));
                            llmSearchInfo.setLogoUrl(search.getString("logo_url"));
                            llmSearchInfo.setSource(search.getString("site_name"));
                            llmSearchInfo.setSummary(search.getString("summary"));
                            llmSearchInfo.setTitle(search.getString("title"));
                            llmSearchInfo.setPublishTime(search.getString("publish_time"));
                            searchInfoList.add(llmSearchInfo);
                        }
                        modelResult.setSearchInfoList(searchInfoList);
                    }
                }
                return modelResult;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)result, (CharSequence)"[DONE]")) {
                return modelResult;
            }
            throw new KDBizException(this.getLlm().getNumber() + "\u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:" + result);
        }
        if (StringUtils.isEmpty((CharSequence)result) || !JSONPath.contains((Object)result, (String)"$.choices[0].message.content")) {
            throw new KDBizException(this.getLlm().getNumber() + "\u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:" + result);
        }
        modelResult.setContent((String)JSONPath.read((String)result, (String)"$.choices[0].message.content", String.class));
        return modelResult;
    }
}

