/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.milvus;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.VectorMetricType;
import kd.ai.gai.core.rag.milvus.MilvusBaseDao;
import kd.ai.gai.core.service.embedding.EmbeddingServiceFactory;
import kd.ai.gai.core.service.milvus.MilvusConfig;
import kd.ai.gai.core.service.milvus.MilvusNewStore;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class MilvusStoreManager {
    private static final Log logger = LogFactory.getLog(MilvusStoreManager.class);
    private static final Map<String, MilvusNewStore> serviceMap = new ConcurrentHashMap<String, MilvusNewStore>();

    public static MilvusBaseDao getStore(LLM llm, VectorMetricType metricType) {
        RequestContext requestContext = RequestContext.get();
        LLM.ModelType modelType = llm.getModelType();
        if (modelType != LLM.ModelType.EMBEDDING) {
            String message = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5411\u91cf\u6a21\u578b\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5", (String)"MilvusStoreManager_0", (String)"ai-gai-core", (Object[])new Object[0]);
            logger.error(message + (Object)((Object)modelType));
            throw new RuntimeException(message);
        }
        int dimension = EmbeddingServiceFactory.getExecutor(llm, metricType).getDimension();
        String embeddingNumber = llm.getNumber();
        String key = requestContext.getAccountId() + "_" + embeddingNumber + "_" + dimension + "_" + metricType.toString();
        return serviceMap.computeIfAbsent(key, k -> {
            MilvusConfig.Builder configBuilder = MilvusConfig.fromSystemProperties(requestContext.getTenantId());
            configBuilder.dimension(dimension).embeddingNumber(embeddingNumber).collectionName(MilvusStoreManager.buildCollectionName(embeddingNumber, metricType)).build();
            MilvusNewStore store = new MilvusNewStore(configBuilder.build());
            store.init();
            return store;
        });
    }

    private static String buildCollectionName(String embeddingNumber, VectorMetricType metricType) {
        RequestContext rc = RequestContext.get();
        String collection = metricType == VectorMetricType.COSINE ? String.format("M_%s_%s_%s", new Object[]{rc.getAccountId(), embeddingNumber, metricType}) : String.format("M_%s_%s", rc.getAccountId(), embeddingNumber);
        logger.info("milvus new collectionName\uff1a{}", (Object)collection);
        return collection;
    }
}

