/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.op;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.domain.dto.FeedParams;
import kd.ai.gai.core.domain.dto.agent.ChatSessionDTO;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.op.UserFeedbackEventParams;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.enuz.op.ClientTypeEnum;
import kd.ai.gai.core.enuz.op.UserFeedbackTypeEnum;
import kd.ai.gai.core.service.GaiCosmicAppService;
import kd.ai.gai.core.service.agent.AgentService;
import kd.ai.gai.core.service.agent.ChatService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.service.op.IRemoteUserFbService;
import kd.ai.gai.core.service.op.IUserFeedbackService;
import kd.ai.gai.core.trace.util.ThreadUtils;
import kd.ai.gai.vipknowledge.KnowledgeService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class UserFeedbackServiceImpl
implements IUserFeedbackService {
    private static final Log log = LogFactory.getLog(UserFeedbackServiceImpl.class);

    @Override
    public void reportUserFeedback(UserFeedbackEventParams userFeedbackEventParams) {
        SLIDEENV slideenv = userFeedbackEventParams.getSlideenv();
        if (slideenv != SLIDEENV.MAIN && slideenv != SLIDEENV.H5 && slideenv != SLIDEENV.HTTP_API) {
            return;
        }
        ThreadUtils.execute(() -> this.report(userFeedbackEventParams));
    }

    private void report(UserFeedbackEventParams userFeedbackEventParams) {
        Message userMessage;
        FeedParams feedParams = userFeedbackEventParams.getFeedParams();
        log.info("feedParams:{}", (Object)JSONObject.toJSONString((Object)feedParams));
        String monitorTraceId = userFeedbackEventParams.getChatTraceId();
        if (userFeedbackEventParams.getOpType() == EnableEnum.NO.getKey()) {
            UserFeedbackServiceImpl.cancelFeedback(monitorTraceId);
            return;
        }
        Message message = userMessage = StringUtils.isNotEmpty((CharSequence)monitorTraceId) ? MessageService.getAgentMessage(monitorTraceId, ChatMessageTypeEnum.USER) : null;
        if (userMessage == null && feedParams != null) {
            monitorTraceId = feedParams.getMonitorTraceId();
            userMessage = MessageService.getAgentMessage(monitorTraceId, ChatMessageTypeEnum.USER);
            log.info("APP monitorTraceId: {}, GAI monitorTraceId: {}", (Object)feedParams.getMonitorTraceId(), (Object)monitorTraceId);
        }
        if (userMessage != null) {
            DynamicObject fbDo = BusinessDataServiceHelper.loadSingle((String)GaiFormIdEnum.GAI_USER_FEEDBACK.getId(), (QFilter[])new QFilter("chattraceid", "=", (Object)monitorTraceId).toArray());
            if (fbDo == null) {
                RequestContext rc = RequestContext.get();
                ChatSessionDTO chatSessionDTO = ChatService.getChatSession(userMessage.getSessionId());
                DynamicObject userDo = BusinessDataServiceHelper.loadSingle((Object)chatSessionDTO.getUserId(), (String)"bos_user");
                fbDo = BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_USER_FEEDBACK.getId());
                fbDo.set("agent", (Object)userMessage.getSkillId());
                fbDo.set("clienttype", (Object)chatSessionDTO.getClientType());
                fbDo.set("creator", (Object)userDo);
                fbDo.set("optime", (Object)new Date(userFeedbackEventParams.getOpTimeTs()));
                fbDo.set("opusername", (Object)chatSessionDTO.getOpUserName());
                fbDo.set("sysuser", userDo != null ? userDo.getPkValue() : Long.valueOf(rc.getCurrUserId()));
                fbDo.set("sysuserorg", (Object)(userDo != null ? UserServiceHelper.getUserMainOrgId((long)((Long)userDo.getPkValue())) : rc.getOrgId()));
                fbDo.set("feedbacktype", (Object)userFeedbackEventParams.getFeedbackType());
                fbDo.set("contenttype", null);
                fbDo.set("content", null);
                fbDo.set("question", (Object)userMessage.getContentTag());
                fbDo.set("answer", null);
                fbDo.set("traceid", (Object)userFeedbackEventParams.getTraceId());
                fbDo.set("chatsessionid", (Object)chatSessionDTO.getId());
                fbDo.set("chattraceid", (Object)userFeedbackEventParams.getChatTraceId());
                fbDo.set("agenttype", (Object)userMessage.getSkillType());
                fbDo.set("agentname", (Object)AgentService.getAgentName(userMessage.getSkillType(), userMessage.getSkillId()));
                fbDo.set("assistant", (Object)userMessage.getAssistantId());
            } else {
                if (feedParams == null) {
                    String answer = this.queryAnswer(monitorTraceId, userFeedbackEventParams.getErrorMsg(), userMessage.getSkillType());
                    fbDo.set("feedbacktype", (Object)userFeedbackEventParams.getFeedbackType());
                    fbDo.set("optime", (Object)new Date(userFeedbackEventParams.getOpTimeTs()));
                    fbDo.set("contenttype", (Object)userFeedbackEventParams.convertContentName());
                    fbDo.set("content", (Object)userFeedbackEventParams.getContent());
                    fbDo.set("answer", (Object)answer);
                } else {
                    log.info("chatSessionId:{} feedbackSource:{}", (Object)feedParams.getChatSessionId(), (Object)feedParams.getFeedbackSource());
                    Map<String, Long> userInfoByPhone = GaiCosmicAppService.getUserInfoByPhone(feedParams.getPhone());
                    String answer = StringUtils.isNotEmpty((CharSequence)feedParams.getMessage()) ? feedParams.getMessage() : this.queryAnswer(feedParams.getMonitorTraceId(), null, userMessage.getSkillType());
                    long clientTypeId = ClientTypeEnum.OTHER.getId();
                    String feedbackType = String.valueOf(feedParams.getLike());
                    if (StringUtils.equalsIgnoreCase((CharSequence)feedParams.getFeedbackSource(), (CharSequence)"COSMIC_APP")) {
                        clientTypeId = ClientTypeEnum.CUSTOM.getId();
                        if (feedParams.getLike() == 1) {
                            feedbackType = UserFeedbackTypeEnum.LIKE.getId();
                        } else if (feedParams.getLike() == 2) {
                            feedbackType = UserFeedbackTypeEnum.TAP.getId();
                        }
                    }
                    fbDo.set("clienttype", (Object)clientTypeId);
                    fbDo.set("feedbacktype", (Object)feedbackType);
                    fbDo.set("optime", (Object)System.currentTimeMillis());
                    fbDo.set("contenttype", (Object)feedParams.getFeedType());
                    fbDo.set("content", (Object)feedParams.getFeedContent());
                    fbDo.set("answer", (Object)answer);
                    fbDo.set("opusername", (Object)feedParams.getUserName());
                    fbDo.set("sysuser", (Object)userInfoByPhone.get("userId"));
                    fbDo.set("sysuserorg", (Object)userInfoByPhone.get("orgId"));
                }
                this.sendUserFeedbackRemote(userFeedbackEventParams, fbDo, userMessage);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fbDo});
        } else {
            log.error("monitorTraceId : {} userMessage not found", (Object)monitorTraceId);
        }
    }

    private void sendUserFeedbackRemote(UserFeedbackEventParams userFeedbackEventParams, DynamicObject fbDo, Message userMessage) {
        String[] fbType;
        if (userMessage.getSkillId().equals(KnowledgeService.getVipKnowledgeSkillId()) && Arrays.asList(fbType = new String[]{"0", "1"}).contains(userFeedbackEventParams.getFeedbackType())) {
            IRemoteUserFbService remoteService = IRemoteUserFbService.create(IRemoteUserFbService.FeedbackClassType.VIP_KNOWLEDGE);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("userFeedbackEventParams", userFeedbackEventParams);
            params.put("feedbackObject", fbDo);
            params.put("userMessage", userMessage);
            remoteService.report(params);
        }
    }

    private static void cancelFeedback(String monitorTraceId) {
        DynamicObject fbDo = BusinessDataServiceHelper.loadSingle((String)GaiFormIdEnum.GAI_USER_FEEDBACK.getId(), (QFilter[])new QFilter("chattraceid", "=", (Object)monitorTraceId).toArray());
        fbDo.set("feedbacktype", (Object)UserFeedbackTypeEnum.OK.getId());
        fbDo.set("contenttype", null);
        fbDo.set("content", null);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fbDo});
    }

    private String queryAnswer(String monitorTraceId, String errorMsg, String skillType) {
        String answer = null;
        String tempErrorMsg = String.format("\u3010%s\u3011%s", ResManager.loadKDString((String)"\u53d1\u751f\u5f02\u5e38", (String)"ReportUserFeedbackEventPlugin_0", (String)"ai-gai-core", (Object[])new Object[0]), errorMsg);
        errorMsg = StringUtils.isNotEmpty((CharSequence)errorMsg) ? tempErrorMsg : null;
        Message assistantMessage = StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)Skill.Type.PROCESS.name()) ? MessageService.getProcessAnswerMessage(monitorTraceId, new ChatMessageTypeEnum[]{ChatMessageTypeEnum.ASSISTANT, ChatMessageTypeEnum.PROCESS}) : MessageService.getAgentMessage(monitorTraceId, ChatMessageTypeEnum.ASSISTANT);
        if (assistantMessage != null) {
            answer = assistantMessage.getContentTag();
            if (StringUtils.isNotEmpty((CharSequence)assistantMessage.getThought())) {
                answer = String.format("%s\n%s", assistantMessage.getThought(), assistantMessage.getContentTag());
            }
            if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                answer = String.format("%s\n%s", answer, errorMsg);
            }
        }
        return answer;
    }
}

