/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.op;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.op.UserFeedbackEventParams;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.service.op.IRemoteUserFbService;
import kd.ai.gai.vipknowledge.KnowledgeOpenApiService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class VipUserFeedbackServiceImpl
implements IRemoteUserFbService {
    private static final Log logger = LogFactory.getLog(VipUserFeedbackServiceImpl.class);

    @Override
    public void report(Map<String, Object> params) {
        try {
            JSONObject result;
            String s;
            Message message = (Message)params.get("userMessage");
            Message agentMessage = MessageService.getAgentMessage(message.getChatTraceId(), ChatMessageTypeEnum.ASSISTANT);
            if (agentMessage == null) {
                logger.error("agentMessage is null");
                return;
            }
            if (StringUtils.isBlank((CharSequence)agentMessage.getConfigTag())) {
                logger.error("agentMessage configTag is null");
                return;
            }
            UserFeedbackEventParams userFeedbackEventParams = (UserFeedbackEventParams)params.get("userFeedbackEventParams");
            JSONObject object = JSON.parseObject((String)agentMessage.getConfigTag());
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("questionId", object.getString("questionId"));
            body.put("feedback", Integer.parseInt(userFeedbackEventParams.getFeedbackType()));
            body.put("value", this.convertValue(userFeedbackEventParams.getOpType()));
            String contentType = this.convertContentType(userFeedbackEventParams.getContentType());
            body.put("feedbackType", contentType);
            String content = userFeedbackEventParams.getContent();
            if (StringUtils.isBlank((CharSequence)contentType) || StringUtils.isNotEmpty((CharSequence)content)) {
                body.put("feedbackRemark", content);
                body.put("feedbackType", "5");
            }
            if (StringUtils.isNotBlank((CharSequence)(s = KnowledgeOpenApiService.userFeedback(body))) && !(result = JSON.parseObject((String)s)).getBooleanValue("success")) {
                logger.info(s);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private String convertContentType(String contentType) {
        if (StringUtils.isBlank((CharSequence)contentType)) {
            return "";
        }
        String[] split = contentType.split(",");
        return split[0];
    }

    private boolean convertValue(int opType) {
        return opType == 1;
    }
}

