/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.rerank;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.ai.gai.core.domain.dto.RerankChunk;
import kd.ai.gai.core.domain.llm.base.ResultRerank;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.message.RerankMessage;
import kd.ai.gai.core.service.rerank.RerankService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class TEIRerankerService
extends RerankService {
    private static final Log logger = LogFactory.getLog(TEIRerankerService.class);
    private final int queryLimit = 1600;
    private final int chunkListLimit = 200;
    private final int chunkLimit = 4096;

    @Override
    public ResultRerank syncRerank(RerankMessage rerankMessage) {
        int topN;
        String query;
        JSONObject modelBody = new JSONObject();
        List<RerankChunk> rerankChunks = rerankMessage.getChunkList();
        ErrorCode errorCode = this.checkParam(rerankChunks, query = rerankMessage.getInputQuery(), topN = rerankMessage.getTop_n());
        if (!Objects.equals(errorCode.getCode(), "0")) {
            return new ResultRerank(errorCode.getCode(), errorCode.getMessage());
        }
        ArrayList<String> documentList = new ArrayList<String>(rerankChunks.size());
        HashMap<String, List<String>> chunkMap = new HashMap<String, List<String>>(rerankChunks.size());
        for (RerankChunk rerank : rerankChunks) {
            String documentText = rerank.getChunk();
            String chunkId = String.valueOf(rerank.getChunkId());
            documentList.add(documentText);
            chunkMap.computeIfAbsent(documentText, k -> new LinkedList()).add(chunkId);
        }
        modelBody.put("query", (Object)query);
        modelBody.put("texts", documentList);
        HashMap<String, String> contextMap = new HashMap<String, String>();
        contextMap.put("stream", "false");
        String userName = RequestContext.get().getUserName();
        logger.info("\u7528\u6237({})\u5f00\u59cb\u8c03\u7528Rerank\u6a21\u578b\u670d\u52a1\uff08TEI\u63a5\u53e3\uff09,\u53c2\u6570\uff1a{}", (Object)userName, (Object)modelBody);
        long start = System.currentTimeMillis();
        Map serviceResult = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"aicc", (String)"AiccService", (String)"syncService", (Object[])new Object[]{contextMap, rerankMessage.getServiceNumber(), modelBody.toJSONString()});
        long usedTime = System.currentTimeMillis() - start;
        logger.info("\u8c03\u7528Rerank\u6a21\u578b\uff08TEI\u63a5\u53e3\uff09\u540c\u6b65\u670d\u52a1\u6267\u884c\u7ed3\u679c {} \uff0c\u8017\u65f6 {}", JSON.toJSON((Object)serviceResult), (Object)usedTime);
        List<RerankChunk> rerankerResult = this.getResult(documentList, chunkMap, (String)serviceResult.get("result"));
        if (topN > 0 && rerankerResult != null) {
            rerankerResult = rerankerResult.subList(0, topN);
        }
        return new ResultRerank((String)serviceResult.get("errorCode"), (String)serviceResult.get("message"), rerankerResult, (String)serviceResult.get("id"));
    }

    @Override
    public List<RerankChunk> getResult(List<String> documentList, Map<String, List<String>> chunkMap, String modelResult) {
        ArrayList<RerankChunk> resultChunks = new ArrayList<RerankChunk>();
        if (this.resultValidate(modelResult)) {
            JSONArray jsonArray = JSON.parseArray((String)modelResult);
            if (jsonArray == null) {
                logger.error("Rerank\u6a21\u578b\u670d\u52a1\uff08TEI\u63a5\u53e3\uff09\u8fd4\u56de\u503c\u89e3\u6790\u7ed3\u679c\u4e3anull\u3002\u8fd4\u56de\u503c\uff1a{}", (Object)modelResult);
                return null;
            }
            for (Object item : jsonArray) {
                JSONObject jsonObject = (JSONObject)item;
                int index = jsonObject.getInteger("index");
                String document = documentList.get(index);
                Float relevanceScore = jsonObject.getFloat("score");
                List<String> chunkIds = chunkMap.get(document);
                if (chunkIds.size() == 0) continue;
                RerankChunk rerankChunk = new RerankChunk();
                rerankChunk.setChunkId(chunkIds.get(0));
                rerankChunk.setChunk(document);
                rerankChunk.setRelevanceScore(relevanceScore);
                resultChunks.add(rerankChunk);
                chunkIds.remove(0);
            }
            return resultChunks;
        }
        return null;
    }

    private boolean resultValidate(String modelResult) {
        if (StringUtils.isBlank((CharSequence)modelResult)) {
            logger.error("Rerank\u6a21\u578b\u670d\u52a1\uff08TEI\u63a5\u53e3\uff09\u8c03\u7528\u8fd4\u56de\u503c\u4e3a\u7a7a");
            return false;
        }
        JSONValidator validator = JSONValidator.from((String)modelResult);
        if (validator.validate()) {
            if (validator.getType() == JSONValidator.Type.Array) {
                return true;
            }
            if (validator.getType() == JSONValidator.Type.Object) {
                JSONObject jsonObject = JSON.parseObject((String)modelResult);
                String error = jsonObject.getString("error");
                String errorType = jsonObject.getString("error_type");
                logger.error("Rerank\u6a21\u578b\u670d\u52a1\uff08TEI\u63a5\u53e3\uff09\u8c03\u7528\u53d1\u751f\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + error + "\uff0c\u9519\u8bef\u7c7b\u578b\uff1a" + errorType);
                return false;
            }
            logger.error("Rerank\u6a21\u578b\u670d\u52a1\uff08TEI\u63a5\u53e3\uff09\u8c03\u7528\u8fd4\u56de\u503c\u5f02\u5e38\uff0c\u8fd4\u56de\u503c\uff1a" + modelResult);
            return false;
        }
        logger.error("Rerank\u6a21\u578b\u670d\u52a1\uff08TEI\u63a5\u53e3\uff09\u8c03\u7528\u8fd4\u56de\u503c\u4e0d\u662f\u5408\u6cd5\u7684JSON\uff0c\u8fd4\u56de\u503c\uff1a" + modelResult);
        return false;
    }

    protected ErrorCode checkParam(List<RerankChunk> rerankChunks, String inputQuery, int topN) {
        if (rerankChunks == null) {
            String errorMsg = "Reanker\u6a21\u578b-\u8bf7\u6c42chunk\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a";
            logger.error(errorMsg);
            return Errors.rerankParamError(errorMsg);
        }
        if (StringUtils.isBlank((CharSequence)inputQuery)) {
            String errorMsg = "Reanker\u6a21\u578b-\u8bf7\u6c42inputQuery\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a";
            logger.error(errorMsg);
            return Errors.rerankParamError(errorMsg);
        }
        int chunkListSize = rerankChunks.size();
        if (chunkListSize == 0) {
            String errorMsg = "Reanker\u6a21\u578b-\u8bf7\u6c42chunk\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a";
            logger.error(errorMsg);
            return Errors.rerankParamError(errorMsg);
        }
        int queryLength = inputQuery.length();
        if (queryLength > 1600) {
            String errorMsg = "Reanker\u6a21\u578b-query\u53c2\u6570\u957f\u5ea6\u8d85\u51fa\u6a21\u578b\u672c\u8eab\u9650\u5236";
            logger.error(errorMsg);
            return Errors.rerankParamError(errorMsg);
        }
        if (topN < 0) {
            String errorMsg = "Reanker\u6a21\u578b-topK\u503c\u4e0d\u80fd\u5c0f\u4e8e0";
            logger.error(errorMsg);
            return Errors.rerankParamError(errorMsg);
        }
        if (topN > chunkListSize) {
            String errorMsg = "Reanker\u6a21\u578b-topK\u503c\u4e0d\u80fd\u8d85\u8fc7chunk\u5757\u6570\u91cf\uff1a[" + chunkListSize + "]";
            logger.error(errorMsg);
            return Errors.rerankParamError(errorMsg);
        }
        if (chunkListSize > 200) {
            String errorMsg = "Reanker\u6a21\u578b-chunk\u5757\u6570\u91cf\u8d85\u51fa\u6a21\u578b\u672c\u8eab\u9650\u5236\u5757\u6570\u91cf\uff1a[200]";
            logger.error(errorMsg);
            return Errors.rerankParamError(errorMsg);
        }
        for (RerankChunk rerankChunk : rerankChunks) {
            String chunkStr = rerankChunk.getChunk();
            if (StringUtils.isBlank((CharSequence)chunkStr)) {
                String errorMsg = "Reanker\u6a21\u578b-\u6bcf\u4e2achunk\u5757\u90fd\u4e0d\u80fd\u4e3anull\u6216\u8005\u7a7a\u5b57\u7b26\u4e32";
                logger.error(errorMsg);
                return Errors.rerankParamError(errorMsg);
            }
            int chunkLength = chunkStr.length();
            if (chunkLength <= 4096) continue;
            String errorMsg = "Reanker\u6a21\u578b-\u5b58\u5728chunk\u5757\u957f\u5ea6\u8d85\u51fa\u6a21\u578b\u672c\u8eab\u9650\u5236";
            logger.error(errorMsg);
            return Errors.rerankParamError(errorMsg);
        }
        return Errors.OK;
    }
}

