/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.trusty;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.SensitiveWordStock;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class SensitiveCheckService {
    public static List<SensitiveWordStock> getSensitiveWords(Long orgId) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        QFilter qBaseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gai_sensitivewords", (Long)orgId);
        qFilter = qFilter.and(qBaseDataFilter);
        String sSeletedProterties = String.format("%s,%s,%s,%s", "id", "words_tag", "inputanswer", "outputanswer");
        Map dObjsWords = BusinessDataServiceHelper.loadFromCache((String)"gai_sensitivewords", (String)sSeletedProterties, (QFilter[])new QFilter[]{qFilter});
        ArrayList<SensitiveWordStock> wordStockList = new ArrayList<SensitiveWordStock>(dObjsWords.size());
        for (DynamicObject dObjWordStock : dObjsWords.values()) {
            SensitiveWordStock wordStock = SensitiveWordStock.fromDynamicObject(dObjWordStock);
            wordStockList.add(wordStock);
        }
        return wordStockList;
    }

    public static List<SensitiveWordStock> getSensitiveWords() {
        return SensitiveCheckService.getSensitiveWords(RequestContext.get().getOrgId());
    }

    private static boolean hasSensitiveWords(long orgId) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        QFilter qBaseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gai_sensitivewords", (Long)orgId);
        qFilter.and(qBaseDataFilter);
        return QueryServiceHelper.exists((String)"gai_sensitivewords", (QFilter[])new QFilter[]{qFilter});
    }

    public static boolean isNeedCheck() {
        return SensitiveCheckService.hasSensitiveWords(RequestContext.get().getOrgId()) || SensitiveCheckService.isNeedThirdCheck();
    }

    public static boolean isNeedThirdCheck() {
        return SensitiveCheckService.getThirdCheckSerive() != null && SensitiveCheckService.isCurUserEnableThirdCheck();
    }

    public static DynamicObject getThirdCheckSerive() {
        return BusinessDataServiceHelper.loadSingle((String)"gai_thirdcheck_service", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
    }

    private static boolean isCurUserEnableThirdCheck() {
        long userId = RequestContext.get().getCurrUserId();
        return !QueryServiceHelper.exists((String)"gai_thirdcheck_user", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatus.C), new QFilter("users.user", "=", (Object)userId)});
    }
}

