/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.trusty;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.domain.dto.TrustLayerContext;
import kd.ai.gai.core.domain.dto.TrustLayerResult;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.service.llm.LlmService;
import kd.ai.gai.core.service.trusty.PiiService;
import kd.ai.gai.core.trust.analyzer.RecognizerEngine;
import kd.ai.gai.core.trust.annotation.MaskingField;
import kd.ai.gai.core.trust.masking.MaskingEngine;
import kd.ai.gai.core.trust.model.EntityType;
import kd.ai.gai.core.trust.model.MaskingInfo;
import kd.ai.gai.core.trust.model.MaskingResult;
import kd.ai.gai.core.trust.model.RecognizerResult;
import kd.ai.gai.core.trust.sensitive.ISensitiveCheck;
import kd.ai.gai.core.trust.sensitive.SensitiveCheckFactory;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class TrustLayerService {
    private static Log logger = LogFactory.getLog(TrustLayerService.class);
    private static final ThreadLocal<TrustLayerContext> maskingCtx = new ThreadLocal();
    private static final Map<Class<?>, List<Field>> mapMaskingFieldCache = new HashMap(10);

    public static TrustLayerResult check(Prompt prompt, Map<String, String> variableMap, List<UserHistoryMessage> history, String userInput, List<Chunk> chunkList) {
        String promptTemplate = StringUtils.isEmpty((CharSequence)prompt.getPrompt()) ? " " : prompt.getPrompt();
        StringBuilder needCheckStr = new StringBuilder();
        needCheckStr.append(promptTemplate);
        needCheckStr.append("\n");
        needCheckStr.append(userInput);
        if (variableMap != null) {
            for (Map.Entry entry : variableMap.entrySet()) {
                if (!promptTemplate.contains("{{" + (String)entry.getKey() + "}}")) continue;
                needCheckStr.append("\n").append((String)entry.getValue());
            }
        }
        for (Chunk chunk : chunkList) {
            needCheckStr.append("\n").append(chunk.getChunk());
        }
        return TrustLayerService.checkInput(needCheckStr.toString());
    }

    public static TrustLayerResult checkInput(String sText) {
        ISensitiveCheck thirdcheck;
        if (StringUtils.isEmpty((CharSequence)sText)) {
            return new TrustLayerResult();
        }
        TrustLayerResult result = SensitiveCheckFactory.getLocalInputCheck().textCheck(sText);
        if (result.getErrorCode() == null && (thirdcheck = SensitiveCheckFactory.getThirdCheck()) != null) {
            result = SensitiveCheckFactory.getThirdCheck().textCheck(sText);
        }
        return result;
    }

    public static TrustLayerResult checkOutput(String sText) {
        ISensitiveCheck thirdcheck;
        if (StringUtils.isEmpty((CharSequence)sText)) {
            return new TrustLayerResult();
        }
        TrustLayerResult result = SensitiveCheckFactory.getLocalOutputCheck().textCheck(sText);
        if (result.getErrorCode() == null && (thirdcheck = SensitiveCheckFactory.getThirdCheck()) != null) {
            result = SensitiveCheckFactory.getThirdCheck().textCheck(sText);
        }
        return result;
    }

    public static void startMasking() {
        List<EntityType> entityTypeList = PiiService.getDesensitizationPiiTypes();
        TrustLayerContext context = new TrustLayerContext();
        context.setMaskingInfoList(new HashSet<MaskingInfo>());
        context.setEntityTypeList(entityTypeList);
        context.setEnableMasking(!entityTypeList.isEmpty());
        maskingCtx.set(context);
    }

    public static TrustLayerContext endMasking() {
        TrustLayerContext context = maskingCtx.get();
        maskingCtx.remove();
        Set<MaskingInfo> maskingInfoList = context.getMaskingInfoList();
        for (MaskingInfo maskingInfo : maskingInfoList) {
            logger.info("MaskingInfo:" + JSON.toJSONString((Object)maskingInfo));
        }
        return context;
    }

    public static String masking(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return text;
        }
        TrustLayerContext tlCtx = maskingCtx.get();
        if (tlCtx == null) {
            return text;
        }
        if (!tlCtx.isEnableMasking()) {
            return text;
        }
        RecognizerEngine recognizerEngine = new RecognizerEngine();
        MaskingEngine maskingEngine = new MaskingEngine();
        List<RecognizerResult> analyzeResult = recognizerEngine.analyze(text, 0.0f, tlCtx.getEntityTypeList());
        if (analyzeResult.isEmpty()) {
            return text;
        }
        List<RecognizerResult> removeConflictsResult = recognizerEngine.removeConflicts(analyzeResult);
        MaskingResult maskingResult = maskingEngine.masking(text, removeConflictsResult, tlCtx.getMaskingInfoList());
        return maskingResult.getMaskingText();
    }

    public static String deMasking(String llmResp, TrustLayerContext tlCtx) {
        logger.debug("demasking-begin");
        logger.debug("TrustLayerContext=" + JSON.toJSONString((Object)tlCtx));
        logger.debug("beforeDeMasking=" + llmResp);
        if (llmResp == null || tlCtx == null || !tlCtx.isEnableMasking() || tlCtx.getMaskingInfoList() == null || tlCtx.getMaskingInfoList().isEmpty()) {
            return llmResp;
        }
        RecognizerEngine recognizerEngine = new RecognizerEngine();
        List<RecognizerResult> maskingAnalyzeResult = recognizerEngine.analyze(llmResp, 0.0f, tlCtx.getEntityTypeList());
        if (maskingAnalyzeResult.isEmpty()) {
            return llmResp;
        }
        List<RecognizerResult> removeConflictsMaskingResult = recognizerEngine.removeConflicts(maskingAnalyzeResult);
        MaskingEngine maskingEngine = new MaskingEngine();
        String afterDeMasking = maskingEngine.deMasking(llmResp, removeConflictsMaskingResult, tlCtx.getMaskingInfoList());
        logger.debug("AfterDeMasking=" + afterDeMasking);
        return afterDeMasking;
    }

    public static void maskingLLMParam(LlmParam llmParam) {
        logger.info(String.format("%s before masking:%s", llmParam.getClass().getName(), JSON.toJSONString((Object)llmParam)));
        TrustLayerService.maskingObjectFields(llmParam, null);
        logger.info(String.format("%s after masking:%s", llmParam.getClass().getName(), JSON.toJSONString((Object)llmParam)));
    }

    public static JSONObject maskingLLMParam(JSONObject llmParamJson, LlmService llmService) {
        Object llmParam = llmService.parseLLMParam(llmParamJson);
        TrustLayerService.maskingObjectFields(llmParam, llmParamJson);
        return llmParamJson;
    }

    private static void maskingObjectFields(Object objValue, JSONObject jsonObjValue) {
        Class<?> clazz = objValue.getClass();
        List<Field> fields = TrustLayerService.getAllMaskingFields(clazz);
        if (fields.isEmpty()) {
            GaiExceptionUtil.throwFormatGaiException(GaiErrorCode.TRUSTY_ERROR_NO_MASKING_FIELD, clazz.getName());
        }
        for (Field field : fields) {
            Object fieldValue = TrustLayerService.getFieldValue(field, objValue);
            TrustLayerService.maskingField(field, fieldValue, objValue, jsonObjValue);
        }
    }

    private static void maskingField(Field field, Object fieldValue, Object objValue, JSONObject jsonObjValue) {
        Class<?> fieldType = field.getType();
        if (String.class.isAssignableFrom(fieldType)) {
            TrustLayerService.maskingStringField(field, fieldValue, objValue, jsonObjValue);
        } else {
            TrustLayerService.maskingObject(fieldValue, jsonObjValue == null ? null : jsonObjValue.get((Object)field.getName()));
        }
    }

    private static void maskingObject(Object fieldValue, Object jsonValue) {
        if (fieldValue == null) {
            return;
        }
        Class<?> fieldType = fieldValue.getClass();
        if (fieldType.isArray()) {
            TrustLayerService.maskingArray(fieldValue, jsonValue == null ? null : (JSONArray)jsonValue);
        } else if (Set.class.isAssignableFrom(fieldType)) {
            TrustLayerService.maskingSet(fieldValue, jsonValue == null ? null : (JSONArray)jsonValue);
        } else if (List.class.isAssignableFrom(fieldType)) {
            TrustLayerService.maskingList(fieldValue, jsonValue == null ? null : (JSONArray)jsonValue);
        } else if (Map.class.isAssignableFrom(fieldType)) {
            TrustLayerService.maskingMap(fieldValue, jsonValue == null ? null : (JSONObject)jsonValue);
        } else if (!TrustLayerService.isPrimitive(fieldType)) {
            TrustLayerService.maskingObjectFields(fieldValue, jsonValue == null ? null : (JSONObject)jsonValue);
        }
    }

    private static void maskingMap(Object fieldValue, JSONObject jsonFieldValue) {
        Map mapValue = (Map)fieldValue;
        if (mapValue == null || mapValue.isEmpty()) {
            return;
        }
        for (Map.Entry entry : mapValue.entrySet()) {
            String key = entry.getKey().toString();
            Object item = entry.getValue();
            if (item == null) continue;
            Class<?> itemType = item.getClass();
            if (String.class.isAssignableFrom(itemType)) {
                item = TrustLayerService.maskingString(item);
                Map.Entry entryNew = entry;
                entryNew.setValue(item.toString());
                if (jsonFieldValue == null) continue;
                jsonFieldValue.put(key, (Object)item.toString());
                continue;
            }
            if (TrustLayerService.isPrimitive(itemType)) continue;
            TrustLayerService.maskingObject(item, jsonFieldValue == null ? null : jsonFieldValue.get((Object)key));
        }
    }

    private static void maskingSet(Object fieldValue, JSONArray jsonArrayFieldValue) {
        Set items = (Set)fieldValue;
        if (items == null || items.isEmpty()) {
            return;
        }
        ArrayList itemList = new ArrayList(items);
        TrustLayerService.maskingList(itemList, jsonArrayFieldValue);
        items.clear();
        for (int i = 0; i < itemList.size(); ++i) {
            items.add(itemList.get(i));
        }
    }

    private static void maskingList(Object fieldValue, JSONArray jsonArrayFieldValue) {
        List items = (List)fieldValue;
        if (items == null || items.isEmpty()) {
            return;
        }
        ListIterator<String> listIterator = items.listIterator();
        int index = 0;
        while (listIterator.hasNext()) {
            Object item = listIterator.next();
            if (item != null) {
                Class<?> itemType = item.getClass();
                if (String.class.isAssignableFrom(itemType)) {
                    String sMaskResult = TrustLayerService.masking(item.toString());
                    if (!item.toString().equals(sMaskResult)) {
                        listIterator.set(sMaskResult);
                        if (jsonArrayFieldValue != null) {
                            jsonArrayFieldValue.set(index, (Object)sMaskResult);
                        }
                    }
                } else if (!TrustLayerService.isPrimitive(itemType)) {
                    TrustLayerService.maskingObject(item, jsonArrayFieldValue == null ? null : jsonArrayFieldValue.get(index));
                }
            }
            ++index;
        }
    }

    private static void maskingArray(Object fieldValue, JSONArray jsonArrayFieldValue) {
        Object[] items = (Object[])fieldValue;
        if (items == null || items.length == 0) {
            return;
        }
        List<Object> itemList = Arrays.asList(items);
        TrustLayerService.maskingList(itemList, jsonArrayFieldValue);
        for (int i = 0; i < items.length; ++i) {
            items[i] = itemList.get(i);
        }
    }

    private static void maskingStringField(Field field, Object fieldValue, Object objValue, JSONObject jsonObjValue) {
        if (fieldValue != null && StringUtils.isNotEmpty((CharSequence)fieldValue.toString())) {
            String maskingResult = TrustLayerService.masking(fieldValue.toString());
            TrustLayerService.setFieldValue(objValue, field, maskingResult);
            if (jsonObjValue != null) {
                jsonObjValue.put(field.getName(), (Object)maskingResult);
            }
        }
    }

    private static Object maskingString(Object objValue) {
        if (objValue != null && StringUtils.isNotEmpty((CharSequence)objValue.toString())) {
            objValue = TrustLayerService.masking(objValue.toString());
        }
        return objValue;
    }

    private static Object getFieldValue(Field field, Object objValue) {
        Object fieldValue = null;
        try {
            if (field.isAccessible()) {
                fieldValue = field.get(objValue);
            } else {
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(field.getName(), objValue.getClass());
                Method getter = propertyDescriptor.getReadMethod();
                fieldValue = getter.invoke(objValue, new Object[0]);
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException ex) {
            GaiExceptionUtil.throwFormatGaiException(ex, GaiErrorCode.TRUSTY_ERROR_GET_FIELD_VALUE, objValue.getClass(), field.getName());
        }
        return fieldValue;
    }

    private static void setFieldValue(Object objValue, Field field, Object fieldValue) {
        try {
            if (field.isAccessible()) {
                field.set(objValue, fieldValue);
            } else {
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(field.getName(), objValue.getClass());
                Method setter = propertyDescriptor.getWriteMethod();
                setter.invoke(objValue, fieldValue);
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException ex) {
            GaiExceptionUtil.throwFormatGaiException(ex, GaiErrorCode.TRUSTY_ERROR_SET_FIELD_VALUE, objValue.getClass(), field.getName());
        }
    }

    private static List<Field> getAllMaskingFields(Class<?> type) {
        List<Field> fields = mapMaskingFieldCache.get(type);
        if (fields != null) {
            return fields;
        }
        fields = new ArrayList<Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            Field[] fs;
            for (Field f : fs = c.getDeclaredFields()) {
                if (!f.isAnnotationPresent(MaskingField.class)) continue;
                fields.add(f);
            }
        }
        mapMaskingFieldCache.put(type, fields);
        return fields;
    }

    private static boolean isPrimitive(Class<?> clazz) {
        if (clazz.equals(Boolean.class)) {
            return true;
        }
        if (clazz.equals(Character.class)) {
            return true;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz.equals(Void.class)) {
            return true;
        }
        return clazz.isPrimitive();
    }
}

