/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.vdb;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.VectorMetricType;
import kd.ai.gai.core.service.embedding.EmbeddingServiceFactory;
import kd.ai.gai.core.service.vdb.client.VDBClientWrapper;
import kd.ai.gai.core.service.vdb.service.VDBService;
import kd.ai.vdb.VDBManager;
import kd.ai.vdb.objects.VectorSimilarity;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class VDBServiceManager {
    private static Log logger = LogFactory.getLog(VDBServiceManager.class);
    private static final Map<String, VDBService> storeMap = new ConcurrentHashMap<String, VDBService>();

    public static VDBService getStore(LLM llm, VectorMetricType metricType) {
        RequestContext requestContext = RequestContext.get();
        logger.info("gai vdb type bos-vdb");
        LLM.ModelType modelType = llm.getModelType();
        if (modelType != LLM.ModelType.EMBEDDING) {
            String message = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5411\u91cf\u6a21\u578b\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5", (String)"VDBServiceManager_0", (String)"ai-gai-core", (Object[])new Object[0]);
            logger.error(message + (Object)((Object)modelType));
            throw new RuntimeException(message);
        }
        int dimension = EmbeddingServiceFactory.getExecutor(llm, metricType).getDimension();
        String embeddingNumber = llm.getNumber();
        VectorSimilarity vectorSimilarity = VDBServiceManager.convertMetricType(metricType);
        String key = "gai_" + requestContext.getAccountId() + "_" + embeddingNumber + "_" + dimension + "_" + metricType.toString();
        return storeMap.computeIfAbsent(key, k -> new VDBService(vectorSimilarity, new VDBClientWrapper(VDBManager.getDefaultClient(), dimension, embeddingNumber)));
    }

    private static VectorSimilarity convertMetricType(VectorMetricType metricType) {
        switch (metricType) {
            case L2: {
                return VectorSimilarity.L2;
            }
            case COSINE: {
                return VectorSimilarity.COSINE;
            }
        }
        String msg = ResManager.loadKDString((String)("\u5411\u91cf\u6570\u636e\u5e93\uff0c\u4e0d\u652f\u6301\u7684\u8ba1\u7b97\u7c7b\u578b:" + (Object)((Object)metricType)), (String)"gai.core.vdb.store.0", (String)"ai-gai-core", (Object[])new Object[0]);
        logger.error(msg);
        throw new RuntimeException(msg);
    }
}

