/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.vdb.client;

import kd.ai.vdb.Filter;
import kd.ai.vdb.QueryParameters;
import kd.ai.vdb.VDBClient;
import kd.ai.vdb.VDBClientConfig;
import kd.ai.vdb.objects.CollectionData;
import kd.ai.vdb.objects.CollectionMeta;

public class VDBClientWrapper {
    private VDBClient vdbClient;
    private int dimension;
    private String embeddingNum;

    public VDBClientWrapper(VDBClient vdbClient, int dimension, String embeddingNum) {
        this.vdbClient = vdbClient;
        this.dimension = dimension;
        this.embeddingNum = embeddingNum;
    }

    public void init(VDBClientConfig config) {
        this.vdbClient.init(config);
    }

    public void close(boolean b) {
    }

    public void insert(String collectionName, String[] fields, Object[][] collectionData) {
        this.validateVectorDimension(collectionData);
        this.vdbClient.insert(collectionName, fields, collectionData);
    }

    public void insert(CollectionData collectionData) {
        this.validateVectorDimension(collectionData.getData());
        this.vdbClient.insert(collectionData);
    }

    public void delete(String collectionName, Object[] ids) {
        this.vdbClient.delete(collectionName, ids);
    }

    public long delete(String collectionName, Filter filter) {
        return this.vdbClient.delete(collectionName, filter);
    }

    public long deleteAll(String collectionName) {
        return this.vdbClient.deleteAll(collectionName);
    }

    public CollectionData search(String collectionName, String destVectorFieldName, double[] destVector, int topk, String[] selectFields) {
        this.validateSearchVector(destVector);
        return this.vdbClient.search(collectionName, destVectorFieldName, destVector, topk, selectFields);
    }

    public CollectionData search(String collectionName, String destVectorFieldName, double[] destVector, int topk, String[] selectFields, Filter filter) {
        this.validateSearchVector(destVector);
        return this.vdbClient.search(collectionName, destVectorFieldName, destVector, topk, selectFields, filter);
    }

    public CollectionData query(String collectionName, int top, String[] selectFields) {
        return this.vdbClient.query(collectionName, top, selectFields);
    }

    public CollectionData query(String collectionName, int limit, int offset, String[] selectFields) {
        return this.vdbClient.query(collectionName, limit, offset, selectFields);
    }

    public CollectionData query(QueryParameters parameters) {
        return this.vdbClient.query(parameters);
    }

    public CollectionData queryByIds(String collectionName, Object[] ids, String[] selectFields) {
        return this.vdbClient.queryByIds(collectionName, ids, selectFields);
    }

    public void createCollection(CollectionMeta collection) {
        this.vdbClient.createCollection(collection);
    }

    public void dropCollection(String collectionName) {
        this.vdbClient.dropCollection(collectionName);
    }

    public boolean existsCollection(String collectionName) {
        return this.vdbClient.existsCollection(collectionName);
    }

    public long count(String collectionName) {
        return this.vdbClient.count(collectionName);
    }

    public CollectionMeta queryMeta(String collectionName) {
        return this.vdbClient.queryMeta(collectionName);
    }

    public void close() throws Exception {
        if (this.vdbClient != null) {
            this.vdbClient.close();
        }
    }

    public VDBClient getVdbClient() {
        return this.vdbClient;
    }

    public void setVdbClient(VDBClient vdbClient) {
        this.vdbClient = vdbClient;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public String getEmbeddingNum() {
        return this.embeddingNum;
    }

    public void setEmbeddingNum(String embeddingNum) {
        this.embeddingNum = embeddingNum;
    }

    private void validateVectorDimension(Object[][] data) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Collection data cannot be empty");
        }
        Object[][] objectArray = data;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object[] row;
            for (Object field : row = objectArray[i]) {
                double[] vector;
                if (!(field instanceof double[]) || (vector = (double[])field).length == this.dimension) continue;
                throw new IllegalArgumentException(String.format("Vector dimension mismatch. Expected: %d, Found: %d", this.dimension, vector.length));
            }
        }
    }

    private void validateSearchVector(double[] vector) {
        if (vector == null) {
            throw new IllegalArgumentException("Search vector cannot be null");
        }
        if (vector.length != this.dimension) {
            throw new IllegalArgumentException(String.format("Search vector dimension mismatch. Expected: %d, Found: %d", this.dimension, vector.length));
        }
    }
}

