/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.vdb.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.service.vdb.client.VDBClientWrapper;
import kd.ai.vdb.Filter;
import kd.ai.vdb.QueryParameters;
import kd.ai.vdb.objects.CollectionData;
import kd.ai.vdb.objects.CollectionMeta;
import kd.ai.vdb.objects.DataType;
import kd.ai.vdb.objects.FieldMeta;
import kd.ai.vdb.objects.IdFieldMeta;
import kd.ai.vdb.objects.VectorFieldMeta;
import kd.ai.vdb.objects.VectorSimilarity;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class VDBService {
    private static Log logger = LogFactory.getLog(VDBService.class);
    private static final int SEARCH_K = 5;
    private static final int MAX_TOP = 100;
    private final AtomicBoolean initialized = new AtomicBoolean();
    private String collectionName;
    private final VectorSimilarity vectorSimilarity;
    private final VDBClientWrapper vdbClient;
    private CollectionMeta collectionMeta;

    public VDBService(VectorSimilarity vectorSimilarity, VDBClientWrapper vdbClient) {
        this.vectorSimilarity = vectorSimilarity;
        this.vdbClient = vdbClient;
        this.collectionName = VDBService.genCollectionName(vdbClient.getEmbeddingNum(), vectorSimilarity);
        this.collectionMeta = this.buildCollectionMeta(this.collectionName);
    }

    private CollectionMeta buildCollectionMeta(String collectionName) {
        CollectionMeta collection = new CollectionMeta();
        collection.setName(collectionName);
        collection.addField((FieldMeta)new IdFieldMeta());
        collection.addField((FieldMeta)new VectorFieldMeta("vector", DataType.DOUBLE, this.vdbClient.getDimension(), this.vectorSimilarity));
        collection.addField(new FieldMeta("repoId", DataType.INT64));
        collection.setShards(2);
        collection.setReplicas(1);
        return collection;
    }

    public void init() {
        if (this.initialized.compareAndSet(false, true)) {
            try {
                logger.info("Initializing vector database collection: {}", (Object)this.collectionName);
                boolean exist = this.vdbClient.existsCollection(this.collectionName);
                if (!exist) {
                    this.vdbClient.createCollection(this.collectionMeta);
                    logger.info("Successfully initialized vector database collection: {}", (Object)this.collectionName);
                } else {
                    logger.info("vector database collection: {} exist ,not Initializing", (Object)this.collectionName);
                }
            }
            catch (RuntimeException e) {
                logger.error("Error initialized vector database collection: {}", (Object)this.collectionName, (Object)e);
                this.initialized.set(false);
                throw e;
            }
        }
    }

    public List<Long> searchIds(List<Float> vector, List<Long> repoIdList) {
        return this.searchIds(vector, repoIdList, 5);
    }

    public List<Long> searchIds(List<Float> vector, List<Long> repoIdList, int top) {
        CollectionData collectionData = this.search(vector, repoIdList, top);
        if (collectionData == null || collectionData.size() == 0) {
            logger.debug("Empty CollectionData, returning empty result list");
            return Collections.emptyList();
        }
        ArrayList<Long> ids = new ArrayList<Long>(collectionData.size());
        for (int i = 0; i < collectionData.size(); ++i) {
            try {
                Object idObj = null;
                if (collectionData.getMeta().getIdField() != null) {
                    idObj = collectionData.getId(i);
                } else if (collectionData.getMeta().contains("_id")) {
                    idObj = collectionData.getValue(i, "_id");
                }
                if (idObj == null) continue;
                if (idObj instanceof String) {
                    try {
                        ids.add(Long.parseLong((String)idObj));
                    }
                    catch (NumberFormatException e) {
                        ids.add(Long.valueOf(idObj.hashCode()));
                    }
                    continue;
                }
                if (!(idObj instanceof Number)) continue;
                ids.add(((Number)idObj).longValue());
                continue;
            }
            catch (Exception e) {
                logger.debug("Unable to get ID for row {}: {}", (Object)i, (Object)e.getMessage());
            }
        }
        return ids;
    }

    public CollectionData search(List<Float> vector, List<Long> repoIdList) {
        return this.search(vector, repoIdList, 5);
    }

    public CollectionData search(List<Float> vector, List<Long> repoIdList, int top) {
        return this.search(this.collectionName, vector, repoIdList, top);
    }

    public CollectionData search(String collectionName, List<Float> vector, List<Long> repoIdList, int top) throws KDBizException {
        logger.debug("milvus search params,top:{}, repoIdList:{}", (Object)top, (Object)JSON.toJSONString(repoIdList));
        int currenTop = top == 0 ? 1 : Math.min(top, 100);
        logger.debug("milvus search params,exec top:{}", (Object)currenTop);
        try {
            if (!this.initialized.get()) {
                this.init();
            }
            double[] destVector = new double[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                destVector[i] = vector.get(i).doubleValue();
            }
            String[] outFields = new String[]{"repoId"};
            Filter filter = this.buildSearchFilter(repoIdList);
            CollectionData collectionData = this.vdbClient.search(collectionName, "vector", destVector, top, outFields, filter);
            logger.info("search result {}", (Object)collectionData);
            return collectionData;
        }
        catch (Exception e) {
            logger.error("Vector search operation failed", (Throwable)e);
            throw new KDBizException("Vector search err:" + e.getMessage());
        }
    }

    private Filter buildSearchFilter(List<Long> repoIdlist) {
        ArrayList<Filter> conditions = new ArrayList<Filter>();
        if (repoIdlist != null && !repoIdlist.isEmpty()) {
            if (repoIdlist.size() == 1) {
                conditions.add(Filter.equal((String)"repoId", (Object)repoIdlist.get(0)));
            } else {
                HashSet<Long> uniqueRepoIds = new HashSet<Long>(repoIdlist);
                Object[] knowledgeIdArray = uniqueRepoIds.toArray();
                conditions.add(Filter.in((String)"repoId", (Object[])knowledgeIdArray));
            }
        }
        if (conditions.isEmpty()) {
            return null;
        }
        if (conditions.size() == 1) {
            return (Filter)conditions.get(0);
        }
        return Filter.and((Filter[])conditions.toArray(new Filter[0]));
    }

    public void delCollection() {
        if (!this.initialized.get()) {
            try {
                this.init();
            }
            catch (Exception e) {
                logger.error("Failed to initialize before deleteAll operation", (Throwable)e);
                throw e;
            }
        }
        try {
            logger.warn("Deleting ALL vector data in collection: {}", (Object)this.collectionName);
            this.vdbClient.deleteAll(this.collectionName);
            logger.info("Successfully deleted all vector data in collection: {}", (Object)this.collectionName);
        }
        catch (Exception e) {
            logger.error("Failed to delete all vector data", (Throwable)e);
            throw new RuntimeException("Delete all operation failed: " + e.getMessage());
        }
    }

    public void insert(CollectionData collectionData) {
        if (collectionData == null || collectionData.size() <= 0) {
            logger.warn("No vector chunks to store");
            throw new KDBizException("\u5206\u6bb5\u4e3a\u7a7a\uff0c\u53ef\u80fd\u662f\u7a7a\u6587\u4ef6");
        }
        if (!this.initialized.get()) {
            this.init();
        }
        this.vdbClient.insert(collectionData);
        logger.info("Successfully stored vectors: count={}, collection={}", (Object)collectionData.size(), (Object)this.collectionName);
    }

    public void bachInsert(List<Chunk> chunkList) {
        if (chunkList == null || chunkList.isEmpty()) {
            logger.warn("No vector chunks to store");
            throw new KDBizException("\u5206\u6bb5\u4e3a\u7a7a\uff0c\u53ef\u80fd\u662f\u7a7a\u6587\u4ef6");
        }
        if (!this.initialized.get()) {
            this.init();
        }
        logger.info("Storing vectors: count={}, collection={}", (Object)chunkList.size(), (Object)this.collectionName);
        try {
            CollectionData collectionData = new CollectionData(this.collectionMeta, chunkList.size());
            for (Chunk chunk : chunkList) {
                if (chunk == null || chunk.getVector() == null) {
                    logger.warn("Skipping null vector chunk");
                    continue;
                }
                List<Float> floatVector = chunk.getVector();
                double[] doubleVector = new double[floatVector.size()];
                for (int i = 0; i < floatVector.size(); ++i) {
                    doubleVector[i] = floatVector.get(i).doubleValue();
                }
                String id = chunk.getId() != 0L ? String.valueOf(chunk.getId()) : UUID.randomUUID().toString().replace("-", "");
                collectionData.append(new Object[]{id, doubleVector, chunk.getRepositoryId()});
            }
            this.vdbClient.insert(collectionData);
            logger.info("Successfully stored vectors: count={}, collection={}", (Object)chunkList.size(), (Object)this.collectionName);
        }
        catch (Exception e) {
            logger.error("VdbStore Failed to store vectors", (Throwable)e);
            throw new KDBizException("VdbStore operation failed: " + e.getMessage());
        }
    }

    public boolean delByIdList(List<Long> idList) {
        if (!this.initialized.get()) {
            try {
                this.init();
            }
            catch (Exception e) {
                logger.error("Failed to initialize before delete operation", (Throwable)e);
                throw e;
            }
        }
        try {
            logger.debug("Deleting vector chunks: count={}, collection={}", (Object)idList.size(), (Object)this.collectionName);
            Object[] idArray = new Object[idList.size()];
            for (int i = 0; i < idList.size(); ++i) {
                idArray[i] = idList.get(i);
            }
            this.vdbClient.delete(this.collectionName, idArray);
            logger.info("Successfully deleted vector chunks: count={}, collection={}", (Object)idList.size(), (Object)this.collectionName);
            return true;
        }
        catch (Exception e) {
            logger.error("Failed to delete chunks: chunkIds=" + idList, (Throwable)e);
            return false;
        }
    }

    public CollectionData query(QueryParameters parameters) {
        if (parameters == null) {
            logger.error("query No parameters, skipping operation");
            throw new IllegalArgumentException("QueryParameters cannot be null");
        }
        logger.info("query parameters:{}", (Object)JsonUtil.toJson(parameters));
        if (!this.initialized.get()) {
            try {
                this.init();
            }
            catch (Exception e) {
                logger.error("Failed to initialize before delete operation", (Throwable)e);
                throw e;
            }
        }
        CollectionData collectionData = this.vdbClient.query(parameters);
        logger.info("query result {}", (Object)collectionData);
        return collectionData;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getCollectionDescription() {
        return "Vector collection for GAI";
    }

    private static String genCollectionName(String embeddingNumber, VectorSimilarity metricType) {
        RequestContext rc = RequestContext.get();
        String collection = metricType == VectorSimilarity.COSINE ? String.format("M_%s_%s_%s", rc.getAccountId(), embeddingNumber, metricType) : String.format("M_%s_%s", rc.getAccountId(), embeddingNumber);
        collection = collection.toLowerCase();
        logger.info("milvus new collectionName\uff1a{}", (Object)collection);
        return collection;
    }
}

