/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.vdb.service;

import io.milvus.grpc.SearchResults;
import io.milvus.response.SearchResultsWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.ai.gai.core.service.vdb.VDBResult;
import kd.ai.vdb.objects.CollectionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VDBServiceConverter {
    private static final Logger logger = LoggerFactory.getLogger(VDBServiceConverter.class);

    public static List<VDBResult> toSearchVDBResults(CollectionData collectionData) {
        if (collectionData == null || collectionData.size() == 0) {
            logger.debug("Empty CollectionData, returning empty result list");
            return Collections.emptyList();
        }
        ArrayList<VDBResult> results = new ArrayList<VDBResult>(collectionData.size());
        for (int i = 0; i < collectionData.size(); ++i) {
            VDBResult result = new VDBResult();
            try {
                Object idObj = null;
                if (collectionData.getMeta().getIdField() != null) {
                    idObj = collectionData.getId(i);
                } else if (collectionData.getMeta().contains("_id")) {
                    idObj = collectionData.getValue(i, "_id");
                }
                if (idObj != null) {
                    if (idObj instanceof String) {
                        try {
                            result.setId(Long.parseLong((String)idObj));
                        }
                        catch (NumberFormatException e) {
                            result.setId(idObj.hashCode());
                        }
                    } else if (idObj instanceof Number) {
                        result.setId(((Number)idObj).longValue());
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Unable to get ID for row {}: {}", (Object)i, (Object)e.getMessage());
            }
            try {
                Object scoreObj = null;
                if (collectionData.getMeta().getScoreField() != null) {
                    scoreObj = collectionData.getValue(i, collectionData.getMeta().getScoreField().getName());
                } else if (collectionData.getMeta().contains("_score")) {
                    scoreObj = collectionData.getValue(i, "_score");
                }
                if (scoreObj instanceof Number) {
                    result.setScore(((Number)scoreObj).floatValue());
                }
            }
            catch (Exception e) {
                logger.debug("Unable to get score for row {}: {}", (Object)i, (Object)e.getMessage());
            }
            results.add(result);
        }
        return results;
    }

    public static List<VDBResult> toSearchVDBResults(SearchResults searchResults) {
        if (searchResults == null) {
            logger.debug("Empty CollectionData, returning empty result list");
            return Collections.emptyList();
        }
        List ids = searchResults.getResults().getIds().getIntId().getDataList();
        if (ids != null && ids.size() > 0) {
            ArrayList<VDBResult> results = new ArrayList<VDBResult>(ids.size());
            SearchResultsWrapper searchWrapper = new SearchResultsWrapper(searchResults.getResults());
            List idScores = searchWrapper.getIDScore(0);
            int size = idScores.size();
            for (int i = 0; i < size; ++i) {
                Long chunkId = (Long)ids.get(i);
                SearchResultsWrapper.IDScore idScore = (SearchResultsWrapper.IDScore)idScores.get(i);
                float score = idScore.getScore();
                VDBResult result = new VDBResult(chunkId, score);
                results.add(result);
            }
            return results;
        }
        logger.debug("Empty SearchResults IDS, returning empty result list");
        return Collections.emptyList();
    }
}

