/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.sse.cache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.ai.gai.core.sse.iterator.AbstractSSEIterator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;

public class SSEIteratorCache {
    private static final Log logger = LogFactory.getLog(SSEIteratorCache.class);
    private static long CLEAR_PER_TIME = 3600000L;
    private static long SSE_OUTPUT_TIME_OUT = 3600000L;
    private static ConcurrentHashMap<String, AbstractSSEIterator> mapIterator = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Long> mapIteratorLastPutTime = new ConcurrentHashMap();
    private static AtomicLong lastClearTimeStamp = new AtomicLong(System.currentTimeMillis());

    public static void put(String chatSessionId, String requestTraceId, AbstractSSEIterator iterator) {
        String cacheKey = SSEIteratorCache.getKey(chatSessionId, requestTraceId);
        SSEIteratorCache.clearTimeOutKey();
        if (mapIterator.containsKey(cacheKey)) {
            logger.info(String.format("\u4f1a\u8bdd\u8bf7\u6c42\u3010sessionId=%s,traceId=%s\u3011\u5b58\u5728\u6d41\u5f0f\u8bf7\u6c42\u672a\u5173\u95ed\uff0c\u5173\u95ed\u65e7\u8bf7\u6c42\u7684\u6d41\u8f93\u51fa\u5668\u3002", chatSessionId, requestTraceId));
            SSEIteratorCache.finish(chatSessionId, requestTraceId);
        }
        mapIteratorLastPutTime.put(cacheKey, System.currentTimeMillis());
        mapIterator.put(cacheKey, iterator);
    }

    public static AbstractSSEIterator get(String chatSessionId, String requestTraceId) {
        return mapIterator.getOrDefault(SSEIteratorCache.getKey(chatSessionId, requestTraceId), null);
    }

    public static AbstractSSEIterator finish(String chatSessionId, String requestTraceId) {
        String cacheKey = SSEIteratorCache.getKey(chatSessionId, requestTraceId);
        AbstractSSEIterator iterator = mapIterator.remove(cacheKey);
        if (iterator != null) {
            logger.info(String.format("SSE finish : ssesionId=%s", chatSessionId));
            iterator.finish();
        }
        mapIteratorLastPutTime.remove(cacheKey);
        return iterator;
    }

    public static String getKey(String chatSessionId, String traceId) {
        return String.format("chat-%s-%s", chatSessionId, traceId);
    }

    public static void clearTimeOutKey() {
        long nowTime = System.currentTimeMillis();
        if (nowTime - lastClearTimeStamp.get() > CLEAR_PER_TIME && mapIterator.size() > 500) {
            ThreadPools.executeOnce((String)("ai-sse-clearTimeOutKey-" + System.currentTimeMillis()), () -> {
                try {
                    AtomicInteger clearCount = new AtomicInteger();
                    mapIteratorLastPutTime.entrySet().forEach(entry -> {
                        String sseIteratorKey = (String)entry.getKey();
                        if (System.currentTimeMillis() - (Long)entry.getValue() > SSE_OUTPUT_TIME_OUT) {
                            AbstractSSEIterator sseIterator = mapIterator.remove(sseIteratorKey);
                            if (sseIterator != null) {
                                sseIterator.finish();
                            }
                            clearCount.getAndIncrement();
                        }
                    });
                    logger.info(String.format("ai-sse-clearTimeOutKey \u5904\u7406\u5b8c\u6210\uff0c\u5171\u6e05\u7406\u5f02\u5e38session KEY [%s] \u4e2a", clearCount));
                    lastClearTimeStamp.set(System.currentTimeMillis());
                }
                catch (Exception ex) {
                    logger.error("ai-sse-clearTimeOutKey \u5f02\u5e38", (Throwable)ex);
                }
            });
        }
    }
}

