/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.sse.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.util.FlowUtils;

public class SSEClient {
    public static final String ACCEPT = "Accept";
    public static final String TEXT_EVENT_STREAM = "text/event-stream";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_TYPE_VALUE = "application/json";
    private final SSEConfig config;
    private final SSEEventListener listener;
    private HttpURLConnection connection;
    private Context context;

    public SSEClient(SSEConfig config, SSEEventListener listener, Context context) {
        this.config = config;
        this.listener = listener;
        this.context = context;
    }

    public void request() {
        try {
            URL url = new URL(this.config.getUrl());
            this.connection = (HttpURLConnection)url.openConnection();
            this.configureConnection(this.connection);
            this.sendRequestBody(this.connection);
            int responseCode = this.connection.getResponseCode();
            if (responseCode != 200) {
                this.handleErrorResponse(responseCode);
                return;
            }
            this.processEventStream(this.connection);
        }
        catch (Exception e) {
            this.listener.onError(e);
        }
        finally {
            this.listener.onComplete();
            this.disconnect();
        }
    }

    public void disconnect() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    private void configureConnection(HttpURLConnection conn) throws Exception {
        conn.setRequestMethod("POST");
        conn.setReadTimeout(this.config.getReadTimeout());
        conn.setConnectTimeout(this.config.getConnectTimeout());
        this.config.getHeaders().forEach(conn::setRequestProperty);
        conn.setDoOutput(true);
    }

    private void sendRequestBody(HttpURLConnection conn) throws IOException {
        try (OutputStream os = conn.getOutputStream();){
            byte[] input = this.config.getRequestBody().getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
    }

    private void processEventStream(HttpURLConnection conn) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder eventBuffer = new StringBuilder();
            int index = 0;
            while (this.isRunning() && (line = reader.readLine()) != null) {
                if (line.startsWith("data:")) {
                    eventBuffer.append(line.substring(5).trim());
                    continue;
                }
                if (line.isEmpty() && eventBuffer.length() > 0) {
                    this.listener.onEvent(eventBuffer.toString(), index);
                    eventBuffer.setLength(0);
                    ++index;
                    continue;
                }
                this.listener.onError(new IOException("Server returned HTTP :" + line));
            }
        }
    }

    private void handleErrorResponse(int statusCode) throws IOException {
        try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(this.connection.getErrorStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder errorResponse = new StringBuilder();
            while ((line = errorReader.readLine()) != null) {
                errorResponse.append(line);
            }
            this.listener.onError(new IOException("Server returned HTTP " + statusCode + ": " + errorResponse));
        }
    }

    private boolean isRunning() {
        return !FlowUtils.isStopped(this.context.getChatSessionId());
    }

    public static interface SSEEventListener {
        public void onEvent(String var1, int var2);

        public void onError(Throwable var1);

        public void onComplete();
    }

    public static class SSEConfig {
        private String url;
        private String requestBody;
        private int readTimeout = 300000;
        private int connectTimeout = 300000;
        private Map<String, String> headers = new HashMap<String, String>();

        public SSEConfig endpoint(String url) {
            this.url = url;
            this.headers.put(SSEClient.CONTENT_TYPE, SSEClient.CONTENT_TYPE_VALUE);
            return this;
        }

        public SSEConfig requestBody(String body) {
            this.requestBody = body;
            return this;
        }

        public SSEConfig header(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public SSEConfig headers(Map<String, String> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public SSEConfig setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public SSEConfig setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public String getUrl() {
            return this.url;
        }

        public String getRequestBody() {
            return this.requestBody;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String toString() {
            return "SSEConfig{url='" + this.url + '\'' + ", requestBody='" + this.requestBody + '\'' + ", readTimeout=" + this.readTimeout + ", connectTimeout=" + this.connectTimeout + ", headers=" + this.headers + '}';
        }
    }
}

