/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trace;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.trace.constant.Constant;
import kd.ai.gai.core.trace.entity.EventLog;
import kd.ai.gai.core.trace.entity.EventLogResult;
import kd.ai.gai.core.trace.entity.StepLog;
import kd.ai.gai.core.trace.entity.StepLogResult;
import kd.ai.gai.core.trace.util.CommonUtil;
import kd.ai.gai.core.trace.util.LogUtil;
import kd.ai.gai.core.trace.util.SessionLogUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class MonitorServiceHelper {
    private static final Log logger = LogFactory.getLog(MonitorServiceHelper.class);

    public static void saveTraceSteps(long sessionId, long traceId, List<StepLog> logs) {
        logger.info("sessionId:{},traceId:{}", (Object)sessionId, (Object)traceId);
        try {
            QFilter filter = new QFilter("traceid", "=", (Object)traceId);
            QFilter[] filters = new QFilter[]{filter};
            DynamicObject traceObject = BusinessDataServiceHelper.loadSingle((String)"gai_log", (QFilter[])filters);
            if (traceObject == null) {
                logger.info("trace is not exist,traceId({})", (Object)traceId);
                StepLog traceLog = logs.get(0);
                Map<String, String> models = MonitorServiceHelper.findTraceModel(logs);
                logger.info("models:{}", models);
                DynamicObject trace = LogUtil.createTraceEntity(traceLog, models);
                for (StepLog log : logs) {
                    long stepId = LogUtil.genStepId();
                    LogUtil.createStepEntityByStep(trace, log, stepId);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trace});
            } else {
                logger.info("trace is exist,create step,traceId({})", (Object)traceId);
                for (StepLog log : logs) {
                    long stepId = LogUtil.genStepId();
                    LogUtil.createStepEntityByStep(traceObject, log, stepId);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{traceObject});
            }
        }
        catch (Exception e) {
            logger.error(String.format("save step log error : %s", CommonUtil.getStackTrace(e)));
        }
    }

    private static Map<String, String> findTraceModel(List<StepLog> logs) {
        String vector = "";
        String llm = "";
        HashMap<String, String> models = new HashMap<String, String>(0);
        if (logs != null && !logs.isEmpty()) {
            for (StepLog log : logs) {
                String stepType = log.getStepType();
                if (StringUtils.equalsIgnoreCase((CharSequence)stepType, (CharSequence)Constant.StepType.GPT_VECTOR_RETRIEVER.getType())) {
                    vector = log.getModelName();
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)stepType, (CharSequence)Constant.StepType.GPT_PROMPT.getType())) continue;
                llm = log.getModelName();
            }
        }
        models.put("vectormodel", vector);
        models.put("generationmodel", llm);
        return models;
    }

    public static StepLogResult saveStepLog(StepLog log) {
        logger.info(String.format("\u4fdd\u5b58Step\u65e5\u5fd7\u53c2\u6570 : %s", JSONObject.toJSONString((Object)log)));
        logger.info("save step db origin sessionId({}),traceId({})", (Object)log.getSessionId(), (Object)log.getTraceId());
        long sessionId = log.getSessionId() == null || log.getSessionId() == 0L ? LogUtil.genSessionId() : log.getSessionId();
        long traceId = log.getTraceId() == null || log.getTraceId() == 0L ? LogUtil.genTraceId() : log.getTraceId();
        long stepId = LogUtil.genStepId();
        logger.info("save step db final sessionId({}),traceId({}),stepId({})", new Object[]{sessionId, traceId, stepId});
        StepLogResult result = new StepLogResult((Long)sessionId, (Long)traceId, (Long)stepId);
        log.setSessionId(sessionId);
        log.setTraceId(traceId);
        try {
            QFilter filter = new QFilter("traceid", "=", (Object)traceId);
            QFilter[] filters = new QFilter[]{filter};
            DynamicObject traceObject = BusinessDataServiceHelper.loadSingle((String)"gai_log", (QFilter[])filters);
            if (traceObject == null) {
                logger.info("trace is not exist,traceId({})", (Object)traceId);
                logger.info("trace input :{},models:{}", (Object)log.getStepInput(), (Object)log.getModelName());
                DynamicObject trace = LogUtil.createTraceEntity(log);
                LogUtil.createStepEntityByStep(trace, log, stepId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trace});
            } else {
                logger.info("trace is exist,create step,traceId({}),stepId({})", (Object)traceId, (Object)stepId);
                LogUtil.createStepEntityByStep(traceObject, log, stepId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{traceObject});
            }
        }
        catch (Exception e) {
            logger.error(String.format("save step log error : %s", CommonUtil.getStackTrace(e)));
        }
        logger.info(String.format("save step log return : %s", JSONObject.toJSONString((Object)result)));
        return result;
    }

    public static StepLogResult saveAgentStepLog(StepLog log) {
        logger.info(String.format("\u4fdd\u5b58Step\u65e5\u5fd7\u53c2\u6570 : %s", JSONObject.toJSONString((Object)log)));
        logger.info("save step db origin sessionId({}),traceId({})", (Object)log.getSessionId(), (Object)log.getTraceId());
        long sessionId = log.getSessionId() == 0L ? LogUtil.genSessionId() : log.getSessionId();
        long traceId = log.getTraceId() == 0L ? LogUtil.genTraceId() : log.getTraceId();
        long stepId = LogUtil.genStepId();
        logger.info("save step db final sessionId({}),traceId({}),stepId({})", new Object[]{sessionId, traceId, stepId});
        StepLogResult result = new StepLogResult((Long)sessionId, (Long)traceId, (Long)stepId);
        log.setSessionId(sessionId);
        log.setTraceId(traceId);
        try {
            QFilter filter = new QFilter("traceid", "=", (Object)traceId);
            QFilter[] filters = new QFilter[]{filter};
            DynamicObject traceObject = BusinessDataServiceHelper.loadSingle((String)"gai_log", (QFilter[])filters);
            if (traceObject == null) {
                logger.info("trace is not exist,traceId({})", (Object)traceId);
                DynamicObject trace = LogUtil.createTraceEntity(log);
                LogUtil.createStepEntityByStep(trace, log, stepId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trace});
            } else {
                logger.info("trace is exist,create step,traceId({}),stepId({})", (Object)traceId, (Object)stepId);
                LogUtil.createStepEntityByStep(traceObject, log, stepId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{traceObject});
            }
        }
        catch (Exception e) {
            logger.error(String.format("save step log error : %s", CommonUtil.getStackTrace(e)));
        }
        logger.info(String.format("save step log return : %s", JSONObject.toJSONString((Object)result)));
        return result;
    }

    public static EventLogResult saveEventLog(EventLog log) {
        logger.info(String.format("\u4fdd\u5b58Event\u65e5\u5fd7\u53c2\u6570 : %s", JSONObject.toJSONString((Object)log)));
        long sessionId = log.getSessionId() == null || log.getSessionId() == 0L ? LogUtil.genSessionId() : log.getSessionId();
        long traceId = log.getTraceId() == null || log.getTraceId() == 0L ? LogUtil.genTraceId() : log.getTraceId();
        long stepId = log.getStepId() == null || log.getStepId() == 0L ? LogUtil.genStepId() : log.getStepId();
        long eventId = LogUtil.genEventId();
        try {
            Boolean existTrace;
            Boolean existStep;
            log.setSessionId(sessionId);
            DynamicObject dbStepEntity = null;
            DynamicObject dbStepTraceEntity = null;
            if (log.getStepId() == 0L) {
                existStep = Boolean.FALSE;
            } else {
                Map<String, DynamicObject> map = LogUtil.getExistStepEntity(log.getStepId());
                dbStepTraceEntity = map.get("trace");
                dbStepEntity = map.get("step");
                existStep = dbStepEntity == null ? Boolean.FALSE : Boolean.TRUE;
            }
            DynamicObject dbTraceEntity = null;
            if (log.getTraceId() == 0L) {
                existTrace = Boolean.FALSE;
            } else {
                dbTraceEntity = LogUtil.getExistTraceEntity(log.getTraceId());
                Boolean bl = existTrace = dbTraceEntity == null ? Boolean.FALSE : Boolean.TRUE;
            }
            if (existStep.booleanValue()) {
                LogUtil.createEventEntity(dbStepEntity, log, eventId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dbStepTraceEntity});
            } else if (existTrace.booleanValue()) {
                log.setStepId(stepId);
                LogUtil.createStepAndEventEntity(dbTraceEntity, log, eventId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dbTraceEntity});
            } else {
                log.setTraceId(traceId);
                log.setStepId(stepId);
                DynamicObject trace = LogUtil.createTraceEntity(log);
                LogUtil.createStepAndEventEntity(trace, log, eventId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trace});
            }
        }
        catch (Exception e) {
            logger.error(String.format("save event log error : %s", CommonUtil.getStackTrace(e)));
        }
        EventLogResult result = new EventLogResult(sessionId, traceId, stepId, eventId);
        logger.info(String.format("save event log return : %s", JSONObject.toJSONString((Object)result)));
        return result;
    }

    public static EventLogResult saveAgentEventLog(EventLog log) {
        logger.info(String.format("\u4fdd\u5b58Event\u65e5\u5fd7\u53c2\u6570 : %s", JSONObject.toJSONString((Object)log)));
        long sessionId = log.getSessionId() == 0L ? LogUtil.genSessionId() : log.getSessionId();
        long traceId = log.getTraceId() == 0L ? LogUtil.genTraceId() : log.getTraceId();
        long stepId = log.getStepId() == 0L ? LogUtil.genStepId() : log.getStepId();
        long eventId = LogUtil.genEventId();
        try {
            Boolean existTrace;
            Boolean existStep;
            log.setSessionId(sessionId);
            DynamicObject dbStepEntity = null;
            DynamicObject dbStepTraceEntity = null;
            if (log.getStepId() == 0L) {
                existStep = Boolean.FALSE;
            } else {
                Map<String, DynamicObject> map = LogUtil.getExistStepEntity(log.getStepId());
                dbStepTraceEntity = map.get("trace");
                dbStepEntity = map.get("step");
                existStep = dbStepEntity == null ? Boolean.FALSE : Boolean.TRUE;
            }
            DynamicObject dbTraceEntity = null;
            if (log.getTraceId() == 0L) {
                existTrace = Boolean.FALSE;
            } else {
                dbTraceEntity = LogUtil.getExistTraceEntity(log.getTraceId());
                Boolean bl = existTrace = dbTraceEntity == null ? Boolean.FALSE : Boolean.TRUE;
            }
            if (existStep.booleanValue()) {
                LogUtil.createEventEntity(dbStepEntity, log, eventId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dbStepTraceEntity});
            } else if (existTrace.booleanValue()) {
                log.setStepId(stepId);
                LogUtil.createStepAndEventEntity(dbTraceEntity, log, eventId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dbTraceEntity});
            } else {
                log.setTraceId(traceId);
                log.setStepId(stepId);
                DynamicObject trace = LogUtil.createTraceEntity(log);
                LogUtil.createStepAndEventEntity(trace, log, eventId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trace});
            }
        }
        catch (Exception e) {
            logger.error(String.format("save event log error : %s", CommonUtil.getStackTrace(e)));
        }
        EventLogResult result = new EventLogResult(sessionId, traceId, stepId, eventId);
        logger.info(String.format("save event log return : %s", JSONObject.toJSONString((Object)result)));
        return result;
    }

    public static JSONObject queryTraceLogs(long traceId) {
        logger.info("Agent\u65e5\u5fd7\u9884\u89c8\uff0ctraceId:{}", (Object)traceId);
        JSONObject trace = SessionLogUtil.querySingleTraceDetail(traceId);
        JSONObject data = new JSONObject();
        if (trace != null) {
            data.put("traceid", (Object)String.valueOf(trace.getLong("traceid")));
            JSONArray steps = new JSONArray();
            data.put("list", (Object)steps);
            JSONArray stepArray = trace.getJSONArray("steps");
            if (stepArray != null && !stepArray.isEmpty()) {
                LinkedHashMap stepMaps = new LinkedHashMap();
                String stepKey = null;
                for (int j = 0; j < stepArray.size(); ++j) {
                    JSONObject metadataJo;
                    JSONObject step = stepArray.getJSONObject(j);
                    String stepType = step.getString("steptype");
                    String metadata = step.getString("metadata_tag");
                    JSONObject jSONObject = metadataJo = StringUtils.isEmpty((CharSequence)metadata) ? new JSONObject() : JSONObject.parseObject((String)metadata);
                    if (StringUtils.equalsIgnoreCase((CharSequence)stepType, (CharSequence)Constant.StepType.TOOL.getType())) {
                        String name = metadataJo.getString("toolName");
                        String toolName = StringUtils.isEmpty((CharSequence)name) ? step.getString("steptype_name") : name;
                        step.put("steptype_name", (Object)String.format("%s(%s)", Constant.StepType.TOOL.getName(), toolName));
                    }
                    if (!stepMaps.containsKey(stepKey = Constant.StepType.isLLMStep(stepType) ? String.format("LLM_%s", metadataJo.getString("taskId")) : (Constant.StepType.isProcessStep(stepType) ? String.format("PROCESS_%s", metadataJo.getString("flowId")) : String.format("OTHER_%s", step.get((Object)"stepid"))))) {
                        ArrayList<JSONObject> taskSteps = new ArrayList<JSONObject>();
                        taskSteps.add(step);
                        stepMaps.put(stepKey, taskSteps);
                        continue;
                    }
                    ((List)stepMaps.get(stepKey)).add(step);
                }
                for (Map.Entry entry : stepMaps.entrySet()) {
                    JSONArray stepsArray;
                    String stepTaskId = (String)entry.getKey();
                    List taskSteps = (List)entry.getValue();
                    if (stepTaskId.startsWith("LLM")) {
                        JSONObject stepData = MonitorServiceHelper.handlerLLMNodes(taskSteps);
                        steps.add((Object)stepData);
                        continue;
                    }
                    if (stepTaskId.startsWith("PROCESS")) {
                        stepsArray = MonitorServiceHelper.handlerStepNodes(taskSteps);
                        steps.addAll((Collection)stepsArray);
                        continue;
                    }
                    stepsArray = MonitorServiceHelper.handlerStepNodes(taskSteps);
                    steps.addAll((Collection)stepsArray);
                }
            }
        }
        logger.info("Agent\u65e5\u5fd7\u9884\u89c8\uff0c\u8fd4\u56dedata:{}", (Object)JSONObject.toJSONString((Object)data));
        return data;
    }

    private static JSONObject handlerLLMNodes(List<JSONObject> taskSteps) {
        JSONObject stepData = new JSONObject();
        LinkedList<String> inputs = new LinkedList<String>();
        LinkedList<String> outputs = new LinkedList<String>();
        JSONObject traceInputObj = new JSONObject();
        traceInputObj.put("role", (Object)"input");
        JSONObject traceOutputObj = new JSONObject();
        traceOutputObj.put("role", (Object)"output");
        JSONObject thoughtObj = new JSONObject();
        thoughtObj.put("role", (Object)"thought");
        JSONObject conversationObj = new JSONObject();
        conversationObj.put("role", (Object)"conversation");
        stepData.put("title", (Object)Constant.StepType.LLM.getName());
        for (int k = 0; k < taskSteps.size(); ++k) {
            JSONObject step = taskSteps.get(k);
            String stepType = step.getString("steptype");
            if (StringUtils.equalsIgnoreCase((CharSequence)stepType, (CharSequence)Constant.StepType.GPT_VECTOR_RETRIEVER.getType())) {
                stepData.put("stepId", (Object)String.valueOf(step.get((Object)"stepid")));
                Date date = step.getDate("step_createtime");
                String dateTime = DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
                stepData.put("date", (Object)dateTime);
            }
            String input = step.getString("stepinput");
            String output = step.getString("stepoutput");
            inputs.add(input);
            outputs.add(output);
            if (!StringUtils.equalsIgnoreCase((CharSequence)stepType, (CharSequence)Constant.StepType.GPT_GENERATION.getType())) continue;
            thoughtObj.put("content", (Object)step.getString("thought_tag"));
            conversationObj.put("content", (Object)step.getString("conversation_tag"));
        }
        traceInputObj.put("content", inputs.get(0));
        traceOutputObj.put("content", outputs.get(outputs.size() - 1));
        JSONArray logs = new JSONArray();
        logs.add((Object)traceInputObj);
        logs.add((Object)traceOutputObj);
        logs.add((Object)thoughtObj);
        logs.add((Object)conversationObj);
        stepData.put("logs", (Object)logs);
        return stepData;
    }

    private static JSONArray handlerStepNodes(List<JSONObject> taskSteps) {
        JSONArray steps = new JSONArray();
        for (int k = 0; k < taskSteps.size(); ++k) {
            JSONObject step = taskSteps.get(k);
            JSONObject stepData = new JSONObject();
            stepData.put("title", (Object)step.getString("steptype_name"));
            stepData.put("stepId", (Object)String.valueOf(step.get((Object)"stepid")));
            Date date = step.getDate("step_createtime");
            String dateTime = DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
            stepData.put("date", (Object)dateTime);
            JSONObject traceInputObj = new JSONObject();
            traceInputObj.put("role", (Object)"input");
            JSONObject traceOutputObj = new JSONObject();
            traceOutputObj.put("role", (Object)"output");
            JSONObject thoughtObj = new JSONObject();
            thoughtObj.put("role", (Object)"thought");
            JSONObject conversationObj = new JSONObject();
            conversationObj.put("role", (Object)"conversation");
            traceInputObj.put("content", (Object)step.getString("stepinput"));
            traceOutputObj.put("content", (Object)step.getString("stepoutput"));
            thoughtObj.put("content", (Object)step.getString("thought_tag"));
            conversationObj.put("content", (Object)step.getString("conversation_tag"));
            JSONArray logs = new JSONArray();
            logs.add((Object)traceInputObj);
            logs.add((Object)traceOutputObj);
            logs.add((Object)thoughtObj);
            logs.add((Object)conversationObj);
            stepData.put("logs", (Object)logs);
            steps.add((Object)stepData);
        }
        return steps;
    }

    public static JSONObject queryStepLogsByChatSessionId(String chatSessionId) {
        QFilter chatSessionFilter = new QFilter("chatsessionid", "=", (Object)chatSessionId);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(chatSessionFilter);
        return SessionLogUtil.queryLogs(filters.toArray(new QFilter[0]));
    }

    public static JSONObject queryStepLogsBySessionId(long sessionId) {
        QFilter[] filters = new QFilter[]{new QFilter("sessionid", "=", (Object)sessionId)};
        return SessionLogUtil.queryLogs(filters);
    }
}

