/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trace.cache;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.cache.CacheKeyUtil;
import kd.bos.dataentity.utils.StringUtils;

public class TracePageCache {
    private final String pageId;
    private final String regionKey;
    private Map<String, String> cacheMap = new HashMap<String, String>(16);
    private final Set<String> changeSet = new HashSet<String>();
    private final Set<String> removedKeys = new HashSet<String>();
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ids-form-cache");

    public TracePageCache(String pageId) {
        this.pageId = pageId;
        this.regionKey = CacheKeyUtil.getAcctId() + ".idsformcache." + this.pageId;
        this.restore();
    }

    public String getPageId() {
        return this.pageId;
    }

    public void put(String keyName, String value) {
        if (value == null) {
            this.remove(keyName);
        } else if (!value.equals(this.cacheMap.get(keyName))) {
            this.cacheMap.put(keyName, value);
            this.changeSet.add(keyName);
            this.removedKeys.remove(keyName);
        }
    }

    public void put(String keyName, List<?> value) {
        if (value == null) {
            this.remove(keyName);
        } else {
            String json = JSON.toJSONString(value);
            this.put(keyName, json);
        }
    }

    public void put(Map<String, String> values) {
        this.cacheMap.putAll(values);
        this.changeSet.addAll(values.keySet());
    }

    public String get(String keyName) {
        return this.cacheMap.get(keyName);
    }

    public <T> List<T> getAsList(String keyName, Class<T> clazz) {
        String s = this.get(keyName);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return new ArrayList();
        }
        return JSON.parseArray((String)s, clazz);
    }

    public <T> T getAsObject(String keyName, Class<T> clazz) {
        String s = this.get(keyName);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        return (T)JSON.parseObject((String)s, clazz);
    }

    public JSONObject getAsObject(String keyName) {
        String s = this.get(keyName);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        return JSON.parseObject((String)s);
    }

    public JSONArray getAsArray(String keyName) {
        String s = this.get(keyName);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        return JSON.parseArray((String)s);
    }

    public void remove(String keyName) {
        this.cacheMap.remove(keyName);
        this.changeSet.remove(keyName);
        this.removedKeys.add(keyName);
    }

    public void restore() {
        this.cacheMap = cache.getAll(this.regionKey);
    }

    public void saveChanges() {
        if (!this.changeSet.isEmpty()) {
            HashMap<String, String> changes = new HashMap<String, String>(16);
            for (String key : this.changeSet) {
                changes.put(key, this.cacheMap.get(key));
            }
            cache.put(this.regionKey, changes, CacheKeyUtil.getPageCacheKeyTimeout());
            this.changeSet.clear();
        }
        if (!this.removedKeys.isEmpty()) {
            String[] keys = this.removedKeys.toArray(new String[0]);
            cache.remove(this.regionKey, keys);
            this.removedKeys.clear();
        }
    }

    public void release() {
        cache.remove(this.regionKey);
        this.cacheMap = null;
    }
}

