/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trace.constant;

import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import org.apache.commons.lang3.StringUtils;

public class Constant {
    public static final String GAI_LOG_BILL_FORM_ID = "gai_log";
    public static final String APP_NUMBER = "gai";
    public static final String APP_CLOUD_AI = "ai";
    public static final String GAI_LOG_VIEW_FORM_ID = "gai_log_view";
    public static final String CUSTOM_CONTROL_EVENT_NAME = "eventName";
    public static final String CUSTOM_CONTROL_PAGE_ID = "pageId";
    public static final String ENTITY_NUMBER = "number";
    public static final String ENTITY_NAME = "name";
    public static final String NODE_NAME = "nodeName";
    public static final String PROCESS_FLOW_ID = "flowId";
    public static final String LLM_TASK_ID = "taskId";
    public static final String EVENT_PARAMS = "eventParams";
    public static final String FEED_BACK_COSMIC_APP = "COSMIC_APP";
    public static final String CHAT_SESSION_ASSISTANT_CACHE_KEY = "_chat_session_assistant_cache_";
    public static final String CHAT_SESSION_AGENT_CACHE_KEY = "_chat_session_agent_cache_";

    public static enum LogType {
        SESSION("session"),
        TRACE("trace"),
        STEP("step");

        private final String key;

        private LogType(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static enum CustomControlEventNameEnum {
        CREATE_NEW_DATA("createNewData"),
        CUSTOM_EVENT("customEvent");

        private final String key;

        private CustomControlEventNameEnum(String key) {
            this.key = key;
        }

        public static CustomControlEventNameEnum fromKey(String key) {
            for (CustomControlEventNameEnum e : CustomControlEventNameEnum.values()) {
                if (!e.getKey().equals(key)) continue;
                return e;
            }
            return null;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static class Event {
        public static final String STEP_ID = "event_stepid";
        public static final String EVENT_ID = "event_eventid";
        public static final String EVENT_NAME = "event_eventname";
        public static final String STEP_TYPE = "event_steptype";
        public static final String EVENT_INPUT = "event_eventinput";
        public static final String EVENT_OUTPUT = "event_eventoutput";
        public static final String EVENT_INPUT_TAG = "event_eventinput_tag";
        public static final String EVENT_OUTPUT_TAG = "event_eventoutput_tag";
        public static final String GPT_PROCESS_ID = "event_gptprocessid";
        public static final String GPT_PROCESS_NODE_ID = "event_gptprocessnodeid";
        public static final String MODEL_NAME = "event_modelname";
        public static final String TAGS = "event_tags";
        public static final String METADATA = "event_metadata";
        public static final String METADATA_TAG = "event_metadata_tag";
        public static final String TOTAL_TOKEN = "event_totaltoken";
        public static final String EVENT_TIME = "event_eventtime";
        public static final String CREATE_TIME = "event_createtime";
    }

    public static class Step {
        public static final String ID = "id";
        public static final String TRACE_ID = "step_traceid";
        public static final String STEP_ID = "stepid";
        public static final String PARENT_STEP_ID = "parentstepid";
        public static final String STEP_TYPE = "steptype";
        public static final String STEP_TYPE_NAME = "steptype_name";
        public static final String STEP_INPUT = "stepinput";
        public static final String STEP_OUTPUT = "stepoutput";
        public static final String STEP_INPUT_TAG = "stepinput_tag";
        public static final String STEP_OUTPUT_TAG = "stepoutput_tag";
        public static final String GPT_PROCESS_ID = "gptprocessid";
        public static final String GPT_PROCESS_NAME = "gptprocessname";
        public static final String GPT_PROCESS_NUMBER = "gptprocessnumber";
        public static final String GPT_PROCESS_NODE_ID = "gptprocessnodeid";
        public static final String GPT_PROCESS_NODE_NAME = "gptprocessnodename";
        public static final String MODEL_NAME = "modelname";
        public static final String TAGS = "tags";
        public static final String METADATA = "metadata";
        public static final String METADATA_TAG = "metadata_tag";
        public static final String TOTAL_TOKEN = "totaltoken";
        public static final String STEP_BEGIN_TIME = "stepbegintime";
        public static final String STEP_FINISH_TIME = "stepfinishtime";
        public static final String LATENCY = "latency";
        public static final String CREATE_TIME = "step_createtime";
        public static final String SUBENTRYENTITY = "subentryentity";
        public static final String SUBENTRYENTITY_STEP_ID = String.format("%s.%s.%s", "entryentity", "subentryentity", "stepid");
        public static final String THOUGHT = "thought";
        public static final String CONVERSATION = "conversation";
        public static final String THOUGHT_TAG = "thought_tag";
        public static final String CONVERSATION_TAG = "conversation_tag";
        public static final String ERROR_CODE = "errorcode";
        public static final String FIRST_TOKEN_TIME = "firsttokentime";
        public static final String ENTRY_ID = "entryid";
    }

    public static class Trace {
        public static final String ID = "id";
        public static final String TRACE_ID = "traceid";
        public static final String TRACE_NUM = "tracenum";
        public static final String BASEDATA_NUMBER = "number";
        public static final String BASEDATA_NAME = "name";
        public static final String BASEDATA_STATUS = "status";
        public static final String BASEDATA_ENABLE = "enable";
        public static final String BASEDATA_USEORG = "useorg";
        public static final String BASEDATA_CREATEORG = "createorg";
        public static final String BASEDATA_CREATEORG_NAME = "createorg_name";
        public static final String ORG = "org";
        public static final String USER_ID = "userid";
        public static final String USER_NAME = "username";
        public static final String CLOUD_ID = "cloudid";
        public static final String APP_ID = "appid";
        public static final String CREATE_TIME = "createtime";
        public static final String MODIFY_TIME = "modifytime";
        public static final String AUDIT_DATE = "auditdate";
        public static final String CREATOR = "creator";
        public static final String MODIFIER = "modifier";
        public static final String AUDITOR = "auditor";
        public static final String ENTRYENTITY = "entryentity";
        public static final String ENTRYENTITY_STEP_ID = String.format("%s.%s", "entryentity", "stepid");
        public static final String TRACE_INPUT = "traceinput";
        public static final String TRACE_OUTPUT = "traceoutput";
        public static final String TRACE_THOUGHT_OUTPUT = "tracethoughtoutput";
        public static final String MONITOR_TRACE_ID = "monitortraceid";
        public static final String ASSISTANT_ID = "assistant";
        public static final String AGENT_ID = "agent";
        public static final String PROMPT_ID = "prompt";
        public static final String PROCESS_ID = "process";
        public static final String VECTOR_MODEL = "vectormodel";
        public static final String LLM_MODEL = "generationmodel";
    }

    public static class Session {
        public static final String CHAT_SESSION_ID = "chatsessionid";
        public static final String SESSION_ID = "sessionid";
    }

    public static class UserInfo {
        public static final String USER_PICTURE_FIELD = "picturefield";
        public static final String USER_HEADER_AVATAR = "avatar";
        public static final String USER_HEADER_PICTURE = "picture";
    }

    public static enum NodeType {
        SESSION,
        TRACE,
        STEP,
        EVENT;

    }

    public static enum StepType {
        LLM("llm", new MultiLangEnumBridge("\u63d0\u793a\u8bcd", "Constant_0", "ai-gai-core")),
        PROCESS("process", new MultiLangEnumBridge("\u4efb\u52a1\u6d41", "Constant_1", "ai-gai-core")),
        GPT_PROCESS_START("gpt_process_start", new MultiLangEnumBridge("\u5f00\u59cb", "Constant_2", "ai-gai-core")),
        GPT_PROCESS_END("gpt_process_end", new MultiLangEnumBridge("\u7ed3\u675f", "Constant_3", "ai-gai-core")),
        GPT_PROMPT("prompt", new MultiLangEnumBridge("\u63d0\u793a\u8bcd\u7ec4\u88c5", "Constant_4", "ai-gai-core")),
        GPT_PROCESS_ACTION("action", new MultiLangEnumBridge("\u81ea\u5b9a\u4e49\u64cd\u4f5c", "Constant_5", "ai-gai-core")),
        GPT_PROCESS_MESSAGE("message", new MultiLangEnumBridge("\u6d88\u606f", "Constant_6", "ai-gai-core")),
        GPT_VECTOR_RETRIEVER("vector-retriever", new MultiLangEnumBridge("\u5411\u91cf\u68c0\u7d22", "Constant_7", "ai-gai-core")),
        GPT_GENERATION("generation", new MultiLangEnumBridge("LLM\u751f\u6210", "Constant_8", "ai-gai-core")),
        ASK_USER("ask_user", new MultiLangEnumBridge("\u7528\u6237\u6f84\u6e05", "Constant_9", "ai-gai-core")),
        GPT_TRUST_LAYER("trust-layer", new MultiLangEnumBridge("\u654f\u611f\u8bcd\u5ba1\u67e5", "Constant_10", "ai-gai-core")),
        CODE("code", new MultiLangEnumBridge("\u4ee3\u7801", "Constant_11", "ai-gai-core")),
        REPO("repo", new MultiLangEnumBridge("\u77e5\u8bc6\u5e93", "Constant_12", "ai-gai-core")),
        REPO_REPLY("repo_reply", new MultiLangEnumBridge("\u77e5\u8bc6\u5e93\u56de\u590d", "Constant_13", "ai-gai-core")),
        VIRTUAL("virtual", new MultiLangEnumBridge("\u865a\u62df\u8282\u70b9", "Constant_14", "ai-gai-core")),
        TOOL("tool", new MultiLangEnumBridge("\u5de5\u5177", "Constant_15", "ai-gai-core")),
        RECOMMEND("recommend", new MultiLangEnumBridge("\u95ee\u9898\u63a8\u8350", "Constant_16", "ai-gai-core")),
        OTHER("other", new MultiLangEnumBridge("\u5176\u5b83", "Constant_17", "ai-gai-core")),
        BATCH_PROCESS("batch_process", new MultiLangEnumBridge("\u6279\u5904\u7406", "Constant_18", "ai-gai-core")),
        LOOP("loop", new MultiLangEnumBridge("\u5faa\u73af", "Constant_19", "ai-gai-core"));

        private String type;
        private MultiLangEnumBridge name;

        private StepType(String type, MultiLangEnumBridge name) {
            this.type = type;
            this.name = name;
        }

        public static boolean isLLMStep(String st) {
            StepType stepType = StepType.parseStepType(st);
            return stepType == GPT_VECTOR_RETRIEVER || stepType == GPT_TRUST_LAYER || stepType == GPT_PROMPT || stepType == GPT_GENERATION;
        }

        public static boolean isProcessStep(String st) {
            StepType stepType = StepType.parseStepType(st);
            return stepType == GPT_PROCESS_START || stepType == GPT_PROCESS_END || stepType == GPT_PROCESS_ACTION || stepType == GPT_PROCESS_MESSAGE || stepType == ASK_USER || stepType == CODE || stepType == REPO || stepType == REPO_REPLY || stepType == BATCH_PROCESS || stepType == LOOP || stepType == RECOMMEND || stepType == VIRTUAL;
        }

        public static StepType parseStepType(String type) {
            for (StepType item : StepType.values()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)item.getType(), (CharSequence)type)) continue;
                return item;
            }
            return OTHER;
        }

        public static String getStepTypeName(String stepType) {
            try {
                StepType[] values;
                for (StepType value : values = StepType.values()) {
                    if (!value.getType().equalsIgnoreCase(stepType)) continue;
                    return value.getName();
                }
            }
            catch (Exception e) {
                return stepType;
            }
            return stepType;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name.loadKDString();
        }
    }

    public static enum Enable {
        ENABLE("1", "\u542f\u7528"),
        DISABLED("0", "\u7981\u7528");

        private String enable;
        private String name;

        private Enable(String enable, String name) {
            this.enable = enable;
            this.name = name;
        }

        public String getEnable() {
            return this.enable;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum BillStatus {
        TEMP("A", "\u6682\u5b58"),
        SUBMIT("B", "\u5df2\u63d0\u4ea4"),
        AUDIT("C", "\u5df2\u5ba1\u6838");

        private String status;
        private String name;

        private BillStatus(String status, String name) {
            this.status = status;
            this.name = name;
        }

        public String getStatus() {
            return this.status;
        }

        public String getName() {
            return this.name;
        }
    }
}

