/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trace.entity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Process;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.AskUserAction;
import kd.ai.gai.core.engine.flow.BillNLQueryAction;
import kd.ai.gai.core.engine.flow.CodeAction;
import kd.ai.gai.core.engine.flow.End;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.LoopAction;
import kd.ai.gai.core.engine.flow.MessageAction;
import kd.ai.gai.core.engine.flow.MserviceAction;
import kd.ai.gai.core.engine.flow.ParallelAction;
import kd.ai.gai.core.engine.flow.RepoAction;
import kd.ai.gai.core.engine.flow.RepoReplyAction;
import kd.ai.gai.core.engine.flow.ScriptAction;
import kd.ai.gai.core.engine.flow.Start;
import kd.ai.gai.core.engine.flow.ToolAction;
import kd.ai.gai.core.engine.flow.VirtualAction;
import kd.ai.gai.core.flow.biz.IFlowNodeLog;
import kd.ai.gai.core.service.ProcessService;
import kd.ai.gai.core.trace.constant.Constant;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;

public class FlowNodeLog
implements IFlowNodeLog,
Serializable {
    public static final String KEY_PARAMS = "params";
    public static final String KEY_PARENT_LOG_ID = "parentLogId";
    public static final String KEY_LOG_ID = "logId";
    private String id;
    private String name;
    private String parentId;
    private Constant.StepType stepType;
    private FlowInfo flowInfo;
    private SessionInfo sessionInfo;
    private NodeInfo nodeInfo;
    private Result result;
    private Map<String, Object> input = new HashMap<String, Object>(2);
    private Map<String, Object> output = new HashMap<String, Object>(2);
    private Map<String, Object> metaData = new HashMap<String, Object>(2);
    private Map<String, FlowNodeLog> childLogs;
    private long startTime;
    private long endTime;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public Map<String, Object> getInput() {
        return this.input;
    }

    public void setInput(Map<String, Object> input) {
        this.input = input;
    }

    public Map<String, Object> getOutput() {
        return this.output;
    }

    public void setOutput(Map<String, Object> output) {
        this.output = output;
    }

    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public void setMetaData(Map<String, Object> metaData) {
        this.metaData = metaData;
    }

    public Map<String, FlowNodeLog> getChildLogs() {
        if (this.childLogs == null) {
            this.childLogs = new LinkedHashMap<String, FlowNodeLog>(1);
        }
        return this.childLogs;
    }

    public void setChildLogs(Map<String, FlowNodeLog> childLogs) {
        this.childLogs = childLogs;
    }

    public NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public void setNodeInfo(NodeInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    public FlowInfo getFlowInfo() {
        return this.flowInfo;
    }

    public void setFlowInfo(FlowInfo flowInfo) {
        this.flowInfo = flowInfo;
    }

    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public void setSessionInfo(SessionInfo sessionInfo) {
        this.sessionInfo = sessionInfo;
    }

    public Constant.StepType getStepType() {
        return this.stepType;
    }

    public void setStepType(Constant.StepType stepType) {
        this.stepType = stepType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void logInputParams(Map<String, Object> input) {
        if (this.input.isEmpty()) {
            this.input = input;
        } else {
            this.input.put(KEY_PARAMS, input);
        }
    }

    @Override
    public void logOutputParams(Map<String, Object> output) {
        if (this.output.isEmpty()) {
            this.output = output;
        } else {
            this.output.put(KEY_PARAMS, output);
        }
    }

    @Override
    public void logInput(String key, Object value) {
        this.input.put(key, value);
    }

    @Override
    public void logOutput(String key, Object value) {
        this.output.put(key, value);
    }

    @Override
    public void logMetaData(String key, Object value) {
        this.metaData.put(key, value);
    }

    @Override
    public void logEnd(Result result) {
        this.setEndTime(System.currentTimeMillis());
        this.result = result;
    }

    public String buildInput() {
        return JSON.toJSONString(this.input, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    public String buildOutput() {
        if (this.result != null && !Errors.OK.getCode().equals(this.result.getErrorCode().getCode())) {
            return this.result.getErrorCode().getMessage();
        }
        return JSON.toJSONString(this.output, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    public String buildTags() {
        ErrorCode errorCode;
        HashMap<String, Object> tags = new HashMap<String, Object>(2);
        Result result = this.getResult();
        if (result == null) {
            result = new Result(Errors.OK);
            this.setResult(result);
        }
        if ((errorCode = result.getErrorCode()) != null && !Errors.OK.getCode().equals(errorCode.getCode())) {
            errorCode = Errors.nodeExecuteError(this.getNodeInfo().getNodeName(), ResManager.loadKDString((String)"\u8bf7\u67e5\u770b\u8be6\u7ec6\u5f02\u5e38\u65e5\u5fd7", (String)"FlowNodeLog_15096365", (String)"ai-gai-core", (Object[])new Object[0]));
            tags.put("traceId", RequestContext.get().getTraceId());
        }
        tags.put("result", errorCode);
        Process process = ProcessService.getProcessById(this.flowInfo.getProcessId());
        HashMap<String, Object> mapProcess = new HashMap<String, Object>(2);
        mapProcess.put("id", process.getId());
        mapProcess.put("name", process.getName());
        mapProcess.put("number", process.getNumber());
        tags.put("process", mapProcess);
        return JSON.toJSONString(tags, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    public String buildMetaData() {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("flowId", this.getFlowInfo().getFlowId());
        map.put(KEY_LOG_ID, this.getId());
        map.put(KEY_PARENT_LOG_ID, this.getParentId());
        map.put("node", this.getNodeInfo());
        map.put("nodeName", this.getName());
        map.putAll(this.metaData);
        return JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    public Constant.StepType getStepTypeByAction(Action action) {
        if (action instanceof Start) {
            return Constant.StepType.GPT_PROCESS_START;
        }
        if (action instanceof End) {
            return Constant.StepType.GPT_PROCESS_END;
        }
        if (action instanceof JavaPluginAction) {
            return Constant.StepType.GPT_PROCESS_ACTION;
        }
        if (action instanceof ToolAction) {
            return Constant.StepType.TOOL;
        }
        if (action instanceof LLMAction || action instanceof BillNLQueryAction || action instanceof RepoReplyAction) {
            return Constant.StepType.LLM;
        }
        if (action instanceof MessageAction) {
            return Constant.StepType.GPT_PROCESS_MESSAGE;
        }
        if (action instanceof MserviceAction) {
            return Constant.StepType.GPT_PROCESS_ACTION;
        }
        if (action instanceof ScriptAction) {
            return Constant.StepType.GPT_PROCESS_ACTION;
        }
        if (action instanceof AskUserAction) {
            return Constant.StepType.ASK_USER;
        }
        if (action instanceof CodeAction) {
            return Constant.StepType.CODE;
        }
        if (action instanceof RepoAction) {
            return Constant.StepType.REPO;
        }
        if (action instanceof VirtualAction) {
            return Constant.StepType.VIRTUAL;
        }
        if (action instanceof ParallelAction) {
            return Constant.StepType.BATCH_PROCESS;
        }
        if (action instanceof LoopAction) {
            return Constant.StepType.LOOP;
        }
        return Constant.StepType.OTHER;
    }

    @Override
    public IFlowNodeLog createChildLog(String childLogId, String childLogName) {
        FlowNodeLog childLog = new FlowNodeLog();
        childLog.setId(String.format("%s.%s", this.getId(), childLogId));
        childLog.setName(childLogName);
        childLog.setParentId(this.getId());
        childLog.setStartTime(System.currentTimeMillis());
        childLog.setStepType(this.getStepType());
        childLog.setFlowInfo(this.getFlowInfo());
        childLog.setSessionInfo(this.getSessionInfo());
        childLog.setNodeInfo(this.getNodeInfo());
        this.getChildLogs().put(childLogId, childLog);
        return childLog;
    }

    public static FlowNodeLog create(String parentId, Context context, Flow gaiFlow, Action action) {
        FlowNodeLog flowNodeLog = new FlowNodeLog();
        if (StringUtils.isNotEmpty((CharSequence)parentId)) {
            flowNodeLog.setId(String.format("%s.%s", parentId, action.getId()));
        } else {
            flowNodeLog.setId(String.valueOf(action.getId()));
        }
        flowNodeLog.setName(action.getName());
        flowNodeLog.setParentId(parentId);
        flowNodeLog.setStartTime(System.currentTimeMillis());
        flowNodeLog.setStepType(flowNodeLog.getStepTypeByAction(action));
        FlowInfo flowInfo = new FlowInfo();
        flowInfo.setFlowId(gaiFlow.getId());
        flowNodeLog.setFlowInfo(flowInfo);
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.setChatSessionId(context.getChatSessionId());
        sessionInfo.setUserId(context.getUserId());
        flowNodeLog.setSessionInfo(sessionInfo);
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.setNodeId(action.getId());
        nodeInfo.setNodeName(action.getName());
        nodeInfo.setNodeType(action.getNodeType().getValue());
        nodeInfo.setNodeTypeName(action.getNodeType().getName());
        flowNodeLog.setNodeInfo(nodeInfo);
        return flowNodeLog;
    }

    public static class NodeInfo {
        private int nodeId;
        private String nodeName;
        private short nodeType;
        private String nodeTypeName;

        public int getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(int nodeId) {
            this.nodeId = nodeId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public short getNodeType() {
            return this.nodeType;
        }

        public void setNodeType(short nodeType) {
            this.nodeType = nodeType;
        }

        public String getNodeTypeName() {
            return this.nodeTypeName;
        }

        public void setNodeTypeName(String nodeTypeName) {
            this.nodeTypeName = nodeTypeName;
        }
    }

    public static class SessionInfo {
        private String chatSessionId;
        private String sessionId;
        private long userId;

        public String getChatSessionId() {
            return this.chatSessionId;
        }

        public void setChatSessionId(String chatSessionId) {
            this.chatSessionId = chatSessionId;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public long getUserId() {
            return this.userId;
        }

        public void setUserId(long userId) {
            this.userId = userId;
        }
    }

    public static class FlowInfo {
        private long flowId;
        private long processId;
        private String processName;
        private String processNumber;

        public long getFlowId() {
            return this.flowId;
        }

        public void setFlowId(long flowId) {
            this.flowId = flowId;
        }

        public long getProcessId() {
            return this.processId;
        }

        public void setProcessId(long processId) {
            this.processId = processId;
        }

        public String getProcessName() {
            return this.processName;
        }

        public void setProcessName(String processName) {
            this.processName = processName;
        }

        public String getProcessNumber() {
            return this.processNumber;
        }

        public void setProcessNumber(String processNumber) {
            this.processNumber = processNumber;
        }
    }
}

