/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trace.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class PermUtils {
    public static final String PERM_ITEM_ENTITY = "perm_permitem";
    public static final String APP_NUMBER = "gai";
    public static final String LOG_PERM_QUERY = "QXX0001";
    public static final String LOG_PERM_ADD = "QXX0002";

    private static boolean hasPermission(Object userId, Object appId, Object entityNum, Object permItemNum) {
        QFilter filter = new QFilter("number", "=", permItemNum);
        DynamicObject permItem = BusinessDataServiceHelper.loadSingle((String)PERM_ITEM_ENTITY, (QFilter[])filter.toArray());
        if (permItem != null) {
            String permId = permItem.getString("id");
            Boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)((Long)userId), (String)((String)appId), (String)((String)entityNum), (String)permId);
            if (!hasPerm.booleanValue()) {
                return false;
            }
        }
        return true;
    }

    public static boolean hasPermission(String permKey, String form) {
        Long currentUserId = UserServiceHelper.getCurrentUserId();
        String appId = AppMetadataCache.getAppInfo((String)APP_NUMBER).getAppId();
        return PermUtils.hasPermission(currentUserId, appId, form, permKey);
    }

    public static boolean hasAddLogPermission() {
        return PermUtils.hasPermission(LOG_PERM_ADD, "gai_log");
    }

    public static boolean hasQueryLogPermission() {
        return PermUtils.hasPermission(LOG_PERM_QUERY, "gai_log");
    }
}

