/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trace.util;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kd.ai.gai.core.trace.util.CommonUtil;
import kd.bos.context.RequestContextCreator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public final class ThreadUtils {
    private static final Log log = LogFactory.getLog(ThreadUtils.class);
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"ai-gai-threadPool", (int)10, (String)"gai");
    private static final ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(2, new ThreadFactory(){
        private final AtomicInteger atomicInteger = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "ai.gai.trace-" + this.atomicInteger.incrementAndGet());
        }
    });

    private ThreadUtils() {
    }

    public static void execute(Runnable runnable) {
        threadPool.execute(runnable, RequestContextCreator.createForThreadPool());
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            log.info(CommonUtil.getStackTrace(e));
        }
    }
}

