/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trace.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.Constant;
import kd.ai.gai.core.domain.dto.Process;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.domain.vo.RepoVO;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.Message;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.agent.AgentCallBackMessage;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.AskUserAction;
import kd.ai.gai.core.engine.flow.CodeAction;
import kd.ai.gai.core.engine.flow.End;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.LoopAction;
import kd.ai.gai.core.engine.flow.MessageAction;
import kd.ai.gai.core.engine.flow.MserviceAction;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.ParallelAction;
import kd.ai.gai.core.engine.flow.RecommendAction;
import kd.ai.gai.core.engine.flow.RepoAction;
import kd.ai.gai.core.engine.flow.ScriptAction;
import kd.ai.gai.core.engine.flow.Start;
import kd.ai.gai.core.engine.flow.ToolAction;
import kd.ai.gai.core.engine.flow.VirtualAction;
import kd.ai.gai.core.engine.message.AskUserMessage;
import kd.ai.gai.core.engine.message.CodeMessage;
import kd.ai.gai.core.engine.message.JavaActionMessage;
import kd.ai.gai.core.engine.message.LLMActionMessage;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.engine.message.MsgNodeMessage;
import kd.ai.gai.core.engine.message.RecommendNodeMessage;
import kd.ai.gai.core.engine.message.RepoMessage;
import kd.ai.gai.core.engine.message.ToolMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMParsedMessage;
import kd.ai.gai.core.engine.message.llmcallback.MserviceLLMCallbackMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.service.ProcessService;
import kd.ai.gai.core.service.RepoService;
import kd.ai.gai.core.trace.MonitorServiceHelper;
import kd.ai.gai.core.trace.constant.Constant;
import kd.ai.gai.core.trace.entity.FlowNodeLog;
import kd.ai.gai.core.trace.entity.PromptLog;
import kd.ai.gai.core.trace.entity.StepLog;
import kd.ai.gai.core.trace.entity.StepLogResult;
import kd.ai.gai.core.trace.entity.TrustLayerLog;
import kd.ai.gai.core.trace.entity.VectorRetrieverLog;
import kd.ai.gai.core.trace.util.LogUtil;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.jetbrains.annotations.Nullable;

public class TraceUtil {
    private static final Log logger = LogFactory.getLog(TraceUtil.class);
    public static final String LLM_TASK_START_TIME_PRE = "llmTaskStartTime";
    public static final String LLM_TASK_LLM_INPUT = "llmTaskLLMInput";
    public static final String LLM_TASK_TRACE = "llmTaskTraceId";

    public static long handleAgentLogSessionId(String chatSessionId) {
        long sid = 0L;
        try {
            IAppCache appCache = EngineCache.getAppCache(chatSessionId);
            String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
            if (kd.bos.util.StringUtils.isEmpty((String)sessionId) || "null".equalsIgnoreCase(sessionId)) {
                sid = LogUtil.genSessionId();
                logger.info("\u7f13\u5b58 chatSessionId({}): sessionId({})", (Object)chatSessionId, (Object)sid);
                appCache.put(TraceUtil.chatSessionKey(chatSessionId), (Object)String.valueOf(sid));
            } else {
                sid = Long.parseLong(sessionId);
            }
        }
        catch (KDBizException e) {
            logger.error("\u667a\u80fd\u4f53\u65e5\u5fd7\u8bb0\u5f55\u5904\u7406session\u5931\u8d25:{}", (Object)e.getMessage());
        }
        return sid;
    }

    public static void cacheSessionId(String chatSessionId, long sessionId) {
        try {
            IAppCache appCache = EngineCache.getAppCache(chatSessionId);
            logger.info("\u7f13\u5b58 chatSessionId({}): sessionId({})", (Object)chatSessionId, (Object)sessionId);
            appCache.put(TraceUtil.chatSessionKey(chatSessionId), (Object)String.valueOf(sessionId));
        }
        catch (KDBizException e) {
            logger.error("\u667a\u80fd\u4f53\u65e5\u5fd7\u8bb0\u5f55\u5904\u7406session\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    public static void startFlow(Context context, Flow flow, long processId) {
        try {
            logger.info("\u5f00\u59cbGPT\u6d41\u7a0b\u65e5\u5fd7\u8bb0\u5f55,processId({}),flowId({})", (Object)processId, (Object)flow.getId());
            String chatSessionId = context.getChatSessionId();
            IAppCache appCache = EngineCache.getAppCache(chatSessionId);
            String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
            if (kd.bos.util.StringUtils.isEmpty((String)sessionId) || "null".equalsIgnoreCase(sessionId)) {
                appCache.put(TraceUtil.chatSessionKey(chatSessionId), (Object)String.valueOf(LogUtil.genSessionId()));
            }
            long flowId = flow.getId();
            appCache.put(TraceUtil.flowProcessKey(flowId), (Object)String.valueOf(processId));
            long traceId = context.getTraceId() > 0L ? context.getTraceId() : LogUtil.genTraceId();
            appCache.put(TraceUtil.flowTraceKey(flowId), (Object)String.valueOf(traceId));
            appCache.put(TraceUtil.traceMonitorKey(traceId), (Object)RequestContext.get().getTraceId());
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
        }
    }

    public static void saveFlowNodeLog(Result result, Context context, Flow flow, Node node, Message actionMessage, Action action, long start, long end, Map<String, String> data) {
        try {
            Message message;
            boolean isParallenBlockInnerNode;
            String chatSessionId = context.getChatSessionId();
            long flowId = flow.getId();
            long nodeId = node.getId();
            IAppCache appCache = EngineCache.getAppCache(chatSessionId);
            String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
            String processId = (String)appCache.get(TraceUtil.flowProcessKey(flowId), String.class);
            String traceId = (String)appCache.get(TraceUtil.flowTraceKey(flowId), String.class);
            long pid = kd.bos.util.StringUtils.isEmpty((String)processId) ? 0L : Long.parseLong(processId);
            logger.info("\u4fdd\u5b58GPT\u6d41\u7a0b\u8282\u70b9\u65e5\u5fd7,chatSessionId({}),processId({}),flowId({}),nodeId({})", new Object[]{chatSessionId, processId, flowId, nodeId});
            String stepType = "";
            String stepInput = "";
            String stepOutput = "";
            JSONObject metadataJo = new JSONObject();
            String nodeName = action.getName();
            boolean bl = isParallenBlockInnerNode = action.isBlockInnerNode() && flow.findNodeById(action.getBlockNodeId()).isParallelBlockNode();
            if (isParallenBlockInnerNode || org.apache.commons.lang3.StringUtils.endsWith((CharSequence)nodeName, (CharSequence)Constant.ENGINE.NODE_NAME_PARALLEL_BLOCK_START) || org.apache.commons.lang3.StringUtils.endsWith((CharSequence)nodeName, (CharSequence)Constant.ENGINE.NODE_NAME_PARALLEL_BLOCK_END)) {
                String threadName = Thread.currentThread().getName();
                threadName = threadName.substring(0, threadName.indexOf("/"));
                threadName = org.apache.commons.lang3.StringUtils.replace((String)threadName, (String)"ai-gai-flow-parallel-threadPool", (String)"parallel");
                threadName = org.apache.commons.lang3.StringUtils.replace((String)threadName, (String)"ai-gai-threadPool", (String)"parallel");
                nodeName = String.format("%s(%s)", action.getName(), threadName);
            }
            metadataJo.put("nodeName", (Object)nodeName);
            metadataJo.put("flowId", (Object)flowId);
            ErrorCode errorCode = result.getErrorCode();
            if (!Errors.OK.getCode().equals(errorCode.getCode())) {
                stepOutput = errorCode.getMessage();
            } else {
                String string = stepOutput = data == null ? "" : JSONObject.toJSONString(data);
            }
            if (action instanceof Start) {
                stepInput = JSONObject.toJSONString(data);
                stepOutput = "";
                stepType = Constant.StepType.GPT_PROCESS_START.getType();
            } else if (action instanceof End) {
                stepType = Constant.StepType.GPT_PROCESS_END.getType();
            } else if (action instanceof JavaPluginAction) {
                message = (JavaActionMessage)actionMessage;
                stepInput = JSONObject.toJSONString(((JavaActionMessage)message).getParams());
                stepType = Constant.StepType.GPT_PROCESS_ACTION.getType();
            } else if (action instanceof ToolAction) {
                message = (ToolMessage)actionMessage;
                stepInput = JSONObject.toJSONString(((ToolMessage)message).getInputParams());
                stepType = Constant.StepType.TOOL.getType();
            } else if (action instanceof LLMAction) {
                message = (LLMActionMessage)actionMessage;
                stepInput = ((LLMActionMessage)message).getUserInput();
                stepType = Constant.StepType.GPT_PROMPT.getType();
            } else if (action instanceof MessageAction) {
                stepType = Constant.StepType.GPT_PROCESS_MESSAGE.getType();
                stepInput = "";
                message = (MsgNodeMessage)actionMessage;
                stepOutput = JSONObject.toJSONString(((MsgNodeMessage)message).getElementList());
            } else if (action instanceof MserviceAction) {
                stepType = Constant.StepType.GPT_PROCESS_ACTION.getType();
            } else if (action instanceof ScriptAction) {
                stepType = Constant.StepType.GPT_PROCESS_ACTION.getType();
            } else if (action instanceof AskUserAction) {
                message = (AskUserMessage)actionMessage;
                stepType = Constant.StepType.ASK_USER.getType();
                stepInput = JSONObject.toJSONString(((AskUserMessage)message).getElementList());
            } else if (action instanceof CodeAction) {
                message = (CodeMessage)actionMessage;
                stepType = Constant.StepType.CODE.getType();
                stepInput = JSONObject.toJSONString(((CodeMessage)message).getInParams());
            } else if (action instanceof RepoAction) {
                message = (RepoMessage)actionMessage;
                stepType = Constant.StepType.REPO.getType();
                stepInput = JSONObject.toJSONString((Object)message);
            } else if (action instanceof VirtualAction) {
                stepType = Constant.StepType.VIRTUAL.getType();
            } else if (action instanceof ParallelAction) {
                stepType = Constant.StepType.BATCH_PROCESS.getType();
            } else if (action instanceof LoopAction) {
                stepType = Constant.StepType.LOOP.getType();
            } else if (action instanceof RecommendAction) {
                message = (RecommendNodeMessage)actionMessage;
                stepInput = JSONObject.toJSONString((Object)message);
                stepType = Constant.StepType.RECOMMEND.getType();
            }
            Boolean saveLog = Boolean.FALSE;
            if (!(action instanceof LLMAction)) {
                saveLog = Boolean.TRUE;
            }
            TraceUtil.saveFlowLog(chatSessionId, context.getUserId(), sessionId, traceId, pid, flowId, nodeId, stepType, stepInput, stepOutput, "", start, end, System.currentTimeMillis(), saveLog, result.getErrorCode(), metadataJo);
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
        }
    }

    private static void saveFlowLog(String chatSessionId, long userId, String sessionId, String traceId, long processId, long flowId, long nodeId, String stepType, String stepInput, String stepOutput, String thought, long start, long end, long createTime, Boolean saveLog, ErrorCode errorCode, JSONObject metadataJo) {
        try {
            StepLogResult result;
            logger.info("\u4fdd\u5b58GPT\u6d41\u7a0b\u8282\u70b9\u65e5\u5fd7,chatSessionId({}),sessionId({}),traceId({}),userId({}),processId({}),flowId({}),nodeId({})", new Object[]{chatSessionId, sessionId, traceId, userId, processId, flowId, nodeId});
            IAppCache appCache = EngineCache.getAppCache(chatSessionId);
            Process process = ProcessService.getProcessById(processId);
            JSONObject tagObject = TraceUtil.buildProcessTags(process);
            String tags = JSONObject.toJSONString((Object)TraceUtil.buildResultTags(tagObject, errorCode));
            String appId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceAppKey(traceId), String.class), (String)"");
            String cloudId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceCloudKey(traceId), String.class), (String)"");
            String metadata = metadataJo != null ? metadataJo.toJSONString() : null;
            StepLog stepLog = TraceUtil.buildStepLog(cloudId, appId, chatSessionId, sessionId, traceId, null, userId, processId, tags, metadata, nodeId, stepType, stepInput, stepOutput, thought, start, end, createTime);
            if (saveLog.booleanValue() && (result = MonitorServiceHelper.saveStepLog(stepLog)) != null) {
                appCache.put(TraceUtil.flowTraceKey(flowId), (Object)String.valueOf(result.getTraceId()));
                appCache.put(TraceUtil.chatSessionKey(chatSessionId), (Object)String.valueOf(result.getSessionId()));
            }
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
        }
    }

    public static void saveFlowLog(FlowNodeLog log) {
        try {
            logger.info(String.format("\u8bb0\u5f55\u4efb\u52a1\u6d41\u8282\u70b9\u65e5\u5fd7\u3002\u65e5\u5fd7\u7ed3\u6784\uff1a%s", JSON.toJSONString((Object)log)));
            FlowNodeLog.FlowInfo flowInfo = log.getFlowInfo();
            FlowNodeLog.SessionInfo sessionInfo = log.getSessionInfo();
            IAppCache appCache = EngineCache.getAppCache(sessionInfo.getChatSessionId());
            String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(sessionInfo.getChatSessionId()), String.class);
            sessionInfo.setSessionId(sessionId);
            String strProcessId = (String)appCache.get(TraceUtil.flowProcessKey(flowInfo.getFlowId()), String.class);
            long processId = kd.bos.util.StringUtils.isEmpty((String)strProcessId) ? 0L : Long.parseLong(strProcessId);
            flowInfo.setProcessId(processId);
            String traceId = (String)appCache.get(TraceUtil.flowTraceKey(flowInfo.getFlowId()), String.class);
            String appId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceAppKey(traceId), String.class), (String)"");
            String cloudId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceCloudKey(traceId), String.class), (String)"");
            StepLog stepLog = TraceUtil.buildStepLog(cloudId, appId, sessionInfo.getChatSessionId(), sessionId, traceId, null, sessionInfo.getUserId(), processId, log.buildTags(), log.buildMetaData(), log.getNodeInfo().getNodeId(), log.getStepType().getType(), log.buildInput(), log.buildOutput(), "", log.getStartTime(), log.getEndTime(), System.currentTimeMillis());
            StepLogResult result = MonitorServiceHelper.saveStepLog(stepLog);
            if (result != null) {
                appCache.put(TraceUtil.flowTraceKey(flowInfo.getFlowId()), (Object)String.valueOf(result.getTraceId()));
                appCache.put(TraceUtil.chatSessionKey(sessionInfo.getChatSessionId()), (Object)String.valueOf(result.getSessionId()));
            }
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
        }
    }

    public static void endLLMLog(String taskId, long traceId, long start) {
        EngineCache.getAppCache(taskId).put(LLM_TASK_TRACE + taskId, (Object)String.valueOf(traceId));
        EngineCache.getAppCache(taskId).put(LLM_TASK_START_TIME_PRE + taskId, (Object)start);
    }

    public static long buildTraceId(Context context, LLMMessage message) {
        long traceId = context.getTraceId();
        try {
            LLMParsedMessage llmParsedMessage;
            String chatSessionId = context.getChatSessionId();
            IAppCache appCache = EngineCache.getAppCache(chatSessionId);
            String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
            if (kd.bos.util.StringUtils.isEmpty((String)sessionId) || "null".equalsIgnoreCase(sessionId)) {
                appCache.put(TraceUtil.chatSessionKey(chatSessionId), (Object)String.valueOf(LogUtil.genSessionId()));
            }
            if ((llmParsedMessage = message.getCallbackMessage()) != null) {
                long flowId = llmParsedMessage.getFlowId();
                if (flowId != 0L) {
                    String trace = (String)appCache.get(TraceUtil.flowTraceKey(flowId), String.class);
                    traceId = !kd.bos.util.StringUtils.isEmpty((String)trace) ? Long.parseLong(trace) : (traceId > 0L ? traceId : LogUtil.genTraceId());
                } else if (llmParsedMessage instanceof AgentCallBackMessage) {
                    AgentCallBackMessage agentCallBackMessage = (AgentCallBackMessage)llmParsedMessage;
                    String agentRunId = agentCallBackMessage.getAgentMessage().getRunId();
                    String cacheTraceId = (String)appCache.get(TraceUtil.traceAgentRunKey(agentRunId), String.class);
                    if (kd.bos.util.StringUtils.isEmpty((String)cacheTraceId)) {
                        traceId = traceId > 0L ? traceId : LogUtil.genTraceId();
                        appCache.put(TraceUtil.traceAgentRunKey(agentRunId), (Object)String.valueOf(traceId));
                    } else {
                        traceId = traceId > 0L ? traceId : Long.parseLong(cacheTraceId);
                    }
                } else {
                    long l = traceId = traceId > 0L ? traceId : LogUtil.genTraceId();
                }
                if (llmParsedMessage instanceof MserviceLLMCallbackMessage) {
                    MserviceLLMCallbackMessage callbackMessage = (MserviceLLMCallbackMessage)llmParsedMessage;
                    String cloudId = callbackMessage.getCloudId();
                    String appId = callbackMessage.getAppId();
                    appCache.put(TraceUtil.traceCloudKey(traceId), (Object)cloudId);
                    appCache.put(TraceUtil.traceAppKey(traceId), (Object)appId);
                }
            } else {
                traceId = traceId > 0L ? traceId : LogUtil.genTraceId();
                String cloudId = "ai";
                String appId = "gai";
                appCache.put(TraceUtil.traceCloudKey(traceId), (Object)cloudId);
                appCache.put(TraceUtil.traceAppKey(traceId), (Object)appId);
            }
            String monitorTraceId = RequestContext.get().getTraceId();
            appCache.put(TraceUtil.traceMonitorKey(traceId), (Object)monitorTraceId);
            return traceId;
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
            return traceId;
        }
    }

    public static long getAgentTraceIdByRunId(String chatSessionId, long runId) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        String cacheTraceId = (String)appCache.get(TraceUtil.traceAgentRunKey(String.valueOf(runId)), String.class);
        if (!kd.bos.util.StringUtils.isEmpty((String)cacheTraceId)) {
            return Long.parseLong(cacheTraceId);
        }
        return runId;
    }

    public static void saveAsyncLLMLog(Context context, LLMParsedMessage message) {
        try {
            String chatSessionId = context.getChatSessionId();
            LocalMemoryCache appCache = EngineCache.getLocalCache(chatSessionId);
            long flowId = message.getFlowId();
            int nodeId = message.getNodeId();
            String nodeName = null;
            nodeName = TraceUtil.getNodeName(context.getChatSessionId(), flowId, nodeId, nodeName);
            String taskId = message.getTaskId();
            Prompt prompt = (Prompt)appCache.get("prompt" + taskId);
            String llmInput = (String)EngineCache.getAppCache(taskId).get(LLM_TASK_LLM_INPUT + taskId, String.class);
            String start = (String)EngineCache.getAppCache(taskId).get(LLM_TASK_START_TIME_PRE + taskId, String.class);
            String trace = (String)EngineCache.getAppCache(taskId).get(LLM_TASK_TRACE + taskId, String.class);
            logger.info("LLMToken llmStartTime:{}", (Object)start);
            long startTime = kd.bos.util.StringUtils.isEmpty((String)start) ? 0L : Long.parseLong(start);
            long end = System.currentTimeMillis();
            long traceId = kd.bos.util.StringUtils.isEmpty((String)trace) ? LogUtil.genTraceId() : Long.parseLong(trace);
            String firstTokenTime = (String)EngineCache.getLocalCache(taskId).get("task_first_token_time");
            logger.info("LLMToken firstTokenTime:{},taskId:{},traceId:{}", new Object[]{firstTokenTime, taskId, traceId});
            logger.info("LLMToken llmStartTime:{},llmEndTime:{}", (Object)start, (Object)end);
            long firstTime = kd.bos.util.StringUtils.isEmpty((String)firstTokenTime) ? end : Long.parseLong(firstTokenTime);
            String stepOutput = "";
            String stepThought = "";
            String errCode = message.getErrCode();
            if (!Errors.OK.getCode().equals(errCode)) {
                stepOutput = message.getErrMsg();
            } else {
                stepOutput = message.getLlmValue();
                stepThought = message.getLlmThink();
            }
            logger.info("LLMToken errCode:{},stepOutput:{}", (Object)errCode, (Object)stepOutput);
            TraceUtil.saveLLMLog(taskId, context, traceId, flowId, nodeId, prompt, llmInput, stepOutput, stepThought, startTime, end, errCode, 0, firstTime, nodeName);
            EngineCache.getAppCache(taskId).remove(LLM_TASK_LLM_INPUT + taskId);
            EngineCache.getAppCache(taskId).remove(LLM_TASK_START_TIME_PRE + taskId);
            EngineCache.getAppCache(taskId).remove(LLM_TASK_TRACE + taskId);
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void saveAsyncStreamLLMLog(Context context, LLMParsedMessage message, String llmValue, String llmThink) {
        try {
            String chatSessionId = context.getChatSessionId();
            LocalMemoryCache appCache = EngineCache.getLocalCache(chatSessionId);
            long flowId = message.getFlowId();
            int nodeId = message.getNodeId();
            String nodeName = null;
            nodeName = TraceUtil.getNodeName(context.getChatSessionId(), flowId, nodeId, nodeName);
            String taskId = message.getTaskId();
            Prompt prompt = (Prompt)appCache.get("prompt" + taskId);
            String llmInput = (String)EngineCache.getAppCache(taskId).get(LLM_TASK_LLM_INPUT + taskId, String.class);
            String start = (String)EngineCache.getAppCache(taskId).get(LLM_TASK_START_TIME_PRE + taskId, String.class);
            String trace = (String)EngineCache.getAppCache(taskId).get(LLM_TASK_TRACE + taskId, String.class);
            logger.info("LLMToken llmStartTime:{}", (Object)start);
            long startTime = kd.bos.util.StringUtils.isEmpty((String)start) ? 0L : Long.parseLong(start);
            long end = System.currentTimeMillis();
            long traceId = kd.bos.util.StringUtils.isEmpty((String)trace) ? LogUtil.genTraceId() : Long.parseLong(trace);
            String firstTokenTime = (String)EngineCache.getLocalCache(taskId).get("task_first_token_time");
            logger.info("LLMToken firstTokenTime:{},taskId:{},traceId:{}", new Object[]{firstTokenTime, taskId, traceId});
            logger.info("LLMToken llmStartTime:{},llmEndTime:{}", (Object)start, (Object)end);
            long firstTime = kd.bos.util.StringUtils.isEmpty((String)firstTokenTime) ? end : Long.parseLong(firstTokenTime);
            String stepOutput = "";
            String stepThought = "";
            String errCode = message.getErrCode();
            if (!Errors.OK.getCode().equals(errCode)) {
                stepOutput = message.getErrMsg();
            } else {
                stepOutput = llmValue;
                stepThought = llmThink;
            }
            logger.info("LLMToken errCode:{},stepOutput:{}", (Object)errCode, (Object)stepOutput);
            TraceUtil.saveLLMLog(taskId, context, traceId, flowId, nodeId, prompt, llmInput, stepOutput, stepThought, startTime, end, errCode, 0, firstTime, nodeName);
            EngineCache.getAppCache(taskId).remove(LLM_TASK_LLM_INPUT + taskId);
            EngineCache.getAppCache(taskId).remove(LLM_TASK_START_TIME_PRE + taskId);
            EngineCache.getAppCache(taskId).remove(LLM_TASK_TRACE + taskId);
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void saveTaskFormatContent(String taskId, String content) {
        DynamicObject taskObject = BusinessDataServiceHelper.newDynamicObject((String)"aicc_task");
        taskObject.set("id", (Object)taskId);
        taskObject.set("formatcontent_tag", (Object)content);
        SaveServiceHelper.update((DynamicObject)taskObject);
    }

    public static void saveIfStreamAsyncLLMLog(Context context, LLMParsedMessage message) {
        if (message.isStream()) {
            String cacheKey = "llmTaskLLMOutputCache_";
            String thoughtCacheKey = "llmTaskLLMThoughtCache_";
            String taskId = message.getTaskId();
            if (kd.bos.util.StringUtils.isNotEmpty((String)taskId)) {
                if (message.isEnd()) {
                    String hisMsg = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskLLMOutputCache_", taskId), String.class);
                    String cacheMessages = String.format("%s%s", kd.bos.util.StringUtils.getStringValue((Object)hisMsg, (String)""), kd.bos.util.StringUtils.getStringValue((Object)message.getLlmValue(), (String)""));
                    String thoughtHisMsg = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskLLMThoughtCache_", taskId), String.class);
                    TraceUtil.saveAsyncStreamLLMLog(context, message, cacheMessages, thoughtHisMsg);
                    EngineCache.getAppCache(taskId).remove(String.format("%s%s", "llmTaskLLMOutputCache_", taskId));
                    EngineCache.getAppCache(taskId).remove(String.format("%s%s", "llmTaskLLMThoughtCache_", taskId));
                } else {
                    String llmValue = message.getLlmValue();
                    String llmThink = message.getLlmThink();
                    if (kd.bos.util.StringUtils.isNotNull((String)llmValue) && llmValue.length() > 0) {
                        String hisMsg = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskLLMOutputCache_", taskId), String.class);
                        String cacheMessages = String.format("%s%s", kd.bos.util.StringUtils.getStringValue((Object)hisMsg, (String)""), kd.bos.util.StringUtils.getStringValue((Object)llmValue, (String)""));
                        EngineCache.getAppCache(taskId).put(String.format("%s%s", "llmTaskLLMOutputCache_", taskId), (Object)cacheMessages);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)llmThink)) {
                        String hisThoughtMsg = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskLLMThoughtCache_", taskId), String.class);
                        String thoughtCacheMessages = String.format("%s%s", kd.bos.util.StringUtils.getStringValue((Object)hisThoughtMsg, (String)""), kd.bos.util.StringUtils.getStringValue((Object)llmThink, (String)""));
                        EngineCache.getAppCache(taskId).put(String.format("%s%s", "llmTaskLLMThoughtCache_", taskId), (Object)thoughtCacheMessages);
                    }
                }
            }
        } else {
            TraceUtil.saveAsyncLLMLog(context, message);
        }
    }

    public static void saveMserviceStreamAsyncLLMLog(Context context, LLMParsedMessage message) {
        if (message.isStream()) {
            String cacheKey = "llmTaskMserviceLLMOutputCache";
            String thoughtCacheKey = "llmTaskLLMThoughtCache_";
            String taskId = message.getTaskId();
            if (kd.bos.util.StringUtils.isNotEmpty((String)taskId)) {
                if (message.isEnd()) {
                    String hisMsg = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskMserviceLLMOutputCache", taskId), String.class);
                    String cacheMessages = String.format("%s%s", kd.bos.util.StringUtils.getStringValue((Object)hisMsg, (String)""), kd.bos.util.StringUtils.getStringValue((Object)message.getLlmValue(), (String)""));
                    String thoughtHisMsg = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskLLMThoughtCache_", taskId), String.class);
                    TraceUtil.saveAsyncStreamLLMLog(context, message, cacheMessages, thoughtHisMsg);
                    EngineCache.getAppCache(taskId).remove(String.format("%s%s", "llmTaskMserviceLLMOutputCache", taskId));
                    EngineCache.getAppCache(taskId).remove(String.format("%s%s", "llmTaskLLMThoughtCache_", taskId));
                } else {
                    String llmValue = message.getLlmValue();
                    String llmThink = message.getLlmThink();
                    if (StringUtils.isNotEmpty((CharSequence)llmValue)) {
                        String hisMsg = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskMserviceLLMOutputCache", taskId), String.class);
                        String cacheMessages = String.format("%s%s", kd.bos.util.StringUtils.getStringValue((Object)hisMsg, (String)""), kd.bos.util.StringUtils.getStringValue((Object)llmValue, (String)""));
                        EngineCache.getAppCache(taskId).put(String.format("%s%s", "llmTaskMserviceLLMOutputCache", taskId), (Object)cacheMessages);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)llmThink)) {
                        String hisThoughtMsg = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskLLMThoughtCache_", taskId), String.class);
                        String thoughtCacheMessages = String.format("%s%s", kd.bos.util.StringUtils.getStringValue((Object)hisThoughtMsg, (String)""), kd.bos.util.StringUtils.getStringValue((Object)llmThink, (String)""));
                        EngineCache.getAppCache(taskId).put(String.format("%s%s", "llmTaskLLMThoughtCache_", taskId), (Object)thoughtCacheMessages);
                    }
                }
            }
        } else {
            TraceUtil.saveAsyncLLMLog(context, message);
        }
    }

    public static void savePromptTestStreamAsyncLLMLog(Context context, LLMParsedMessage message) {
        if (message.isStream()) {
            String cacheKey = "llmTaskPromptTestLLMOutputCache";
            String thoughtCacheKey = "llmTaskPromptTestLLMThoughtCache";
            String taskId = message.getTaskId();
            if (kd.bos.util.StringUtils.isNotEmpty((String)taskId)) {
                if (message.isEnd()) {
                    String hisMsg = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskPromptTestLLMOutputCache", taskId), String.class);
                    String cacheMessages = String.format("%s%s", kd.bos.util.StringUtils.getStringValue((Object)hisMsg, (String)""), kd.bos.util.StringUtils.getStringValue((Object)message.getLlmValue(), (String)""));
                    String hisThoughtMsg = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskPromptTestLLMThoughtCache", taskId), String.class);
                    TraceUtil.saveAsyncStreamLLMLog(context, message, cacheMessages, hisThoughtMsg);
                    EngineCache.getAppCache(taskId).remove(String.format("%s%s", "llmTaskPromptTestLLMOutputCache", taskId));
                    EngineCache.getAppCache(taskId).remove(String.format("%s%s", "llmTaskPromptTestLLMThoughtCache", taskId));
                } else {
                    String llmValue = message.getLlmValue();
                    String llmThink = message.getLlmThink();
                    if (StringUtils.isNotEmpty((CharSequence)llmValue)) {
                        String hisMsg = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskPromptTestLLMOutputCache", taskId), String.class);
                        String cacheMessages = String.format("%s%s", kd.bos.util.StringUtils.getStringValue((Object)hisMsg, (String)""), kd.bos.util.StringUtils.getStringValue((Object)llmValue, (String)""));
                        EngineCache.getAppCache(taskId).put(String.format("%s%s", "llmTaskPromptTestLLMOutputCache", taskId), (Object)cacheMessages);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)llmThink)) {
                        String hisThoughtMsg = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskPromptTestLLMThoughtCache", taskId), String.class);
                        String cacheThoughtMessages = String.format("%s%s", kd.bos.util.StringUtils.getStringValue((Object)hisThoughtMsg, (String)""), kd.bos.util.StringUtils.getStringValue((Object)llmThink, (String)""));
                        EngineCache.getAppCache(taskId).put(String.format("%s%s", "llmTaskPromptTestLLMThoughtCache", taskId), (Object)cacheThoughtMessages);
                    }
                }
            }
        } else {
            TraceUtil.saveAsyncLLMLog(context, message);
        }
    }

    public static void saveSyncLLMLog(String taskId, Context context, LLMMessage message, String llmValue, String llmThink, Prompt prompt, long traceId, long start, long end, String errCode) {
        try {
            LLMParsedMessage llmParsedMessage = message.getCallbackMessage();
            long flowId = 0L;
            long nodeId = 0L;
            String nodeName = null;
            if (llmParsedMessage != null) {
                flowId = llmParsedMessage.getFlowId();
                nodeId = llmParsedMessage.getNodeId();
                nodeName = TraceUtil.getNodeName(context.getChatSessionId(), flowId, (int)nodeId, nodeName);
            }
            String llmInput = (String)EngineCache.getAppCache(taskId).get(LLM_TASK_LLM_INPUT + taskId, String.class);
            TraceUtil.saveLLMLog(taskId, context, traceId, flowId, nodeId, prompt, llmInput, llmValue, llmThink, start, end, errCode, 0, end, nodeName);
            EngineCache.getAppCache(taskId).remove(LLM_TASK_LLM_INPUT + taskId);
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
        }
    }

    private static void saveLLMLog(String taskId, Context context, long traceId, long flowId, long nodeId, Prompt prompt, String stepInput, String stepOutput, String stepThought, long start, long end, String errCode, int token, long firstTokenTime, String nodeName) {
        try {
            String chatSessionId = context.getChatSessionId();
            IAppCache appCache = EngineCache.getAppCache(chatSessionId);
            LLM llm = prompt.getLlm();
            String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
            long processId = 0L;
            Process process = null;
            if (flowId != 0L) {
                String pid = (String)appCache.get(TraceUtil.flowProcessKey(flowId), String.class);
                processId = kd.bos.util.StringUtils.isEmpty((String)pid) ? 0L : Long.parseLong(pid);
                process = ProcessService.getProcessById(processId);
            }
            logger.info("\u4fdd\u5b58GPT LLM\u65e5\u5fd7,chatSessionId({}),processId({}),flowId({}),nodeId({})", new Object[]{chatSessionId, processId, flowId, nodeId});
            String trace = String.valueOf(traceId);
            String appId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceAppKey(traceId), String.class), (String)"");
            String cloudId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceCloudKey(traceId), String.class), (String)"");
            JSONObject tagObj = TraceUtil.buildLLMPromptTags(chatSessionId, process, prompt);
            String tags = JSONObject.toJSONString((Object)TraceUtil.buildResultTags(chatSessionId, tagObj, errCode));
            JSONObject metadataJo = TraceUtil.buildLLMPromptMetadata(prompt, nodeName, taskId);
            if (flowId != 0L) {
                metadataJo.put("flowId", (Object)flowId);
            }
            String metadata = JSONObject.toJSONString((Object)metadataJo);
            StepLog stepLog = TraceUtil.buildStepLog(cloudId, appId, chatSessionId, sessionId, trace, prompt.getServiceNumber(), context.getUserId(), processId, tags, metadata, nodeId, Constant.StepType.GPT_GENERATION.getType(), stepInput, stepOutput, stepThought, start, end, System.currentTimeMillis(), token);
            stepLog.setPromptId(prompt.getId());
            stepLog.setErrorCode(errCode);
            stepLog.setFirstTokenTime(firstTokenTime == 0L ? new Date(end) : new Date(firstTokenTime));
            StepLogResult result = MonitorServiceHelper.saveStepLog(stepLog);
            if (result != null) {
                appCache.put(TraceUtil.chatSessionKey(chatSessionId), (Object)String.valueOf(result.getSessionId()));
            }
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
        }
    }

    public static void savePromptLog(String taskId, String chatSessionId, long traceId, String modelName, String userInput, String llmParamString, String thought, long flowId, long nodeId, Prompt prompt, long start, long end) {
        try {
            long userId = RequestContext.get().getCurrUserId();
            if (!kd.bos.util.StringUtils.isEmpty((String)taskId)) {
                EngineCache.getAppCache(taskId).put(LLM_TASK_LLM_INPUT + taskId, (Object)llmParamString);
            }
            IAppCache appCache = EngineCache.getAppCache(chatSessionId);
            String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
            long processId = 0L;
            Process process = null;
            String nodeName = null;
            if (flowId != 0L) {
                String pid = (String)appCache.get(TraceUtil.flowProcessKey(flowId), String.class);
                processId = kd.bos.util.StringUtils.isEmpty((String)pid) ? 0L : Long.parseLong(pid);
                process = ProcessService.getProcessById(processId);
                nodeName = TraceUtil.getNodeName(chatSessionId, flowId, (int)nodeId, nodeName);
            }
            String trace = String.valueOf(traceId);
            String appId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceAppKey(traceId), String.class), (String)"");
            String cloudId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceCloudKey(traceId), String.class), (String)"");
            String tags = JSONObject.toJSONString((Object)TraceUtil.buildLLMPromptTags(chatSessionId, process, prompt));
            String metadata = JSONObject.toJSONString((Object)TraceUtil.buildLLMPromptMetadata(prompt, nodeName));
            StepLog stepLog = TraceUtil.buildStepLog(cloudId, appId, chatSessionId, sessionId, trace, modelName, userId, processId, tags, metadata, nodeId, Constant.StepType.GPT_PROMPT.getType(), userInput, llmParamString, thought, start, end, System.currentTimeMillis());
            stepLog.setPromptId(prompt.getId());
            StepLogResult result = MonitorServiceHelper.saveStepLog(stepLog);
            if (result != null) {
                appCache.put(TraceUtil.chatSessionKey(chatSessionId), (Object)String.valueOf(result.getSessionId()));
            }
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
        }
    }

    @Nullable
    private static String getNodeName(String chatSessionId, long flowId, int nodeId, String nodeName) {
        Flow flow = FlowCacheData.getFlowById(chatSessionId, flowId);
        if (flow != null) {
            Action llmAction = flow.findActionById(nodeId);
            String string = nodeName = llmAction != null ? llmAction.getName() : null;
            if (nodeName != null && ProcessNodeType.RecommendQuestion.getName().equals(nodeName)) {
                String llmName = ResManager.loadKDString((String)ProcessNodeType.Llm.getName(), (String)"TraceUtil_0", (String)"ai-gai-core", (Object[])new Object[0]);
                nodeName = nodeName + "-" + llmName;
            }
        }
        return nodeName;
    }

    public static void saveVectorRetrieverLog(String chatSessionId, long traceId, String userInput, String vectorOutput, String thought, long flowId, long nodeId, Prompt prompt, long start, long end) {
        try {
            long userId = RequestContext.get().getCurrUserId();
            IAppCache appCache = EngineCache.getAppCache(chatSessionId);
            String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
            long processId = 0L;
            Process process = null;
            String nodeName = null;
            if (flowId != 0L) {
                String pid = (String)appCache.get(TraceUtil.flowProcessKey(flowId), String.class);
                processId = kd.bos.util.StringUtils.isEmpty((String)pid) ? 0L : Long.parseLong(pid);
                process = ProcessService.getProcessById(processId);
                nodeName = TraceUtil.getNodeName(chatSessionId, flowId, (int)nodeId, nodeName);
            }
            String modelName = TraceUtil.parseModelName(prompt, userInput);
            String tags = JSONObject.toJSONString((Object)TraceUtil.buildLLMPromptTags(chatSessionId, process, prompt));
            String trace = String.valueOf(traceId);
            String appId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceAppKey(traceId), String.class), (String)"");
            String cloudId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceCloudKey(traceId), String.class), (String)"");
            String metadata = JSONObject.toJSONString((Object)TraceUtil.buildLLMPromptMetadata(prompt, nodeName));
            StepLog stepLog = TraceUtil.buildStepLog(cloudId, appId, chatSessionId, sessionId, trace, modelName, userId, processId, tags, metadata, nodeId, Constant.StepType.GPT_VECTOR_RETRIEVER.getType(), userInput, vectorOutput, thought, start, end, System.currentTimeMillis());
            stepLog.setPromptId(prompt.getId());
            StepLogResult result = MonitorServiceHelper.saveStepLog(stepLog);
            if (result != null) {
                appCache.put(TraceUtil.chatSessionKey(chatSessionId), (Object)String.valueOf(result.getSessionId()));
            }
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
        }
    }

    public static void saveTraceVectorAndPromptLog(String chatSessionId, long traceId, VectorRetrieverLog vectorRetrieverLog, PromptLog promptLog) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
        ArrayList<StepLog> logs = new ArrayList<StepLog>();
        logs.add(TraceUtil.transformVectorRetrieverLog(traceId, vectorRetrieverLog));
        logs.add(TraceUtil.transformPromptLog(traceId, promptLog));
        MonitorServiceHelper.saveTraceSteps(kd.bos.util.StringUtils.isEmpty((String)sessionId) ? 0L : Long.parseLong(sessionId), traceId, logs);
    }

    public static void saveTraceStepsLog(String chatSessionId, long traceId, VectorRetrieverLog vectorRetrieverLog, PromptLog promptLog, TrustLayerLog trustLayerLog) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
        ArrayList<StepLog> logs = new ArrayList<StepLog>();
        logs.add(TraceUtil.transformVectorRetrieverLog(traceId, vectorRetrieverLog));
        logs.add(TraceUtil.transformTrustLayerLog(traceId, trustLayerLog));
        logs.add(TraceUtil.transformPromptLog(traceId, promptLog));
        MonitorServiceHelper.saveTraceSteps(kd.bos.util.StringUtils.isEmpty((String)sessionId) ? 0L : Long.parseLong(sessionId), traceId, logs);
    }

    public static void saveTraceTrustLog(String chatSessionId, long traceId, TrustLayerLog trustLayerLog) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
        ArrayList<StepLog> logs = new ArrayList<StepLog>();
        logs.add(TraceUtil.transformTrustLayerLog(traceId, trustLayerLog));
        MonitorServiceHelper.saveTraceSteps(kd.bos.util.StringUtils.isEmpty((String)sessionId) ? 0L : Long.parseLong(sessionId), traceId, logs);
    }

    private static StepLog transformTrustLayerLog(long traceId, TrustLayerLog trustLayerLog) {
        String chatSessionId = trustLayerLog.getChatSessionId();
        Prompt prompt = trustLayerLog.getPrompt();
        String userInput = trustLayerLog.getUserInput();
        String output = trustLayerLog.getErrorMsg();
        String errorCode = trustLayerLog.getErrorCode();
        long start = trustLayerLog.getStart();
        long end = trustLayerLog.getEnd();
        long userId = RequestContext.get().getCurrUserId();
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
        String tags = JSONObject.toJSONString((Object)TraceUtil.buildLLMPromptTags(chatSessionId, null, prompt));
        String trace = String.valueOf(traceId);
        String appId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceAppKey(traceId), String.class), (String)"");
        String cloudId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceCloudKey(traceId), String.class), (String)"");
        String taskId = trustLayerLog.getTaskId();
        JSONObject metadataJo = TraceUtil.buildLLMPromptMetadata(prompt, null, taskId);
        if (trustLayerLog.getFlowId() != 0L) {
            metadataJo.put("flowId", (Object)trustLayerLog.getFlowId());
        }
        String metadata = JSONObject.toJSONString((Object)metadataJo);
        StepLog stepLog = TraceUtil.buildStepLog(cloudId, appId, chatSessionId, sessionId, trace, null, userId, 0L, tags, metadata, 0L, Constant.StepType.GPT_TRUST_LAYER.getType(), userInput, output, "", start, end, System.currentTimeMillis());
        stepLog.setPromptId(prompt.getId());
        stepLog.setErrorCode(errorCode);
        return stepLog;
    }

    private static StepLog transformVectorRetrieverLog(long traceId, VectorRetrieverLog vectorRetrieverLog) {
        long flowId = vectorRetrieverLog.getFlowId();
        long nodeId = vectorRetrieverLog.getNodeId();
        String chatSessionId = vectorRetrieverLog.getChatSessionId();
        Prompt prompt = vectorRetrieverLog.getPrompt();
        String userInput = vectorRetrieverLog.getUserInput();
        String vectorOutput = vectorRetrieverLog.getVectorOutput();
        String think = vectorRetrieverLog.getThink();
        long start = vectorRetrieverLog.getStart();
        long end = vectorRetrieverLog.getEnd();
        long userId = RequestContext.get().getCurrUserId();
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
        long processId = 0L;
        Process process = null;
        String nodeName = null;
        if (flowId != 0L) {
            String pid = (String)appCache.get(TraceUtil.flowProcessKey(flowId), String.class);
            processId = kd.bos.util.StringUtils.isEmpty((String)pid) ? 0L : Long.parseLong(pid);
            process = ProcessService.getProcessById(processId);
            nodeName = TraceUtil.getNodeName(chatSessionId, flowId, (int)nodeId, nodeName);
        }
        String modelName = TraceUtil.parseModelName(prompt, userInput);
        String tags = JSONObject.toJSONString((Object)TraceUtil.buildLLMPromptTags(chatSessionId, process, prompt));
        String trace = String.valueOf(traceId);
        String appId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceAppKey(traceId), String.class), (String)"");
        String cloudId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceCloudKey(traceId), String.class), (String)"");
        String taskId = vectorRetrieverLog.getTaskId();
        JSONObject metadataJo = TraceUtil.buildLLMPromptMetadata(prompt, nodeName, taskId);
        if (flowId != 0L) {
            metadataJo.put("flowId", (Object)flowId);
        }
        String metadata = JSONObject.toJSONString((Object)metadataJo);
        StepLog stepLog = TraceUtil.buildStepLog(cloudId, appId, chatSessionId, sessionId, trace, modelName, userId, processId, tags, metadata, nodeId, Constant.StepType.GPT_VECTOR_RETRIEVER.getType(), userInput, vectorOutput, think, start, end, System.currentTimeMillis());
        stepLog.setPromptId(prompt.getId());
        return stepLog;
    }

    private static StepLog transformPromptLog(long traceId, PromptLog promptLog) {
        long flowId = promptLog.getFlowId();
        long nodeId = promptLog.getNodeId();
        String taskId = promptLog.getTaskId();
        String llmParamString = promptLog.getLlmParamString();
        String chatSessionId = promptLog.getChatSessionId();
        Prompt prompt = promptLog.getPrompt();
        String modelName = promptLog.getModelName();
        String userInput = promptLog.getUserInput();
        long start = promptLog.getStart();
        long end = promptLog.getEnd();
        long userId = RequestContext.get().getCurrUserId();
        if (!kd.bos.util.StringUtils.isEmpty((String)taskId)) {
            EngineCache.getAppCache(taskId).put(LLM_TASK_LLM_INPUT + taskId, (Object)llmParamString);
        }
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
        long processId = 0L;
        Process process = null;
        String nodeName = null;
        if (flowId != 0L) {
            String pid = (String)appCache.get(TraceUtil.flowProcessKey(flowId), String.class);
            processId = kd.bos.util.StringUtils.isEmpty((String)pid) ? 0L : Long.parseLong(pid);
            process = ProcessService.getProcessById(processId);
            nodeName = TraceUtil.getNodeName(chatSessionId, flowId, (int)nodeId, nodeName);
        }
        String trace = String.valueOf(traceId);
        String appId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceAppKey(traceId), String.class), (String)"");
        String cloudId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceCloudKey(traceId), String.class), (String)"");
        String tags = JSONObject.toJSONString((Object)TraceUtil.buildLLMPromptTags(chatSessionId, process, prompt));
        JSONObject metadataJo = TraceUtil.buildLLMPromptMetadata(prompt, nodeName, taskId);
        if (promptLog.getFlowId() != 0L) {
            metadataJo.put("flowId", (Object)promptLog.getFlowId());
        }
        String metadata = JSONObject.toJSONString((Object)metadataJo);
        StepLog stepLog = TraceUtil.buildStepLog(cloudId, appId, chatSessionId, sessionId, trace, modelName, userId, processId, tags, metadata, nodeId, Constant.StepType.GPT_PROMPT.getType(), userInput, llmParamString, "", start, end, System.currentTimeMillis());
        stepLog.setPromptId(prompt.getId());
        return stepLog;
    }

    private static String parseModelName(Prompt prompt, String userInput) {
        List<Long> repoIdList = prompt.getRepoIds();
        logger.info("\u4e0a\u4e0b\u6587repoIdList:{}", JSON.toJSON(repoIdList));
        if (repoIdList != null && !repoIdList.isEmpty() && !StringUtils.isEmpty((CharSequence)userInput)) {
            RepoVO repoInfo = RepoService.getRepoInfo(repoIdList.get(0));
            LLM embeddingModel = repoInfo.getLlm();
            return embeddingModel.getNumber();
        }
        return "";
    }

    private static StepLog buildStepLog(String cloudId, String appId, String chatSessionId, String sessionId, String traceId, String modelName, long userId, long processId, String tags, String metadata, long nodeId, String stepType, String stepInput, String stepOutput, String stepThought, long start, long end, long createTime) {
        return TraceUtil.buildStepLog(cloudId, appId, chatSessionId, sessionId, traceId, modelName, userId, processId, tags, metadata, nodeId, stepType, stepInput, stepOutput, stepThought, start, end, createTime, 0);
    }

    private static StepLog buildStepLog(String cloudId, String appId, String chatSessionId, String sessionId, String traceId, String modelName, long userId, long processId, String tags, String metadata, long nodeId, String stepType, String stepInput, String stepOutput, String stepThought, long start, long end, long createTime, int token) {
        logger.info("\u4fdd\u5b58Step\u65e5\u5fd7,cloudId({}),appId({}),chatSessionId({}),processId({}),nodeId({}),stepType({}),sessionId({}),traceId({})", new Object[]{cloudId, appId, chatSessionId, processId, nodeId, stepType, sessionId, traceId});
        StepLog stepLog = new StepLog();
        stepLog.setChatSessionId(chatSessionId);
        stepLog.setSessionId(kd.bos.util.StringUtils.isEmpty((String)sessionId) ? 0L : Long.parseLong(sessionId));
        stepLog.setTraceId(kd.bos.util.StringUtils.isEmpty((String)traceId) ? 0L : Long.parseLong(traceId));
        stepLog.setUserId(userId);
        stepLog.setCloudId(cloudId);
        stepLog.setAppId(appId);
        stepLog.setModelName(modelName);
        stepLog.setTags(tags);
        stepLog.setGptProcessId(processId);
        stepLog.setGptProcessNodeId(nodeId);
        stepLog.setStepType(stepType);
        stepLog.setStepOutput(stepOutput);
        stepLog.setStepInput(stepInput);
        stepLog.setThought(stepThought);
        stepLog.setMetadata(metadata);
        stepLog.setStepBeginTime(new Date(start));
        stepLog.setStepFinishTime(new Date(end));
        stepLog.setTotalToken(token);
        stepLog.setLatency(new BigDecimal(end - start).setScale(0));
        stepLog.setCreateTime(createTime == 0L ? new Date() : new Date(createTime));
        IAppCache cache = EngineCache.getAppCache(chatSessionId);
        if (cache != null) {
            String mTraceId = (String)cache.get(TraceUtil.traceMonitorKey(traceId), String.class);
            stepLog.setMonitorTraceId(mTraceId);
            String assistantId = (String)cache.get("_chat_session_assistant_cache_", String.class);
            String agentId = (String)cache.get("_chat_session_agent_cache_", String.class);
            stepLog.setAssistantId(kd.bos.util.StringUtils.isEmpty((String)assistantId) ? 0L : Long.parseLong(assistantId));
            stepLog.setAgentId(kd.bos.util.StringUtils.isEmpty((String)agentId) ? 0L : Long.parseLong(agentId));
            logger.info("save log assistantId:{},agentId:{}", (Object)assistantId, (Object)agentId);
        }
        return stepLog;
    }

    private static void saveAgentCallToolLog(String chatSessionId, String sessionId, long traceId, long toolId, String toolName, String userInput, String toolOutput, String appId, String cloudId, long start, long end) {
        try {
            long userId = RequestContext.get().getCurrUserId();
            String trace = String.valueOf(traceId);
            String tags = JSONObject.toJSONString((Object)new JSONObject());
            JSONObject metadataJo = new JSONObject();
            metadataJo.put("toolName", (Object)toolName);
            metadataJo.put("toolId", (Object)toolId);
            String metadata = JSONObject.toJSONString((Object)metadataJo);
            StepLog stepLog = TraceUtil.buildStepLog(cloudId, appId, chatSessionId, sessionId, trace, null, userId, 0L, tags, metadata, 0L, Constant.StepType.TOOL.getType(), userInput, toolOutput, null, start, end, System.currentTimeMillis());
            MonitorServiceHelper.saveStepLog(stepLog);
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
        }
    }

    public static void saveAgentCallToolLog(String chatSessionId, Long runId, long toolId, String toolName, String userInput, String toolOutput, long start, long end) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
        String trace = (String)appCache.get(TraceUtil.traceAgentRunKey(String.valueOf(runId)), String.class);
        Long traceId = Long.parseLong(trace);
        String appId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceAppKey(traceId), String.class), (String)"");
        String cloudId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceCloudKey(traceId), String.class), (String)"");
        TraceUtil.saveAgentCallToolLog(chatSessionId, sessionId, traceId, toolId, toolName, userInput, toolOutput, appId, cloudId, start, end);
    }

    private static JSONObject buildLLMPromptMetadata(Prompt prompt, String nodeName) {
        JSONObject object = new JSONObject();
        object.put("nodeName", (Object)nodeName);
        object.put("prompt", (Object)prompt);
        return object;
    }

    private static JSONObject buildLLMPromptMetadata(Prompt prompt, String nodeName, String taskId) {
        JSONObject object = TraceUtil.buildLLMPromptMetadata(prompt, nodeName);
        object.put("taskId", (Object)taskId);
        return object;
    }

    private static JSONObject buildProcessTags(Process process) {
        JSONObject object = new JSONObject();
        if (process != null) {
            object.put("process", (Object)new JSONObject());
            object.getJSONObject("process").put("number", (Object)process.getNumber());
            object.getJSONObject("process").put("name", (Object)process.getName());
        }
        return object;
    }

    private static JSONObject buildResultTags(String chatSessionId, JSONObject tagObject, String errCode) {
        JSONObject object = new JSONObject();
        object.put("errCode", (Object)errCode);
        tagObject.put("result", (Object)object);
        JSONObject agentInfo = (JSONObject)EngineCache.getAppCache(chatSessionId).get("agent", JSONObject.class);
        if (agentInfo != null) {
            tagObject.put("agent", (Object)agentInfo);
        }
        return tagObject;
    }

    private static JSONObject buildResultTags(JSONObject tagObject, ErrorCode errorCode) {
        JSONObject object = new JSONObject();
        object.put("errCode", (Object)errorCode);
        tagObject.put("result", (Object)object);
        return tagObject;
    }

    private static JSONObject buildLLMPromptTags(String chatSessionId, Process process, Prompt prompt) {
        JSONObject agentInfo;
        JSONObject object = TraceUtil.buildProcessTags(process);
        if (prompt != null) {
            object.put("prompt", (Object)new JSONObject());
            object.getJSONObject("prompt").put("number", (Object)prompt.getNumber());
            object.getJSONObject("prompt").put("name", (Object)prompt.getName());
        }
        if ((agentInfo = (JSONObject)EngineCache.getAppCache(chatSessionId).get("agent", JSONObject.class)) != null) {
            object.put("agent", (Object)agentInfo);
        }
        return object;
    }

    public static String flowTraceKey(long flowId) {
        return String.format("FLOW-TRACE-%s", flowId);
    }

    private static String chatSessionKey(String chatSessionId) {
        return String.format("CHAT-SESSION-%s", chatSessionId);
    }

    private static String flowProcessKey(long flowId) {
        return String.format("FLOW-PROCESS-%s", flowId);
    }

    private static String traceCloudKey(long traceId) {
        return TraceUtil.traceCloudKey(String.valueOf(traceId));
    }

    private static String traceCloudKey(String traceId) {
        return String.format("TRACE-CLOUD-%s", traceId);
    }

    private static String traceAppKey(long traceId) {
        return TraceUtil.traceAppKey(String.valueOf(traceId));
    }

    private static String traceAppKey(String traceId) {
        return String.format("TRACE-APP-%s", traceId);
    }

    private static String traceMonitorKey(long traceId) {
        return TraceUtil.traceMonitorKey(String.valueOf(traceId));
    }

    private static String traceMonitorKey(String traceId) {
        return String.format("TRACE-MONITOR-%s", traceId);
    }

    private static String traceAgentRunKey(String runId) {
        return String.format("TRACE-AGENT-RUN-%s", runId);
    }
}

