/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trust.analyzer;

import java.util.Arrays;
import java.util.Collections;
import kd.ai.gai.core.trust.analyzer.NumberRecognizer;
import kd.ai.gai.core.trust.model.EntityType;

public class PhoneRecognizer
extends NumberRecognizer {
    public PhoneRecognizer(String name) {
        super(name, EntityType.PHONE_NUMBER, Collections.singletonList("zh"), Arrays.asList("phone", "number", "telephone", "cell", "cellphone", "mobile", "call", "tel", "\u7535\u8bdd", "\u53f7\u7801", "\u624b\u673a", "\u5ea7\u673a", "\u603b\u673a"));
        this.addPattern("(13[0-9]|14[5-9]|15[0-3,5-9]|16[6]|17[0-8]|18[0-9]|19[8,9])\\d{4}\\d{4}", 0.45f);
        this.addPattern("(13[0-9]|14[5-9]|15[0-3,5-9]|16[6]|17[0-8]|18[0-9]|19[8,9])[- ]\\d{4}[- ]\\d{4}", 0.4f);
        this.addPattern("((010|02\\d)[- ][1-9]\\d{2,3}[- ]?\\d{4}([- ][0-9]{1,4})?)|(0[1-9]\\d{2}[- ][1-9]\\d{2,3}[- ]?\\d{4}([- ][0-9]{1,4})?)", 0.4f);
        this.addPattern("([\\(\uff08](?:\\+?|00)86 \\d{2,4}[\\)\uff09]\\d{4}[- ]\\d{4})", 0.4f);
        this.addPattern("(400[016789][- ]?\\d{3}[- ]?\\d{3})", 0.4f);
        this.addPattern("(400[- ]?[016789]\\d{2}[- ]?\\d{4})", 0.4f);
    }

    private boolean isAllNumber(String text) {
        char[] chars;
        for (char ch : chars = text.toCharArray()) {
            if (PhoneRecognizer.isNumber(ch)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean invalidateResult(String text, String match, int start, int end) {
        boolean bInvalid = false;
        if (start > 0 && !match.startsWith("(") && !match.startsWith("\uff08")) {
            char previousChar;
            int prefix = 0;
            while (start - prefix - 1 >= 0 && PhoneRecognizer.isNumber(previousChar = text.charAt(start - prefix - 1))) {
                ++prefix;
            }
            if (prefix > 0) {
                String prefixNumber = text.substring(start - prefix, start);
                boolean bl = bInvalid = !"86".equals(prefixNumber) && !"0086".equals(prefixNumber);
            }
        }
        if (start > 0) {
            char previousChar = text.charAt(start - 1);
            boolean bl = bInvalid = bInvalid || PhoneRecognizer.isInvalidPunctuationSymbol(previousChar);
        }
        if (end < text.length()) {
            char nextChar = text.charAt(end);
            bInvalid = bInvalid || PhoneRecognizer.isInvalidPunctuationSymbol(nextChar) || PhoneRecognizer.isNumber(nextChar);
        }
        return bInvalid;
    }
}

