/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trust.analyzer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kd.ai.gai.core.trust.analyzer.AbcRecognizer;
import kd.ai.gai.core.trust.analyzer.LemmaContextAwareEnhancer;
import kd.ai.gai.core.trust.analyzer.RecognizerFactory;
import kd.ai.gai.core.trust.model.EntityType;
import kd.ai.gai.core.trust.model.RecognizerResult;
import kd.ai.gai.core.trust.tools.RecognizerTools;

public class RecognizerEngine {
    public List<RecognizerResult> analyze(String text, float scoreThreshold, List<EntityType> entityTypeList) {
        List<AbcRecognizer> recognizerList = entityTypeList == null ? RecognizerFactory.getInstance().getAllRecognizerList() : RecognizerFactory.getInstance().getRecognizerList(entityTypeList);
        List<RecognizerResult> results = new ArrayList<RecognizerResult>();
        for (AbcRecognizer recognizer : recognizerList) {
            List<RecognizerResult> currentResults = recognizer.analyze(text);
            if (currentResults == null || currentResults.isEmpty()) continue;
            results.addAll(currentResults);
        }
        results = this.enhanceUsingContext(text, results, recognizerList);
        results = RecognizerTools.removeDuplicates(results);
        results = this.removeLowScores(results, scoreThreshold);
        return results;
    }

    public List<RecognizerResult> removeConflicts(List<RecognizerResult> analyzerResults) {
        ArrayList<RecognizerResult> tmpAnalyzerResults = new ArrayList<RecognizerResult>(analyzerResults);
        RecognizerTools.sortStartEnd(tmpAnalyzerResults);
        int elementsLength = tmpAnalyzerResults.size();
        int index = 0;
        ArrayList<RecognizerResult> otherElements = new ArrayList<RecognizerResult>();
        while (index < elementsLength - 1) {
            RecognizerResult currentEntity = (RecognizerResult)tmpAnalyzerResults.get(index);
            RecognizerResult nextEntity = (RecognizerResult)tmpAnalyzerResults.get(index + 1);
            boolean removeLowScore = false;
            if (currentEntity.getEnd() <= nextEntity.getStart()) {
                ++index;
            } else if (currentEntity.equalIndices(nextEntity)) {
                removeLowScore = true;
            } else if (currentEntity.contains(nextEntity)) {
                otherElements.add(nextEntity);
                tmpAnalyzerResults.remove(index + 1);
                --elementsLength;
            } else if (nextEntity.getStart() < currentEntity.getEnd()) {
                removeLowScore = true;
            }
            if (!removeLowScore) continue;
            if (currentEntity.getScore() >= nextEntity.getScore()) {
                tmpAnalyzerResults.remove(nextEntity);
                otherElements.add(nextEntity);
            } else {
                tmpAnalyzerResults.remove(currentEntity);
                otherElements.add(currentEntity);
            }
            --elementsLength;
        }
        RecognizerTools.sortScoreStartEnd(otherElements);
        otherElements.forEach(otherElement -> {
            if (!this.isResultConflictedWithOtherElements((List<RecognizerResult>)tmpAnalyzerResults, (RecognizerResult)otherElement)) {
                tmpAnalyzerResults.add((RecognizerResult)otherElement);
            }
        });
        tmpAnalyzerResults.sort(Comparator.comparingInt(RecognizerResult::getStart));
        return tmpAnalyzerResults;
    }

    private boolean isResultConflictedWithOtherElements(List<RecognizerResult> otherElements, RecognizerResult result) {
        for (RecognizerResult otherElement : otherElements) {
            RecognizerResult second;
            RecognizerResult first;
            if (otherElement.getStart() <= result.getStart()) {
                first = otherElement;
                second = result;
            } else {
                first = result;
                second = otherElement;
            }
            if (first.getEnd() <= second.getStart()) continue;
            return true;
        }
        return false;
    }

    private List<RecognizerResult> removeLowScores(List<RecognizerResult> results, float scoreThreshold) {
        ArrayList<RecognizerResult> rtn = new ArrayList<RecognizerResult>();
        for (RecognizerResult result : results) {
            if (!(result.getScore() >= scoreThreshold)) continue;
            rtn.add(result);
        }
        return rtn;
    }

    private List<RecognizerResult> enhanceUsingContext(String text, List<RecognizerResult> rawResults, List<AbcRecognizer> recognizers) {
        List<RecognizerResult> results = new ArrayList<RecognizerResult>(rawResults);
        LemmaContextAwareEnhancer contextAwareEnhancer = new LemmaContextAwareEnhancer();
        results = contextAwareEnhancer.enhanceUsingContext(text, results, recognizers);
        return results;
    }
}

