/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trust.analyzer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.ai.gai.core.trust.analyzer.AbcRecognizer;
import kd.ai.gai.core.trust.analyzer.CreditCardRecognizer;
import kd.ai.gai.core.trust.analyzer.PatternRecognizerBuilder;
import kd.ai.gai.core.trust.analyzer.PhoneRecognizer;
import kd.ai.gai.core.trust.model.EntityType;

public class RecognizerFactory {
    private static final RecognizerFactory instance = new RecognizerFactory();
    private final List<AbcRecognizer> recognizerList;
    private static final List<EntityType> SYSTEM_ENTITY = Arrays.asList(EntityType.SYSTEM_ID, EntityType.OTHER, EntityType.DATE_TIME, EntityType.IP_ADDRESS);

    private RecognizerFactory() {
        ArrayList<AbcRecognizer> tmp = new ArrayList<AbcRecognizer>(2);
        tmp.add(PatternRecognizerBuilder.newBuilder("EMAIL_ADDRESS", EntityType.EMAIL_ADDRESS).addSupportedLanguage("en", "zh").addContext("email", "\u90ae\u7bb1").addPattern("[A-Za-z0-9._%+-]+(\\[AT\\]|@)[A-Za-z0-9.-]+(\\[DOT\\]|\\.)[A-Za-z]{2,}", 0.5f).build());
        tmp.add(new CreditCardRecognizer("CREDIT_CARD"));
        tmp.add(new PhoneRecognizer("PHONE_NUMBER"));
        tmp.add(PatternRecognizerBuilder.newBuilder("ID_CARD", EntityType.ID_CARD).addSupportedLanguage("zh").addContext("\u8eab\u4efd\u8bc1\u53f7", "\u8eab\u4efd\u8bc1").addPattern("\\d{8}(0\\d|10|11|12)([0-2]\\d|30|31)\\d{3}", 0.5f).addPattern("\\d{6}(18|19|20)\\d{2}(0\\d|10|11|12)([0-2]\\d|30|31)\\d{3}(\\d|X|x)", 0.5f).numberRecognizer().build());
        tmp.add(PatternRecognizerBuilder.newBuilder("SYSTEM_ID1", EntityType.SYSTEM_ID).addSupportedLanguage("en", "zh").addContext("id", "pkid").addPattern("\\d{18,}", 0.25f).numberRecognizer().build());
        tmp.add(PatternRecognizerBuilder.newBuilder("SYSTEM_ID2", EntityType.SYSTEM_ID).addSupportedLanguage("en", "zh").addPattern("\"[A-Za-z0-9.-_]+\":[\"]?\\d{4,}[\"]?,", 0.25f).build());
        tmp.add(PatternRecognizerBuilder.newBuilder("SYSTEM_BILL_NUMBER", EntityType.SYSTEM_ID).addSupportedLanguage("en", "zh").addContext("\u7f16\u53f7", "\u7f16\u7801").addPattern("(?:[A-Z]{2,5}-)(?:[A-Z0-9]{2,}-)*(?:[A-Z0-9]{2,})", 0.3f).addPattern("(?:[A-Z0-9]{2,}-)+(?:[A-Z0-9]{2,})", 0.25f).build());
        tmp.add(PatternRecognizerBuilder.newBuilder("UUID", EntityType.SYSTEM_ID).addSupportedLanguage("en", "zh").addPattern("\\b[a-f0-9]{8}\\-[a-f0-9]{4}\\-[a-f0-9]{4}\\-[a-f0-9]{4}\\-[a-f0-9]{12}\\b", 0.65f).build());
        tmp.add(PatternRecognizerBuilder.newBuilder("OTHER1", EntityType.OTHER).addSupportedLanguage("en", "zh").addPattern("(?:(\\d{4}([- ]\\d{4}){3,4}))", 0.25f).numberRecognizer().build());
        tmp.add(PatternRecognizerBuilder.newBuilder("IP_ADDRESS", EntityType.IP_ADDRESS).addSupportedLanguage("en", "zh").addContext("ip", "ipv4", "ipv6").addPattern("\\b(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b", 0.6f).addPattern("\\b(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\\b", 0.6f).build());
        tmp.add(PatternRecognizerBuilder.newBuilder("DATE_TIME", EntityType.DATE_TIME).addSupportedLanguage("en", "zh").addContext("date", "\u65e5\u671f").addPattern("\\b(([1-9]|0[1-9]|1[0-2])/([1-9]|0[1-9]|[1-2][0-9]|3[0-1])/(\\d{4}|\\d{2}))\\b", 0.6f).addPattern("\\b(([1-9]|0[1-9]|[1-2][0-9]|3[0-1])/([1-9]|0[1-9]|1[0-2])/(\\d{4}|\\d{2}))\\b", 0.6f).addPattern("\\b(\\d{4}/([1-9]|0[1-9]|1[0-2])/([1-9]|0[1-9]|[1-2][0-9]|3[0-1]))\\b", 0.6f).addPattern("\\b(([1-9]|0[1-9]|1[0-2])-([1-9]|0[1-9]|[1-2][0-9]|3[0-1])-\\d{4})\\b", 0.6f).addPattern("\\b(([1-9]|0[1-9]|[1-2][0-9]|3[0-1])-([1-9]|0[1-9]|1[0-2])-\\d{4})\\b", 0.6f).addPattern("\\b(\\d{4}-([1-9]|0[1-9]|1[0-2])-([1-9]|0[1-9]|[1-2][0-9]|3[0-1]))\\b", 0.6f).addPattern("\\b(([1-9]|0[1-9]|[1-2][0-9]|3[0-1])\\.([1-9]|0[1-9]|1[0-2])\\.(\\d{4}|\\d{2}))\\b", 0.6f).addPattern("\\b(([1-9]|0[1-9]|[1-2][0-9]|3[0-1])-(JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)-(\\d{4}|\\d{2}))\\b", 0.6f).addPattern("\\b((JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)-(\\d{4}|\\d{2}))\\b", 0.6f).addPattern("\\b(([1-9]|0[1-9]|[1-2][0-9]|3[0-1])-(JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC))\\b", 0.6f).numberRecognizer().build());
        String baseUrlRegex = "((www\\d{0,3}[.])?[a-z0-9.\\-]+[.](?:(?:com)|(?:edu)|(?:gov)|(?:int)|(?:mil)|(?:net)|(?:onl)|(?:org)|(?:pro)|(?:red)|(?:tel)|(?:uno)|(?:xxx)|(?:ac)|(?:ad)|(?:ae)|(?:af)|(?:ag)|(?:ai)|(?:al)|(?:am)|(?:an)|(?:ao)|(?:aq)|(?:ar)|(?:as)|(?:at)|(?:au)|(?:aw)|(?:ax)|(?:az)|(?:ba)|(?:bb)|(?:bd)|(?:be)|(?:bf)|(?:bg)|(?:bh)|(?:bi)|(?:bj)|(?:bm)|(?:bn)|(?:bo)|(?:br)|(?:bs)|(?:bt)|(?:bv)|(?:bw)|(?:by)|(?:bz)|(?:ca)|(?:cc)|(?:cd)|(?:cf)|(?:cg)|(?:ch)|(?:ci)|(?:ck)|(?:cl)|(?:cm)|(?:cn)|(?:co)|(?:cr)|(?:cu)|(?:cv)|(?:cw)|(?:cx)|(?:cy)|(?:cz)|(?:de)|(?:dj)|(?:dk)|(?:dm)|(?:do)|(?:dz)|(?:ec)|(?:ee)|(?:eg)|(?:er)|(?:es)|(?:et)|(?:eu)|(?:fi)|(?:fj)|(?:fk)|(?:fm)|(?:fo)|(?:fr)|(?:ga)|(?:gb)|(?:gd)|(?:ge)|(?:gf)|(?:gg)|(?:gh)|(?:gi)|(?:gl)|(?:gm)|(?:gn)|(?:gp)|(?:gq)|(?:gr)|(?:gs)|(?:gt)|(?:gu)|(?:gw)|(?:gy)|(?:hk)|(?:hm)|(?:hn)|(?:hr)|(?:ht)|(?:hu)|(?:id)|(?:ie)|(?:il)|(?:im)|(?:in)|(?:io)|(?:iq)|(?:ir)|(?:is)|(?:it)|(?:je)|(?:jm)|(?:jo)|(?:jp)|(?:ke)|(?:kg)|(?:kh)|(?:ki)|(?:km)|(?:kn)|(?:kp)|(?:kr)|(?:kw)|(?:ky)|(?:kz)|(?:la)|(?:lb)|(?:lc)|(?:li)|(?:lk)|(?:lr)|(?:ls)|(?:lt)|(?:lu)|(?:lv)|(?:ly)|(?:ma)|(?:mc)|(?:md)|(?:me)|(?:mg)|(?:mh)|(?:mk)|(?:ml)|(?:mm)|(?:mn)|(?:mo)|(?:mp)|(?:mq)|(?:mr)|(?:ms)|(?:mt)|(?:mu)|(?:mv)|(?:mw)|(?:mx)|(?:my)|(?:mz)|(?:na)|(?:nc)|(?:ne)|(?:nf)|(?:ng)|(?:ni)|(?:nl)|(?:no)|(?:np)|(?:nr)|(?:nu)|(?:nz)|(?:om)|(?:pa)|(?:pe)|(?:pf)|(?:pg)|(?:ph)|(?:pk)|(?:pl)|(?:pm)|(?:pn)|(?:pr)|(?:ps)|(?:pt)|(?:pw)|(?:py)|(?:qa)|(?:re)|(?:ro)|(?:rs)|(?:ru)|(?:rw)|(?:sa)|(?:sb)|(?:sc)|(?:sd)|(?:se)|(?:sg)|(?:sh)|(?:si)|(?:sj)|(?:sk)|(?:sl)|(?:sm)|(?:sn)|(?:so)|(?:sr)|(?:st)|(?:su)|(?:sv)|(?:sx)|(?:sy)|(?:sz)|(?:tc)|(?:td)|(?:tf)|(?:tg)|(?:th)|(?:tj)|(?:tk)|(?:tl)|(?:tm)|(?:tn)|(?:to)|(?:tp)|(?:tr)|(?:tt)|(?:tv)|(?:tw)|(?:tz)|(?:ua)|(?:ug)|(?:uk)|(?:us)|(?:uy)|(?:uz)|(?:va)|(?:vc)|(?:ve)|(?:vg)|(?:vi)|(?:vn)|(?:vu)|(?:wf)|(?:ws)|(?:ye)|(?:yt)|(?:za)|(?:zm)|(?:zw))(?:/[^\\s()<>]+|/)?)";
        tmp.add(PatternRecognizerBuilder.newBuilder("URL", EntityType.URL).addSupportedLanguage("en", "zh").addContext("url", "website", "link", "\u94fe\u63a5", "\u7f51\u5740").addPattern("(?i)(?:https?://)" + baseUrlRegex, 0.6f).addPattern("(?i)" + baseUrlRegex, 0.5f).build());
        this.recognizerList = Collections.unmodifiableList(tmp);
    }

    public static RecognizerFactory getInstance() {
        return instance;
    }

    public List<AbcRecognizer> getAllRecognizerList() {
        return this.recognizerList;
    }

    public List<AbcRecognizer> getRecognizerList(List<EntityType> entityTypeList) {
        ArrayList<AbcRecognizer> list = new ArrayList<AbcRecognizer>(this.recognizerList.size());
        for (AbcRecognizer recognizer : this.recognizerList) {
            if (!entityTypeList.contains((Object)recognizer.getSupportedEntity()) && !SYSTEM_ENTITY.contains((Object)recognizer.getSupportedEntity())) continue;
            list.add(recognizer);
        }
        return list;
    }
}

