/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trust.analyzer;

import com.huaban.analysis.jieba.WordDictionary;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.reflect.MethodUtils;

public class UserWordDictionary {
    private static Log logger = LogFactory.getLog(UserWordDictionary.class);
    private static UserWordDictionary singleInstance;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserWordDictionary getInstance() {
        if (singleInstance == null) {
            Class<UserWordDictionary> clazz = UserWordDictionary.class;
            synchronized (UserWordDictionary.class) {
                if (singleInstance == null) {
                    singleInstance = new UserWordDictionary();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return singleInstance;
            }
        }
        return singleInstance;
    }

    private UserWordDictionary() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWords(Set<String> words) {
        HashSet<String> newWords = new HashSet<String>(words.size());
        this.readLock.lock();
        try {
            for (String word : words) {
                if (WordDictionary.getInstance().containsWord(word)) continue;
                newWords.add(word);
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (!newWords.isEmpty()) {
            this.loadUserWords(newWords);
        }
    }

    private void addWordsToDict(WordDictionary dict, Set<String> words) {
        double freq = 3.0;
        for (String word : words) {
            try {
                word = (String)MethodUtils.invokeMethod((Object)dict, (boolean)true, (String)"addWord", (Object[])new Object[]{word});
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            dict.freqs.put(word, Math.log(freq / (double)dict.freqs.size()));
        }
    }

    private void loadUserWords(Set<String> words) {
        this.writeLock.lock();
        try {
            WordDictionary dict = WordDictionary.getInstance();
            this.addWordsToDict(dict, words);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

