/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trust.sensitive;

import com.huaban.analysis.jieba.JiebaSegmenter;
import com.huaban.analysis.jieba.SegToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kd.ai.gai.core.domain.dto.SensitiveWordStock;
import kd.ai.gai.core.domain.dto.TrustLayerResult;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.service.trusty.SensitiveCheckService;
import kd.ai.gai.core.trust.analyzer.UserWordDictionary;
import kd.ai.gai.core.trust.sensitive.ISensitiveCheck;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;

public class LocalInputCheck
implements ISensitiveCheck {
    @Override
    public void initServerConfig(DynamicObject config) {
    }

    @Override
    public TrustLayerResult textCheck(String sText) {
        TrustLayerResult result = new TrustLayerResult();
        if (StringUtils.isEmpty((CharSequence)sText)) {
            return result;
        }
        List<SensitiveWordStock> sensitiveWords = SensitiveCheckService.getSensitiveWords();
        if (sensitiveWords.isEmpty()) {
            return result;
        }
        HashSet<String> allWords = new HashSet<String>();
        for (SensitiveWordStock sensitiveWordStock : sensitiveWords) {
            if (sensitiveWordStock.getWords() == null) continue;
            for (String word : sensitiveWordStock.getWords()) {
                if (StringUtils.isEmpty((CharSequence)word)) continue;
                allWords.add(word);
            }
        }
        if (allWords.isEmpty()) {
            return result;
        }
        UserWordDictionary.getInstance().addWords(allWords);
        HashSet<String> tokenize = new HashSet<String>(this.tokenize(sText));
        tokenize.retainAll(allWords);
        if (tokenize.isEmpty()) {
            return result;
        }
        String containWord = (String)tokenize.iterator().next();
        if (!StringUtils.isEmpty((CharSequence)containWord)) {
            for (SensitiveWordStock sensitiveWordStock : sensitiveWords) {
                if (sensitiveWordStock.getWords() == null || !Arrays.asList(sensitiveWordStock.getWords()).contains(containWord)) continue;
                result.setErrorCode(Errors.containSensitiveWord(sensitiveWordStock.getInputanswer()));
                result.setContainSensitiveWord(true);
                result.setErrorMsg(sensitiveWordStock.getInputanswer());
                break;
            }
        }
        return result;
    }

    protected ErrorCode getErrorcode(SensitiveWordStock sensitiveWordStock) {
        return Errors.containSensitiveWord(sensitiveWordStock.getInputanswer());
    }

    protected String getErrorMsg(SensitiveWordStock sensitiveWordStock) {
        return sensitiveWordStock.getInputanswer();
    }

    private List<String> tokenize(String text) {
        JiebaSegmenter jieba = new JiebaSegmenter();
        List segTokenList = jieba.process(text, JiebaSegmenter.SegMode.INDEX);
        ArrayList<String> rtn = new ArrayList<String>(segTokenList.size());
        for (SegToken segToken : segTokenList) {
            if (StringUtils.isEmpty((CharSequence)segToken.word)) continue;
            rtn.add(segToken.word);
        }
        return rtn;
    }
}

