/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trust.sensitive.yidun;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.TrustLayerResult;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.trust.sensitive.ISensitiveCheck;
import kd.ai.gai.core.trust.sensitive.yidun.Suggestion;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.StringUtils;

public class YiDunCheck
implements ISensitiveCheck {
    private static Log logger = LogFactory.getLog(YiDunCheck.class);
    private String SECRET_ID = "";
    private String SECRET_KEY = "";
    private String TEXT_BUSINESSID = "";
    private String TEXT_CHECK_URL = "";
    private String TEXT_BATCH_CHECK_URL = "";

    @Override
    public void initServerConfig(DynamicObject config) {
        this.SECRET_ID = config.getString("appid");
        this.SECRET_KEY = config.getString("appkey");
        this.TEXT_BUSINESSID = config.getString("businessid");
        String protocol = config.getString("protocol");
        String server = config.getString("server");
        String port = config.getString("port");
        if (server.endsWith("/")) {
            server = server.substring(0, server.length() - 1);
        }
        if (StringUtils.isNotEmpty((String)port)) {
            server = String.format("%s:%s", server, port);
        }
        this.TEXT_CHECK_URL = String.format("%s://%s%s", protocol, server, "/v5/text/check");
        this.TEXT_BATCH_CHECK_URL = String.format("%s://%s%s", protocol, server, "/v5/text/batch-check");
    }

    @Override
    public TrustLayerResult textCheck(String sText) {
        if (StringUtils.isEmpty((String)sText)) {
            return new TrustLayerResult();
        }
        ArrayList<String> contentList = new ArrayList<String>(1);
        this.splitText(sText, contentList);
        if (contentList.size() > 1) {
            return this.callBacthCheck(contentList);
        }
        return this.callCheck(sText);
    }

    private TrustLayerResult callCheck(String content) {
        try {
            HashMap mapHeader = new HashMap();
            HashMap<String, Object> mapBody = new HashMap<String, Object>();
            mapBody.put("secretId", this.SECRET_ID);
            mapBody.put("businessId", this.TEXT_BUSINESSID);
            mapBody.put("version", "v5.3");
            mapBody.put("timestamp", String.valueOf(System.currentTimeMillis()));
            mapBody.put("nonce", String.valueOf(new SecureRandom().nextInt()));
            mapBody.put("signatureMethod", "SHA256");
            String sTraceId = RequestContext.get().getTraceId();
            mapBody.put("dataId", sTraceId);
            mapBody.put("content", content);
            String signature = this.genSignature(this.SECRET_KEY, mapBody);
            mapBody.put("signature", signature);
            logger.info("YiDunCheck-body: " + JSON.toJSONString(mapBody));
            String response = HttpClientUtils.post((String)this.TEXT_CHECK_URL, mapHeader, mapBody);
            logger.info("YiDunCheck-response: " + response);
            return this.buildCheckResult(response);
        }
        catch (IOException ex) {
            return this.builErrCheckResult(ex);
        }
        catch (Exception ex) {
            return this.builErrCheckResult(ex);
        }
    }

    private TrustLayerResult callBacthCheck(List<String> contentList) {
        try {
            HashMap mapHeader = new HashMap();
            HashMap<String, Object> mapBody = new HashMap<String, Object>();
            mapBody.put("secretId", this.SECRET_ID);
            mapBody.put("businessId", this.TEXT_BUSINESSID);
            mapBody.put("version", "v5.3");
            mapBody.put("timestamp", String.valueOf(System.currentTimeMillis()));
            mapBody.put("nonce", String.valueOf(new SecureRandom().nextInt()));
            mapBody.put("signatureMethod", "SHA256");
            String sTraceId = RequestContext.get().getTraceId();
            ArrayList contentMapList = new ArrayList(contentList.size());
            for (int i = 0; i < contentList.size(); ++i) {
                String content = contentList.get(i);
                HashMap<String, String> mapContent = new HashMap<String, String>(2);
                mapContent.put("dataId", String.format("%s_%s", sTraceId, i));
                mapContent.put("content", content);
                contentMapList.add(mapContent);
            }
            mapBody.put("texts", JSON.toJSONString(contentMapList));
            String signature = this.genSignature(this.SECRET_KEY, mapBody);
            mapBody.put("signature", signature);
            String sBody = JSON.toJSONString(mapBody);
            logger.info("YiDunCheck-body: \n");
            while (StringUtils.isNotEmpty((String)sBody)) {
                String sLog = "";
                if (sBody.length() > 5000) {
                    sLog = sBody.substring(0, 5000);
                    sBody = sBody.substring(5000);
                } else {
                    sLog = sBody;
                    sBody = "";
                }
                logger.info(sLog);
            }
            String response = HttpClientUtils.post((String)this.TEXT_BATCH_CHECK_URL, mapHeader, mapBody);
            logger.info("YiDunCheck-response: " + response);
            return this.buildBatchCheckResult(response);
        }
        catch (IOException ex) {
            return this.builErrCheckResult(ex);
        }
        catch (Exception ex) {
            return this.builErrCheckResult(ex);
        }
    }

    private void splitText(String sContent, List<String> splitContentList) {
        if (sContent.length() > 10000) {
            int maxLen = 10000;
            int lastIndex = 9999;
            for (int i = maxLen - 1; i > 0; --i) {
                char ch = sContent.charAt(i);
                if (ch != '\uff0c' && ch != '\u3002' && ch != '\uff1f' && ch != '\uff01' && ch != '\uff1a' && ch != '\uff1b' && ch != '\n' && (ch != ',' && ch != '.' && ch != '?' && ch != '!' || i >= maxLen - 1 || sContent.charAt(i + 1) != ' ')) continue;
                lastIndex = i;
                break;
            }
            String sSplitTextLeft = sContent.substring(0, lastIndex);
            String sSplitTextRight = sContent.substring(lastIndex);
            splitContentList.add(sSplitTextLeft);
            this.splitText(sSplitTextRight, splitContentList);
        } else {
            splitContentList.add(sContent);
        }
    }

    private TrustLayerResult builErrCheckResult(Exception ex) {
        logger.error((Throwable)ex);
        String sMessage = "";
        sMessage = ex.getMessage();
        if (StringUtils.isEmpty((String)sMessage)) {
            sMessage = ex.toString();
        }
        TrustLayerResult result = new TrustLayerResult();
        result.setErrorCode(Errors.TRUSTY_THIRD_CHECK_ERROR);
        result.setErrorMsg(String.format("%s\u3002traceId\uff1a%s", Errors.builErrorCode(Errors.TRUSTY_THIRD_CHECK_ERROR, sMessage).getMessage(), RequestContext.get().getTraceId()));
        return result;
    }

    private String genSignature(String secretKey, Map<String, Object> params) {
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder sb = new StringBuilder();
        for (Object key : keys) {
            sb.append((String)key).append(params.get(key));
        }
        sb.append(secretKey);
        return Hashing.sha256().hashString((CharSequence)sb.toString(), StandardCharsets.UTF_8).toString();
    }

    private TrustLayerResult buildBatchCheckResult(String response) {
        TrustLayerResult checkResult = new TrustLayerResult();
        JSONObject jsonResponse = JSON.parseObject((String)response);
        int code = jsonResponse.getInteger("code");
        if (code != 200) {
            String msg = jsonResponse.getString("msg");
            checkResult.setErrorCode(Errors.TRUSTY_THIRD_CHECK_ERROR);
            checkResult.setErrorMsg(String.format("%s\u3002traceId\uff1a%s", Errors.builErrorCode(Errors.TRUSTY_THIRD_CHECK_ERROR, msg).getMessage(), RequestContext.get().getTraceId()));
            return checkResult;
        }
        JSONArray jsonArrayResult = jsonResponse.getJSONArray("result");
        for (int i = 0; i < jsonArrayResult.size(); ++i) {
            JSONObject jsonAntispam = jsonArrayResult.getJSONObject(i).getJSONObject("antispam");
            TrustLayerResult curCheckResult = this.createResult(jsonAntispam);
            if (curCheckResult.getErrorCode() == null) continue;
            checkResult = curCheckResult;
            break;
        }
        return checkResult;
    }

    private TrustLayerResult buildCheckResult(String response) {
        TrustLayerResult checkResult = new TrustLayerResult();
        JSONObject jsonResponse = JSON.parseObject((String)response);
        int code = jsonResponse.getInteger("code");
        if (code != 200) {
            String msg = jsonResponse.getString("msg");
            checkResult.setErrorCode(Errors.TRUSTY_THIRD_CHECK_ERROR);
            checkResult.setErrorMsg(String.format("%s\u3002traceId\uff1a%s", Errors.builErrorCode(Errors.TRUSTY_THIRD_CHECK_ERROR, msg).getMessage(), RequestContext.get().getTraceId()));
            return checkResult;
        }
        JSONObject jsonResult = jsonResponse.getJSONObject("result");
        JSONObject jsonAntispam = jsonResult.getJSONObject("antispam");
        checkResult = this.createResult(jsonAntispam);
        return checkResult;
    }

    private TrustLayerResult createResult(JSONObject jsonAntispam) {
        int intSuggestion = jsonAntispam.getInteger("suggestion");
        int intLabel = jsonAntispam.getInteger("label");
        TrustLayerResult checkResult = new TrustLayerResult();
        Suggestion suggestion = Suggestion.parse(intSuggestion);
        if (suggestion != null) {
            switch (suggestion) {
                case POSSIBLE: {
                    int intCustomAction;
                    if (!jsonAntispam.containsKey((Object)"customAction") || (intCustomAction = jsonAntispam.getInteger("customAction").intValue()) != Suggestion.NOT_PASS.getValue()) break;
                    checkResult.setErrorCode(Errors.TRUSTY_THIRD_CHECK_NOT_PASS);
                    checkResult.setErrorMsg(Errors.TRUSTY_THIRD_CHECK_NOT_PASS.getMessage());
                    break;
                }
                case NOT_PASS: {
                    checkResult.setErrorCode(Errors.TRUSTY_THIRD_CHECK_NOT_PASS);
                    checkResult.setErrorMsg(Errors.TRUSTY_THIRD_CHECK_NOT_PASS.getMessage());
                }
            }
        }
        return checkResult;
    }
}

