/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.util;

import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;

public class DynamicObjectUtils {
    public static String dynamicObject2Json(DynamicObject dynamicObject, DynamicObjectType entityType) {
        return DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{dynamicObject}, (DynamicObjectType)entityType);
    }

    public static DynamicObject json2DynamicObject(String json, DynamicObjectType dynamicObjectType) {
        Object[] objects = DynamicObjectSerializeUtil.deserialize((String)json, (DynamicObjectType)dynamicObjectType);
        return (DynamicObject)objects[0];
    }

    public static DynamicObject deepCopy(DynamicObject oldEntity, boolean onlyDBProperty, boolean clearPrimarykeyValue) {
        CloneUtils cloneUtils = new CloneUtils(onlyDBProperty, clearPrimarykeyValue);
        DynamicObject newEntity = (DynamicObject)cloneUtils.clone((IDataEntityBase)oldEntity);
        DynamicObjectUtils.setDynamicObjectDirty(newEntity, clearPrimarykeyValue);
        return newEntity;
    }

    public static DynamicObject deepCopy(IDataEntityType dtNewEntityType, DynamicObject oldEntity, boolean onlyDBProperty, boolean clearPrimarykeyValue) {
        CloneUtils cloneUtils = new CloneUtils(onlyDBProperty, clearPrimarykeyValue);
        DynamicObject newEntity = (DynamicObject)cloneUtils.clone(dtNewEntityType, (Object)oldEntity);
        DynamicObjectUtils.setDynamicObjectDirty(newEntity, clearPrimarykeyValue);
        return newEntity;
    }

    private static void setDynamicObjectDirty(DynamicObject dataEntity, boolean clearPrimaryKeyValue) {
        if (clearPrimaryKeyValue) {
            return;
        }
        dataEntity.getDataEntityState().setDirty(true);
        List collectionProperties = dataEntity.getDataEntityType().getProperties().getCollectionProperties(true);
        for (ICollectionProperty collectionProperty : collectionProperties) {
            Object collectionValue = dataEntity.get((IDataEntityProperty)collectionProperty);
            if (!(collectionValue instanceof DynamicObjectCollection)) continue;
            boolean hasCollectionProperties = !collectionProperty.getItemType().getProperties().getCollectionProperties(true).isEmpty();
            boolean isMultilanguageText = collectionValue instanceof LocaleDynamicObjectCollection;
            DynamicObjectCollection collection = (DynamicObjectCollection)collectionValue;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                DynamicObject dynamicObject = (DynamicObject)iterator.next();
                if (isMultilanguageText && (dynamicObject.getPkValue() == null || StringUtils.isEmpty((CharSequence)dynamicObject.getPkValue().toString()))) {
                    iterator.remove();
                    continue;
                }
                dynamicObject.getDataEntityState().setDirty(true);
                if (!hasCollectionProperties) continue;
                DynamicObjectUtils.setDynamicObjectDirty(dynamicObject, false);
            }
        }
    }

    public static void copyDynamicObject(DynamicObject from, DynamicObject to, int entryCopyType, boolean ignoreNull, boolean isMulReset, boolean clearPrimarykeyValue) {
        DynamicObjectType dynamicObjectType = to.getDynamicObjectType();
        DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
        DynamicObjectType dataFromDynamicObjectType = from.getDynamicObjectType();
        DataEntityPropertyCollection dataFromProperties = dataFromDynamicObjectType.getProperties();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (!dataFromProperties.containsKey((Object)name)) continue;
            if (property instanceof EntryProp) {
                if (entryCopyType == 1) continue;
                DynamicObjectCollection toDynamicObjectCollection = to.getDynamicObjectCollection(name);
                if (entryCopyType == 2) {
                    toDynamicObjectCollection.clear();
                }
                DynamicObjectCollection dataFromDynamicObjectCollection = from.getDynamicObjectCollection(name);
                for (DynamicObject dataFromDynamicObject : dataFromDynamicObjectCollection) {
                    String fromEntryPk = String.valueOf(dataFromDynamicObject.getPkValue());
                    DynamicObject dynamicObject = null;
                    boolean isadd = false;
                    if (entryCopyType == 4 && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fromEntryPk)) {
                        for (DynamicObject toObj : toDynamicObjectCollection) {
                            String toEntryPk = String.valueOf(toObj.getPkValue());
                            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)toEntryPk) || !toEntryPk.equals(fromEntryPk)) continue;
                            dynamicObject = toObj;
                            break;
                        }
                    }
                    if (dynamicObject == null) {
                        dynamicObject = new DynamicObject(toDynamicObjectCollection.getDynamicObjectType());
                        isadd = true;
                    }
                    DynamicObjectUtils.copyDynamicObject(dataFromDynamicObject, dynamicObject, 1, ignoreNull, isMulReset, clearPrimarykeyValue);
                    if (entryCopyType != 2 && entryCopyType != 3 || !isadd) continue;
                    toDynamicObjectCollection.add((Object)dynamicObject);
                }
                continue;
            }
            if (property instanceof MulBasedataProp && isMulReset) {
                MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
                IDataEntityType itemType = mulBasedataProp.getItemType();
                ISimpleProperty primaryKey = itemType.getPrimaryKey();
                DynamicObjectCollection toColls = (DynamicObjectCollection)to.get(name);
                toColls.clear();
                DynamicObjectType toDynamicObjectType = toColls.getDynamicObjectType();
                DynamicObjectCollection fromColls = (DynamicObjectCollection)from.get(name);
                for (DynamicObject coll : fromColls) {
                    DynamicObject mulBaseData = new DynamicObject(toDynamicObjectType);
                    DynamicObjectUtils.copyDynamicObject(coll, mulBaseData, 1, ignoreNull, false, false);
                    primaryKey.resetValue((Object)mulBaseData);
                    toColls.add((Object)mulBaseData);
                }
                continue;
            }
            if (property instanceof MuliLangTextProp) {
                ILocaleString localeString = from.getLocaleString(name);
                to.set(name, (Object)localeString);
                continue;
            }
            if (ignoreNull && from.get(name) == null) continue;
            to.set(name, from.get(name));
        }
        if (clearPrimarykeyValue) {
            ISimpleProperty toPrimaryKey = dynamicObjectType.getPrimaryKey();
            toPrimaryKey.resetValue((Object)to);
        }
    }
}

