/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.domain.op.UserFeedbackEventParams;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.AskUserAction;
import kd.ai.gai.core.engine.flow.BreakLoopAction;
import kd.ai.gai.core.engine.flow.CodeAction;
import kd.ai.gai.core.engine.flow.Condition;
import kd.ai.gai.core.engine.flow.End;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.LoopAction;
import kd.ai.gai.core.engine.flow.MessageAction;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.ParallelAction;
import kd.ai.gai.core.engine.flow.RecommendAction;
import kd.ai.gai.core.engine.flow.RepoAction;
import kd.ai.gai.core.engine.flow.RepoReplyAction;
import kd.ai.gai.core.engine.flow.SetVariableAction;
import kd.ai.gai.core.engine.flow.Start;
import kd.ai.gai.core.engine.flow.StartLoopAction;
import kd.ai.gai.core.engine.flow.StartParallelAction;
import kd.ai.gai.core.engine.flow.ToolAction;
import kd.ai.gai.core.engine.flow.Transfer;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.EndFlowMessage;
import kd.ai.gai.core.engine.message.MsgNodeMessage;
import kd.ai.gai.core.engine.message.StartFlowMessage;
import kd.ai.gai.core.engine.message.StopStreamMessage;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.enuz.field.type.VarFieldType;
import kd.ai.gai.core.enuz.op.UserFeedbackTypeEnum;
import kd.ai.gai.core.flow.application.AskUserNodeApplication;
import kd.ai.gai.core.flow.application.BreakLoopNodeApplication;
import kd.ai.gai.core.flow.application.CodeNodeApplication;
import kd.ai.gai.core.flow.application.EndNodeApplication;
import kd.ai.gai.core.flow.application.JavaActionNodeApplication;
import kd.ai.gai.core.flow.application.LoopInitNodeApplication;
import kd.ai.gai.core.flow.application.LoopNextNodeApplication;
import kd.ai.gai.core.flow.application.MessageNodeApplication;
import kd.ai.gai.core.flow.application.NOPNodeApplication;
import kd.ai.gai.core.flow.application.ParallelBlockEndNodeApplication;
import kd.ai.gai.core.flow.application.ParallelBlockStartNodeApplication;
import kd.ai.gai.core.flow.application.ParallelInitNodeApplication;
import kd.ai.gai.core.flow.application.ParallelMergeNodeApplication;
import kd.ai.gai.core.flow.application.PromptNodeApplication;
import kd.ai.gai.core.flow.application.RecommendNodeApplication;
import kd.ai.gai.core.flow.application.RepoNodeApplication;
import kd.ai.gai.core.flow.application.RepoReplyNodeApplication;
import kd.ai.gai.core.flow.application.SetVariableNodeApplication;
import kd.ai.gai.core.flow.application.StartLoopNodeApplication;
import kd.ai.gai.core.flow.application.StartNodeApplication;
import kd.ai.gai.core.flow.application.StartParallelNodeApplication;
import kd.ai.gai.core.flow.application.ToolNodeApplication;
import kd.ai.gai.core.flow.build.FlowBuilderFactory;
import kd.ai.gai.core.flow.build.attribute.FlowAttribute;
import kd.ai.gai.core.flow.callback.AskUserNodeCallback;
import kd.ai.gai.core.flow.callback.PromptNodeCallback;
import kd.ai.gai.core.flow.callback.RepoReplyNodeCallback;
import kd.ai.gai.core.flow.condition.GaiCondition;
import kd.ai.gai.core.flow.connector.server.GaiFlowTaskExecutor;
import kd.ai.gai.core.flow.param.builder.ParamDefinitionBuilder;
import kd.ai.gai.core.flow.param.define.BasicParamDefinition;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.execution.ParamMode;
import kd.ai.gai.core.flow.runtime.FlowRuntimeLock;
import kd.ai.gai.core.service.ChatHistoryService;
import kd.ai.gai.core.service.agent.AnnotationService;
import kd.ai.gai.core.service.agent.FileService;
import kd.ai.gai.core.service.op.IUserFeedbackService;
import kd.ai.gai.core.trace.util.TraceUtil;
import kd.ai.gai.flow.connector.server.TaskExecutor;
import kd.ai.gai.flow.dt.DataType;
import kd.ai.gai.flow.dt.DataTypes;
import kd.ai.gai.flow.flow.core.AsyncThreadsFailedException;
import kd.ai.gai.flow.flow.core.DataArea;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.FC;
import kd.ai.gai.flow.flow.core.Flow;
import kd.ai.gai.flow.flow.core.FlowBuilder;
import kd.ai.gai.flow.flow.core.FlowRuntime;
import kd.ai.gai.flow.flow.core.GroupBuilder;
import kd.ai.gai.flow.flow.core.NodeBuilder;
import kd.ai.gai.flow.flow.core.Profile;
import kd.ai.gai.flow.flow.core.Transition;
import kd.ai.gai.flow.flow.core.TransitionBuilder;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.ai.gai.flow.flow.core.plugin.Callback;
import kd.ai.gai.flow.flow.core.plugin.ext.ScriptCondition;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class FlowUtils {
    private static final Log log = LogFactory.getLog(FlowUtils.class);
    private static final int USER_HISTORY_COUNT = 200;
    private static final String NODEID_PARALLEL_BLOCK_START = "parallel_block_start";
    private static final String NODEID_PARALLEL_BLOCK_END = "parallel_block_end";

    public static DataType toDataType(String type) {
        switch (type) {
            case "Integer": {
                return DataTypes.INTEGER;
            }
            case "DateTime": {
                return DataTypes.DATETIME;
            }
        }
        return DataTypes.STRING;
    }

    public static Flow buildFlow(Context context, kd.ai.gai.core.engine.flow.Flow gaiFlow) {
        String flowParamMode = gaiFlow.getParamMode();
        ParamMode paramMode = kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)flowParamMode) ? ParamMode.PROPERTY : ParamMode.valueOf(flowParamMode);
        if (paramMode == ParamMode.PROPERTY) {
            return FlowUtils.buildFlowWithNodeProperty(context, gaiFlow);
        }
        return FlowBuilderFactory.build(context, gaiFlow);
    }

    public static Flow buildFlowWithNodeProperty(Context context, kd.ai.gai.core.engine.flow.Flow gaiFlow) {
        List<Transfer> transfers;
        List<Transfer> resortTransferList;
        if (gaiFlow == null) {
            log.error("chatSessionId\u3010{}\u3011\u6d41\u7a0b\u4e3a\u7a7a\u3002 ", (Object)context.getChatSessionId());
            throw new KDBizException(Errors.flowNotExistedError(context.getChatSessionId()), new Object[0]);
        }
        FlowBuilder flowBuilder = FC.getFactory().newInstance(String.valueOf(gaiFlow.getId()), gaiFlow.getName());
        Start start = gaiFlow.getStart();
        NodeBuilder startNode = flowBuilder.node(String.valueOf(start.getId()), start.getName());
        startNode.biz((Application)new StartNodeApplication(context, gaiFlow));
        String startFlowMessage = "startFlowMessage";
        flowBuilder.variable(startFlowMessage, startFlowMessage, "\u8f93\u5165\u53c2\u6570", FlowUtils.toDataType(VarFieldType.STRING.getType()));
        flowBuilder.addInput(startFlowMessage);
        List<Object> loopNodeIdList = new ArrayList();
        List<Object> parallelNodeIdList = new ArrayList();
        List<Object> parallelBlockInnerNodeIdList = new ArrayList();
        Map<Object, Object> breakLoopNodeIdActionMap = new HashMap();
        List<Action> actionList = gaiFlow.getActions();
        if (actionList != null && !actionList.isEmpty()) {
            List normalActionList = actionList.stream().filter(action -> !action.isBlockInnerNode()).collect(Collectors.toList());
            List blockInnerActionList = actionList.stream().filter(Node::isBlockInnerNode).collect(Collectors.toList());
            Map<Integer, List<Action>> blockInnerNodeIdActionListMap = blockInnerActionList.stream().collect(Collectors.groupingBy(Node::getBlockNodeId, Collectors.mapping(Action2 -> Action2, Collectors.toList())));
            loopNodeIdList = actionList.stream().filter(action -> Short.parseShort(action.getType()) == ProcessNodeType.Loop.getValue()).map(Node::getId).collect(Collectors.toList());
            parallelNodeIdList = actionList.stream().filter(action -> Short.parseShort(action.getType()) == ProcessNodeType.Parallel.getValue()).map(Node::getId).collect(Collectors.toList());
            parallelBlockInnerNodeIdList = actionList.stream().filter(action -> action.isBlockInnerNode() && gaiFlow.findNodeById(action.getBlockNodeId()).isParallelBlockNode()).map(Node::getId).collect(Collectors.toList());
            breakLoopNodeIdActionMap = blockInnerActionList.stream().filter(Node::isBreakLoopNode).collect(Collectors.toMap(Node::getId, Function.identity(), (key1, key2) -> key2));
            block13: for (Object action2 : normalActionList) {
                String nodeId = String.valueOf(((Node)action2).getId());
                String nodeName = ((Node)action2).getName();
                NodeBuilder nodeBuilder = null;
                ProcessNodeType processNodeType = ProcessNodeType.valueOf(Integer.parseInt(((Node)action2).getType()));
                switch (processNodeType) {
                    case Llm: {
                        nodeBuilder = flowBuilder.node(nodeId, nodeName);
                        nodeBuilder.biz((Application)new PromptNodeApplication(context, gaiFlow, (LLMAction)action2), (Callback)new PromptNodeCallback());
                        continue block13;
                    }
                    case CusOption: {
                        nodeBuilder = flowBuilder.node(nodeId, nodeName);
                        nodeBuilder.biz((Application)new JavaActionNodeApplication(context, gaiFlow, (JavaPluginAction)action2, -1));
                        continue block13;
                    }
                    case Message: {
                        nodeBuilder = flowBuilder.node(nodeId, nodeName);
                        nodeBuilder.biz((Application)new MessageNodeApplication(context, gaiFlow, (MessageAction)action2, -1));
                        continue block13;
                    }
                    case AskUser: {
                        nodeBuilder = flowBuilder.node(nodeId, nodeName);
                        nodeBuilder.biz((Application)new AskUserNodeApplication(context, gaiFlow, (AskUserAction)action2), (Callback)new AskUserNodeCallback());
                        continue block13;
                    }
                    case Repo: {
                        nodeBuilder = flowBuilder.node(nodeId, nodeName);
                        nodeBuilder.biz((Application)new RepoNodeApplication(context, gaiFlow, (RepoAction)action2, -1));
                        continue block13;
                    }
                    case RepoReply: {
                        nodeBuilder = flowBuilder.node(nodeId, nodeName);
                        nodeBuilder.biz((Application)new RepoReplyNodeApplication(context, gaiFlow, (RepoReplyAction)action2, -1), (Callback)new RepoReplyNodeCallback());
                        continue block13;
                    }
                    case Tool: {
                        nodeBuilder = flowBuilder.node(nodeId, nodeName);
                        nodeBuilder.biz((Application)new ToolNodeApplication(context, gaiFlow, (ToolAction)action2, -1));
                        continue block13;
                    }
                    case Loop: {
                        nodeBuilder = flowBuilder.node(nodeId, nodeName);
                        FlowUtils.buildLoopNode(context, gaiFlow, (LoopAction)action2, nodeId, flowBuilder, nodeName, blockInnerNodeIdActionListMap, nodeBuilder);
                        continue block13;
                    }
                    case Code: {
                        nodeBuilder = flowBuilder.node(nodeId, nodeName);
                        nodeBuilder.biz((Application)new CodeNodeApplication(context, gaiFlow, (CodeAction)action2, -1));
                        continue block13;
                    }
                    case Parallel: {
                        FlowUtils.buildParallelNode(context, gaiFlow, (Action)action2, nodeId, flowBuilder, nodeName, blockInnerNodeIdActionListMap);
                        continue block13;
                    }
                    case RecommendQuestion: {
                        nodeBuilder = flowBuilder.node(nodeId, nodeName);
                        nodeBuilder.biz((Application)new RecommendNodeApplication(context, gaiFlow, (RecommendAction)action2));
                        continue block13;
                    }
                }
                throw new KDBizException(Errors.notSupportActionType(action2.getClass().getName()), new Object[0]);
            }
        }
        End end = gaiFlow.getEnd();
        EndFlowMessage endFlowMessage = new EndFlowMessage();
        endFlowMessage.setFlowId(gaiFlow.getId());
        endFlowMessage.setError(false);
        endFlowMessage.setChatSessionId(context.getChatSessionId());
        endFlowMessage.setErrorCode(Errors.OK);
        NodeBuilder endNode = flowBuilder.node(String.valueOf(end.getId()), end.getName());
        endNode.biz((Application)new EndNodeApplication(context, gaiFlow, endFlowMessage));
        List<VarMapper> outParamMap = end.getOutParamMap();
        if (end.getOutputVars() != null && !end.getOutputVars().isEmpty() && outParamMap != null) {
            for (Var var : end.getOutputVars()) {
                String varName = FlowUtils.getPropertyName(end.getId(), var.getName());
                flowBuilder.variable(varName, varName, var.getDesc(), FlowUtils.toDataType(var.getType()));
                flowBuilder.addOutput(varName);
            }
        }
        if (!(resortTransferList = FlowUtils.resortTransfers(transfers = gaiFlow.getTransfers(), start, actionList, end)).isEmpty()) {
            for (Transfer transfer : resortTransferList) {
                Integer fromNodeId = transfer.getFromNodeId();
                String fromNodeIdStr = String.valueOf(transfer.getFromNodeId());
                Integer toNodeId = transfer.getToNodeId();
                Condition gaiCondition = transfer.getCondition();
                if (!breakLoopNodeIdActionMap.containsKey(toNodeId)) continue;
                String innerNOPNodeId = String.format("%s_NOP", toNodeId);
                TransitionBuilder transitionBuilder = flowBuilder.transition(String.format("%s_%s_NOP_transfer", fromNodeId, toNodeId), String.format("%s_%s", fromNodeId, innerNOPNodeId), fromNodeIdStr, innerNOPNodeId, Transition.Type.NORMAL);
            }
            ArrayList<String> loopNextTransferList = new ArrayList<String>(1);
            for (Transfer transfer : resortTransferList) {
                String transferIdStr;
                String loopNext2LoopTransferId;
                Integer fromNodeId = transfer.getFromNodeId();
                String fromNodeIdStr = String.valueOf(transfer.getFromNodeId());
                Integer toNodeId = transfer.getToNodeId();
                String toNodeIdStr = String.valueOf(toNodeId);
                if (CollectionUtils.containsAny(loopNodeIdList, (Object[])new Integer[]{fromNodeId}) && !loopNextTransferList.contains(loopNext2LoopTransferId = String.format("%s_%s", fromNodeIdStr = String.format("%s_loop_next", fromNodeId), fromNodeId))) {
                    loopNextTransferList.add(loopNext2LoopTransferId);
                    String loopBreakVar = String.format("%s_%s", "loopBreak", fromNodeId);
                    ScriptCondition loopNextCondition = new ScriptCondition(String.format("!%s", loopBreakVar));
                    flowBuilder.transition(loopNext2LoopTransferId, loopNext2LoopTransferId, fromNodeIdStr, String.valueOf(fromNodeId), Transition.Type.NORMAL).setCondition((kd.ai.gai.flow.flow.core.plugin.Condition)loopNextCondition);
                }
                if (CollectionUtils.containsAny(loopNodeIdList, (Object[])new Integer[]{toNodeId})) {
                    toNodeIdStr = String.format("%s_loop_init", toNodeId);
                }
                TransitionBuilder transition = null;
                if (CollectionUtils.containsAny(parallelNodeIdList, (Object[])new Integer[]{fromNodeId})) {
                    fromNodeIdStr = String.format("%s_parallel_merge", fromNodeId);
                    transferIdStr = String.format("%s_parallel_transfer", transfer.getId());
                    transition = flowBuilder.transition(transferIdStr, String.format("%s_%s", fromNodeId, toNodeId), fromNodeIdStr, toNodeIdStr, Transition.Type.NORMAL);
                } else if (CollectionUtils.containsAny(parallelNodeIdList, (Object[])new Integer[]{toNodeId})) {
                    toNodeIdStr = String.format("%s_parallel_init", toNodeId);
                    transferIdStr = String.format("%s_parallel_transfer", transfer.getId());
                    transition = flowBuilder.transition(transferIdStr, String.format("%s_%s", fromNodeId, toNodeId), fromNodeIdStr, toNodeIdStr, Transition.Type.NORMAL);
                } else if (CollectionUtils.containsAny(parallelBlockInnerNodeIdList, (Object[])new Integer[]{fromNodeId})) {
                    int blockNodeId = gaiFlow.findActionById(fromNodeId).getBlockNodeId();
                    ParallelAction parallelAction = (ParallelAction)gaiFlow.findActionById(blockNodeId);
                    for (int i = 0; i < parallelAction.getParallelLimit(); ++i) {
                        fromNodeIdStr = String.format("parallel_sub_%s_%s", fromNodeId, i);
                        toNodeIdStr = String.format("parallel_sub_%s_%s", toNodeId, i);
                        String transferIdStr2 = String.format("%s_parallel_transfer_%s", transfer.getId(), i);
                        TransitionBuilder parallelTransition = flowBuilder.transition(transferIdStr2, String.format("%s_%s_%s", fromNodeId, toNodeId, i), fromNodeIdStr, toNodeIdStr, Transition.Type.NORMAL);
                        Condition gaiCondition = transfer.getCondition();
                        if (gaiCondition == null || gaiCondition.getConditionRows() == null) continue;
                        parallelTransition.setCondition((kd.ai.gai.flow.flow.core.plugin.Condition)new GaiCondition(context, gaiFlow, transfer, i));
                    }
                } else {
                    transition = flowBuilder.transition(String.valueOf(transfer.getId()), String.format("%s_%s", fromNodeId, toNodeId), fromNodeIdStr, toNodeIdStr, Transition.Type.NORMAL);
                }
                Condition gaiCondition = transfer.getCondition();
                if (transition == null || gaiCondition == null || gaiCondition.getConditionRows() == null) continue;
                transition.setCondition((kd.ai.gai.flow.flow.core.plugin.Condition)new GaiCondition(context, gaiFlow, transfer, -1));
            }
        }
        Flow flow = flowBuilder.end();
        flow.setAttribute(FlowAttribute.PARAM_MODE.name(), (Object)ParamMode.PROPERTY);
        return flow;
    }

    private static void buildParallelNode(Context context, kd.ai.gai.core.engine.flow.Flow gaiFlow, Action action, String nodeId, FlowBuilder flowBuilder, String nodeName, Map<Integer, List<Action>> blockInnerNodeIdActionListMap) {
        ParallelAction parallelAction = (ParallelAction)action;
        List<Var> varList = parallelAction.getVarList();
        String parallelInitNodeId = String.format("%s_parallel_init", nodeId);
        NodeBuilder parallelInitNode = flowBuilder.node(parallelInitNodeId, String.format("%s_\u5e76\u884c\u521d\u59cb\u5316", nodeName));
        parallelInitNode.andSplit();
        ArrayList<String> inputVarList = new ArrayList<String>();
        ArrayList outputVarList = new ArrayList();
        if (CollectionUtils.isNotEmpty(varList)) {
            for (Var var : varList) {
                String inputVarName = String.format("%s_%s_%s", "parallelBlockInput", var.getName(), action.getId());
                flowBuilder.variable(inputVarName, inputVarName, inputVarName, VarFieldType.toFlowDataType(var.getVarFieldType()));
                inputVarList.add(inputVarName);
            }
        }
        String parallelLimitVar = String.format("%s_%s_%s", "parallelBlockInput", "parallelLimit", action.getId());
        flowBuilder.variable(parallelLimitVar, parallelLimitVar, parallelLimitVar, VarFieldType.toFlowDataType(VarFieldType.INTEGER));
        inputVarList.add(parallelLimitVar);
        String parentMemoryPropertiesVarName = String.format("%s_%s_%s", "parallelBlockInput", "parentMemoryProperties", action.getId());
        flowBuilder.variable(parentMemoryPropertiesVarName, parentMemoryPropertiesVarName, parentMemoryPropertiesVarName, VarFieldType.toFlowDataType(VarFieldType.STRING));
        inputVarList.add(parentMemoryPropertiesVarName);
        parallelInitNode.biz((Application)new ParallelInitNodeApplication(context, gaiFlow, (ParallelAction)action));
        for (int i = 0; i < parallelAction.getParallelLimit(); ++i) {
            String parallelBlockInitNodeId = String.format("%s_%s_%s", nodeId, NODEID_PARALLEL_BLOCK_START, i);
            String parallelBlockInitNodeName = String.format("%s_\u5e76\u884c\u5f00\u59cb", nodeName);
            NodeBuilder parallelBlockInitNode = flowBuilder.node(parallelBlockInitNodeId, parallelBlockInitNodeName);
            parallelBlockInitNode.asyncBegin((TaskExecutor)GaiFlowTaskExecutor.INSTANCE.get(), (String[])inputVarList.stream().toArray(String[]::new), (String[])outputVarList.stream().toArray(String[]::new));
            parallelBlockInitNode.biz((Application)new ParallelBlockStartNodeApplication(context, gaiFlow, (ParallelAction)action, i));
            String parallelInitTransferNodeId = String.format("%s_parallel_init_transfer_%s", nodeId, i);
            flowBuilder.transition(parallelInitTransferNodeId, parallelInitTransferNodeId, parallelInitNodeId, parallelBlockInitNodeId, Transition.Type.NORMAL);
            String parallelNodeId = String.format("parallel_%s_%s", nodeId, i);
            String parallelNodeName = String.format("parallel_%s_%s", nodeName, i);
            NodeBuilder nodeBuilder = flowBuilder.node(parallelNodeId, parallelNodeName);
            FlowUtils.buildParallelNode(context, gaiFlow, (ParallelAction)action, nodeId, flowBuilder, nodeName, blockInnerNodeIdActionListMap, nodeBuilder, i);
            flowBuilder.transition(parallelBlockInitNodeId, parallelBlockInitNodeId, parallelBlockInitNodeId, parallelNodeId, Transition.Type.NORMAL);
            String parallelBlockEndNodeId = String.format("%s_%s_%s", nodeId, NODEID_PARALLEL_BLOCK_END, i);
            String parallelBlockEndNodeName = String.format("%s_\u5e76\u884c\u7ed3\u675f", nodeName);
            NodeBuilder parallelBlockEndNode = flowBuilder.node(parallelBlockEndNodeId, parallelBlockEndNodeName);
            parallelBlockEndNode.asyncEnd();
            parallelBlockEndNode.biz((Application)new ParallelBlockEndNodeApplication(context, gaiFlow, (ParallelAction)action, i));
            flowBuilder.transition(parallelBlockEndNodeId, parallelBlockEndNodeId, parallelNodeId, parallelBlockEndNodeId, Transition.Type.NORMAL);
        }
        String parallelMergeNodeId = String.format("%s_parallel_merge", nodeId);
        NodeBuilder parallelMergeNode = flowBuilder.node(parallelMergeNodeId, String.format("%s_\u5e76\u884c\u6c47\u805a", nodeName));
        parallelMergeNode.biz((Application)new ParallelMergeNodeApplication(context, gaiFlow, (ParallelAction)action));
        parallelMergeNode.andMerge();
        for (int i = 0; i < parallelAction.getParallelLimit(); ++i) {
            String parallelBlockEndNodeId = String.format("%s_%s_%s", nodeId, NODEID_PARALLEL_BLOCK_END, i);
            String parallelMergeTransferNodeId = String.format("%s_parallel_merge_transfer_%s", nodeId, i);
            flowBuilder.transition(parallelMergeTransferNodeId, parallelMergeTransferNodeId, parallelBlockEndNodeId, parallelMergeNodeId, Transition.Type.NORMAL);
        }
    }

    private static List<Transfer> resortTransfers(List<Transfer> transfers, Start start, List<Action> actionList, End end) {
        List<Integer> outTransferOutList;
        ArrayList<Transfer> resortTransferList = new ArrayList<Transfer>(10);
        Map idTransferMap = transfers.stream().collect(Collectors.toMap(Transfer::getId, Function.identity(), (key1, key2) -> key2));
        ArrayList allTransferOutList = new ArrayList();
        ArrayList hasConditionTransferList = new ArrayList();
        List<Integer> startTransferOutList = start.getTransferOutList();
        if (startTransferOutList != null && !startTransferOutList.isEmpty()) {
            startTransferOutList.forEach(i -> {
                Transfer transfer = (Transfer)idTransferMap.get(i);
                if (transfer.getCondition() != null) {
                    hasConditionTransferList.add(transfer);
                } else {
                    allTransferOutList.add(i);
                }
            });
        }
        if (actionList != null && !actionList.isEmpty()) {
            actionList.forEach(action -> {
                List<Integer> transferOutList = action.getTransferOutList();
                if (transferOutList != null && !transferOutList.isEmpty()) {
                    transferOutList.forEach(i -> {
                        Transfer transfer = (Transfer)idTransferMap.get(i);
                        if (transfer.getCondition() != null) {
                            hasConditionTransferList.add(transfer);
                        } else {
                            allTransferOutList.add(i);
                        }
                    });
                }
            });
        }
        if ((outTransferOutList = end.getTransferOutList()) != null && !outTransferOutList.isEmpty()) {
            outTransferOutList.forEach(i -> {
                Transfer transfer = (Transfer)idTransferMap.get(i);
                if (transfer.getCondition() != null) {
                    hasConditionTransferList.add(transfer);
                } else {
                    allTransferOutList.add(i);
                }
            });
        }
        Collections.reverse(allTransferOutList);
        allTransferOutList.forEach(transferId -> {
            Transfer transfer = (Transfer)idTransferMap.get(transferId);
            if (transfer != null) {
                resortTransferList.add(transfer);
            }
        });
        if (!hasConditionTransferList.isEmpty()) {
            resortTransferList.addAll(hasConditionTransferList);
        }
        return resortTransferList;
    }

    private static void buildLoopNode(Context context, kd.ai.gai.core.engine.flow.Flow gaiFlow, LoopAction action, String nodeId, FlowBuilder flowBuilder, String nodeName, Map<Integer, List<Action>> blockInnerNodeIdActionListMap, NodeBuilder nodeBuilder) {
        List<Var> varList = action.getVarList();
        List<Action> blockInnerNodeActionList = blockInnerNodeIdActionListMap.get(action.getId());
        List breakLoopNodeIdList = blockInnerNodeActionList.stream().filter(subAction -> Short.parseShort(subAction.getType()) == ProcessNodeType.BreakLoop.getValue()).map(Node::getId).collect(Collectors.toList());
        if ((varList == null || varList.isEmpty()) && breakLoopNodeIdList.isEmpty()) {
            throw new KDBizException(Errors.flowLoopNoBreakLoop(action.getName()), new Object[0]);
        }
        String loopBreakVar = String.format("%s_%s", "loopBreak", nodeId);
        String loopIndexVar = String.format("%s_%s", "loopIndex", nodeId);
        String loopInitNodeId = String.format("%s_loop_init", nodeId);
        NodeBuilder loopInitNode = flowBuilder.node(loopInitNodeId, String.format("%s_\u5faa\u73af\u521d\u59cb\u5316", nodeName));
        String loopInitTransferNodeId = String.format("%s_loop_init_transfer", nodeId);
        flowBuilder.transition(loopInitTransferNodeId, loopInitTransferNodeId, loopInitNodeId, nodeId, Transition.Type.NORMAL);
        GroupBuilder group = flowBuilder.group(String.format("%s_loop_group", nodeId), String.format("%s_\u5faa\u73af\u4f53", nodeName));
        group.addMember(loopInitNodeId);
        group.variable(loopIndexVar, loopIndexVar, loopIndexVar, DataTypes.INTEGER);
        group.variable(loopBreakVar, loopBreakVar, loopBreakVar, DataTypes.BOOLEAN);
        loopInitNode.biz((Application)new LoopInitNodeApplication(context, gaiFlow, action));
        List<Action> blockNodeActionList = blockInnerNodeIdActionListMap.get(Integer.parseInt(nodeId));
        ArrayList blockStartNodeIdList = new ArrayList(10);
        ArrayList breakLoopActionList = new ArrayList(1);
        blockNodeActionList.forEach(nodeAction -> {
            String innerNodeId = String.valueOf(nodeAction.getId());
            String innerNOPNodeId = null;
            NodeBuilder innerNodeBuilder = nodeBuilder.node(innerNodeId, nodeAction.getName());
            ProcessNodeType innerNodeType = ProcessNodeType.valueOf(Integer.parseInt(nodeAction.getType()));
            switch (innerNodeType) {
                case Llm: {
                    innerNodeBuilder.biz((Application)new PromptNodeApplication(context, gaiFlow, (LLMAction)nodeAction), (Callback)new PromptNodeCallback());
                    break;
                }
                case CusOption: {
                    innerNodeBuilder.biz((Application)new JavaActionNodeApplication(context, gaiFlow, (JavaPluginAction)nodeAction, -1));
                    break;
                }
                case Message: {
                    innerNodeBuilder.biz((Application)new MessageNodeApplication(context, gaiFlow, (MessageAction)nodeAction, -1));
                    break;
                }
                case AskUser: {
                    innerNodeBuilder.biz((Application)new AskUserNodeApplication(context, gaiFlow, (AskUserAction)nodeAction), (Callback)new AskUserNodeCallback());
                    break;
                }
                case Repo: {
                    innerNodeBuilder.biz((Application)new RepoNodeApplication(context, gaiFlow, (RepoAction)nodeAction, -1));
                    break;
                }
                case RepoReply: {
                    innerNodeBuilder.biz((Application)new RepoReplyNodeApplication(context, gaiFlow, (RepoReplyAction)nodeAction, -1), (Callback)new RepoReplyNodeCallback());
                    break;
                }
                case SetVariable: {
                    innerNodeBuilder.biz((Application)new SetVariableNodeApplication(context, gaiFlow, (SetVariableAction)nodeAction));
                    break;
                }
                case BreakLoop: {
                    innerNodeBuilder.biz((Application)new BreakLoopNodeApplication(context, gaiFlow, (BreakLoopAction)nodeAction));
                    breakLoopActionList.add((BreakLoopAction)nodeAction);
                    break;
                }
                case StartLoop: {
                    innerNodeBuilder.biz((Application)new StartLoopNodeApplication(context, gaiFlow, (StartLoopAction)nodeAction));
                    break;
                }
                case Code: {
                    innerNodeBuilder.biz((Application)new CodeNodeApplication(context, gaiFlow, (CodeAction)nodeAction, -1));
                    break;
                }
                case Tool: {
                    innerNodeBuilder.biz((Application)new ToolNodeApplication(context, gaiFlow, (ToolAction)nodeAction, -1));
                    break;
                }
                default: {
                    throw new KDBizException(Errors.notSupportActionType(nodeAction.getClass().getName()), new Object[0]);
                }
            }
            group.addMember(innerNodeId);
            if (StringUtils.isNotEmpty(innerNOPNodeId)) {
                group.addMember(innerNOPNodeId);
            }
            if (nodeAction.getTransferInList() == null || nodeAction.getTransferInList().isEmpty()) {
                blockStartNodeIdList.add(nodeAction.getId());
            }
        });
        breakLoopActionList.forEach(breakLoopAction -> {
            String innerNOPNodeId = String.format("%s_NOP", breakLoopAction.getId());
            NodeBuilder innerNodeBuilder = nodeBuilder.node(innerNOPNodeId, String.format("%s_\u7a7a\u64cd\u4f5c", breakLoopAction.getName()));
            innerNodeBuilder.biz((Application)new NOPNodeApplication(context, gaiFlow, (Action)breakLoopAction));
        });
        String loopNextNodeId = String.format("%s_loop_next", nodeId);
        NodeBuilder loopNextNode = flowBuilder.node(loopNextNodeId, String.format("%s_\u5faa\u73af\u5224\u65ad", nodeName));
        loopNextNode.biz((Application)new LoopNextNodeApplication(context, gaiFlow, action));
        String loopNextTransferNodeId = String.format("%s_loop_next_transfer", nodeId);
        flowBuilder.transition(loopNextTransferNodeId, loopNextTransferNodeId, nodeId, loopNextNodeId, Transition.Type.NORMAL);
        group.addMember(loopNextNodeId);
    }

    private static void buildParallelNode(Context context, kd.ai.gai.core.engine.flow.Flow gaiFlow, ParallelAction action, String nodeId, FlowBuilder flowBuilder, String nodeName, Map<Integer, List<Action>> blockInnerNodeIdActionListMap, NodeBuilder nodeBuilder, int parallelIndex) {
        List<Action> blockInnerNodeActionList = blockInnerNodeIdActionListMap.get(Integer.parseInt(nodeId));
        blockInnerNodeActionList.forEach(nodeAction -> {
            String innerNodeId = String.format("parallel_sub_%s_%s", nodeAction.getId(), parallelIndex);
            String innerNodeName = nodeAction.getName();
            NodeBuilder innerNodeBuilder = nodeBuilder.node(innerNodeId, innerNodeName);
            ProcessNodeType innerNodeType = ProcessNodeType.valueOf(Integer.parseInt(nodeAction.getType()));
            switch (innerNodeType) {
                case Llm: {
                    innerNodeBuilder.biz((Application)new PromptNodeApplication(context, gaiFlow, (LLMAction)nodeAction, parallelIndex));
                    break;
                }
                case Message: {
                    innerNodeBuilder.biz((Application)new MessageNodeApplication(context, gaiFlow, (MessageAction)nodeAction, parallelIndex));
                    break;
                }
                case Code: {
                    innerNodeBuilder.biz((Application)new CodeNodeApplication(context, gaiFlow, (CodeAction)nodeAction, parallelIndex));
                    break;
                }
                case CusOption: {
                    innerNodeBuilder.biz((Application)new JavaActionNodeApplication(context, gaiFlow, (JavaPluginAction)nodeAction, parallelIndex));
                    break;
                }
                case Repo: {
                    innerNodeBuilder.biz((Application)new RepoNodeApplication(context, gaiFlow, (RepoAction)nodeAction, parallelIndex));
                    break;
                }
                case RepoReply: {
                    innerNodeBuilder.biz((Application)new RepoReplyNodeApplication(context, gaiFlow, (RepoReplyAction)nodeAction, parallelIndex));
                    break;
                }
                case StartParallel: {
                    innerNodeBuilder.multiChoice();
                    innerNodeBuilder.biz((Application)new StartParallelNodeApplication(context, gaiFlow, (StartParallelAction)nodeAction, parallelIndex));
                    break;
                }
                default: {
                    throw new KDBizException(Errors.notSupportActionType(nodeAction.getClass().getName()), new Object[0]);
                }
            }
            if (nodeAction.getTransferInList() != null && nodeAction.getTransferInList().size() > 1) {
                innerNodeBuilder.smartMerge();
            }
        });
    }

    public static Map<String, Object> getMemoryProperties(Execution e) {
        String doubleSuffix = ".0";
        Map properties = e.getMemory().getProperties();
        LinkedHashMap<String, Object> newProperties = new LinkedHashMap<String, Object>(properties.size());
        if (!properties.isEmpty()) {
            for (Map.Entry entry : properties.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof Double) {
                    if (value.toString().endsWith(doubleSuffix)) {
                        value = (long)Double.parseDouble(value.toString());
                    }
                } else if (value instanceof ArrayList) {
                    Object first;
                    boolean isIntegerArray = false;
                    List objList = (List)value;
                    if (!objList.isEmpty() && (first = objList.get(0)) instanceof Double) {
                        isIntegerArray = true;
                        for (Object obj : objList) {
                            if (!(obj instanceof Double) || obj.toString().endsWith(doubleSuffix)) continue;
                            isIntegerArray = false;
                            break;
                        }
                    }
                    if (isIntegerArray) {
                        value = JSONArray.parseArray((String)JSONObject.toJSONString(value), Long.class);
                    }
                }
                newProperties.put((String)entry.getKey(), value);
            }
        }
        return newProperties;
    }

    public static String getVarValue(Context context, String propertyName, Execution e) {
        return FlowUtils.getVarValue(context, propertyName, e, -1);
    }

    public static String getVarValue(Context context, String propertyName, Execution e, int parallelIndex) {
        Object varValue = FlowUtils.getVarValue(context, propertyName, e, VarFieldType.STRING, parallelIndex);
        if (varValue instanceof List || varValue instanceof Object[]) {
            varValue = JSONObject.toJSONString((Object)varValue);
        }
        return varValue != null ? varValue + "" : "";
    }

    public static String getPurePropertyName(String propertyName) {
        return propertyName.replace("VAR_VALUE_", "").replace("VAR_TYPE_", "");
    }

    public static Object getVarValue(Context context, String propertyName, Execution e, VarFieldType varFieldType) {
        return FlowUtils.getVarValue(context, propertyName, e, varFieldType, -1);
    }

    public static Object getVarValue(Context context, String propertyName, Execution e, VarFieldType varFieldType, int parallelIndex) {
        Map<String, Object> outDataMap = FlowUtils.getMemoryProperties(e);
        if ("0.system.chat_history".equals(FlowUtils.getPurePropertyName(propertyName))) {
            UserHistoryMessage[] userHistoryMessage = ChatHistoryService.getByChatSessionId(200, context.getChatSessionId());
            return userHistoryMessage.length > 0 ? JsonUtil.toJson(userHistoryMessage) : outDataMap.getOrDefault("0.system.user_input", "") + "";
        }
        if ("0.system.chat_sessionid".equals(FlowUtils.getPurePropertyName(propertyName))) {
            return context.getChatSessionId();
        }
        if (StringUtils.contains((CharSequence)propertyName, (CharSequence)"{{item}}")) {
            String outVarName = propertyName.replace("VAR_VALUE_", "").replace("VAR_TYPE_", "");
            outVarName = outVarName.replace(String.format(".%s", "{{item}}"), "");
            String[] split = outVarName.split("\\.", 2);
            int outNodeId = Integer.parseInt(split[0]);
            outVarName = split[1];
            Object value = outDataMap.get(FlowUtils.getPropertyName(outNodeId, outVarName));
            List valueList = new ArrayList(1);
            if (value instanceof List) {
                valueList = (List)value;
            } else if (value instanceof Object[]) {
                Collections.addAll(valueList, (Object[])value);
            }
            int loopIndex = parallelIndex;
            if (parallelIndex == -1) {
                String loopIndexVarName = String.format("%s.%s", outVarName, "{{index}}");
                loopIndex = (int)Double.parseDouble(outDataMap.get(FlowUtils.getPropertyName(outNodeId, loopIndexVarName)).toString());
            }
            value = valueList.get(loopIndex);
            if (varFieldType == VarFieldType.INTEGER) {
                value = (long)Double.parseDouble(value.toString());
            }
            return value;
        }
        if (StringUtils.contains((CharSequence)propertyName, (CharSequence)"{{index}}")) {
            if (parallelIndex != -1) {
                return parallelIndex;
            }
            return FlowUtils.getVarLoopIndex(propertyName, outDataMap);
        }
        Object value = outDataMap.get(propertyName);
        String outVarName = propertyName.replace("VAR_VALUE_", "").replace("VAR_TYPE_", "");
        String[] split = outVarName.split("\\.", 2);
        int outNodeId = Integer.parseInt(split[0]);
        outVarName = split[1];
        if (!outVarName.startsWith("system.") && StringUtils.contains((CharSequence)outVarName, (CharSequence)".")) {
            String[] loopVarArr = outVarName.split("\\.", 2);
            outVarName = loopVarArr[0];
            String itemKey = loopVarArr[1];
            value = outDataMap.get(FlowUtils.getPropertyName(outNodeId, outVarName));
            int varLoopIndex = parallelIndex;
            if (parallelIndex == -1) {
                String loopIndexVarName = String.format("%s.%s", outVarName, "{{index}}");
                varLoopIndex = (int)Double.parseDouble(outDataMap.get(FlowUtils.getPropertyName(outNodeId, loopIndexVarName)).toString());
            }
            List valueList = new ArrayList(1);
            if (value instanceof List) {
                valueList = (List)value;
            } else if (value instanceof Object[]) {
                Collections.addAll(valueList, (Object[])value);
            }
            if (CollectionUtils.isNotEmpty(valueList)) {
                JSONObject itemJo = JSONObject.parseObject((String)JSONObject.toJSONString(valueList.get(varLoopIndex)));
                value = itemJo.get((Object)itemKey);
            }
        }
        if (varFieldType == VarFieldType.INTEGER) {
            return (long)Double.parseDouble(value.toString());
        }
        if (varFieldType == VarFieldType.ARRAY_INTEGER) {
            return ObjectUtils.isEmpty((Object)value) ? new ArrayList() : JSONObject.parseArray((String)value.toString(), Integer.class);
        }
        if (varFieldType == VarFieldType.ARRAY_STRING) {
            return ObjectUtils.isEmpty((Object)value) ? new ArrayList() : JSONObject.parseArray((String)value.toString(), String.class);
        }
        if (varFieldType == VarFieldType.ARRAY_OBJECT) {
            return ObjectUtils.isEmpty((Object)value) ? new ArrayList() : JSONObject.parseArray((String)value.toString(), JSONObject.class);
        }
        return value;
    }

    public static Object getFlowVarValue(String propertyName, Execution e, VarFieldType varFieldType) {
        Object value = e.get(propertyName);
        if (varFieldType == VarFieldType.INTEGER) {
            return (long)Double.parseDouble(value.toString());
        }
        if (varFieldType == VarFieldType.ARRAY_INTEGER) {
            return ObjectUtils.isEmpty((Object)value) ? new ArrayList() : JSONObject.parseArray((String)JSONObject.toJSONString((Object)value), Integer.class);
        }
        if (varFieldType == VarFieldType.ARRAY_STRING) {
            return ObjectUtils.isEmpty((Object)value) ? new ArrayList() : JSONObject.parseArray((String)JSONObject.toJSONString((Object)value), String.class);
        }
        if (varFieldType == VarFieldType.ARRAY_OBJECT) {
            return ObjectUtils.isEmpty((Object)value) ? new ArrayList() : JSONObject.parseArray((String)value.toString(), JSONObject.class);
        }
        return value;
    }

    private static int getVarLoopIndex(String propertyName, Map<String, Object> outDataMap) {
        String outVarName = propertyName.replace("VAR_VALUE_", "").replace("VAR_TYPE_", "");
        outVarName = outVarName.replace(String.format(".%s", "{{index}}"), "");
        String[] split = outVarName.split("\\.", 2);
        int outNodeId = Integer.parseInt(split[0]);
        outVarName = split[1];
        String loopIndexVarName = String.format("%s.%s", outVarName, "{{index}}");
        return (int)Double.parseDouble(outDataMap.get(FlowUtils.getPropertyName(outNodeId, loopIndexVarName)).toString());
    }

    public static Map<String, String> buildInputData(Context context, Action action, Execution e, int parallelIndex) {
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        if (action.getInParamMap() != null) {
            for (VarMapper varMapper : action.getInParamMap()) {
                if ("system.chat_history".equals(varMapper.getOutVarName())) {
                    UserHistoryMessage[] userHistoryMessage = ChatHistoryService.getByChatSessionId(200, context.getChatSessionId());
                    data.put(varMapper.getInVarName(), JsonUtil.toJson(userHistoryMessage));
                    continue;
                }
                if ("system.chat_sessionid".equals(varMapper.getOutVarName())) {
                    data.put(varMapper.getInVarName(), context.getChatSessionId());
                    continue;
                }
                String outVarName = varMapper.getOutVarName();
                if ("user_input".equals(outVarName)) {
                    outVarName = "system.user_input";
                }
                String varValue = FlowUtils.getVarValue(context, FlowUtils.getPropertyName(varMapper.getOutNodeId(), outVarName), e, parallelIndex);
                data.put(varMapper.getInVarName(), varValue);
            }
        } else {
            log.warn("action {} \u6ca1\u6709\u914d\u7f6e\u8f93\u5165\u53c2\u6570\u7684\u503c\u6620\u5c04\u5173\u7cfb\u3002");
        }
        if (action instanceof JavaPluginAction) {
            data.put("PAGE_ID", context.getBizPageId());
            data.put("ROOT_PAGE_ID", context.getRootPageId());
        }
        return data;
    }

    public static List<MsgNodeMessage.MessageElement> toMessages(Context context, List<Var> vars, List<VarMapper> mapperList, Action action, Execution e) {
        return FlowUtils.toMessages(context, vars, mapperList, action, e, -1);
    }

    public static List<MsgNodeMessage.MessageElement> toMessages(Context context, List<Var> vars, List<VarMapper> mapperList, Action action, Execution e, int parallelIndex) {
        ArrayList<MsgNodeMessage.MessageElement> elementList = new ArrayList<MsgNodeMessage.MessageElement>();
        if (vars != null) {
            Map varMapperMap = Optional.ofNullable(mapperList).map(map -> map.stream().collect(Collectors.toMap(VarMapper::getInVarName, Function.identity(), (key1, key2) -> key2))).orElseGet(HashMap::new);
            for (Var var : vars) {
                MsgNodeMessage.MessageElement messageElement = new MsgNodeMessage.MessageElement();
                elementList.add(messageElement);
                messageElement.setType(var.getType());
                if (var.isInput()) {
                    messageElement.setValue(var.getValue());
                    FlowUtils.setNodeProperty(e, action.getId(), var.getName(), var.getValue());
                    continue;
                }
                VarMapper varMapper = (VarMapper)varMapperMap.get(var.getName());
                if (varMapper == null) continue;
                if ("system.chat_history".equals(varMapper.getOutVarName())) {
                    UserHistoryMessage[] userHistoryMessage = ChatHistoryService.getByChatSessionId(200, context.getChatSessionId());
                    messageElement.setValue(JsonUtil.toJson(userHistoryMessage));
                    FlowUtils.setNodeProperty(e, action.getId(), var.getName(), JsonUtil.toJson(userHistoryMessage));
                    continue;
                }
                if ("system.chat_sessionid".equals(varMapper.getOutVarName())) {
                    messageElement.setValue(context.getChatSessionId());
                    FlowUtils.setNodeProperty(e, action.getId(), var.getName(), context.getChatSessionId());
                    continue;
                }
                if (!varMapper.getInVarName().equals(var.getName())) continue;
                String outVarName = varMapper.getOutVarName();
                String varValue = FlowUtils.getVarValue(context, FlowUtils.getPropertyName(varMapper.getOutNodeId(), outVarName), e, parallelIndex);
                messageElement.setValue(varValue + "");
                FlowUtils.setNodeProperty(e, action.getId(), var.getName(), varValue);
            }
        }
        return elementList;
    }

    public static String getPropertyName(int nodeId, String varName) {
        return String.format("%s%s.%s", "VAR_VALUE_", nodeId, varName);
    }

    public static String getPropertyTypeName(int nodeId, String varName) {
        return String.format("%s%s.%s", "VAR_TYPE_", nodeId, varName);
    }

    public static void loadParentProperties(Execution e) {
        Execution parentExecution = e.getParent();
        Map<String, Object> properties = FlowUtils.getMemoryProperties(parentExecution);
        if (!properties.isEmpty()) {
            DataArea memory = e.getMemory();
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                String key = entry.getKey();
                if (StringUtils.containsAny((CharSequence)key, (CharSequence[])new CharSequence[]{"loopIndex", String.format(".%s", "{{index}}")}) && entry.getValue() instanceof Number) {
                    memory.setProperty(key, (Object)((int)Double.parseDouble(entry.getValue().toString())));
                    continue;
                }
                memory.setProperty(key, entry.getValue());
            }
        }
    }

    public static void setNodeProperty(Execution execution, int nodeId, String varName, Object varValue) {
        DataArea memory = execution.getMemory();
        memory.setProperty(FlowUtils.getPropertyName(nodeId, varName), varValue);
    }

    public static void setNodeProperties(Execution execution, int nodeId, Map<String, ?> data) {
        if (data != null && !data.isEmpty()) {
            DataArea memory = execution.getMemory();
            for (Map.Entry<String, ?> entry : data.entrySet()) {
                memory.setProperty(FlowUtils.getPropertyName(nodeId, entry.getKey()), entry.getValue());
            }
        }
    }

    public static void copyNodeProperties(Execution execution, Map<String, ?> data) {
        if (data != null && !data.isEmpty()) {
            DataArea memory = execution.getMemory();
            for (Map.Entry<String, ?> entry : data.entrySet()) {
                memory.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    public static Object getNodeProperty(Execution execution, int nodeId, String varName) {
        return execution.getMemory().getProperty(FlowUtils.getPropertyName(nodeId, varName));
    }

    public static String getNodePropertyStr(Execution execution, int nodeId, String varName) {
        Object value = execution.getMemory().getProperty(FlowUtils.getPropertyName(nodeId, varName));
        return value != null ? (String)value : "";
    }

    public static Condition.ValueType getNodePropertyValueType(Context context, kd.ai.gai.core.engine.flow.Flow gaiFlow, Execution execution, int nodeId, String varName, int parallelIndex) {
        if (varName.contains("{{index}}")) {
            return Condition.ValueType.DECIMAL;
        }
        if (varName.contains("{{item}}")) {
            Action action = gaiFlow.findActionById(nodeId);
            if (action.isLoopBlockNode()) {
                return FlowUtils.getArrayItemValueType(varName, ((LoopAction)action).getVarList());
            }
            if (action.isParallelBlockNode()) {
                return FlowUtils.getArrayItemValueType(varName, ((ParallelAction)action).getVarList());
            }
            return Condition.ValueType.TEXT;
        }
        String value = FlowUtils.getVarValue(context, FlowUtils.getPropertyTypeName(nodeId, varName), execution, parallelIndex);
        return StringUtils.isNotEmpty((CharSequence)value) ? Condition.ValueType.valueOf(value) : Condition.ValueType.TEXT;
    }

    private static Condition.ValueType getArrayItemValueType(String varName, List<Var> varList) {
        VarFieldType itemVarFieldType;
        Map<Object, Object> varMap = varList != null ? varList.stream().collect(Collectors.toMap(Var::getName, Function.identity(), (key1, key2) -> key2)) : Collections.emptyMap();
        Var var = (Var)varMap.get(varName.split("\\.", 2)[0]);
        if (var != null && (itemVarFieldType = var.getItemVarFieldType()).getType().equals(VarFieldType.INTEGER.getType())) {
            return Condition.ValueType.DECIMAL;
        }
        return Condition.ValueType.TEXT;
    }

    public static void setNodePropertyConditionVarType(Execution execution, int nodeId, String varName, String varType) {
        DataArea memory = execution.getMemory();
        Condition.ValueType conditionVarType = Condition.ValueType.TEXT;
        VarFieldType varFieldType = VarFieldType.parse(varType);
        if (varFieldType == VarFieldType.INTEGER) {
            conditionVarType = Condition.ValueType.DECIMAL;
        }
        memory.setProperty(FlowUtils.getPropertyTypeName(nodeId, varName), (Object)conditionVarType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void signalFlow(String chatSessionId, long flowId, Object params) {
        FlowRuntime runtime = FlowCacheData.getRuntime(chatSessionId, flowId);
        if (runtime == null) {
            throw new KDBizException(Errors.flowInstanceNotExisted(flowId), new Object[0]);
        }
        String lastExecutionId = runtime.getLastExecution().getId();
        try {
            runtime.inject(lastExecutionId, params);
            runtime.signal(lastExecutionId);
        }
        catch (AsyncThreadsFailedException ex) {
            log.error("\u5f02\u6b65\u5206\u652f\u7ebf\u7a0b\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            FlowUtils.throwSuppressedException(ex);
        }
        finally {
            if (runtime.isClosed()) {
                FlowCacheData.clearCache(chatSessionId, "FLOW_RUNTIME_DOC");
            } else {
                FlowCacheData.putRuntimeDoc(chatSessionId, flowId, runtime);
            }
        }
    }

    public static void signal(String chatSessionId, long flowId, Object params) {
        FlowRuntimeLock.invokeWithLock(chatSessionId, flowId, () -> FlowUtils.signalFlow(chatSessionId, flowId, params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resumeFlow(String chatSessionId, long flowId) {
        FlowRuntime runtime = FlowCacheData.getRuntime(chatSessionId, flowId);
        if (runtime == null) {
            throw new KDBizException(Errors.flowInstanceNotExisted(flowId), new Object[0]);
        }
        try {
            runtime.resume();
        }
        catch (AsyncThreadsFailedException ex) {
            log.error("\u5f02\u6b65\u5206\u652f\u7ebf\u7a0b\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            FlowUtils.throwSuppressedException(ex);
        }
        finally {
            if (runtime.isClosed()) {
                FlowCacheData.clearCache(chatSessionId, "FLOW_RUNTIME_DOC");
            } else {
                FlowCacheData.putRuntimeDoc(chatSessionId, flowId, runtime);
            }
        }
    }

    public static void resume(String chatSessionId, long flowId) {
        FlowRuntimeLock.invokeWithLock(chatSessionId, flowId, () -> FlowUtils.resumeFlow(chatSessionId, flowId));
    }

    private static void resumeFlowFromDebug(String chatSessionId, long flowId, Map<String, Object> params) {
        FlowRuntime runtime = FlowCacheData.getRuntime(chatSessionId, flowId);
        if (runtime == null) {
            throw new KDBizException(Errors.flowInstanceNotExisted(flowId), new Object[0]);
        }
        String debugInfo = (String)params.get(FlowUtils.getPropertyName(0, "debug_info"));
        FlowUtils.setNodeProperty(runtime.getLastExecution(), 0, "debug_info", debugInfo);
        FlowUtils.resumeFlow(chatSessionId, flowId);
    }

    public static void resumeFromDebug(String chatSessionId, long flowId, Map<String, Object> params) {
        FlowRuntimeLock.invokeWithLock(chatSessionId, flowId, () -> FlowUtils.resumeFlowFromDebug(chatSessionId, flowId, params));
    }

    public static void suspend(String chatSessionId, long flowId, FlowRuntime runtime) {
        runtime.suspend();
    }

    private static void addExtendParamDefinitions(kd.ai.gai.core.engine.flow.Flow gaiFlow, Map<String, String> inParams) {
        String flowParamMode = gaiFlow.getParamMode();
        ParamMode paramMode = kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)flowParamMode) ? ParamMode.PROPERTY : ParamMode.valueOf(flowParamMode);
        if (paramMode == ParamMode.PROPERTY) {
            return;
        }
        Start start = gaiFlow.getStart();
        List<ParamDefinition> paramDefs = start.getInputParams();
        Map paramDefMap = paramDefs.stream().collect(Collectors.toMap(ParamDefinition::getName, Function.identity()));
        for (Map.Entry<String, String> entry : inParams.entrySet()) {
            String paramName = entry.getKey();
            if (paramDefMap.containsKey(paramName)) continue;
            BasicParamDefinition paramDefinition = ParamDefinitionBuilder.string(paramName).constant(entry.getValue()).asBoth().makePublic().build();
            start.addParam("system", paramDefinition);
        }
    }

    public static Result startFlow(Context context, StartFlowMessage message) {
        FlowCacheData.clearCache(context.getChatSessionId(), "flowCancelled");
        IUserFeedbackService.create().reportUserFeedback(new UserFeedbackEventParams(context.getSlideenv(), context.getChatTraceId(), context.getTraceId(), UserFeedbackTypeEnum.OK.getId(), KDDateUtils.now().getTime()));
        HashMap<String, String> inParams = message.getInParams() != null ? message.getInParams() : new HashMap<String, String>();
        FlowUtils.extractUserAttachments(inParams, message.getUserInput());
        message.setInParams(inParams);
        Consumer beforeFlowCacheAction = gaiFlow -> FlowUtils.addExtendParamDefinitions(gaiFlow, inParams);
        kd.ai.gai.core.engine.flow.Flow gaiFlow2 = FlowCacheData.createFlow(message.getChatSessionId(), message.getProcessId(), (Consumer<kd.ai.gai.core.engine.flow.Flow>)beforeFlowCacheAction);
        return FlowRuntimeLock.invokeWithLock(context.getChatSessionId(), gaiFlow2.getId(), () -> FlowUtils.executeFlow(context, message, gaiFlow2));
    }

    private static Result executeFlow(Context context, StartFlowMessage message, kd.ai.gai.core.engine.flow.Flow gaiFlow) {
        Object[] inArgs = new Object[]{JSONObject.toJSONString((Object)message)};
        Flow flow = FlowUtils.buildFlow(context, gaiFlow);
        TraceUtil.startFlow(context, gaiFlow, message.getProcessId());
        IAppCache appCache = EngineCache.getAppCache(context.getChatSessionId());
        String traceId = (String)appCache.get(TraceUtil.flowTraceKey(gaiFlow.getId()), String.class);
        log.info("--------flow.dumpDiagram--------\n{}", (Object)flow.dumpDiagram());
        FlowRuntime runtime = flow.newInstance();
        runtime.setProfile(Profile.DEBUG);
        try {
            runtime.execute(inArgs);
        }
        catch (AsyncThreadsFailedException ex) {
            log.error("\u5f02\u6b65\u5206\u652f\u7ebf\u7a0b\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            FlowUtils.throwSuppressedException(ex);
        }
        if (!runtime.isClosed()) {
            FlowCacheData.putRuntimeDoc(context.getChatSessionId(), gaiFlow.getId(), runtime);
        }
        Result result = new Result(Errors.OK);
        result.setTraceId(traceId);
        return result;
    }

    private static void throwSuppressedException(AsyncThreadsFailedException ex) {
        Throwable[] throwables = ex.getSuppressed();
        if (throwables == null || throwables.length == 0) {
            throw ex;
        }
        Throwable throwable = throwables[0];
        if (throwable instanceof KDException) {
            throw (KDException)throwable;
        }
        if (throwable instanceof kd.ai.gai.exception.KDException) {
            throw (kd.ai.gai.exception.KDException)throwable;
        }
        throw new RuntimeException(throwable);
    }

    public static void extractUserAttachments(Map<String, String> inParams, String userInput) {
        String plainUserInput = AnnotationService.clearTags(userInput);
        List<String> fileIdList = AnnotationService.parseCosmicFile(userInput);
        List<Long> userAttachmentIdList = FileService.queryAttPkIdList(fileIdList);
        String userAttachmentIds = StringUtils.join(userAttachmentIdList, (String)",");
        String userGaiAttachmentIds = StringUtils.join(fileIdList, (String)",");
        inParams.put("system.user_attachments", userAttachmentIds);
        inParams.put("system.user_gai_attachments_id", userGaiAttachmentIds);
        inParams.put("system.user_input", StringUtils.defaultString((String)plainUserInput));
    }

    public static String getUserInput(Context context, kd.ai.gai.core.engine.flow.Flow flow, Execution e) {
        return FlowUtils.getVarValue(context, FlowUtils.getPropertyName(flow.getStart().getId(), "system.user_input"), e);
    }

    public static String fillCode(String code, String inVarName, String varValue) {
        varValue = StringUtils.replace((String)varValue, (String)"'", (String)"\\'");
        String varTempate = String.format("{{%s}}", inVarName);
        return StringUtils.replace((String)code, (String)varTempate, (String)String.format("'%s'", varValue));
    }

    public static void stopChat(Context context, String taskId, String flowId) {
        StopStreamMessage stopStreamMessage = new StopStreamMessage();
        stopStreamMessage.setTaskId(taskId);
        stopStreamMessage.setFlowId(kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)flowId) ? 0L : Long.parseLong(flowId));
        HandlerFactory.runHandler(context, stopStreamMessage);
    }

    public static ParamMode getParamMode(Execution e) {
        Object value = e.getDefine().getFlow().getAttribute(FlowAttribute.PARAM_MODE.name());
        if (value == null) {
            return ParamMode.PROPERTY;
        }
        return (ParamMode)((Object)value);
    }

    public static boolean isStopped(String chatSessionId) {
        String cache = FlowCacheData.getCache(chatSessionId, "flowCancelled");
        log.info("isStopped:{}", (Object)cache);
        return Boolean.parseBoolean(cache);
    }
}

