/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.util;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.field.type.OutFieldType;
import kd.ai.gai.core.enuz.field.type.VarFieldType;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.ai.gai.core.service.AiccService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;

public class GaiFieldTypeInitUtils {
    public static List<ComboItem> createLlmComboItem(String type, String id) {
        List<Map<String, Object>> serviceList = AiccService.getLlmList();
        GaiFieldTypeInitUtils.updateCache(serviceList);
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(serviceList.size());
        block10: for (Map<String, Object> service : serviceList) {
            String instanceMsg;
            boolean isLimit = (Boolean)service.get("limit");
            if (type != null && isLimit) {
                switch (type) {
                    case "process": {
                        String processId = service.get("processIdsTag").toString();
                        List<String> processIds = Arrays.asList(processId.split(","));
                        if (processIds.contains(id)) break;
                        continue block10;
                    }
                    case "prompt": {
                        String promptId = service.get("promptIdsTag").toString();
                        List<String> promptIds = Arrays.asList(promptId.split(","));
                        if (promptIds.contains(id)) break;
                        continue block10;
                    }
                    case "agent": {
                        String agentId = service.get("agentIdsTag").toString();
                        List<String> agentIds = Arrays.asList(agentId.split(","));
                        if (agentIds.contains(id)) break;
                        continue block10;
                    }
                }
            }
            ComboItem comboItem = new ComboItem();
            if (Boolean.TRUE.equals(service.get("active"))) {
                instanceMsg = "\uff08\u5b9e\u4f8b\u5df2\u914d\u7f6e\uff09";
                if (!RequestContext.get().getLang().getLangTag().equals("zh-CN")) {
                    instanceMsg = "(instance configured)";
                }
                comboItem.setCaption(new LocaleString(service.get("name") + instanceMsg));
            } else {
                instanceMsg = "\uff08\u5b9e\u4f8b\u672a\u914d\u7f6e\uff09";
                if (!RequestContext.get().getLang().getLangTag().equals("zh-CN")) {
                    instanceMsg = "(instance not configured)";
                }
                comboItem.setCaption(new LocaleString(service.get("name") + instanceMsg));
            }
            comboItem.setValue((String)service.get("number"));
            list.add(comboItem);
        }
        return list;
    }

    public static void updateCache(List<Map<String, Object>> serviceList) {
        String servicesKey = "serivceList";
        IAppCache cache = AppCache.get((String)("gai-" + RequestContext.get().getTenantId() + "_" + RequestContext.get().getTenantCode()));
        if (serviceList != null && !serviceList.isEmpty()) {
            cache.put(servicesKey, (Object)JSON.toJSONString(serviceList));
        }
    }

    public static List<Map> getServicesCache() {
        String servicesKey = "serivceList";
        IAppCache cache = AppCache.get((String)("gai-" + RequestContext.get().getTenantId() + "_" + RequestContext.get().getTenantCode()));
        String strs = (String)cache.get(servicesKey, String.class);
        return JSON.parseArray((String)strs, Map.class);
    }

    public static List<ComboItem> createRerankComboItem() {
        List<Map<String, Object>> serviceList = AiccService.getRerankList();
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(serviceList.size());
        for (Map<String, Object> service : serviceList) {
            ComboItem comboItem = new ComboItem();
            if (Boolean.TRUE.equals(service.get("active"))) {
                comboItem.setCaption(new LocaleString(service.get("name") + "\uff08\u5b9e\u4f8b\u5df2\u914d\u7f6e\uff09"));
            } else {
                comboItem.setCaption(new LocaleString(service.get("name") + "\uff08\u5b9e\u4f8b\u672a\u914d\u7f6e\uff09"));
            }
            comboItem.setValue((String)service.get("number"));
            list.add(comboItem);
        }
        return list;
    }

    public static List<ComboItem> createEmbeddingComboItem() {
        LLM[] llms = LLM.values();
        if (llms.length > 0) {
            List<String> instanceList = AiccService.getAiccInstanceListWithInstance();
            ArrayList<ComboItem> list = new ArrayList<ComboItem>(llms.length);
            for (LLM llm : llms) {
                if (!llm.isActive() || llm.getModelType() != LLM.ModelType.EMBEDDING) continue;
                ComboItem comboItem = new ComboItem();
                if (instanceList.contains(llm.getNumber())) {
                    comboItem.setCaption(new LocaleString(llm.getName() + "\uff08\u5b9e\u4f8b\u5df2\u914d\u7f6e\uff09"));
                } else {
                    comboItem.setCaption(new LocaleString(llm.getName() + "\uff08\u5b9e\u4f8b\u672a\u914d\u7f6e\uff09"));
                }
                comboItem.setValue(llm.getNumber());
                list.add(comboItem);
            }
            return list;
        }
        ErrorCode errorCode = new ErrorCode(GaiErrorCode.LANGUAGE_MODEL_INIT_ERROR.getCode(), GaiErrorCode.LANGUAGE_MODEL_INIT_ERROR.getMsg());
        throw new KDBizException(errorCode, new Object[0]);
    }

    public static List<ComboItem> createRepoEmbeddingComboItem() {
        LLM[] llms = LLM.values();
        if (llms.length > 0) {
            List<String> instanceList = AiccService.getAiccInstanceListWithInstance();
            ArrayList<ComboItem> list = new ArrayList<ComboItem>(llms.length);
            for (LLM llm : llms) {
                if (!llm.isActive() || llm.getModelType() != LLM.ModelType.EMBEDDING) continue;
                ComboItem comboItem = new ComboItem();
                if (instanceList.contains(llm.getNumber())) {
                    comboItem.setCaption(new LocaleString(llm.getName() + "\uff08\u5b9e\u4f8b\u5df2\u914d\u7f6e\uff09"));
                    comboItem.setValue(llm.getNumber());
                }
                list.add(comboItem);
            }
            return list;
        }
        ErrorCode errorCode = new ErrorCode(GaiErrorCode.LANGUAGE_MODEL_INIT_ERROR.getCode(), GaiErrorCode.LANGUAGE_MODEL_INIT_ERROR.getMsg());
        throw new KDBizException(errorCode, new Object[0]);
    }

    public static String getFirstEnableEmbedding() {
        LLM[] llmArr = LLM.values();
        if (llmArr.length > 0) {
            List<String> instanceList = AiccService.getAiccInstanceListWithInstance();
            for (LLM llm : llmArr) {
                if (!llm.isActive() || llm.getModelType() != LLM.ModelType.EMBEDDING || !instanceList.contains(llm.getNumber())) continue;
                return llm.getNumber();
            }
        }
        return null;
    }

    public static List<ComboItem> createParamTypeComboItem(ParamType[] types) {
        if (Objects.nonNull(types) && types.length > 0) {
            ArrayList<ComboItem> list = new ArrayList<ComboItem>(types.length);
            boolean hasArrayType = false;
            for (ParamType type : types) {
                if (type == ParamType.ARRAY) {
                    hasArrayType = true;
                    continue;
                }
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(type.getDesc()));
                comboItem.setValue(type.getDesc());
                list.add(comboItem);
            }
            if (hasArrayType) {
                for (ParamType type : types) {
                    if (type == ParamType.ARRAY) continue;
                    String comboValue = GaiFieldTypeInitUtils.buildDisplayedArrayType(type);
                    ComboItem comboItem = new ComboItem();
                    comboItem.setCaption(new LocaleString(comboValue));
                    comboItem.setValue(comboValue);
                    list.add(comboItem);
                }
            }
            return list;
        }
        ErrorCode errorCode = new ErrorCode(GaiErrorCode.PARAM_TYPE_INIT_ERROR.getCode(), GaiErrorCode.PARAM_TYPE_INIT_ERROR.getMsg());
        throw new KDBizException(errorCode, new Object[0]);
    }

    public static List<ComboItem> createParamTypeComboItem() {
        return GaiFieldTypeInitUtils.createParamTypeComboItem(ParamType.VALUES);
    }

    public static String buildDisplayedArrayType(ParamType itemType) {
        return ParamType.ARRAY.getDesc() + "<" + itemType.getDesc() + ">";
    }

    public static List<ComboItem> createVarTypeComboItem() {
        return GaiFieldTypeInitUtils.createVarTypeComboItem(VarFieldType.values());
    }

    public static List<ComboItem> createVarTypeComboItem(VarFieldType[] types) {
        if (Objects.nonNull(types) && types.length > 0) {
            ArrayList<ComboItem> list = new ArrayList<ComboItem>(types.length);
            for (VarFieldType type : types) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(type.getName()));
                comboItem.setValue(type.getType());
                list.add(comboItem);
            }
            return list;
        }
        ErrorCode errorCode = new ErrorCode(GaiErrorCode.VAR_FIELD_TYPE_INIT_ERROR.getCode(), GaiErrorCode.VAR_FIELD_TYPE_INIT_ERROR.getMsg());
        throw new KDBizException(errorCode, new Object[0]);
    }

    public static List<ComboItem> createOutTypeComboItem() {
        OutFieldType[] types = OutFieldType.values();
        if (Objects.nonNull(types) && types.length > 0) {
            ArrayList<ComboItem> list = new ArrayList<ComboItem>(types.length);
            for (OutFieldType type : types) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(type.getName()));
                comboItem.setValue(type.getType());
                list.add(comboItem);
            }
            return list;
        }
        ErrorCode errorCode = new ErrorCode(GaiErrorCode.OUT_FIELD_TYPE_INIT_ERROR.getCode(), GaiErrorCode.OUT_FIELD_TYPE_INIT_ERROR.getMsg());
        throw new KDBizException(errorCode, new Object[0]);
    }

    public static String getDefaultLLMService(String serviceNumber) {
        List<Map<String, Object>> serviceList = AiccService.getLlmList();
        if (serviceList.isEmpty()) {
            return serviceNumber;
        }
        List enbaleLLMList = serviceList.stream().filter(serviceMap -> Boolean.TRUE.equals(serviceMap.get("active"))).map(serviceMap -> (String)serviceMap.get("number")).collect(Collectors.toList());
        if (enbaleLLMList.isEmpty() || enbaleLLMList.contains(serviceNumber)) {
            return serviceNumber;
        }
        return (String)enbaleLLMList.get(0);
    }

    public static String getDefaultRerankService(String serviceNumber) {
        List<Map<String, Object>> serviceList = AiccService.getRerankList();
        if (serviceList.isEmpty()) {
            return null;
        }
        ArrayList<String> enableServiceList = new ArrayList<String>(serviceList.size());
        for (Map<String, Object> service : serviceList) {
            if (service.get("number").equals(serviceNumber) && Boolean.TRUE.equals(service.get("active"))) {
                return serviceNumber;
            }
            if (!Boolean.TRUE.equals(service.get("active"))) continue;
            enableServiceList.add((String)service.get("number"));
        }
        if (enableServiceList.isEmpty()) {
            return null;
        }
        return (String)enableServiceList.get(0);
    }
}

