/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSafeAccessor {
    private static final Logger log = LoggerFactory.getLogger(JsonSafeAccessor.class);

    private JsonSafeAccessor() {
    }

    public static String getString(JSONObject json, String key) {
        return JsonSafeAccessor.getString(json, key, null);
    }

    public static String getString(JSONObject json, String key, String defaultValue) {
        if (json == null || !json.containsKey((Object)key)) {
            return defaultValue;
        }
        try {
            return json.getString(key);
        }
        catch (Exception e) {
            log.debug("\u83b7\u53d6String\u503c\u5931\u8d25: key={}, value={}", new Object[]{key, json.get((Object)key), e});
            return defaultValue;
        }
    }

    public static Integer getInteger(JSONObject json, String key) {
        return JsonSafeAccessor.getInteger(json, key, null);
    }

    public static Integer getInteger(JSONObject json, String key, Integer defaultValue) {
        if (json == null || !json.containsKey((Object)key)) {
            return defaultValue;
        }
        try {
            return json.getInteger(key);
        }
        catch (Exception e) {
            log.debug("\u83b7\u53d6Integer\u503c\u5931\u8d25: key={}, value={}", new Object[]{key, json.get((Object)key), e});
            return defaultValue;
        }
    }

    public static Long getLong(JSONObject json, String key) {
        return JsonSafeAccessor.getLong(json, key, null);
    }

    public static Long getLong(JSONObject json, String key, Long defaultValue) {
        if (json == null || !json.containsKey((Object)key)) {
            return defaultValue;
        }
        try {
            return json.getLong(key);
        }
        catch (Exception e) {
            log.debug("\u83b7\u53d6Long\u503c\u5931\u8d25: key={}, value={}", new Object[]{key, json.get((Object)key), e});
            return defaultValue;
        }
    }

    public static Double getDouble(JSONObject json, String key) {
        return JsonSafeAccessor.getDouble(json, key, null);
    }

    public static Double getDouble(JSONObject json, String key, Double defaultValue) {
        if (json == null || !json.containsKey((Object)key)) {
            return defaultValue;
        }
        try {
            return json.getDouble(key);
        }
        catch (Exception e) {
            log.debug("\u83b7\u53d6Double\u503c\u5931\u8d25: key={}, value={}", new Object[]{key, json.get((Object)key), e});
            return defaultValue;
        }
    }

    public static Float getFloat(JSONObject json, String key) {
        return JsonSafeAccessor.getFloat(json, key, null);
    }

    public static Float getFloat(JSONObject json, String key, Float defaultValue) {
        if (json == null || !json.containsKey((Object)key)) {
            return defaultValue;
        }
        try {
            return json.getFloat(key);
        }
        catch (Exception e) {
            log.debug("\u83b7\u53d6Float\u503c\u5931\u8d25: key={}, value={}", new Object[]{key, json.get((Object)key), e});
            return defaultValue;
        }
    }

    public static Boolean getBoolean(JSONObject json, String key) {
        return JsonSafeAccessor.getBoolean(json, key, null);
    }

    public static Boolean getBoolean(JSONObject json, String key, Boolean defaultValue) {
        if (json == null || !json.containsKey((Object)key)) {
            return defaultValue;
        }
        try {
            return json.getBoolean(key);
        }
        catch (Exception e) {
            log.debug("\u83b7\u53d6Boolean\u503c\u5931\u8d25: key={}, value={}", new Object[]{key, json.get((Object)key), e});
            return defaultValue;
        }
    }

    public static BigDecimal getBigDecimal(JSONObject json, String key) {
        return JsonSafeAccessor.getBigDecimal(json, key, null);
    }

    public static BigDecimal getBigDecimal(JSONObject json, String key, BigDecimal defaultValue) {
        if (json == null || !json.containsKey((Object)key)) {
            return defaultValue;
        }
        try {
            return json.getBigDecimal(key);
        }
        catch (Exception e) {
            log.debug("\u83b7\u53d6BigDecimal\u503c\u5931\u8d25: key={}, value={}", new Object[]{key, json.get((Object)key), e});
            return defaultValue;
        }
    }

    public static JSONObject getJSONObject(JSONObject json, String key) {
        if (json == null || !json.containsKey((Object)key)) {
            return null;
        }
        try {
            return json.getJSONObject(key);
        }
        catch (Exception e) {
            log.debug("\u83b7\u53d6JSONObject\u503c\u5931\u8d25: key={}, value={}", new Object[]{key, json.get((Object)key), e});
            return null;
        }
    }

    public static JSONArray getJSONArray(JSONObject json, String key) {
        if (json == null || !json.containsKey((Object)key)) {
            return null;
        }
        try {
            return json.getJSONArray(key);
        }
        catch (Exception e) {
            log.debug("\u83b7\u53d6JSONArray\u503c\u5931\u8d25: key={}, value={}", new Object[]{key, json.get((Object)key), e});
            return null;
        }
    }

    public static <T> List<T> getList(JSONObject json, String key, Class<T> clazz) {
        if (json == null || !json.containsKey((Object)key)) {
            return Collections.emptyList();
        }
        try {
            return json.getJSONArray(key).toJavaList(clazz);
        }
        catch (Exception e) {
            log.debug("\u83b7\u53d6List\u503c\u5931\u8d25: key={}, value={}", new Object[]{key, json.get((Object)key), e});
            return Collections.emptyList();
        }
    }

    public static String getString(Map<String, Object> map, String key) {
        return JsonSafeAccessor.getString(map, key, null);
    }

    public static String getString(Map<String, Object> map, String key, String defaultValue) {
        if (map == null || !map.containsKey(key) || map.get(key) == null) {
            return defaultValue;
        }
        return map.get(key).toString();
    }

    public static Integer getInteger(Map<String, Object> map, String key) {
        return JsonSafeAccessor.getInteger(map, key, null);
    }

    public static Integer getInteger(Map<String, Object> map, String key, Integer defaultValue) {
        return JsonSafeAccessor.getNumericValue(map, key, value -> {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.parseInt(value.toString());
        }, defaultValue, "Integer");
    }

    public static Long getLong(Map<String, Object> map, String key) {
        return JsonSafeAccessor.getLong(map, key, null);
    }

    public static Long getLong(Map<String, Object> map, String key, Long defaultValue) {
        return JsonSafeAccessor.getNumericValue(map, key, value -> {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            return Long.parseLong(value.toString());
        }, defaultValue, "Long");
    }

    public static Double getDouble(Map<String, Object> map, String key) {
        return JsonSafeAccessor.getDouble(map, key, null);
    }

    public static Double getDouble(Map<String, Object> map, String key, Double defaultValue) {
        return JsonSafeAccessor.getNumericValue(map, key, value -> {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return Double.parseDouble(value.toString());
        }, defaultValue, "Double");
    }

    public static Float getFloat(Map<String, Object> map, String key) {
        return JsonSafeAccessor.getFloat(map, key, null);
    }

    public static Float getFloat(Map<String, Object> map, String key, Float defaultValue) {
        return JsonSafeAccessor.getNumericValue(map, key, value -> {
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            return Float.valueOf(Float.parseFloat(value.toString()));
        }, defaultValue, "Float");
    }

    public static Boolean getBoolean(Map<String, Object> map, String key) {
        return JsonSafeAccessor.getBoolean(map, key, null);
    }

    public static Boolean getBoolean(Map<String, Object> map, String key, Boolean defaultValue) {
        if (map == null || !map.containsKey(key) || map.get(key) == null) {
            return defaultValue;
        }
        Object value = map.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        try {
            String strValue = value.toString().toLowerCase();
            return "true".equals(strValue) || "1".equals(strValue) || "yes".equals(strValue);
        }
        catch (Exception e) {
            log.debug("\u83b7\u53d6Boolean\u503c\u5931\u8d25: key={}, value={}", new Object[]{key, value, e});
            return defaultValue;
        }
    }

    private static <T> T getNumericValue(Map<String, Object> map, String key, Function<Object, T> converter, T defaultValue, String typeName) {
        if (map == null || !map.containsKey(key) || map.get(key) == null) {
            return defaultValue;
        }
        try {
            return converter.apply(map.get(key));
        }
        catch (NumberFormatException e) {
            log.debug("\u8f6c\u6362{}\u7c7b\u578b\u5931\u8d25: key={}, value={}", new Object[]{typeName, key, map.get(key), e});
            return defaultValue;
        }
    }
}

