/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.util;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.flow.CodeAction;
import kd.ai.gai.core.flow.param.define.ParamDefinition;
import kd.ai.gai.core.flow.param.dimension.ParamType;
import kd.bos.script.ScriptContext;
import kd.bos.script.ScriptExecutor;

public class KScriptUtils {
    public static String generateScript(CodeAction action, String code) {
        List<ParamDefinition> paramDefinitions = action.getParamByGroup(action.getInputParamGroup());
        Map<String, ParamType> paramNameToTypeMap = KScriptUtils.getParamNameToTypeMap(paramDefinitions);
        return KScriptUtils.generateHelperFunctions() + "\n" + KScriptUtils.generateMainFunction(paramNameToTypeMap, code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object execScript(String script, Map<String, Object> map) {
        ScriptExecutor scriptExecutor = ScriptExecutor.create();
        scriptExecutor.init(ctx -> map.forEach((arg_0, arg_1) -> ((ScriptContext)ctx).set(arg_0, arg_1)));
        scriptExecutor.begin();
        try {
            Object object = scriptExecutor.exec(new String[]{script});
            return object;
        }
        finally {
            scriptExecutor.end();
        }
    }

    private static String generateHelperFunctions() {
        return "function toArray(input) {\n  if (input == null) return [];\n  if (Array.isArray(input)) return input;\n  try {\n    const parsed = JSON.parse(input);\n    return Array.isArray(parsed) ? parsed : [parsed];\n  } catch (e) {\n    return [input];\n  }\n}\n\nfunction toDate(input) {\n  if (input == null) return null;\n  const date = new Date(input);\n  return isNaN(date.getTime()) ? null : date;\n}\n\nfunction toObject(input) {\n  if (input == null) return {};\n  if (typeof input === 'object' && !Array.isArray(input)) return input;\n  try {\n    const parsed = JSON.parse(input);\n    return typeof parsed === 'object' && !Array.isArray(parsed) ? parsed : { value: parsed };\n  } catch (e) {\n    return { value: input };\n  }\n}\n\nfunction toBoolean(input) {\n  if (input === 'false' || input === '0' || input === '' || input === null || input === undefined) {\n    return false;\n  }\n  return Boolean(input);\n}\n\nfunction toNumber(input) {\n  if (input == null) return NaN;\n  if (typeof input === 'number') return input;\n  const num1 = parseInt(input);\n  const num2 = parseFloat(input);\n  if (isNaN(num1)) {\n    return NaN;\n  } else if (num1 == num2) {\n    return num1;\n  } else {\n    return num2;\n  }\n}";
    }

    private static String generateVariableDeclarations(Map<String, ParamType> paramNameToTypeMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ParamType> entry : paramNameToTypeMap.entrySet()) {
            String varName = entry.getKey();
            ParamType type = entry.getValue();
            sb.append("  var ").append(varName).append(" = $input.get('").append(varName).append("');\n");
            if (type == ParamType.STRING) {
                sb.append("  ").append(varName).append(" = ").append(varName).append(" != null ? ").append(varName).append(".toString() : '';\n");
                continue;
            }
            if (type == ParamType.INTEGER || type == ParamType.FLOAT) {
                sb.append("  ").append(varName).append(" = toNumber(").append(varName).append(");\n");
                continue;
            }
            if (type == ParamType.BOOLEAN) {
                sb.append("  ").append(varName).append(" = toBoolean(").append(varName).append(");\n");
                continue;
            }
            if (type == ParamType.DATE) {
                sb.append("  ").append(varName).append(" = toDate(").append(varName).append(");\n");
                continue;
            }
            if (type == ParamType.OBJECT) {
                sb.append("  ").append(varName).append(" = toObject(").append(varName).append(");\n");
                continue;
            }
            if (type == ParamType.ARRAY) {
                sb.append("  ").append(varName).append(" = toArray(").append(varName).append(");\n");
                continue;
            }
            sb.append("  // Unsupported type\n");
        }
        return sb.toString();
    }

    private static String indentCode(String code) {
        if (code == null || code.trim().isEmpty()) {
            return "";
        }
        String[] lines = code.trim().split("\\r?\\n");
        StringBuilder indented = new StringBuilder();
        for (String line : lines) {
            indented.append("  ").append(line).append("\n");
        }
        return indented.toString();
    }

    private static String generateMainFunction(Map<String, ParamType> paramNameToTypeMap, String userCode) {
        StringBuilder sb = new StringBuilder();
        sb.append("function main() {\n");
        sb.append(KScriptUtils.generateVariableDeclarations(paramNameToTypeMap)).append("\n");
        sb.append(KScriptUtils.indentCode(userCode)).append("\n");
        sb.append("}\n");
        sb.append("main();");
        return sb.toString();
    }

    private static Map<String, ParamType> getParamNameToTypeMap(List<ParamDefinition> paramDefinitions) {
        return paramDefinitions.stream().collect(Collectors.toMap(ParamDefinition::getName, ParamDefinition::getType));
    }
}

