/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.util;

import kd.bos.license.api.ILicenseService;
import kd.bos.service.ServiceFactory;

public class ProductUtil {
    public static final int ORG_MANAGE_MODE_MIDDLE = 2;
    public static final int ORG_MANAGE_MODE_GALAXY = 4;

    public static ProductType getProductType() {
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modelType = licenseService.getModeType();
        ProductType type = modelType == 2 || modelType == 4 ? ProductType.GALAXY_PRODUCT : ProductType.CONSTELLATION_PRODUCT;
        return type;
    }

    public static boolean isGalaxyProduct() {
        return ProductUtil.getProductType() == ProductType.GALAXY_PRODUCT;
    }

    public static enum ProductType {
        CONSTELLATION_PRODUCT(3, "constellation", "\u661f\u701a"),
        GALAXY_PRODUCT(93, "galaxy", "\u661f\u7a7a\u65d7\u8230\u7248");

        private final int code;
        private final String name;
        private final String desc;

        private ProductType(int code, String name, String desc) {
            this.code = code;
            this.name = name;
            this.desc = desc;
        }

        public int getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }

        public static ProductType getProductTypeByCode(int code) {
            for (ProductType productType : ProductType.values()) {
                if (productType.getCode() != code) continue;
                return productType;
            }
            return null;
        }

        public static ProductType getProductTypeByName(String name) {
            for (ProductType productType : ProductType.values()) {
                if (!productType.getName().equals(name)) continue;
                return productType;
            }
            return null;
        }
    }
}

