/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.End;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.RecommendAction;
import kd.ai.gai.core.engine.flow.Transfer;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.bos.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RecommendNodeUtil {
    public static String insertRecommendNode(String flowJsonStr, RecommendAction recommendAction) {
        if (StringUtils.isBlank((CharSequence)flowJsonStr)) {
            return flowJsonStr;
        }
        Flow flow = JsonUtil.fromJson(flowJsonStr, Flow.class);
        if (flow == null || flow.getEnd() == null || CollectionUtils.isEmpty(flow.getTransfers())) {
            return flowJsonStr;
        }
        int maxId = RecommendNodeUtil.getMaxIdInFlow(flow);
        int recommendNodeId = maxId + 800;
        recommendAction.setId(recommendNodeId);
        Transfer recommendToEnd = new Transfer();
        int recommendToEndId = maxId + 900;
        recommendToEnd.setId(recommendToEndId);
        End end = flow.getEnd();
        int endNodeId = end.getId();
        List<Transfer> transfers = flow.getTransfers();
        ArrayList<Integer> recommendTransferInList = new ArrayList<Integer>();
        for (Transfer transfer : transfers) {
            int toNodeId = transfer.getToNodeId();
            if (toNodeId != endNodeId) continue;
            transfer.setToNodeId(recommendNodeId);
            recommendTransferInList.add(transfer.getId());
        }
        recommendAction.setTransferInList(recommendTransferInList);
        recommendToEnd.setFromNodeId(recommendNodeId);
        recommendToEnd.setToNodeId(endNodeId);
        recommendAction.setTransferOutList(Lists.newArrayList((Object[])new Integer[]{recommendToEndId}));
        end.setTransferInList(Lists.newArrayList((Object[])new Integer[]{recommendToEndId}));
        ArrayList<RecommendAction> actions = flow.getActions();
        actions = actions == null ? new ArrayList<RecommendAction>() : actions;
        actions.add(recommendAction);
        transfers.add(recommendToEnd);
        return JsonUtil.toJson(flow);
    }

    public static void removeRecommendNode(Flow flow) {
        if (flow == null || flow.getEnd() == null || CollectionUtils.isEmpty(flow.getActions())) {
            return;
        }
        Node recommendAction = null;
        List<Action> actions = flow.getActions();
        Iterator<Action> actionIterator = actions.iterator();
        while (actionIterator.hasNext()) {
            Action action = actionIterator.next();
            if (!(action instanceof RecommendAction)) continue;
            recommendAction = (RecommendAction)action;
            actionIterator.remove();
        }
        if (recommendAction == null) {
            return;
        }
        int recommendNodeId = recommendAction.getId();
        End end = flow.getEnd();
        int endNodeId = end.getId();
        List<Transfer> transfers = flow.getTransfers();
        ArrayList<Integer> endTransferInList = new ArrayList<Integer>();
        Iterator<Transfer> transferIterator = transfers.iterator();
        while (transferIterator.hasNext()) {
            Transfer transfer = transferIterator.next();
            int fromNodeId = transfer.getFromNodeId();
            int toNodeId = transfer.getToNodeId();
            if (fromNodeId == recommendNodeId && toNodeId == endNodeId) {
                transferIterator.remove();
                continue;
            }
            if (toNodeId != recommendNodeId) continue;
            transfer.setToNodeId(endNodeId);
            endTransferInList.add(transfer.getId());
        }
        end.setTransferInList(endTransferInList);
    }

    public static int getMaxIdInFlow(Flow flow) {
        int maxId = flow.getEnd().getId();
        List<Action> actions = flow.getActions();
        for (Action action : actions) {
            maxId = Math.max(action.getId(), maxId);
        }
        List<Transfer> transfers = flow.getTransfers();
        for (Transfer transfer : transfers) {
            maxId = Math.max(transfer.getId(), maxId);
        }
        return maxId;
    }
}

