/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.ai.gai.core.domain.util.MenuModel;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.RootPageIdContext;
import kd.bos.algo.DataSet;
import kd.bos.base.parameter.ParameterService;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.model.AppSchemeType;
import kd.bos.portal.model.BrandUpEnum;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.portal.util.PortalUsableFuncUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.util.StringUtils;

public class ShowFormUtil {
    private static final Log log = LogFactory.getLog(ShowFormUtil.class);

    public static void showBillListInApp(String billFormId, String appNumber, IFormView myView) {
        ShowFormUtil.showApp(appNumber, myView);
        IFormView mainPageView = myView.getMainView();
        String menuId = ShowFormUtil.getMenuId(billFormId);
        String pageId = ShowFormUtil.getMenuPageId(mainPageView.getPageId(), menuId);
        IFormView formPageView = mainPageView.getViewNoPlugin(pageId);
        if (formPageView == null) {
            ShowFormUtil.openBillList(appNumber, billFormId, pageId, myView);
        } else {
            BillList billList = (BillList)formPageView.getControl("billlistap");
            billList.refresh();
            formPageView.updateView(billList.getKey());
            formPageView.activate();
            myView.sendFormAction(formPageView);
        }
    }

    private static String getMenuId(String billFormId) {
        MenuModel menuModel = ShowFormUtil.getEntityMenuWithSessionCache(billFormId);
        if (menuModel != null) {
            return menuModel.getMenuId();
        }
        return null;
    }

    private static MenuModel getEntityMenuWithSessionCache(String entityNumber) {
        List<MenuModel> menuList = ShowFormUtil.getEntityListMenu(entityNumber, false);
        if (menuList == null || menuList.isEmpty()) {
            return null;
        }
        for (MenuModel menu : menuList) {
            if (!ShowFormUtil.isMenuExist(menu.getAppNumber(), menu.getMenuId())) continue;
            return menu;
        }
        List<MenuModel> dbMenuList = ShowFormUtil.getEntityListMenu(entityNumber, true);
        return dbMenuList.isEmpty() ? null : dbMenuList.get(0);
    }

    private static boolean isMenuExist(String appNumber, String menuId) {
        try {
            AppMenuInfo menu = AppMetadataCache.getAppMenuInfo((String)appNumber, (String)menuId);
            return menu != null;
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return false;
        }
    }

    private static List<MenuModel> getEntityListMenu(String entityNumber, boolean reload) {
        List<MenuModel> value;
        String key = ShowFormUtil.getKey(entityNumber);
        if (!reload && (value = ShowFormUtil.getListMenuModelCache(key)) != null) {
            return value;
        }
        entityNumber = ShowFormUtil.getBillFormId(entityNumber);
        List<MenuModel> menus = ShowFormUtil.queryEntityListMenu(entityNumber);
        ShowFormUtil.putMenuModelCache(key, menus);
        return menus;
    }

    private static void putMenuModelCache(String key, List<MenuModel> value) {
        LocalMemoryCache cache = ShowFormUtil.getCache();
        cache.put(key, value);
    }

    private static void putCache(String key, String value) {
        LocalMemoryCache cache = ShowFormUtil.getCache();
        cache.put(key, (Object)value);
    }

    /*
     * Exception decompiling
     */
    private static List<MenuModel> queryEntityListMenu(String entityNumber) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Set<String> getCanShowAppPkidOfDBCenter() {
        long start = System.currentTimeMillis();
        Set<String> result = ShowFormUtil.getCanShowAppPkidOfDBCenterWithCache();
        log.info(String.format("gai-get app fid takes %s ms", System.currentTimeMillis() - start));
        return result;
    }

    private static Set<String> getCanShowAppPkidOfDBCenterWithCache() {
        String key = ShowFormUtil.getKeyOfCanShowApp();
        String value = ShowFormUtil.getCache(key);
        if (value != null) {
            return (Set)SerializationUtils.fromJsonString((String)value, Set.class);
        }
        Set<String> result = ShowFormUtil.doGetCanShowAppPkidOfDBCenter();
        ShowFormUtil.putCache(key, SerializationUtils.toJsonString(result));
        return result;
    }

    private static String getKeyOfCanShowApp() {
        RequestContext ctx = RequestContext.get();
        return String.format("gai.app.%s", ctx.getGlobalSessionId());
    }

    private static Set<String> doGetCanShowAppPkidOfDBCenter() {
        Map cloudBlackListMap = RunModeServiceHelper.getCloudBlacklist();
        Set cloudBlackListFidSet = cloudBlackListMap.keySet();
        JSONArray clouds = ShowFormUtil.getAppInfo();
        HashSet<String> result = new HashSet<String>();
        block0: for (int i = 0; i < clouds.size(); ++i) {
            JSONArray apps = clouds.getJSONArray(i);
            for (int j = 0; j < apps.size(); ++j) {
                JSONObject app = apps.getJSONObject(j);
                String id = app.getString("id");
                boolean isCloud = app.getBooleanValue("iscloud");
                if (isCloud && cloudBlackListFidSet.contains(id)) continue block0;
                if (isCloud) continue;
                result.add(id);
            }
        }
        return result;
    }

    private static JSONArray getAppInfo() {
        long start = System.currentTimeMillis();
        PortalUsableFuncUtil portalUtil = new PortalUsableFuncUtil(log);
        JSONArray resultApps = portalUtil.getAllAppsInSystem();
        try {
            resultApps = portalUtil.getAppsFilters(false, AppSchemeType.USERSCHEME, resultApps);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        log.info(String.format("ais--get can show app takes: %sms", System.currentTimeMillis() - start));
        return resultApps;
    }

    /*
     * Exception decompiling
     */
    private static DataSet queryBillFormByEntity(String entityNumber) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static DataSet queryAppMenuOfListByBillFormId() {
        long startTime = System.currentTimeMillis();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT menu.FID as ").append("id").append(", ");
        sql.append("menu.fformid as ").append("formid").append(", ");
        sql.append("menul.fname as ").append("name").append(", ");
        sql.append("app.fid as ").append("appFid").append(", ");
        sql.append("app.fnumber as ").append("appNumber").append(", ");
        sql.append("appl.fname as ").append("appName").append(", ");
        sql.append("cloudl.fname as ").append("cloudName").append(' ');
        sql.append("FROM T_META_MENURUNTIME menu ");
        sql.append("LEFT JOIN T_META_MENURUNTIME_L menul ON menu.FID=menul.FID ");
        sql.append(String.format("AND menul.FLOCALEID='%s' ", Lang.get().toString()));
        sql.append("LEFT JOIN T_META_APPRUNTIME_L appl ON menu.FAPPID=appl.FAPPID ");
        sql.append(String.format("AND appl.FLOCALEID='%s' ", Lang.get().toString()));
        sql.append("LEFT JOIN T_META_BIZAPP app ON app.FNUMBER = appl.FAPPID ");
        sql.append("LEFT JOIN T_META_BIZCLOUD_L cloudl on cloudl.FID = app.FBIZCLOUDID ");
        sql.append(String.format(" AND cloudl.FLOCALEID='%s' ", Lang.get().toString()));
        sql.append("WHERE fparamtype = 'ListShowParameter' ");
        DataSet ds = DB.queryDataSet((String)"ais.getAppMenuOfListByBillFormId", (DBRoute)DBRoute.meta, (String)sql.toString(), null);
        log.info(String.format("queryAppMenuOfListByBillFormId takes %sms", System.currentTimeMillis() - startTime));
        return ds;
    }

    private static String getBillFormId(String entityNumber) {
        if ("bos_user".equalsIgnoreCase(entityNumber)) {
            return "bos_usertreelistview";
        }
        if ("bos_adminorg".equalsIgnoreCase(entityNumber)) {
            return "bos_adminorg_structure";
        }
        return entityNumber;
    }

    private static String getKey(String entityNumber) {
        RequestContext ctx = RequestContext.get();
        return String.format("gai.menus.%s.%s", ctx.getGlobalSessionId(), entityNumber);
    }

    private static List<MenuModel> getListMenuModelCache(String key) {
        LocalMemoryCache cache = ShowFormUtil.getCache();
        Object o = cache.get(key);
        if (o != null) {
            return (List)o;
        }
        return null;
    }

    private static String getCache(String key) {
        LocalMemoryCache cache = ShowFormUtil.getCache();
        Object o = cache.get(key);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    private static LocalMemoryCache getCache() {
        return ShowFormUtil.getLocalMemoryCache("gai");
    }

    private static LocalMemoryCache getLocalMemoryCache(String number) {
        return EngineCache.getLocalCache(number);
    }

    private static void openBillList(String appNumber, String billFormId, String billPageId, IFormView myView) {
        IFormView mainPageView = myView.getMainView();
        if (mainPageView == null) {
            log.info("openBill----mainPageView or mainPageID is null");
            return;
        }
        String appPageId = ShowFormUtil.getAppPageId(mainPageView.getPageId(), appNumber);
        IFormView appPageView = mainPageView.getViewNoPlugin(appPageId);
        if (appPageView != null) {
            if (appPageView.getPageId().equalsIgnoreCase(mainPageView.getPageId())) {
                appPageView = mainPageView;
            }
            FormConfig formConfig = FormMetadataCache.getListFormConfig((String)billFormId);
            ListShowParameter sp = new ListShowParameter();
            sp.setBillFormId(billFormId);
            sp.setFormId(formConfig.getListFormId());
            sp.getOpenStyle().setShowType(ShowType.NewTabPage);
            sp.getOpenStyle().setTargetKey("_submaintab_");
            sp.setHasRight(true);
            sp.setAppId(appNumber);
            sp.setCustomParam("appid", (Object)appNumber);
            sp.setPageId(billPageId);
            sp.setParentPageId(appPageId);
            mainPageView.showForm((FormShowParameter)sp);
            myView.sendFormAction(mainPageView);
            if (myView.getPageId().equals(appPageView.getPageId())) {
                myView.showForm((FormShowParameter)sp);
            } else {
                appPageView.showForm((FormShowParameter)sp);
                myView.sendFormAction(appPageView);
            }
        }
    }

    public static String getMenuPageId(String mainPageViewPageId, String menuId) {
        return menuId + mainPageViewPageId;
    }

    private static boolean isNewPortal() {
        boolean newPortal;
        try {
            long start = System.currentTimeMillis();
            newPortal = ParameterService.isSupportNewPortal();
            log.info(String.format("ais--call isSupportNewPortal takes %s ms", System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            newPortal = false;
        }
        return newPortal;
    }

    public static void showApp(String appId, IFormView myView) {
        List appNumbers;
        AppInfo app = ShowFormUtil.getAppInfo(appId);
        if (app == null) {
            myView.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u5e94\u7528", (String)"ShowFormUtil_2", (String)"ai-gai-core", (Object[])new Object[0]));
            return;
        }
        if (!ShowFormUtil.isNewPortal() && (appNumbers = BrandUpEnum.getAppNumbers((String)app.getNumber())) != null) {
            myView.openUrl("?appNumber=" + app.getNumber());
            return;
        }
        if ("1".equals(app.getMainFormType())) {
            if (!StringUtils.isBlank((String)app.getHomeURL())) {
                myView.openUrl(app.getHomeURL());
            } else {
                log.error("\u5e94\u7528{}\u7684\u5916\u90e8\u94fe\u63a5\u4e3a\u7a7a", (Object)appId);
            }
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("view", myView);
        map.put("appname", app.getName().getLocaleValue());
        map.put("appmainnumber", app.getHomeNum());
        OpenPageUtils.openApp((String)app.getNumber(), (String)"", map, (IFormView)myView);
    }

    public static AppInfo getAppInfo(String appId) {
        try {
            return AppMetadataCache.getAppInfo((String)appId);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return null;
        }
    }

    public static void openBill(String appId, String billFormId, Object billPkId, IFormView myView, String crossPageData, Map<String, Object> gaiParams, String type) {
        String billPkIdString = null;
        if (billPkId != null && StringUtils.isNotEmpty((String)(billPkId + ""))) {
            billPkIdString = billPkId + "";
        }
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("formId", billFormId);
        para.put("pkId", billPkIdString);
        HashMap<String, Object> tmpParams = new HashMap<String, Object>();
        tmpParams.putAll(para);
        tmpParams.putAll(gaiParams);
        tmpParams.put("view", myView);
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
        String appNumber = appInfo.getNumber();
        String mainPageId = appInfo.getHomeId();
        if (mainPageId == null || mainPageId.trim().length() == 0) {
            throw new KDBizException("\u5e94\u7528\u9996\u9875\u6ca1\u6709\u914d\u7f6e\u3002");
        }
        DynamicObject pageObject = BusinessDataServiceHelper.loadSingleFromCache((Object)mainPageId, (String)"bos_formmeta", (String)"number, inheritpath");
        if (pageObject == null) {
            throw new KDBizException("\u5e94\u7528\u9996\u9875\u9875\u9762\u4e0d\u5b58\u5728\u3002");
        }
        if (!StringUtils.isEmpty((String)crossPageData)) {
            Map crossPageDataMap = (Map)JSON.parseObject((String)crossPageData, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            RootPageIdContext rootPageIdContext = new RootPageIdContext(mainPageId, null, crossPageDataMap);
            FlowCacheData.putRootPageId2ChatSessionId(mainPageId, rootPageIdContext);
        }
        String mainPageNumber = pageObject.getString("number");
        tmpParams.put("appname", appInfo.getName().getLocaleValue());
        tmpParams.put("appmainnumber", mainPageNumber);
        tmpParams.put("pkId", billPkIdString);
        OpenPageUtils.openApp((String)appInfo.getNumber(), (String)null, tmpParams, (IFormView)myView);
        tmpParams.remove("view");
        String pageId = ShowFormUtil.getBillPageId(myView.getMainView(), billFormId, billPkIdString);
        IFormView formIdPage = myView.getViewNoPlugin(pageId);
        if (formIdPage != null) {
            ShowFormUtil.activatePage(pageId, myView, para);
        } else {
            IFormView mainPageView = myView.getMainView();
            if (mainPageView == null) {
                log.info("openBill----mainPageView or mainPageID is null");
            } else {
                String appPageId = ShowFormUtil.getAppPageId(mainPageView.getPageId(), appNumber);
                IFormView appPageView = mainPageView.getViewNoPlugin(appPageId);
                if (appPageView != null) {
                    if (appPageView.getPageId().equalsIgnoreCase(mainPageView.getPageId())) {
                        appPageView = mainPageView;
                    }
                    if ("list".equalsIgnoreCase(type)) {
                        ListShowParameter lsp = (ListShowParameter)ShowFormUtil.createShowFormParameter(billFormId, tmpParams);
                        lsp.setBillFormId(billFormId);
                        lsp.setFormId("bos_list");
                        ShowFormUtil.showForm(myView, (FormShowParameter)lsp, appNumber, tmpParams, pageId, appPageView);
                    } else {
                        FormShowParameter fsp = ShowFormUtil.createShowFormParameter(billFormId, tmpParams);
                        ShowFormUtil.showForm(myView, fsp, appNumber, tmpParams, pageId, appPageView);
                    }
                } else {
                    log.info("openBill----appPageView is null");
                }
            }
        }
    }

    private static void showForm(IFormView myView, FormShowParameter fsp, String appNumber, Map<String, Object> tmpParams, String pageId, IFormView appPageView) {
        fsp.setHasRight(true);
        fsp.setAppId(appNumber);
        fsp.setCustomParam("appid", (Object)appNumber);
        ShowFormUtil.addCustomParam(fsp, tmpParams);
        fsp.setPageId(pageId);
        if (myView.getPageId().equals(appPageView.getPageId())) {
            myView.showForm(fsp);
        } else {
            appPageView.showForm(fsp);
            myView.sendFormAction(appPageView);
        }
    }

    public static void activatePage(String pageID, IFormView view, Map<String, Object> customParams) {
        IFormView childView = view.getViewNoPlugin(pageID);
        if ("bos".equals(childView.getFormShowParameter().getServiceAppId())) {
            childView = view.getView(pageID);
        }
        if (childView != null) {
            if (!view.getPageId().equalsIgnoreCase(childView.getPageId())) {
                HashMap customparameters = (HashMap)customParams.get("customparameters");
                childView.getFormShowParameter().getCustomParams().remove("messageId");
                childView.getFormShowParameter().getCustomParams().remove("tabType");
                childView.getFormShowParameter().getCustomParams().remove("openPage");
                if (customparameters != null) {
                    if (customparameters.get("messageId") != null) {
                        childView.getFormShowParameter().setCustomParam("messageId", customparameters.get("messageId"));
                    }
                    if (customparameters.get("tabType") != null) {
                        childView.getFormShowParameter().setCustomParam("tabType", customparameters.get("tabType"));
                    }
                    if (customparameters.get("openPage") != null) {
                        childView.getFormShowParameter().setCustomParam("openPage", customparameters.get("openPage"));
                    }
                }
                childView.getFormShowParameter().setHasRight(true);
                childView.activate();
                if ("bos".equals(childView.getFormShowParameter().getServiceAppId())) {
                    childView.updateView();
                }
                view.sendFormAction(childView);
            }
        } else {
            view.showTipNotification("\u7cfb\u7edf\u5df2\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u767b\u5f55!");
        }
    }

    public static FormShowParameter createShowFormParameter(String formNumber, Map<String, Object> parameter) {
        FormShowParameter sp = FormShowParameter.createFormShowParameter(parameter);
        sp.getOpenStyle().setShowType(ShowType.NewTabPage);
        sp.getOpenStyle().setTargetKey("_submaintab_");
        HashMap map = new HashMap();
        sp.setCustomParams(map);
        return sp;
    }

    public static void addCustomParam(FormShowParameter fsp, Map<String, Object> customParams) {
        if (customParams != null) {
            customParams.forEach((k, v) -> fsp.setCustomParam(k, v));
        }
    }

    public static String getBillPageId(IFormView targetView, String formId, String billPkid) {
        return formId + targetView.getPageId() + "_" + billPkid;
    }

    public static String getAppPageId(String mainPageViewPageId, String appNumber) {
        return appNumber + mainPageViewPageId;
    }

    public static void showFormInCurrentForm(IFormView view, String formId, String title) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(formId);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.InCurrentForm);
        fsp.setOpenStyle(openStyle);
        if (StringUtils.isNotEmpty((String)title)) {
            fsp.setCaption(title);
        }
        view.showForm(fsp);
    }
}

