/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.vipknowledge;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.ai.gai.core.domain.vo.SuggestedAskData;
import kd.ai.gai.core.n2aparam.N2aParamConfig;
import kd.ai.gai.core.util.ProductUtil;
import kd.ai.gai.vipknowledge.cloud.CloudPlatFormAuth;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;
import org.apache.commons.lang3.StringUtils;

public class KnowledgeOpenApiService {
    public static final String RECOMMEND_API = "/openapi/cosmic/gpt/recommend";
    private static final Log logger = LogFactory.getLog(KnowledgeOpenApiService.class);
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
    public static final String GAI_RECOMMEND_QUESTION = "gai_RQuestion_";

    private KnowledgeOpenApiService() {
    }

    public static List<SuggestedAskData> getSuggestedAskData() {
        ProductUtil.ProductType productType = ProductUtil.getProductType();
        logger.info("getSuggestedAskData:" + productType.getName());
        JSONObject appConfigInfo = N2aParamConfig.getAppConfigInfo();
        List<String> question = KnowledgeOpenApiService.getRecommendQuestion(appConfigInfo.getString(productType.getName()));
        if (question.isEmpty()) {
            return Collections.emptyList();
        }
        return KnowledgeOpenApiService.buildSuggestedAskData(question);
    }

    public static List<SuggestedAskData> getSuggestedAskDataFromCache() {
        ProductUtil.ProductType productType = ProductUtil.getProductType();
        logger.info("getSuggestedAskData:" + productType.getName());
        JSONObject appConfigInfo = N2aParamConfig.getAppConfigInfo();
        String cacheValue = (String)cache.get(GAI_RECOMMEND_QUESTION + appConfigInfo.getString(productType.getName()) + RequestContext.get().getAccountId() + RequestContext.get().getCurrUserId());
        if (StringUtils.isNotEmpty((CharSequence)cacheValue)) {
            List question = JSON.parseArray((String)cacheValue, String.class);
            if (question.isEmpty()) {
                return Collections.emptyList();
            }
            return KnowledgeOpenApiService.buildSuggestedAskData(question);
        }
        return Collections.emptyList();
    }

    private static List<SuggestedAskData> buildSuggestedAskData(List<String> question) {
        ArrayList<SuggestedAskData> suggestedAskDatas = new ArrayList<SuggestedAskData>(question.size());
        for (int i = 0; i < question.size(); ++i) {
            String s = question.get(i);
            SuggestedAskData suggestedAskData = new SuggestedAskData();
            suggestedAskData.setId(i + "");
            suggestedAskData.setName(s);
            suggestedAskDatas.add(suggestedAskData);
        }
        return suggestedAskDatas;
    }

    public static List<String> getRecommendQuestion(String productId) {
        logger.info("getRecommendQuestion: get from api");
        JSONObject appConfigInfo = N2aParamConfig.getAppConfigInfo();
        String code = CloudPlatFormAuth.getAuthCode(appConfigInfo);
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("auth_code", code);
        params.put("productId", productId);
        Map<String, String> header = CloudPlatFormAuth.getHeader(appConfigInfo, params);
        String returnData = HttpClientUtils.get((String)(appConfigInfo.getString("knowledgeUrl") + RECOMMEND_API + "?auth_code=" + code + "&productId=" + productId), header, new TreeMap());
        try {
            if (StringUtils.isNotEmpty((CharSequence)returnData)) {
                List data = JSON.parseArray((String)returnData, String.class);
                cache.put(GAI_RECOMMEND_QUESTION + productId + RequestContext.get().getCurrUserId(), (Object)returnData);
                return data;
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            logger.warn(returnData);
        }
        return Collections.emptyList();
    }

    public static String userFeedback(Map<String, Object> body) throws IOException {
        JSONObject appConfigInfo = N2aParamConfig.getAppConfigInfo();
        String code = CloudPlatFormAuth.getAuthCode(appConfigInfo);
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("auth_code", code);
        Map<String, String> header = CloudPlatFormAuth.getHeader(appConfigInfo, params);
        return HttpClientUtils.postAppJson((String)(appConfigInfo.getString("knowledgeUrl") + "/openapi/cosmic/gpt/feedback?auth_code=" + code), header, body);
    }
}

