/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.vipknowledge;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.domain.vo.SuggestedAskData;
import kd.ai.gai.core.n2aparam.N2aParamConfig;
import kd.ai.gai.core.service.ProcessService;
import kd.ai.gai.vipknowledge.KnowledgeOpenApiService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import org.apache.commons.lang3.StringUtils;

public class KnowledgeService {
    private static final Log logger = LogFactory.getLog(KnowledgeService.class);
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"gai-KnowledgeService", (int)10);

    private KnowledgeService() {
    }

    public static Skill getVipKnowledgeSkill(String skillId) {
        ArrayList<Long> skillIds = new ArrayList<Long>();
        Long id = StringUtils.isBlank((CharSequence)skillId) ? 0L : Long.parseLong(skillId);
        skillIds.add(id);
        List<Skill> skills = ProcessService.getProcessByIds(skillIds);
        if (skills == null || skills.isEmpty()) {
            return null;
        }
        Skill skill = skills.get(0);
        List<SuggestedAskData> suggestedAskData = KnowledgeService.getSuggestedAskData();
        if (suggestedAskData != null && !suggestedAskData.isEmpty()) {
            skill.setSuggestedAsks(suggestedAskData);
        }
        return skill;
    }

    public static List<SuggestedAskData> getSuggestedAskData() {
        List<SuggestedAskData> suggestedAskDataFromCache = KnowledgeOpenApiService.getSuggestedAskDataFromCache();
        if (suggestedAskDataFromCache != null && !suggestedAskDataFromCache.isEmpty()) {
            return suggestedAskDataFromCache;
        }
        Future submit = threadPool.submit(KnowledgeOpenApiService::getSuggestedAskData);
        List suggestedAskData = null;
        try {
            suggestedAskData = (List)submit.get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return suggestedAskData;
    }

    public static Long getVipKnowledgeSkillId() {
        String skill = KnowledgeService.getVipKnowledgeSkillIdStr();
        if (StringUtils.isBlank((CharSequence)skill)) {
            return 0L;
        }
        return Long.parseLong(skill);
    }

    public static String getVipKnowledgeSkillIdStr() {
        JSONObject object = N2aParamConfig.getAppConfigInfo();
        String skill = object.getString("skill");
        if (StringUtils.isBlank((CharSequence)skill)) {
            return "";
        }
        return skill;
    }
}

