/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.vipknowledge.cloud;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import kd.ai.gai.core.n2aparam.N2aParamConfig;
import kd.ai.gai.vipknowledge.cloud.CloudPlatformResult;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.HttpClientUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.collections.MapUtils;

public class CloudPlatFormAuth {
    private static final Log logger = LogFactory.getLog(CloudPlatFormAuth.class);
    private static final String SELECTPROPERTIES = "id,registeraccount,user,uid,identity";
    private static final String ENTITYNAME = "bos_cloud_user_relation";
    private static final String ERRCODE = "errcode";
    private static final String DESCRIPTION = "description";
    public static final String TARGET = "target";
    public static final String APP = "app";
    public static final String APP_STR = "app_str";
    public static final String KNOWLEDGE_URL = "knowledgeUrl";
    public static final String SKILL = "skill";
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
    private static final String GAI_CLOUD_AUTH_CODE = "gai_cloud_auth_code";
    public static final String REFLUSH_NUMBER = "50061";

    public static boolean hasCloudUserRelation() {
        DynamicObject[] data = CloudPlatFormAuth.getCloudUserRelation(RequestContext.get().getCurrUserId());
        return data != null && data.length > 0;
    }

    public static DynamicObject[] getCloudUserRelation(Long userId) {
        return BusinessDataServiceHelper.load((String)ENTITYNAME, (String)SELECTPROPERTIES, (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId)});
    }

    public static String getAuthCode() {
        return CloudPlatFormAuth.getAuthCode(N2aParamConfig.getAppConfigInfo());
    }

    public static String getAuthCode(JSONObject appConfigInfo) {
        CloudPlatformResult cloudPlatformResult = CloudPlatFormAuth.identity2codeByCloudPlatform(appConfigInfo.getString(TARGET), RequestContext.get().getGlobalSessionId());
        if (!cloudPlatformResult.isSuccess()) {
            logger.error(String.format("RecommendTask error:%1s", cloudPlatformResult.getMessage()));
            return "";
        }
        String data = (String)cloudPlatformResult.getData();
        JSONObject jsonObject = JSON.parseObject((String)data);
        return jsonObject.getString("code");
    }

    public static CloudPlatformResult identity2codeByCloudPlatform(String targetId, String chatSessionId) {
        CloudPlatformResult result = new CloudPlatformResult();
        try {
            String identity;
            Map<String, Object> body;
            String codeData = (String)cache.get(GAI_CLOUD_AUTH_CODE + chatSessionId);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)codeData)) {
                result.setData(codeData);
                result.setSuccess(true);
                return result;
            }
            DynamicObject[] array = CloudPlatFormAuth.getCloudUserRelation(RequestContext.get().getCurrUserId());
            if (array == null || array.length < 1) {
                result.setMessage("cloud user is null");
                return result;
            }
            DynamicObject cloudUserRelation = array[0];
            String config = DefaultParameterService.getDefaultValueByKey((String)"cloud_customer_service_config");
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)config)) {
                result.setMessage("cloud_customer_service_config is null");
                return result;
            }
            JSONObject configData = JSON.parseObject((String)config);
            CloudPlatformResult cloudPlatformResult = CloudPlatFormAuth.identity2codeByCloudPlatform(configData, body = CloudPlatFormAuth.createRequestBody(identity = cloudUserRelation.getString("identity"), targetId));
            if (!cloudPlatformResult.isSuccess() && REFLUSH_NUMBER.equals(cloudPlatformResult.getErrCode())) {
                cloudPlatformResult = CloudPlatFormAuth.handleCloudPlatformRefresh(cloudUserRelation, configData, targetId);
            }
            String data = (String)cloudPlatformResult.getData();
            logger.info(String.format("cloudPlatformResult%1s,%2s", data, cloudPlatformResult.getMessage()));
            if (cloudPlatformResult.isSuccess()) {
                cache.put(GAI_CLOUD_AUTH_CODE + chatSessionId, (Object)data, 30, TimeUnit.MINUTES);
            }
            return cloudPlatformResult;
        }
        catch (IOException | InterruptedException e) {
            result.setMessage("Error occurred in identity2codeByCloudPlatform" + e);
            return result;
        }
    }

    private static CloudPlatformResult handleCloudPlatformRefresh(DynamicObject cloudUserRelation, JSONObject configInfo, String targetId) throws IOException, InterruptedException {
        Object responseData;
        Map<String, Object> body = CloudPlatFormAuth.createRequestBody(cloudUserRelation.getString("identity"), configInfo.getString("targetId"));
        CloudPlatformResult refreshResult = CloudPlatFormAuth.refreshIdentityByCloudPlatform(configInfo, body);
        if (refreshResult.isSuccess() && (responseData = refreshResult.getData()) != null) {
            JSONObject data = JSON.parseObject((String)responseData.toString());
            String refreshIdentity = data.getString("refreshIdentity");
            cloudUserRelation.set("identity", (Object)refreshIdentity);
            SaveServiceHelper.update((DynamicObject)cloudUserRelation);
            body = CloudPlatFormAuth.createRequestBody(refreshIdentity, targetId);
            return CloudPlatFormAuth.identity2codeByCloudPlatform(configInfo, body);
        }
        logger.error(String.format("Error occurred in handleCloudPlatform%1s,%2s", refreshResult.getData(), refreshResult.getMessage()));
        return refreshResult;
    }

    public static CloudPlatformResult refreshIdentityByCloudPlatform(JSONObject configInfo, Map<String, Object> body) throws IOException, InterruptedException {
        CloudPlatformResult cloudPlatformResult = new CloudPlatformResult();
        TreeMap<String, String> params = new TreeMap<String, String>();
        Map<String, String> header = CloudPlatFormAuth.getHeader(configInfo, params);
        String response = HttpClientUtils.postAppJson((String)(configInfo.getString("serviceUrl") + "/api/user/refreshIdentity"), header, body);
        logger.info(response);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)response)) {
            JSONObject json = JSON.parseObject((String)response);
            cloudPlatformResult.setErrCode(json.getString(ERRCODE));
            if ("0".equals(json.getString(ERRCODE))) {
                json = json.getJSONObject("data");
                cloudPlatformResult.setData(json.toJSONString());
            } else {
                cloudPlatformResult.setMessage(json.getString(DESCRIPTION));
            }
        }
        return cloudPlatformResult;
    }

    private static Map<String, Object> createRequestBody(String identity, String targetId) {
        HashMap<String, Object> body = new HashMap<String, Object>(8);
        body.put("identity", identity);
        body.put("targetId", targetId);
        return body;
    }

    public static String sign(String appSecret, String timestamp, String nonce, SortedMap<String, String> params) {
        StringBuilder sber = new StringBuilder();
        sber.append(timestamp).append(nonce);
        if (MapUtils.isNotEmpty(params)) {
            params.forEach((k, v) -> {
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)v)) {
                    byte[] bytes = StringUtils.getBytesUtf8((String)v);
                    sber.append(new String(bytes, 0, Math.min(bytes.length, 100), StandardCharsets.UTF_8));
                }
            });
        }
        return Base64.encodeBase64String((byte[])new HmacUtils(HmacAlgorithms.HMAC_SHA_256, StringUtils.getBytesUtf8((String)appSecret)).hmac(StringUtils.getBytesUtf8((String)sber.toString())));
    }

    public static CloudPlatformResult identity2codeByCloudPlatform(JSONObject configInfo, Map<String, Object> body) throws IOException, InterruptedException {
        CloudPlatformResult cloudPlatformResult = new CloudPlatformResult();
        TreeMap<String, String> params = new TreeMap<String, String>();
        Map<String, String> header = CloudPlatFormAuth.getHeader(configInfo, params);
        String response = HttpClientUtils.postAppJson((String)(configInfo.getString("serviceUrl") + "/api/user/identity2code"), header, body);
        logger.info(response);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)response)) {
            JSONObject json = JSON.parseObject((String)response);
            cloudPlatformResult.setErrCode(json.getString(ERRCODE));
            if ("0".equals(json.getString(ERRCODE))) {
                json = json.getJSONObject("data");
                cloudPlatformResult.setData(json.toJSONString());
            } else {
                cloudPlatformResult.setMessage(json.getString(DESCRIPTION));
            }
        }
        return cloudPlatformResult;
    }

    public static Map<String, String> getHeader(SortedMap<String, String> params) {
        return CloudPlatFormAuth.getHeader(N2aParamConfig.getAppConfigInfo(), params);
    }

    public static Map<String, String> getHeader(JSONObject configInfo, SortedMap<String, String> params) {
        HashMap<String, String> header = new HashMap<String, String>(8);
        String timestamp = System.currentTimeMillis() + "";
        header.put("x-acgw-timestamp", timestamp);
        String nonce = kd.bos.util.StringUtils.randomWord((int)32);
        header.put("x-acgw-nonce", nonce);
        header.put("x-acgw-appid", configInfo.getString(APP));
        header.put("x-acgw-sign", CloudPlatFormAuth.sign(configInfo.getString(APP_STR), timestamp, nonce, params));
        return header;
    }
}

