/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.connector.server;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.connector.server.ConnectorContext;
import kd.ai.gai.flow.db.DataRow;
import kd.ai.gai.flow.db.DbUtil;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.dt.i.Hex;
import kd.ai.gai.flow.except.IscBizException;
import kd.ai.gai.flow.misc.Json;

public class SerializableResultManager {
    private static final String DELETE_FROM = "delete from ";
    public static final String FIDFILTER = " where fid=?";
    private static final int TIME_RANGE = 14400000;
    public static final String T_ISCB_TMP_RETURNS = "T_ISCB_TMP_RETURNS";
    public static final String FHASMORE = "fhasmore";
    public static final String T_ISCB_TMP_MAIN = "T_ISCB_TMP_MAIN";

    private SerializableResultManager() {
    }

    public static void cleanResultsOfTimeout(Connection cn) {
        String sql = "DELETE FROM T_ISCB_TMP_MAIN WHERE ftime < ?";
        Timestamp time = new Timestamp(System.currentTimeMillis() - 14400000L);
        int affected = DbUtil.executeUpdate(cn, sql, Collections.singletonList(time), Collections.singletonList(93));
        if (affected > 0) {
            sql = "DELETE FROM T_ISCB_TMP_RETURNS WHERE not exists(select fid from T_ISCB_TMP_MAIN where fid=T_ISCB_TMP_RETURNS.fid)";
            DbUtil.executeUpdate(cn, sql);
        }
    }

    public static void addHasMoreFieldToReturnTable(Connection cn) {
        String sql = "SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_ISCB_TMP_RETURNS' AND KSQL_COL_NAME = 'FHASMORE'";
        int count = D.i(DbUtil.executeScalar(cn, sql));
        if (count < 1) {
            sql = "ALTER TABLE T_ISCB_TMP_RETURNS ADD (fhasmore CHAR(1))";
            DbUtil.executeUpdate(cn, sql);
        }
    }

    public static void createTmpMainTable(Connection cn) {
        String sql = "CREATE TABLE T_ISCB_TMP_MAIN(fid varchar(32) not null, ftime timestamp not null, CONSTRAINT PK_ISCB_TMP_MAIN primary key(fid))";
        DbUtil.executeUpdate(cn, sql);
    }

    public static void saveTmpMainRecord(ConnectorContext ctx, String id) {
        Connection cn = null;
        try {
            cn = ctx.getConnection();
            String sql = "insert into T_ISCB_TMP_MAIN(fid,ftime)values(?,?)";
            ArrayList<Object> values = new ArrayList<Object>();
            ArrayList<Integer> types = new ArrayList<Integer>();
            values.add(id);
            types.add(12);
            values.add(new Timestamp(System.currentTimeMillis()));
            types.add(93);
            DbUtil.executeUpdate(cn, sql, values, types);
        }
        catch (Exception e) {
            throw new IscBizException(e);
        }
        finally {
            ctx.dispose(cn);
        }
    }

    private static boolean isMainRecordExists(Connection cn, String id) {
        List<Integer> types;
        String sql = "select count(*) from T_ISCB_TMP_MAIN where fid = ?";
        List<Object> values = Collections.singletonList(id);
        int count = D.i(DbUtil.executeScalar(cn, sql, values, types = Collections.singletonList(12)));
        return count > 0;
    }

    public static void createResultTable(Connection cn, String blobType) {
        String sql = "CREATE TABLE T_ISCB_TMP_RETURNS(fid varchar(32) not null, fseq int not null, fdata " + blobType + " not null, ftime timestamp not null, CONSTRAINT PK_ISCB_TMP_RETURNS primary key(fid, fseq))";
        DbUtil.executeUpdate(cn, sql);
    }

    public static Object getResult(ConnectorContext ctx, String id) {
        byte[] bytes = SerializableResultManager.getChunk(ctx, id);
        if (bytes == null) {
            return null;
        }
        String json = new String(bytes, D.UTF_8);
        return Json.toObject(json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getChunk(ConnectorContext ctx, String id) {
        Connection cn = ctx.getConnection();
        try {
            byte[] byArray = SerializableResultManager.loadResult(cn, id);
            return byArray;
        }
        finally {
            ctx.dispose(cn);
        }
    }

    public static void saveChunk(ConnectorContext ctx, String id, int index, byte[] chunk) {
        SerializableResultManager.saveChunk(ctx, id, index, chunk, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveChunk(ConnectorContext ctx, String id, int index, byte[] chunk, boolean hasMore) {
        block4: {
            Connection cn = null;
            try {
                cn = ctx.getConnection();
                if (SerializableResultManager.isMainRecordExists(cn, id)) {
                    SerializableResultManager.innerSaveChunk(id, index, chunk, cn, hasMore);
                    break block4;
                }
                throw new IscBizException(String.format(ResManager.loadKDString("\u6682\u5b58\u8868\u4e3b\u8868\u4e2d\u4e0d\u5b58\u5728[%s]\u8c03\u7528\u8bb0\u5f55", "SerializableResultManager_3", "isc-iscb-util", new Object[0]), id));
            }
            finally {
                ctx.dispose(cn);
            }
        }
    }

    private static void innerSaveChunk(String id, int index, byte[] chunk, Connection cn, boolean hasMore) {
        String sql = "insert into T_ISCB_TMP_RETURNS(fid,fseq,fdata,ftime,fhasmore)values(?,?,?,?,?)";
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        values.add(id);
        types.add(12);
        values.add(index);
        types.add(4);
        values.add(chunk);
        types.add(-3);
        values.add(new Timestamp(System.currentTimeMillis()));
        types.add(93);
        values.add(hasMore ? "1" : "0");
        types.add(1);
        DbUtil.executeUpdate(cn, sql, values, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int removeChunks(ConnectorContext ctx, String id) {
        Connection cn = ctx.getConnection();
        try {
            List<Object> values = Collections.singletonList(id);
            List<Integer> types = Collections.singletonList(12);
            String sql = "delete from T_ISCB_TMP_MAIN where fid=?";
            DbUtil.executeUpdate(cn, sql, values, types);
            sql = "delete from T_ISCB_TMP_RETURNS where fid=?";
            int n = DbUtil.executeUpdate(cn, sql, values, types);
            return n;
        }
        finally {
            ctx.dispose(cn);
        }
    }

    private static byte[] loadResult(Connection cn, String id) {
        List<Integer> types;
        String sql = "SELECT MIN(fseq) FROM T_ISCB_TMP_RETURNS WHERE fid=?";
        List<Object> values = Collections.singletonList(id);
        Object fseq = DbUtil.executeScalar(cn, sql, values, types = Collections.singletonList(12));
        if (fseq == null) {
            if (SerializableResultManager.isMainRecordExists(cn, id)) {
                return null;
            }
            throw new IscBizException(String.format(ResManager.loadKDString("\u6682\u5b58\u8868\u4e3b\u8868\u4e2d\u4e0d\u5b58\u5728[%s]\u8c03\u7528\u8bb0\u5f55\u3002", "SerializableResultManager_4", "isc-iscb-util", new Object[0]), id));
        }
        sql = "SELECT fid,fseq,fdata,fhasmore FROM T_ISCB_TMP_RETURNS WHERE fid=? AND fseq=" + fseq;
        DataRow row = DbUtil.executeRow(cn, sql, values, types);
        SerializableResultManager.delete(cn, row);
        return Hex.decode((String)row.getValue("fdata"));
    }

    private static void delete(Connection cn, DataRow row) {
        Object id = row.getValue("fid");
        Object seq = row.getValue("fseq");
        boolean hasMore = D.x(row.getValue(FHASMORE));
        String sql = "delete from T_ISCB_TMP_RETURNS where fid=? and fseq=?";
        DbUtil.executeUpdate(cn, sql, Arrays.asList(id, seq), Arrays.asList(12, 4));
        if (!hasMore) {
            sql = "delete from T_ISCB_TMP_MAIN where fid=?";
            DbUtil.executeUpdate(cn, sql, Collections.singletonList(id), Collections.singletonList(12));
        } else {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            sql = "update T_ISCB_TMP_MAIN set ftime=? where fid=?";
            DbUtil.executeUpdate(cn, sql, Arrays.asList(now, id), Arrays.asList(93, 12));
        }
    }

    public static void createIndexOnTmpMain(Connection cn) {
        String sql = "select count(*) from KSQL_INDEXES where KSQL_INDNAME = 'IDX_ISC_T_MAIN_TIME'";
        Object count = DbUtil.executeScalar(cn, sql);
        if (D.i(count) < 1) {
            sql = "create index IDX_ISC_T_MAIN_TIME on T_ISCB_TMP_MAIN (FTIME DESC)";
            DbUtil.executeUpdate(cn, sql);
        }
    }
}

