/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ArrayUtils {
    public static <T> List<List<T>> split(T[] array, int batchSize) {
        return ArrayUtils.split(ArrayUtils.iterator(array), batchSize);
    }

    public static <T> List<List<T>> split(List<T> list, int batchSize) {
        return ArrayUtils.split(list.iterator(), batchSize);
    }

    public static <T> List<List<T>> split(Iterable<T> iterable, int batchSize) {
        return ArrayUtils.split(iterable.iterator(), batchSize);
    }

    private static <T> List<List<T>> split(Iterator<T> it, int batchSize) {
        ArrayList<List<T>> batches = new ArrayList<List<T>>();
        ArrayList<T> batch = new ArrayList<T>(batchSize);
        while (it.hasNext()) {
            T o = it.next();
            batch.add(o);
            if (batch.size() < batchSize) continue;
            batches.add(batch);
            batch = new ArrayList(batchSize);
        }
        if (!batch.isEmpty()) {
            batches.add(batch);
        }
        return batches;
    }

    public static <T> Iterator<T> iterator(final T[] array) {
        return new Iterator<T>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < array.length;
            }

            @Override
            public T next() {
                return array[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

