/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.data;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public final class Buffer<T>
implements Collection<T> {
    public static final String SEPERATOR = ",";
    private LinkedList<T> list = new LinkedList();
    private int capacity;

    public Buffer(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public boolean add(T o) {
        while (this.list.size() >= this.capacity) {
            this.list.removeFirst();
        }
        this.list.add(o);
        return true;
    }

    public T last() {
        return this.list.isEmpty() ? null : (T)this.list.getLast();
    }

    public T first() {
        return this.list.isEmpty() ? null : (T)this.list.getFirst();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (T o : c) {
            this.add(o);
        }
        return true;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return Collections.unmodifiableList(this.list).iterator();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.list.toArray(array);
    }
}

