/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.data;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.ai.gai.flow.misc.Pair;

public final class Counter {
    private AtomicLong[] tickets;
    private AtomicInteger[] values;
    private long millis;
    private long interval;

    public Counter(int millis, int interval) {
        int i;
        if (millis <= 0 || interval <= 0) {
            throw new IllegalArgumentException("negative param value!");
        }
        int len = interval + 1;
        this.tickets = new AtomicLong[len];
        for (i = 0; i < len; ++i) {
            this.tickets[i] = new AtomicLong(0L);
        }
        this.values = new AtomicInteger[len];
        for (i = 0; i < len; ++i) {
            this.values[i] = new AtomicInteger(0);
        }
        this.millis = millis;
        this.interval = len;
    }

    public void inc(int n) {
        long ticket = System.currentTimeMillis() / this.millis;
        int index = (int)(ticket % this.interval);
        AtomicInteger counter = this.values[index];
        int v0 = counter.get();
        if (ticket == this.tickets[index].getAndSet(ticket)) {
            counter.getAndAdd(n);
        } else {
            this.reset(n, counter, v0);
        }
    }

    public void set(int n) {
        long ticket = System.currentTimeMillis() / this.millis;
        int index = (int)(ticket % this.interval);
        this.values[index].set(n);
        this.tickets[index].set(ticket);
    }

    public void setMax(int n) {
        long ticket = System.currentTimeMillis() / this.millis;
        int index = (int)(ticket % this.interval);
        int old_value = this.values[index].get();
        long old_ticket = this.tickets[index].get();
        if (old_ticket != ticket || old_value < n) {
            this.values[index].set(n);
            this.tickets[index].set(ticket);
        }
    }

    public void setMin(int n) {
        long ticket = System.currentTimeMillis() / this.millis;
        int index = (int)(ticket % this.interval);
        int old_value = this.values[index].get();
        long old_ticket = this.tickets[index].get();
        if (old_ticket != ticket || old_value > n) {
            this.values[index].set(n);
            this.tickets[index].set(ticket);
        }
    }

    private void reset(int n, AtomicInteger counter, int v0) {
        int v1 = counter.getAndSet(n);
        while (v1 != v0) {
            v0 = counter.get();
            v1 = counter.getAndSet(n += v1 - v0);
        }
    }

    public int get() {
        long end = System.currentTimeMillis() / this.millis;
        long start = end - this.interval;
        int total = 0;
        int i = 0;
        while ((long)i < this.interval) {
            long ticket = this.tickets[i].get();
            int count = this.values[i].get();
            if (ticket > start && ticket <= end && ticket == this.tickets[i].get()) {
                total += count;
            }
            ++i;
        }
        return total;
    }

    public int min() {
        long end = System.currentTimeMillis() / this.millis;
        long start = end - this.interval;
        int min = Integer.MAX_VALUE;
        int i = 0;
        while ((long)i < this.interval) {
            long ticket = this.tickets[i].get();
            if (ticket > start && ticket <= end) {
                int value = this.values[i].get();
                if (ticket == this.tickets[i].get() && value < min) {
                    min = value;
                }
            }
            ++i;
        }
        return min == Integer.MAX_VALUE ? 0 : min;
    }

    public int max() {
        long end = System.currentTimeMillis() / this.millis;
        long start = end - this.interval;
        int max = Integer.MIN_VALUE;
        int i = 0;
        while ((long)i < this.interval) {
            long ticket = this.tickets[i].get();
            if (ticket > start && ticket <= end) {
                int value = this.values[i].get();
                if (ticket == this.tickets[i].get() && value > max) {
                    max = value;
                }
            }
            ++i;
        }
        return max == Integer.MIN_VALUE ? 0 : max;
    }

    public int avg() {
        long end = System.currentTimeMillis() / this.millis;
        long start = end - this.interval;
        int total = 0;
        int count = 0;
        int i = 0;
        while ((long)i < this.interval) {
            long ticket = this.tickets[i].get();
            if (ticket > start && ticket <= end) {
                int value = this.values[i].get();
                if (ticket == this.tickets[i].get()) {
                    total += value;
                    ++count;
                }
            }
            ++i;
        }
        return count == 0 ? 0 : total / count;
    }

    public Pair<Integer, Integer> minMax() {
        long end = System.currentTimeMillis() / this.millis;
        long start = end - this.interval;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int i = 0;
        while ((long)i < this.interval) {
            long ticket = this.tickets[i].get();
            if (ticket > start && ticket <= end) {
                int value = this.values[i].get();
                if (ticket == this.tickets[i].get()) {
                    if (value < min) {
                        min = value;
                    } else if (value > max) {
                        max = value;
                    }
                }
            }
            ++i;
        }
        if (min == Integer.MAX_VALUE) {
            min = 0;
        }
        if (max == Integer.MIN_VALUE) {
            max = 0;
        }
        return new Pair<Integer, Integer>(min, max);
    }

    public int getInterval() {
        return (int)this.interval - 1;
    }

    public long getTimeUnit() {
        return (int)this.millis;
    }
}

