/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.flow.data.LinkedNode;
import kd.ai.gai.flow.except.IscBizException;

public final class LinkedList<E extends LinkedNode<E>>
implements Serializable {
    private static final long serialVersionUID = -4488666902618419188L;
    private E header;

    public LinkedList(E header) {
        this.init(header);
    }

    private void init(E header) {
        this.header = header;
        ((LinkedNode)this.header).prior = this.header;
        ((LinkedNode)this.header).next = ((LinkedNode)this.header).prior;
    }

    public void clear() {
        this.init(this.header);
    }

    public void push(E node) {
        this.insertBefore(node, this.header);
    }

    public E pop() {
        if (((LinkedNode)this.header).next == this.header) {
            return null;
        }
        return (E)this.poll(((LinkedNode)this.header).prior);
    }

    public void insertAtFirst(E node) {
        this.insertBefore(node, ((LinkedNode)this.header).next);
    }

    public void insertBefore(E node, E before) {
        if (((LinkedNode)node).next != null || ((LinkedNode)node).prior != null) {
            throw new IscBizException("node is in linked list!");
        }
        ((LinkedNode)node).next = before;
        ((LinkedNode)node).prior = ((LinkedNode)before).prior;
        ((LinkedNode)((LinkedNode)before).prior).next = node;
        ((LinkedNode)before).prior = node;
    }

    public E poll() {
        if (((LinkedNode)this.header).next == this.header) {
            return null;
        }
        return (E)this.poll(((LinkedNode)this.header).next);
    }

    public E first() {
        if (((LinkedNode)this.header).next == this.header) {
            return null;
        }
        return (E)((LinkedNode)this.header).next;
    }

    public E last() {
        if (((LinkedNode)this.header).next == this.header) {
            return null;
        }
        return (E)((LinkedNode)this.header).prior;
    }

    public E poll(E node) {
        ((LinkedNode)((LinkedNode)node).next).prior = ((LinkedNode)node).prior;
        ((LinkedNode)((LinkedNode)node).prior).next = ((LinkedNode)node).next;
        ((LinkedNode)node).prior = null;
        ((LinkedNode)node).next = null;
        return node;
    }

    public List<E> removeTail(E node) {
        Object prior;
        ArrayList list = new ArrayList();
        Object next = ((LinkedNode)node).next;
        while (next != node && next != this.header) {
            list.add(next);
            next = ((LinkedNode)next).next;
        }
        ((LinkedNode)this.header).prior = prior = ((LinkedNode)node).prior;
        ((LinkedNode)prior).next = this.header;
        return list;
    }

    public boolean isEmpty() {
        return ((LinkedNode)this.header).next == this.header;
    }
}

