/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.flow.data.LinkedList;
import kd.ai.gai.flow.data.LinkedNode;

public final class RollMap<K, V> {
    private HashMap<K, Node<K, V>> map;
    private LinkedList<Node<K, V>> list;

    public RollMap(int capacity) {
        this.map = new HashMap(capacity);
        this.list = new LinkedList(new Node());
    }

    public boolean isEmpty() {
        return this.map.size() == 0;
    }

    public void put(K key, V obj) {
        Node<K, V> node = this.map.get(key);
        if (node != null) {
            this.moveLast(node);
        } else {
            node = this.createNewNode(key);
        }
        ((Node)node).value = obj;
    }

    private Node<K, V> createNewNode(K key) {
        Node node = new Node();
        node.key = key;
        this.map.put(key, node);
        this.list.push(node);
        return node;
    }

    private void moveLast(Node<K, V> node) {
        this.list.poll(node);
        this.list.push(node);
    }

    public int size() {
        return this.map.size();
    }

    public V get(K key) {
        Node<K, V> node = this.map.get(key);
        if (node == null) {
            return null;
        }
        this.moveLast(node);
        return (V)((Node)node).value;
    }

    public Map.Entry<K, V> first() {
        Node<K, V> first = this.list.first();
        if (first == null) {
            return null;
        }
        this.moveLast(first);
        return first;
    }

    public Collection<V> values() {
        ArrayList<Object> list = new ArrayList<Object>(this.map.size());
        for (Node<K, V> node : this.map.values()) {
            list.add(((Node)node).value);
        }
        return list;
    }

    public boolean contains(K key) {
        return this.map.containsKey(key);
    }

    public V remove(K key) {
        Node<K, V> node = this.map.get(key);
        if (node == null) {
            return null;
        }
        this.list.poll(node);
        this.map.remove(((Node)node).key);
        return (V)((Node)node).value;
    }

    public void clear() {
        this.list.clear();
        this.map.clear();
    }

    private static final class Node<K, V>
    extends LinkedNode<Node<K, V>>
    implements Map.Entry<K, V> {
        private static final long serialVersionUID = -8264155532011907301L;
        private transient K key;
        private transient V value;

        private Node() {
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

